/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.mapcss;

import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.mapcss.Expression;
import org.openstreetmap.josm.tools.Utils;

public abstract class Condition {
    public static final EnumSet<Op> COMPARISON_OPERATERS = EnumSet.of(Op.GREATER_OR_EQUAL, Op.GREATER, Op.LESS_OR_EQUAL, Op.LESS);

    public abstract boolean applies(Environment var1);

    public static class ExpressionCondition
    extends Condition {
        private Expression e;

        public ExpressionCondition(Expression expression) {
            this.e = expression;
        }

        public boolean applies(Environment environment) {
            Boolean bl = Cascade.convertTo(this.e.evaluate(environment), Boolean.class);
            return bl != null && bl != false;
        }

        public String toString() {
            return "[" + this.e + "]";
        }
    }

    public static class PseudoClassCondition
    extends Condition {
        String id;
        boolean not;

        public PseudoClassCondition(String string, boolean bl) {
            this.id = string;
            this.not = bl;
        }

        public boolean applies(Environment environment) {
            return this.not ^ this.appliesImpl(environment);
        }

        public boolean appliesImpl(Environment environment) {
            if (Utils.equal(this.id, "closed")) {
                if (environment.osm instanceof Way && ((Way)environment.osm).isClosed()) {
                    return true;
                }
                return environment.osm instanceof Relation && ((Relation)environment.osm).isMultipolygon();
            }
            if (Utils.equal(this.id, "modified")) {
                return environment.osm.isModified() || environment.osm.isNewOrUndeleted();
            }
            if (Utils.equal(this.id, "new")) {
                return environment.osm.isNew();
            }
            if (Utils.equal(this.id, "connection") && environment.osm instanceof Node) {
                return ((Node)environment.osm).isConnectionNode();
            }
            if (Utils.equal(this.id, "tagged")) {
                return environment.osm.isTagged();
            }
            return true;
        }

        public String toString() {
            return ":" + (this.not ? "!" : "") + this.id;
        }
    }

    public static class KeyCondition
    extends Condition {
        private String k;
        private boolean not;
        private boolean yes;

        public KeyCondition(String string, boolean bl, boolean bl2) {
            this.k = string;
            this.not = bl;
            this.yes = bl2;
        }

        public boolean applies(Environment environment) {
            if (this.yes) {
                return OsmUtils.isTrue(environment.osm.get(this.k)) ^ this.not;
            }
            return environment.osm.hasKey(this.k) ^ this.not;
        }

        public String toString() {
            return "[" + (this.not ? "!" : "") + this.k + "]";
        }
    }

    public static class KeyValueCondition
    extends Condition {
        public String k;
        public String v;
        public Op op;
        private float v_float;

        public KeyValueCondition(String string, String string2, Op op) {
            this.k = string;
            this.v = string2;
            this.op = op;
            if (COMPARISON_OPERATERS.contains((Object)op)) {
                this.v_float = Float.parseFloat(string2);
            }
        }

        public boolean applies(Environment environment) {
            float f;
            String string = environment.osm.get(this.k);
            if (string == null && this.op != Op.NEQ) {
                return false;
            }
            switch (this.op) {
                case EQ: {
                    return Utils.equal(string, this.v);
                }
                case NEQ: {
                    return !Utils.equal(string, this.v);
                }
                case REGEX: {
                    Pattern pattern = Pattern.compile(this.v);
                    Matcher matcher = pattern.matcher(string);
                    return matcher.find();
                }
                case ONE_OF: {
                    String[] stringArray;
                    for (String string2 : stringArray = string.split(";")) {
                        if (!Utils.equal(this.v, string2.trim())) continue;
                        return true;
                    }
                    return false;
                }
                case BEGINS_WITH: {
                    return string.startsWith(this.v);
                }
                case ENDS_WITH: {
                    return string.endsWith(this.v);
                }
                case CONTAINS: {
                    return string.contains(this.v);
                }
            }
            try {
                f = Float.parseFloat(string);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            switch (this.op) {
                case GREATER_OR_EQUAL: {
                    return f >= this.v_float;
                }
                case GREATER: {
                    return f > this.v_float;
                }
                case LESS_OR_EQUAL: {
                    return f <= this.v_float;
                }
                case LESS: {
                    return f < this.v_float;
                }
            }
            throw new AssertionError();
        }

        public String toString() {
            return "[" + this.k + "'" + (Object)((Object)this.op) + "'" + this.v + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Op {
        EQ,
        NEQ,
        GREATER_OR_EQUAL,
        GREATER,
        LESS_OR_EQUAL,
        LESS,
        REGEX,
        ONE_OF,
        BEGINS_WITH,
        ENDS_WITH,
        CONTAINS;

    }
}

