/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint.mapcss;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.mappaint.Environment;
import org.openstreetmap.josm.gui.mappaint.Range;
import org.openstreetmap.josm.gui.mappaint.mapcss.Condition;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Utils;

public interface Selector {
    public boolean matches(Environment var1);

    public String getSubpart();

    public Range getRange();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class GeneralSelector
    implements Selector {
        public String base;
        public Range range;
        protected List<Condition> conds;
        private String subpart;
        static final double R = 6378135.0;

        public GeneralSelector(String string, Pair<Integer, Integer> pair, List<Condition> list, String string2) {
            this.base = string;
            if (pair != null) {
                int n;
                int n2 = pair.a == null ? 0 : (Integer)pair.a;
                int n3 = n = pair.b == null ? Integer.MAX_VALUE : (Integer)pair.b;
                if (n2 <= n) {
                    this.range = GeneralSelector.fromLevel(n2, n);
                }
            }
            if (this.range == null) {
                this.range = new Range();
            }
            this.conds = list;
            this.subpart = string2;
        }

        @Override
        public String getSubpart() {
            return this.subpart;
        }

        @Override
        public Range getRange() {
            return this.range;
        }

        @Override
        public boolean matches(Environment environment) {
            if (!this.baseApplies(environment.osm)) {
                return false;
            }
            for (Condition condition : this.conds) {
                if (condition.applies(environment)) continue;
                return false;
            }
            return true;
        }

        private boolean baseApplies(OsmPrimitive osmPrimitive) {
            if (this.base.equals("*")) {
                return true;
            }
            if (this.base.equals("area")) {
                if (osmPrimitive instanceof Way) {
                    return true;
                }
                if (osmPrimitive instanceof Relation && ((Relation)osmPrimitive).isMultipolygon()) {
                    return true;
                }
            }
            return this.base.equals(OsmPrimitiveType.from(osmPrimitive).getAPIName());
        }

        public static Range fromLevel(int n, int n2) {
            if (n > n2) {
                throw new AssertionError();
            }
            double d = 0.0;
            double d2 = Double.POSITIVE_INFINITY;
            if (n2 != Integer.MAX_VALUE) {
                d = GeneralSelector.level2scale(n2 + 1);
            }
            if (n != 0) {
                d2 = GeneralSelector.level2scale(n);
            }
            return new Range(d, d2);
        }

        public static double level2scale(int n) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            return 4.0075004119207874E7 / Math.pow(2.0, n) / 2.56;
        }

        public String toString() {
            return this.base + (this.range == null ? "" : this.range) + Utils.join("", this.conds) + (this.subpart != null ? "::" + this.subpart : "");
        }
    }

    public static class ChildOrParentSelector
    implements Selector {
        Selector a;
        Selector b;
        private final boolean parentSelector;

        public ChildOrParentSelector(Selector selector, Selector selector2, boolean bl) {
            this.a = selector;
            this.b = selector2;
            this.parentSelector = bl;
        }

        public boolean matches(Environment environment) {
            block6: {
                Environment environment2;
                block7: {
                    block5: {
                        if (!this.b.matches(environment)) {
                            return false;
                        }
                        environment2 = new Environment(null, environment.mc, environment.layer, environment.source);
                        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
                        if (this.parentSelector) break block5;
                        Iterator<OsmPrimitive> iterator = environment.osm.getReferrers().iterator();
                        while (iterator.hasNext()) {
                            OsmPrimitive osmPrimitive;
                            environment2.osm = osmPrimitive = iterator.next();
                            if (!this.a.matches(environment2)) continue;
                            arrayList.add(osmPrimitive);
                        }
                        if (!arrayList.isEmpty()) {
                            environment.setMatchingReferrers(arrayList);
                            return true;
                        }
                        break block6;
                    }
                    if (!(environment.osm instanceof Relation)) break block7;
                    Iterator<OsmPrimitive> iterator = ((Relation)environment.osm).getMemberPrimitives().iterator();
                    while (iterator.hasNext()) {
                        OsmPrimitive osmPrimitive;
                        environment2.osm = osmPrimitive = iterator.next();
                        if (!this.a.matches(environment2)) continue;
                        return true;
                    }
                    break block6;
                }
                if (!(environment.osm instanceof Way)) break block6;
                for (Node node : ((Way)environment.osm).getNodes()) {
                    environment2.osm = node;
                    if (!this.a.matches(environment2)) continue;
                    return true;
                }
            }
            return false;
        }

        public String getSubpart() {
            return this.b.getSubpart();
        }

        public Range getRange() {
            return this.b.getRange();
        }
    }
}

