/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.oauth;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.oauth.OAuthParameters;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class AdvancedOAuthPropertiesPanel
extends VerticallyScrollablePanel {
    private JCheckBox cbUseDefaults;
    private JTextField tfConsumerKey;
    private JTextField tfConsumerSecret;
    private JTextField tfRequestTokenURL;
    private JTextField tfAccessTokenURL;
    private JTextField tfAuthoriseURL;
    private UseDefaultItemListener ilUseDefault;

    protected void build() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 3);
        gridBagConstraints.gridwidth = 2;
        this.cbUseDefaults = new JCheckBox(I18n.tr("Use default settings"));
        this.add((Component)this.cbUseDefaults, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)new JLabel(I18n.tr("Consumer Key:")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.tfConsumerKey = new JTextField();
        this.add((Component)this.tfConsumerKey, gridBagConstraints);
        SelectAllOnFocusGainedDecorator.decorate(this.tfConsumerKey);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)new JLabel(I18n.tr("Consumer Secret:")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.tfConsumerSecret = new JTextField();
        this.add((Component)this.tfConsumerSecret, gridBagConstraints);
        SelectAllOnFocusGainedDecorator.decorate(this.tfConsumerSecret);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)new JLabel(I18n.tr("Request Token URL:")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.tfRequestTokenURL = new JTextField();
        this.add((Component)this.tfRequestTokenURL, gridBagConstraints);
        SelectAllOnFocusGainedDecorator.decorate(this.tfRequestTokenURL);
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)new JLabel(I18n.tr("Access Token URL:")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.tfAccessTokenURL = new JTextField();
        this.add((Component)this.tfAccessTokenURL, gridBagConstraints);
        SelectAllOnFocusGainedDecorator.decorate(this.tfAccessTokenURL);
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)new JLabel(I18n.tr("Authorize URL:")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        this.tfAuthoriseURL = new JTextField();
        this.add((Component)this.tfAuthoriseURL, gridBagConstraints);
        SelectAllOnFocusGainedDecorator.decorate(this.tfAuthoriseURL);
        this.ilUseDefault = new UseDefaultItemListener();
        this.cbUseDefaults.addItemListener(this.ilUseDefault);
    }

    protected boolean hasCustomSettings() {
        return !this.tfConsumerKey.getText().equals("AdCRxTpvnbmfV8aPqrTLyA") || !this.tfConsumerSecret.getText().equals("XmYOiGY9hApytcBC3xCec3e28QBqOWz5g6DSb5UpE") || !this.tfRequestTokenURL.getText().equals("http://www.openstreetmap.org/oauth/request_token") || !this.tfAccessTokenURL.getText().equals("http://www.openstreetmap.org/oauth/access_token") || !this.tfAuthoriseURL.getText().equals("http://www.openstreetmap.org/oauth/authorize");
    }

    protected boolean confirmOverwriteCustomSettings() {
        HelpAwareOptionPane.ButtonSpec[] buttonSpecArray = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Continue"), ImageProvider.get("ok"), I18n.tr("Click to reset the OAuth settings to default values"), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel"), ImageProvider.get("cancel"), I18n.tr("Click to abort resetting to the OAuth default values"), null)};
        int n = HelpAwareOptionPane.showOptionDialog(this, I18n.tr("<html>JOSM is about to reset the OAuth settings to default values.<br>The current custom settings are not saved.</html>"), I18n.tr("Overwrite custom OAuth settings?"), 2, null, buttonSpecArray, buttonSpecArray[0], HelpUtil.ht("/Dialog/OAuthAuthorisationWizard"));
        return n == 0;
    }

    protected void resetToDefaultSettings() {
        this.cbUseDefaults.setSelected(true);
        this.tfConsumerKey.setText("AdCRxTpvnbmfV8aPqrTLyA");
        this.tfConsumerSecret.setText("XmYOiGY9hApytcBC3xCec3e28QBqOWz5g6DSb5UpE");
        this.tfRequestTokenURL.setText("http://www.openstreetmap.org/oauth/request_token");
        this.tfAccessTokenURL.setText("http://www.openstreetmap.org/oauth/access_token");
        this.tfAuthoriseURL.setText("http://www.openstreetmap.org/oauth/authorize");
        this.setChildComponentsEnabled(false);
    }

    protected void setChildComponentsEnabled(boolean bl) {
        for (Component component : this.getComponents()) {
            if (!(component instanceof JTextField) && !(component instanceof JLabel)) continue;
            component.setEnabled(bl);
        }
    }

    public OAuthParameters getAdvancedParameters() {
        if (this.cbUseDefaults.isSelected()) {
            return OAuthParameters.createDefault();
        }
        OAuthParameters oAuthParameters = new OAuthParameters();
        oAuthParameters.setConsumerKey(this.tfConsumerKey.getText());
        oAuthParameters.setConsumerSecret(this.tfConsumerSecret.getText());
        oAuthParameters.setRequestTokenUrl(this.tfRequestTokenURL.getText());
        oAuthParameters.setAccessTokenUrl(this.tfAccessTokenURL.getText());
        oAuthParameters.setAuthoriseUrl(this.tfAuthoriseURL.getText());
        return oAuthParameters;
    }

    public void setAdvancedParameters(OAuthParameters oAuthParameters) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(oAuthParameters, "parameters");
        if (oAuthParameters.equals(OAuthParameters.createDefault())) {
            this.cbUseDefaults.setSelected(true);
            this.setChildComponentsEnabled(false);
        } else {
            this.cbUseDefaults.setSelected(false);
            this.setChildComponentsEnabled(true);
            this.tfConsumerKey.setText(oAuthParameters.getConsumerKey() == null ? "" : oAuthParameters.getConsumerKey());
            this.tfConsumerSecret.setText(oAuthParameters.getConsumerSecret() == null ? "" : oAuthParameters.getConsumerSecret());
            this.tfRequestTokenURL.setText(oAuthParameters.getRequestTokenUrl() == null ? "" : oAuthParameters.getRequestTokenUrl());
            this.tfAccessTokenURL.setText(oAuthParameters.getAccessTokenUrl() == null ? "" : oAuthParameters.getAccessTokenUrl());
            this.tfAuthoriseURL.setText(oAuthParameters.getAuthoriseUrl() == null ? "" : oAuthParameters.getAuthoriseUrl());
        }
    }

    public AdvancedOAuthPropertiesPanel() {
        this.build();
    }

    public void initFromPreferences(Preferences preferences) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(preferences, "pref");
        boolean bl = preferences.getBoolean("oauth.settings.use-default", true);
        this.ilUseDefault.setEnabled(false);
        if (bl) {
            this.resetToDefaultSettings();
        } else {
            this.cbUseDefaults.setSelected(false);
            this.tfConsumerKey.setText(preferences.get("oauth.settings.consumer-key", ""));
            this.tfConsumerSecret.setText(preferences.get("oauth.settings.consumer-secret", ""));
            this.tfRequestTokenURL.setText(preferences.get("oauth.settings.request-token-url", ""));
            this.tfAccessTokenURL.setText(preferences.get("oauth.settings.access-token-url", ""));
            this.tfAuthoriseURL.setText(preferences.get("oauth.settings.authorise-url", ""));
            this.setChildComponentsEnabled(true);
        }
        this.ilUseDefault.setEnabled(true);
    }

    public void rememberPreferences(Preferences preferences) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(preferences, "pref");
        preferences.put("oauth.settings.use-default", this.cbUseDefaults.isSelected());
        if (this.cbUseDefaults.isSelected()) {
            preferences.put("oauth.settings.consumer-key", null);
            preferences.put("oauth.settings.consumer-secret", null);
            preferences.put("oauth.settings.request-token-url", null);
            preferences.put("oauth.settings.access-token-url", null);
            preferences.put("oauth.settings.authorise-url", null);
        } else {
            preferences.put("oauth.settings.consumer-key", this.tfConsumerKey.getText().trim());
            preferences.put("oauth.settings.consumer-secret", this.tfConsumerSecret.getText().trim());
            preferences.put("oauth.settings.request-token-url", this.tfRequestTokenURL.getText().trim());
            preferences.put("oauth.settings.access-token-url", this.tfAccessTokenURL.getText().trim());
            preferences.put("oauth.settings.authorise-url", this.tfAuthoriseURL.getText().trim());
        }
    }

    class UseDefaultItemListener
    implements ItemListener {
        private boolean enabled;

        UseDefaultItemListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (!this.enabled) {
                return;
            }
            switch (itemEvent.getStateChange()) {
                case 1: {
                    if (AdvancedOAuthPropertiesPanel.this.hasCustomSettings() && !AdvancedOAuthPropertiesPanel.this.confirmOverwriteCustomSettings()) {
                        AdvancedOAuthPropertiesPanel.this.cbUseDefaults.setSelected(false);
                        return;
                    }
                    AdvancedOAuthPropertiesPanel.this.resetToDefaultSettings();
                    break;
                }
                case 2: {
                    AdvancedOAuthPropertiesPanel.this.setChildComponentsEnabled(true);
                }
            }
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }
    }
}

