/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.gui.MapScaler;
import org.openstreetmap.josm.gui.dialogs.ConflictDialog;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceSettingFactory;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorPreference
implements PreferenceSetting {
    private DefaultTableModel tableModel;
    private JTable colors;
    private ArrayList<String> del = new ArrayList();
    JButton colorEdit;
    JButton defaultSet;
    JButton remove;

    public void setColorModel(Map<String, String> map) {
        Vector<Object> vector;
        if (this.tableModel == null) {
            this.tableModel = new DefaultTableModel();
            this.tableModel.addColumn(I18n.tr("Name"));
            this.tableModel.addColumn(I18n.tr("Color"));
        }
        while (this.tableModel.getRowCount() > 0) {
            this.tableModel.removeRow(0);
        }
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        TreeMap<String, String> treeMap2 = new TreeMap<String, String>();
        TreeMap<String, String> treeMap3 = new TreeMap<String, String>();
        for (String object : map.keySet()) {
            if (object.startsWith("layer ")) {
                treeMap3.put(this.getName(object), object);
                continue;
            }
            if (object.startsWith("mappaint.")) {
                treeMap2.put(this.getName(object) + object, object);
                continue;
            }
            treeMap.put(this.getName(object), object);
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            vector = new Vector<Object>(2);
            vector.add(entry.getValue());
            vector.add(ColorHelper.html2color(map.get(entry.getValue())));
            this.tableModel.addRow(vector);
        }
        for (Map.Entry entry : treeMap2.entrySet()) {
            vector = new Vector(2);
            vector.add(entry.getValue());
            vector.add(ColorHelper.html2color(map.get(entry.getValue())));
            this.tableModel.addRow(vector);
        }
        for (Map.Entry entry : treeMap3.entrySet()) {
            vector = new Vector(2);
            vector.add(entry.getValue());
            vector.add(ColorHelper.html2color(map.get(entry.getValue())));
            this.tableModel.addRow(vector);
        }
        if (this.colors != null) {
            this.colors.repaint();
        }
    }

    public Map<String, String> getColorModel() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            String string = (String)this.tableModel.getValueAt(i, 0);
            String string2 = ColorHelper.color2html((Color)this.tableModel.getValueAt(i, 1));
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    private String getName(String string) {
        try {
            Matcher matcher = Pattern.compile("mappaint\\.(.+?)\\.(.+)").matcher(string);
            matcher.matches();
            return I18n.tr("Paint style {0}: {1}", I18n.tr(matcher.group(1)), I18n.tr(matcher.group(2)));
        }
        catch (Exception exception) {
            try {
                Matcher matcher = Pattern.compile("layer (.+)").matcher(string);
                matcher.matches();
                return I18n.tr("Layer: {0}", I18n.tr(matcher.group(1)));
            }
            catch (Exception exception2) {
                return I18n.tr(string);
            }
        }
    }

    @Override
    public void addGui(final PreferenceTabbedPane preferenceTabbedPane) {
        this.fixColorPrefixes();
        this.setColorModel(Main.pref.getAllColors());
        this.colorEdit = new JButton(I18n.tr("Choose"));
        this.colorEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ColorPreference.this.colors.getSelectedRow();
                JColorChooser jColorChooser = new JColorChooser((Color)ColorPreference.this.colors.getValueAt(n, 1));
                int n2 = JOptionPane.showConfirmDialog(preferenceTabbedPane, jColorChooser, I18n.tr("Choose a color for {0}", ColorPreference.this.getName((String)ColorPreference.this.colors.getValueAt(n, 0))), 2, -1);
                if (n2 == 0) {
                    ColorPreference.this.colors.setValueAt(jColorChooser.getColor(), n, 1);
                }
            }
        });
        this.defaultSet = new JButton(I18n.tr("Set to default"));
        this.defaultSet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ColorPreference.this.colors.getSelectedRow();
                String string = (String)ColorPreference.this.colors.getValueAt(n, 0);
                Color color = Main.pref.getDefaultColor(string);
                if (color != null) {
                    ColorPreference.this.colors.setValueAt(color, n, 1);
                }
            }
        });
        JButton jButton = new JButton(I18n.tr("Set all to default"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                for (int i = 0; i < ColorPreference.this.colors.getRowCount(); ++i) {
                    String string = (String)ColorPreference.this.colors.getValueAt(i, 0);
                    Color color = Main.pref.getDefaultColor(string);
                    if (color == null) continue;
                    ColorPreference.this.colors.setValueAt(color, i, 1);
                }
            }
        });
        this.remove = new JButton(I18n.tr("Remove"));
        this.remove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ColorPreference.this.colors.getSelectedRow();
                ColorPreference.this.del.add((String)ColorPreference.this.colors.getValueAt(n, 0));
                ColorPreference.this.tableModel.removeRow(n);
            }
        });
        this.remove.setEnabled(false);
        this.colorEdit.setEnabled(false);
        this.defaultSet.setEnabled(false);
        this.colors = new JTable(this.tableModel){

            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                super.valueChanged(listSelectionEvent);
                int n = this.getSelectedRow();
                ColorPreference.this.remove.setEnabled(n >= 0 && ColorPreference.this.isRemoveColor(n) != false);
                ColorPreference.this.colorEdit.setEnabled(n >= 0);
                ColorPreference.this.defaultSet.setEnabled(n >= 0);
            }
        };
        this.colors.setSelectionMode(0);
        final TableCellRenderer tableCellRenderer = this.colors.getDefaultRenderer(Object.class);
        this.colors.setDefaultRenderer(Object.class, new TableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                if (n2 == 1) {
                    JLabel jLabel = new JLabel(ColorHelper.color2html((Color)object));
                    jLabel.setBackground((Color)object);
                    jLabel.setOpaque(true);
                    return jLabel;
                }
                return tableCellRenderer.getTableCellRendererComponent(jTable, ColorPreference.this.getName(object.toString()), bl, bl2, n, n2);
            }
        });
        this.colors.getColumnModel().getColumn(1).setWidth(100);
        this.colors.setToolTipText(I18n.tr("Colors used by different objects in JOSM."));
        this.colors.setPreferredScrollableViewportSize(new Dimension(100, 112));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JScrollPane jScrollPane = new JScrollPane(this.colors);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jPanel.add((Component)jScrollPane, GBC.eol().fill(1));
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel.add((Component)jPanel2, GBC.eol().insets(5, 0, 5, 5).fill(2));
        jPanel2.add(Box.createHorizontalGlue(), GBC.std().fill(2));
        jPanel2.add((Component)this.colorEdit, GBC.std().insets(0, 5, 0, 0));
        jPanel2.add((Component)this.defaultSet, GBC.std().insets(5, 5, 5, 0));
        jPanel2.add((Component)jButton, GBC.std().insets(0, 5, 0, 0));
        jPanel2.add((Component)this.remove, GBC.std().insets(0, 5, 0, 0));
        preferenceTabbedPane.displaycontent.addTab(I18n.tr("Colors"), jPanel);
    }

    Boolean isRemoveColor(int n) {
        return ((String)this.colors.getValueAt(n, 0)).startsWith("layer ");
    }

    private void fixColorPrefixes() {
        PaintColors.getColors();
        MarkerLayer.getColor(null);
        GpxLayer.getColor(null);
        OsmDataLayer.getOutsideColor();
        MapScaler.getColor();
        ConflictDialog.getColor();
    }

    @Override
    public boolean ok() {
        Boolean bl = false;
        for (String string : this.del) {
            Main.pref.put("color." + string, null);
        }
        for (int i = 0; i < this.colors.getRowCount(); ++i) {
            String string;
            string = (String)this.colors.getValueAt(i, 0);
            if (!Main.pref.putColor(string, (Color)this.colors.getValueAt(i, 1)) || !string.startsWith("mappaint.")) continue;
            bl = true;
        }
        OsmDataLayer.createHatchTexture();
        return bl;
    }

    public static class Factory
    implements PreferenceSettingFactory {
        public PreferenceSetting createPreferenceSetting() {
            return new ColorPreference();
        }
    }
}

