/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.SelectionManager;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class ZoomAction
extends MapMode
implements SelectionManager.SelectionEnded {
    private final SelectionManager selectionManager;

    public ZoomAction(MapFrame mapFrame) {
        super(I18n.tr("Zoom"), "zoom", I18n.tr("Zoom and move map"), Shortcut.registerShortcut("mapmode:zoom", I18n.tr("Mode: {0}", I18n.tr("Zoom")), 90, 3), mapFrame, ImageProvider.getCursor("normal", "zoom"));
        this.selectionManager = new SelectionManager(this, true, mapFrame.mapView);
    }

    public void selectionEnded(Rectangle rectangle, MouseEvent mouseEvent) {
        if (rectangle.width >= 3 && rectangle.height >= 3 && Main.isDisplayingMapView()) {
            MapView mapView = Main.map.mapView;
            mapView.zoomToFactor(mapView.getEastNorth(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2), rectangle.getWidth() / (double)mapView.getWidth());
        }
    }

    public void enterMode() {
        super.enterMode();
        this.selectionManager.register(Main.map.mapView);
    }

    public void exitMode() {
        super.exitMode();
        this.selectionManager.unregister(Main.map.mapView);
    }

    public String getModeHelpText() {
        return I18n.tr("Zoom by dragging or Ctrl+. or Ctrl+,; move with Ctrl+up, left, down, right; move zoom with right button");
    }
}

