/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.osm.DataIntegrityProblemException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class DataSetMerger {
    private final ConflictCollection conflicts;
    private final DataSet targetDataSet;
    private final DataSet sourceDataSet;
    private final Map<PrimitiveId, PrimitiveId> mergedMap;
    private final Set<PrimitiveId> objectsWithChildrenToMerge;
    private final Set<OsmPrimitive> objectsToDelete;

    public DataSetMerger(DataSet dataSet, DataSet dataSet2) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(dataSet, "targetDataSet");
        this.targetDataSet = dataSet;
        this.sourceDataSet = dataSet2;
        this.conflicts = new ConflictCollection();
        this.mergedMap = new HashMap<PrimitiveId, PrimitiveId>();
        this.objectsWithChildrenToMerge = new HashSet<PrimitiveId>();
        this.objectsToDelete = new HashSet<OsmPrimitive>();
    }

    protected void mergePrimitive(OsmPrimitive osmPrimitive) {
        Object object;
        if (!osmPrimitive.isNew()) {
            if (this.mergeById(osmPrimitive)) {
                return;
            }
        } else {
            if (osmPrimitive.isDeleted()) {
                return;
            }
            object = null;
            switch (osmPrimitive.getType()) {
                case NODE: {
                    object = this.targetDataSet.getNodes();
                    break;
                }
                case WAY: {
                    object = this.targetDataSet.getWays();
                    break;
                }
                case RELATION: {
                    object = this.targetDataSet.getRelations();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            Iterator<OsmPrimitive> iterator = object.iterator();
            while (iterator.hasNext()) {
                OsmPrimitive osmPrimitive2 = iterator.next();
                if (!osmPrimitive2.isNew() || osmPrimitive2.isDeleted() || !osmPrimitive2.hasEqualSemanticAttributes(osmPrimitive)) continue;
                this.mergedMap.put(osmPrimitive.getPrimitiveId(), osmPrimitive2.getPrimitiveId());
                osmPrimitive2.setVisible(osmPrimitive.isVisible());
                osmPrimitive2.setUser(osmPrimitive.getUser());
                osmPrimitive2.setTimestamp(osmPrimitive.getTimestamp());
                osmPrimitive2.setModified(osmPrimitive.isModified());
                this.objectsWithChildrenToMerge.add(osmPrimitive.getPrimitiveId());
                return;
            }
        }
        object = null;
        switch (osmPrimitive.getType()) {
            case NODE: {
                object = osmPrimitive.isNew() ? new Node() : new Node(osmPrimitive.getId());
                break;
            }
            case WAY: {
                object = osmPrimitive.isNew() ? new Way() : new Way(osmPrimitive.getId());
                break;
            }
            case RELATION: {
                object = osmPrimitive.isNew() ? new Relation() : new Relation(osmPrimitive.getId());
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        ((OsmPrimitive)object).mergeFrom(osmPrimitive);
        this.targetDataSet.addPrimitive((OsmPrimitive)object);
        this.mergedMap.put(osmPrimitive.getPrimitiveId(), ((OsmPrimitive)object).getPrimitiveId());
        this.objectsWithChildrenToMerge.add(osmPrimitive.getPrimitiveId());
    }

    protected OsmPrimitive getMergeTarget(OsmPrimitive osmPrimitive) throws IllegalStateException {
        PrimitiveId primitiveId = this.mergedMap.get(osmPrimitive.getPrimitiveId());
        if (primitiveId == null) {
            return null;
        }
        return this.targetDataSet.getPrimitiveById(primitiveId);
    }

    protected void fixIncomplete(Way way) {
        Way way2 = (Way)this.getMergeTarget(way);
        if (way2 == null) {
            throw new RuntimeException(I18n.tr("Missing merge target for way with id {0}", way.getUniqueId()));
        }
    }

    public void fixReferences() {
        for (Way osmPrimitive : this.sourceDataSet.getWays()) {
            if (this.conflicts.hasConflictForTheir(osmPrimitive) || !this.objectsWithChildrenToMerge.contains(osmPrimitive.getPrimitiveId())) continue;
            this.mergeNodeList(osmPrimitive);
            this.fixIncomplete(osmPrimitive);
        }
        for (Relation relation : this.sourceDataSet.getRelations()) {
            if (this.conflicts.hasConflictForTheir(relation) || !this.objectsWithChildrenToMerge.contains(relation.getPrimitiveId())) continue;
            this.mergeRelationMembers(relation);
        }
        this.deleteMarkedObjects();
    }

    protected void deleteMarkedObjects() {
        boolean bl;
        do {
            bl = false;
            Iterator<OsmPrimitive> iterator = this.objectsToDelete.iterator();
            block1: while (iterator.hasNext()) {
                OsmPrimitive osmPrimitive = iterator.next();
                OsmPrimitive osmPrimitive2 = this.sourceDataSet.getPrimitiveById(osmPrimitive.getPrimitiveId());
                if (osmPrimitive2 == null) {
                    throw new RuntimeException(I18n.tr("Object of type {0} with id {1} was marked to be deleted, but it's missing in the source dataset", new Object[]{osmPrimitive.getType(), osmPrimitive.getUniqueId()}));
                }
                List<OsmPrimitive> list = osmPrimitive.getReferrers();
                if (list.isEmpty()) {
                    osmPrimitive.setDeleted(true);
                    osmPrimitive.mergeFrom(osmPrimitive2);
                    iterator.remove();
                    bl = true;
                    continue;
                }
                for (OsmPrimitive osmPrimitive3 : list) {
                    if (this.objectsToDelete.contains(osmPrimitive3)) continue;
                    this.conflicts.add(osmPrimitive, osmPrimitive2);
                    iterator.remove();
                    bl = true;
                    continue block1;
                }
            }
        } while (bl);
        if (!this.objectsToDelete.isEmpty()) {
            for (OsmPrimitive osmPrimitive : this.objectsToDelete) {
                if (osmPrimitive instanceof Way) {
                    ((Way)osmPrimitive).setNodes(null);
                    continue;
                }
                if (!(osmPrimitive instanceof Relation)) continue;
                ((Relation)osmPrimitive).setMembers(null);
            }
            for (OsmPrimitive osmPrimitive : this.objectsToDelete) {
                osmPrimitive.setDeleted(true);
                osmPrimitive.mergeFrom(this.sourceDataSet.getPrimitiveById(osmPrimitive.getPrimitiveId()));
            }
        }
    }

    private void mergeNodeList(Way way) throws IllegalStateException {
        Way way2 = (Way)this.getMergeTarget(way);
        if (way2 == null) {
            throw new IllegalStateException(I18n.tr("Missing merge target for way with id {0}", way.getUniqueId()));
        }
        ArrayList<Node> arrayList = new ArrayList<Node>(way.getNodesCount());
        for (Node node : way.getNodes()) {
            Node node2 = (Node)this.getMergeTarget(node);
            if (node2 != null) {
                arrayList.add(node2);
                if (!node2.isDeleted() || this.conflicts.hasConflictForMy(node2)) continue;
                this.conflicts.add(new Conflict<Node>(node2, node, true));
                node2.setDeleted(false);
                continue;
            }
            throw new IllegalStateException(I18n.tr("Missing merge target for node with id {0}", node.getUniqueId()));
        }
        way2.setNodes(arrayList);
    }

    private void mergeRelationMembers(Relation relation) throws IllegalStateException {
        Relation relation2 = (Relation)this.getMergeTarget(relation);
        if (relation2 == null) {
            throw new IllegalStateException(I18n.tr("Missing merge target for relation with id {0}", relation.getUniqueId()));
        }
        LinkedList<RelationMember> linkedList = new LinkedList<RelationMember>();
        for (RelationMember relationMember : relation.getMembers()) {
            OsmPrimitive osmPrimitive = this.getMergeTarget(relationMember.getMember());
            if (osmPrimitive == null) {
                throw new IllegalStateException(I18n.tr("Missing merge target of type {0} with id {1}", new Object[]{relationMember.getType(), relationMember.getUniqueId()}));
            }
            RelationMember relationMember2 = new RelationMember(relationMember.getRole(), osmPrimitive);
            linkedList.add(relationMember2);
            if (!osmPrimitive.isDeleted() || this.conflicts.hasConflictForMy(osmPrimitive)) continue;
            this.conflicts.add(new Conflict<OsmPrimitive>(osmPrimitive, relationMember.getMember(), true));
            osmPrimitive.setDeleted(false);
        }
        relation2.setMembers(linkedList);
    }

    private boolean mergeById(OsmPrimitive osmPrimitive) {
        OsmPrimitive osmPrimitive2 = this.targetDataSet.getPrimitiveById(osmPrimitive.getId(), osmPrimitive.getType());
        if (osmPrimitive2 == null) {
            return false;
        }
        this.mergedMap.put(osmPrimitive.getPrimitiveId(), osmPrimitive2.getPrimitiveId());
        if (osmPrimitive2.getVersion() > osmPrimitive.getVersion()) {
            return true;
        }
        if (osmPrimitive2.isIncomplete() && !osmPrimitive.isIncomplete()) {
            osmPrimitive2.mergeFrom(osmPrimitive);
            this.objectsWithChildrenToMerge.add(osmPrimitive.getPrimitiveId());
        } else if (!(!osmPrimitive2.isIncomplete() && osmPrimitive.isIncomplete() || osmPrimitive2.isIncomplete() && osmPrimitive.isIncomplete())) {
            if (!osmPrimitive2.isModified() && !osmPrimitive.isModified() && osmPrimitive2.isVisible() != osmPrimitive.isVisible() && osmPrimitive2.getVersion() == osmPrimitive.getVersion()) {
                throw new DataIntegrityProblemException(I18n.tr("Conflict in 'visible' attribute for object of type {0} with id {1}", new Object[]{osmPrimitive2.getType(), osmPrimitive2.getId()}));
            }
            if (osmPrimitive2.isDeleted() && !osmPrimitive.isDeleted() && osmPrimitive2.getVersion() == osmPrimitive.getVersion()) {
                for (OsmPrimitive osmPrimitive3 : osmPrimitive.getReferrers()) {
                    if (this.targetDataSet.getPrimitiveById(osmPrimitive3.getPrimitiveId()) != null) continue;
                    this.conflicts.add(new Conflict<OsmPrimitive>(osmPrimitive2, osmPrimitive, true));
                    osmPrimitive2.setDeleted(false);
                    break;
                }
            } else if (!osmPrimitive2.isModified() && osmPrimitive.isDeleted()) {
                this.objectsToDelete.add(osmPrimitive2);
            } else if (!osmPrimitive2.isModified() && osmPrimitive.isModified()) {
                osmPrimitive2.mergeFrom(osmPrimitive);
                this.objectsWithChildrenToMerge.add(osmPrimitive.getPrimitiveId());
            } else if (!osmPrimitive2.isModified() && !osmPrimitive.isModified() && osmPrimitive2.getVersion() == osmPrimitive.getVersion()) {
                osmPrimitive2.mergeFrom(osmPrimitive);
                this.objectsWithChildrenToMerge.add(osmPrimitive.getPrimitiveId());
            } else if (!osmPrimitive2.isModified() && !osmPrimitive.isModified() && osmPrimitive2.getVersion() < osmPrimitive.getVersion()) {
                osmPrimitive2.mergeFrom(osmPrimitive);
                this.objectsWithChildrenToMerge.add(osmPrimitive.getPrimitiveId());
            } else if (osmPrimitive2.isModified() && !osmPrimitive.isModified() && osmPrimitive2.getVersion() == osmPrimitive.getVersion()) {
                if (osmPrimitive2.hasEqualSemanticAttributes(osmPrimitive)) {
                    osmPrimitive2.setModified(false);
                }
            } else if (osmPrimitive.isDeleted() != osmPrimitive2.isDeleted()) {
                this.conflicts.add(osmPrimitive2, osmPrimitive);
            } else if (!osmPrimitive2.hasEqualSemanticAttributes(osmPrimitive)) {
                this.conflicts.add(osmPrimitive2, osmPrimitive);
            } else {
                osmPrimitive2.mergeFrom(osmPrimitive);
                this.objectsWithChildrenToMerge.add(osmPrimitive.getPrimitiveId());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge() {
        if (this.sourceDataSet == null) {
            return;
        }
        this.targetDataSet.beginUpdate();
        try {
            for (Node osmPrimitive : this.sourceDataSet.getNodes()) {
                this.mergePrimitive(osmPrimitive);
            }
            for (Way way : this.sourceDataSet.getWays()) {
                this.mergePrimitive(way);
            }
            for (Relation relation : this.sourceDataSet.getRelations()) {
                this.mergePrimitive(relation);
            }
            this.fixReferences();
        }
        finally {
            this.targetDataSet.endUpdate();
        }
    }

    public DataSet getTargetDataSet() {
        return this.targetDataSet;
    }

    public ConflictCollection getConflicts() {
        return this.conflicts;
    }
}

