/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.conflict.pair.ConflictResolver;
import org.openstreetmap.josm.gui.help.HelpBrowser;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ConflictResolutionDialog
extends JDialog
implements PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(ConflictResolutionDialog.class.getName());
    public static final Dimension DEFAULT_SIZE = new Dimension(600, 400);
    private ConflictResolver resolver;
    private ApplyResolutionAction applyResolutionAction;

    protected void restorePositionAndDimension() {
        Point point = new Point();
        Dimension dimension = new Dimension();
        try {
            point.x = Integer.parseInt(Main.pref.get("conflictresolutiondialog.x", "0"));
            point.x = Math.max(0, point.x);
        }
        catch (Exception exception) {
            logger.warning("unexpected value for preference conflictresolutiondialog.x, assuming 0");
            point.x = 0;
        }
        try {
            point.y = Integer.parseInt(Main.pref.get("conflictresolutiondialog.y", "0"));
            point.y = Math.max(0, point.y);
        }
        catch (Exception exception) {
            logger.warning("unexpected value for preference conflictresolutiondialog.x, assuming 0");
            point.y = 0;
        }
        try {
            dimension.width = Integer.parseInt(Main.pref.get("conflictresolutiondialog.width", Integer.toString(ConflictResolutionDialog.DEFAULT_SIZE.width)));
            dimension.width = Math.max(0, dimension.width);
        }
        catch (Exception exception) {
            logger.warning("unexpected value for preference conflictresolutiondialog.width, assuming " + ConflictResolutionDialog.DEFAULT_SIZE.width);
            point.y = 0;
        }
        try {
            dimension.height = Integer.parseInt(Main.pref.get("conflictresolutiondialog.height", Integer.toString(ConflictResolutionDialog.DEFAULT_SIZE.height)));
            dimension.height = Math.max(0, dimension.height);
        }
        catch (Exception exception) {
            logger.warning("unexpected value for preference conflictresolutiondialog.height, assuming " + ConflictResolutionDialog.DEFAULT_SIZE.height);
            point.y = 0;
        }
        this.setLocation(point);
        this.setSize(dimension);
    }

    protected void rememberPositionAndDimension() {
        Point point = this.getLocation();
        Main.pref.put("conflictresolutiondialog.x", Integer.toString(point.x));
        Main.pref.put("conflictresolutiondialog.y", Integer.toString(point.y));
        Dimension dimension = this.getSize();
        Main.pref.put("conflictresolutiondialog.width", Integer.toString(dimension.width));
        Main.pref.put("conflictresolutiondialog.height", Integer.toString(dimension.height));
    }

    public void removeNotify() {
        super.removeNotify();
        this.unregisterListeners();
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.restorePositionAndDimension();
            this.toFront();
        } else {
            this.rememberPositionAndDimension();
            this.unregisterListeners();
        }
        super.setVisible(bl);
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    protected JPanel buildButtonRow() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        this.applyResolutionAction = new ApplyResolutionAction();
        JButton jButton = new JButton(this.applyResolutionAction);
        jButton.setName("button.apply");
        jPanel.add(jButton);
        jButton = new JButton(new CancelAction());
        jButton.setName("button.cancel");
        jPanel.add(jButton);
        jButton = new JButton(new HelpAction());
        jButton.setName("button.help");
        jPanel.add(jButton);
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        return jPanel;
    }

    private void registerListeners() {
        this.resolver.addPropertyChangeListener(this.applyResolutionAction);
    }

    private void unregisterListeners() {
        this.resolver.removePropertyChangeListener(this.applyResolutionAction);
    }

    protected void build() {
        this.setDefaultCloseOperation(2);
        this.updateTitle();
        this.getContentPane().setLayout(new BorderLayout());
        this.resolver = new ConflictResolver();
        this.resolver.setName("panel.conflictresolver");
        this.getContentPane().add((Component)this.resolver, "Center");
        this.getContentPane().add((Component)this.buildButtonRow(), "South");
        this.resolver.addPropertyChangeListener(this);
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("Dialog/Conflict"));
        this.registerListeners();
    }

    public ConflictResolutionDialog(Component component) {
        super((Window)JOptionPane.getFrameForComponent(component), Dialog.ModalityType.DOCUMENT_MODAL);
        this.build();
    }

    public ConflictResolver getConflictResolver() {
        return this.resolver;
    }

    protected void updateTitle() {
        this.updateTitle(null);
    }

    protected void updateTitle(OsmPrimitive osmPrimitive) {
        if (osmPrimitive == null) {
            this.setTitle(I18n.tr("Resolve conflicts"));
        } else {
            this.setTitle(I18n.tr("Resolve conflicts for ''{0}''", osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance())));
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals(ConflictResolver.MY_PRIMITIVE_PROP)) {
            this.updateTitle((OsmPrimitive)propertyChangeEvent.getNewValue());
        }
    }

    class ApplyResolutionAction
    extends AbstractAction
    implements PropertyChangeListener {
        public ApplyResolutionAction() {
            this.putValue("ShortDescription", I18n.tr("Apply resolved conflicts and close the dialog"));
            this.putValue("Name", I18n.tr("Apply Resolution"));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "conflict"));
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            this.setEnabled(ConflictResolutionDialog.this.resolver.isResolvedCompletely());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray;
            if (!ConflictResolutionDialog.this.resolver.isResolvedCompletely()) {
                objectArray = new Object[]{I18n.tr("Close anyway"), I18n.tr("Continue resolving")};
                int n = JOptionPane.showOptionDialog(Main.parent, I18n.tr("<html>You did not finish to merge the differences in this conflict.<br>Conflict resolutions will not be applied unless all differences<br>are resolved.<br>Click <strong>{0}</strong> to close anyway.<strong> Already<br>resolved differences will not be applied.</strong><br>Click <strong>{1}</strong> to return to resolving conflicts.</html>", objectArray[0].toString(), objectArray[1].toString()), I18n.tr("Conflict not resolved completely"), 0, 2, null, objectArray, objectArray[1]);
                switch (n) {
                    case 0: {
                        ConflictResolutionDialog.this.closeDialog();
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            objectArray = ConflictResolutionDialog.this.resolver.buildResolveCommand();
            Main.main.undoRedo.add((Command)objectArray);
            ConflictResolutionDialog.this.closeDialog();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(ConflictResolver.RESOLVED_COMPLETELY_PROP)) {
                this.updateEnabledState();
            }
        }
    }

    static class HelpAction
    extends AbstractAction {
        public HelpAction() {
            this.putValue("ShortDescription", I18n.tr("Show help information"));
            this.putValue("Name", I18n.tr("Help"));
            this.putValue("SmallIcon", ImageProvider.get("help"));
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HelpBrowser.setUrlForHelpTopic(HelpUtil.ht("/Dialog/Conflict"));
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("ShortDescription", I18n.tr("Cancel conflict resolution and close the dialog"));
            this.putValue("Name", I18n.tr("Cancel"));
            this.putValue("SmallIcon", ImageProvider.get("", "cancel"));
            this.setEnabled(true);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ConflictResolutionDialog.this.closeDialog();
        }
    }
}

