/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SingleSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.User;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.MultiCascade;
import org.openstreetmap.josm.gui.mappaint.StyleCache;
import org.openstreetmap.josm.gui.mappaint.StyleSource;
import org.openstreetmap.josm.gui.mappaint.mapcss.MapCSSStyleSource;
import org.openstreetmap.josm.gui.mappaint.xml.XmlStyleSource;
import org.openstreetmap.josm.tools.DateUtils;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InspectPrimitiveDialog
extends ExtendedDialog {
    protected Collection<OsmPrimitive> primitives;
    private JTextArea txtData;
    private JTextArea txtMappaint;
    boolean mappaintTabLoaded;

    public InspectPrimitiveDialog(Collection<OsmPrimitive> collection) {
        super(Main.parent, I18n.tr("Advanced object info"), new String[]{I18n.tr("Close")});
        this.primitives = collection;
        this.setPreferredSize(new Dimension(750, 550));
        this.setButtonIcons(new String[]{"ok.png"});
        JTabbedPane jTabbedPane = new JTabbedPane();
        JPanel jPanel = this.buildDataPanel();
        jTabbedPane.addTab(I18n.tr("data"), jPanel);
        final JPanel jPanel2 = new JPanel();
        jTabbedPane.addTab(I18n.tr("map style"), jPanel2);
        jTabbedPane.getModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (!InspectPrimitiveDialog.this.mappaintTabLoaded && ((SingleSelectionModel)changeEvent.getSource()).getSelectedIndex() == 1) {
                    InspectPrimitiveDialog.this.mappaintTabLoaded = true;
                    InspectPrimitiveDialog.this.buildMapPaintPanel(jPanel2);
                    InspectPrimitiveDialog.this.createMapPaintText();
                }
            }
        });
        this.txtData.setText(this.buildDataText());
        this.setContent(jTabbedPane, false);
    }

    protected JPanel buildDataPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.txtData = new JTextArea();
        this.txtData.setFont(new Font("Monospaced", this.txtData.getFont().getStyle(), this.txtData.getFont().getSize()));
        this.txtData.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.txtData);
        jPanel.add((Component)jScrollPane, GBC.std().fill());
        return jPanel;
    }

    protected String buildDataText() {
        StringBuilder stringBuilder = new StringBuilder();
        for (OsmPrimitive osmPrimitive : new SubclassFilteredCollection(this.primitives, OsmPrimitive.nodePredicate)) {
            stringBuilder.append("Node id=" + osmPrimitive.getUniqueId());
            if (!this.checkDataSet(osmPrimitive)) {
                stringBuilder.append(" not in data set");
                continue;
            }
            if (osmPrimitive.isIncomplete()) {
                stringBuilder.append(" incomplete\n");
                this.addWayReferrer(stringBuilder, (Node)osmPrimitive);
                this.addRelationReferrer(stringBuilder, osmPrimitive);
                continue;
            }
            stringBuilder.append(String.format(" lat=%s lon=%s (projected: x=%s, y=%s); ", Double.toString(((Node)osmPrimitive).getCoor().lat()), Double.toString(((Node)osmPrimitive).getCoor().lon()), Double.toString(((Node)osmPrimitive).getEastNorth().east()), Double.toString(((Node)osmPrimitive).getEastNorth().north())));
            this.addCommon(stringBuilder, osmPrimitive);
            this.addAttributes(stringBuilder, osmPrimitive);
            this.addWayReferrer(stringBuilder, (Node)osmPrimitive);
            this.addRelationReferrer(stringBuilder, osmPrimitive);
            stringBuilder.append('\n');
        }
        for (OsmPrimitive osmPrimitive : new SubclassFilteredCollection(this.primitives, OsmPrimitive.wayPredicate)) {
            stringBuilder.append("Way id=" + osmPrimitive.getUniqueId());
            if (!this.checkDataSet(osmPrimitive)) {
                stringBuilder.append(" not in data set");
                continue;
            }
            if (osmPrimitive.isIncomplete()) {
                stringBuilder.append(" incomplete\n");
                this.addRelationReferrer(stringBuilder, osmPrimitive);
                continue;
            }
            stringBuilder.append(String.format(" %d nodes; ", ((Way)osmPrimitive).getNodes().size()));
            this.addCommon(stringBuilder, osmPrimitive);
            this.addAttributes(stringBuilder, osmPrimitive);
            this.addRelationReferrer(stringBuilder, osmPrimitive);
            stringBuilder.append("  nodes:\n");
            for (Node primitiveId : ((Way)osmPrimitive).getNodes()) {
                stringBuilder.append(String.format("    %d\n", primitiveId.getUniqueId()));
            }
            stringBuilder.append('\n');
        }
        for (OsmPrimitive osmPrimitive : new SubclassFilteredCollection(this.primitives, OsmPrimitive.relationPredicate)) {
            stringBuilder.append("Relation id=" + osmPrimitive.getUniqueId());
            if (!this.checkDataSet(osmPrimitive)) {
                stringBuilder.append(" not in data set");
                continue;
            }
            if (osmPrimitive.isIncomplete()) {
                stringBuilder.append(" incomplete\n");
                this.addRelationReferrer(stringBuilder, osmPrimitive);
                continue;
            }
            stringBuilder.append(String.format(" %d members; ", ((Relation)osmPrimitive).getMembersCount()));
            this.addCommon(stringBuilder, osmPrimitive);
            this.addAttributes(stringBuilder, osmPrimitive);
            this.addRelationReferrer(stringBuilder, osmPrimitive);
            stringBuilder.append("  members:\n");
            for (RelationMember relationMember : ((Relation)osmPrimitive).getMembers()) {
                stringBuilder.append(String.format("    %s%d '%s'\n", relationMember.getMember().getType().getAPIName().substring(0, 1), relationMember.getMember().getUniqueId(), relationMember.getRole()));
            }
            stringBuilder.append('\n');
        }
        return stringBuilder.toString().trim();
    }

    protected void addCommon(StringBuilder stringBuilder, OsmPrimitive osmPrimitive) {
        stringBuilder.append(String.format("Data set: %X; User: [%s]; ChangeSet id: %d; Timestamp: %s, Version: %d", osmPrimitive.getDataSet().hashCode(), this.userString(osmPrimitive.getUser()), osmPrimitive.getChangesetId(), DateUtils.fromDate(osmPrimitive.getTimestamp()), osmPrimitive.getVersion()));
        if (osmPrimitive.isDeleted()) {
            stringBuilder.append("; deleted");
        }
        if (!osmPrimitive.isVisible()) {
            stringBuilder.append("; deleted-on-server");
        }
        if (osmPrimitive.isModified()) {
            stringBuilder.append("; modified");
        }
        if (osmPrimitive.isDisabledAndHidden()) {
            stringBuilder.append("; filtered/hidden");
        }
        if (osmPrimitive.isDisabled()) {
            stringBuilder.append("; filtered/disabled");
        }
        if (osmPrimitive.hasDirectionKeys()) {
            stringBuilder.append("; has direction keys");
            if (osmPrimitive.reversedDirection()) {
                stringBuilder.append(" (reversed)");
            }
        }
        stringBuilder.append("\n");
    }

    protected void addAttributes(StringBuilder stringBuilder, OsmPrimitive osmPrimitive) {
        if (osmPrimitive.hasKeys()) {
            stringBuilder.append("  tags:\n");
            for (String string : osmPrimitive.keySet()) {
                stringBuilder.append(String.format("    \"%s\"=\"%s\"\n", string, osmPrimitive.get(string)));
            }
        }
    }

    protected void addWayReferrer(StringBuilder stringBuilder, Node node) {
        List<OsmPrimitive> list = node.getReferrers();
        SubclassFilteredCollection subclassFilteredCollection = new SubclassFilteredCollection(list, OsmPrimitive.wayPredicate);
        if (subclassFilteredCollection.size() > 0) {
            stringBuilder.append("  way referrer:\n");
            for (Way way : subclassFilteredCollection) {
                stringBuilder.append("    " + way.getUniqueId() + "\n");
            }
        }
    }

    protected void addRelationReferrer(StringBuilder stringBuilder, OsmPrimitive osmPrimitive) {
        List<OsmPrimitive> list = osmPrimitive.getReferrers();
        SubclassFilteredCollection subclassFilteredCollection = new SubclassFilteredCollection(list, OsmPrimitive.relationPredicate);
        if (subclassFilteredCollection.size() > 0) {
            stringBuilder.append("  relation referrer:\n");
            for (Relation relation : subclassFilteredCollection) {
                stringBuilder.append("    " + relation.getUniqueId() + "\n");
            }
        }
    }

    protected boolean checkDataSet(OsmPrimitive osmPrimitive) {
        DataSet dataSet = osmPrimitive.getDataSet();
        if (dataSet == null) {
            return false;
        }
        return dataSet.getPrimitiveById(osmPrimitive) != null;
    }

    protected String userString(User user) {
        if (user == null) {
            return "<null>";
        }
        ArrayList<String> arrayList = user.getNames();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("id:" + user.getId());
        if (arrayList.size() == 1) {
            stringBuilder.append(" name:" + user.getName());
        } else if (arrayList.size() > 1) {
            stringBuilder.append(String.format(" %d names:%s", arrayList.size(), user.getName()));
        }
        return stringBuilder.toString();
    }

    protected void buildMapPaintPanel(JPanel jPanel) {
        jPanel.setLayout(new GridBagLayout());
        this.txtMappaint = new JTextArea();
        this.txtMappaint.setFont(new Font("Monospaced", this.txtMappaint.getFont().getStyle(), this.txtMappaint.getFont().getSize()));
        this.txtMappaint.setEditable(false);
        jPanel.add((Component)new JScrollPane(this.txtMappaint), GBC.std().fill());
    }

    protected void createMapPaintText() {
        Object object;
        Collection<OsmPrimitive> collection = Main.main.getCurrentDataSet().getSelected();
        ElemStyles elemStyles = MapPaintStyles.getStyles();
        MapView mapView = Main.map.mapView;
        double d = mapView.getDist100Pixel();
        for (OsmPrimitive object2 : collection) {
            this.txtMappaint.append("Styles Cache for \"" + object2.getDisplayName(DefaultNameFormatter.getInstance()) + "\":");
            object = new MultiCascade();
            for (StyleSource styleSource : elemStyles.getStyleSources()) {
                if (styleSource.active) {
                    this.txtMappaint.append("\n\n> applying " + this.getSort(styleSource) + " style \"" + styleSource.getDisplayString() + "\n");
                    styleSource.apply((MultiCascade)object, object2, d, null, false);
                    this.txtMappaint.append("\nRange:" + ((MultiCascade)object).range);
                    for (Map.Entry entry : ((MultiCascade)object).getLayers()) {
                        this.txtMappaint.append("\n " + (String)entry.getKey() + ": \n" + entry.getValue());
                    }
                    continue;
                }
                this.txtMappaint.append("\n\n> skipping \"" + styleSource.getDisplayString() + "\" (not active)");
            }
            this.txtMappaint.append("\n\nList of generated Styles:\n");
            StyleCache.StyleList styleList = elemStyles.get(object2, d, mapView);
            Iterator<ElemStyle> iterator = styleList.iterator();
            while (iterator.hasNext()) {
                ElemStyle elemStyle = iterator.next();
                this.txtMappaint.append(" * " + elemStyle + "\n");
            }
            this.txtMappaint.append("\n\n");
        }
        if (collection.size() == 2) {
            ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>(collection);
            StyleCache styleCache = ((OsmPrimitive)arrayList.get((int)0)).mappaintStyle;
            object = ((OsmPrimitive)arrayList.get((int)1)).mappaintStyle;
            if (styleCache == object) {
                this.txtMappaint.append("The 2 selected Objects have identical style caches.");
            }
            if (!styleCache.equals(object)) {
                this.txtMappaint.append("The 2 selected Objects have different style caches.");
            }
            if (styleCache.equals(object) && styleCache != object) {
                this.txtMappaint.append("Warning: The 2 selected Objects have equal, but not identical style caches.");
            }
        }
    }

    private String getSort(StyleSource styleSource) {
        if (styleSource instanceof XmlStyleSource) {
            return "xml";
        }
        if (styleSource instanceof MapCSSStyleSource) {
            return "mapcss";
        }
        return "unkown";
    }
}

