/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset.query;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class UrlBasedQueryPanel
extends JPanel {
    private JTextField tfUrl;
    private JLabel lblValid;

    protected JPanel buildURLPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel.add((Component)new JLabel(I18n.tr("URL: ")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.tfUrl = new JTextField();
        jPanel.add((Component)this.tfUrl, gridBagConstraints);
        this.tfUrl.getDocument().addDocumentListener(new ChangetQueryUrlValidator());
        this.tfUrl.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                UrlBasedQueryPanel.this.tfUrl.selectAll();
            }
        });
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 2;
        this.lblValid = new JLabel();
        jPanel.add((Component)this.lblValid, gridBagConstraints);
        this.lblValid.setPreferredSize(new Dimension(20, 20));
        return jPanel;
    }

    protected JPanel buildHelpPanel() {
        HtmlPanel htmlPanel = new HtmlPanel();
        htmlPanel.setText("<html><body>" + I18n.tr("Please enter or paste an URL to retrieve changesets from the OSM API.") + "<p><strong>" + I18n.tr("Examples") + "</strong></p>" + "<ul>" + "<li><a href=\"http://www.openstreetmap.org/browse/changesets?open=true\">http://www.openstreetmap.org/browse/changesets?open=true</a></li>" + "<li><a href=\"http://api.openstreetmap.org/api/0.6/changesets?open=true\">http://api.openstreetmap.org/api/0.6/changesets?open=true</a></li>" + "</ul>" + I18n.tr("Note that changeset queries are currently always submitted to ''{0}'', regardless of the host, port and path of the URL entered below.", OsmApi.getOsmApi().getBaseUrl()) + "</body></html>");
        htmlPanel.getEditorPane().addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                    UrlBasedQueryPanel.this.tfUrl.setText(hyperlinkEvent.getDescription());
                    UrlBasedQueryPanel.this.tfUrl.requestFocusInWindow();
                }
            }
        });
        return htmlPanel;
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        this.add((Component)this.buildHelpPanel(), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.buildURLPanel(), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.add((Component)new JPanel(), gridBagConstraints);
    }

    public UrlBasedQueryPanel() {
        this.build();
    }

    protected boolean isValidChangesetQueryUrl(String string) {
        return this.buildChangesetQuery(string) != null;
    }

    protected ChangesetQuery buildChangesetQuery(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        String string2 = uRL.getPath();
        String string3 = uRL.getQuery();
        if (string2 == null || !string2.endsWith("/changesets")) {
            return null;
        }
        try {
            return ChangesetQuery.buildFromUrlQuery(string3);
        }
        catch (ChangesetQuery.ChangesetQueryUrlException changesetQueryUrlException) {
            return null;
        }
    }

    public ChangesetQuery buildChangesetQuery() {
        String string = this.tfUrl.getText().trim();
        return this.buildChangesetQuery(string);
    }

    public void startUserInput() {
        this.tfUrl.requestFocusInWindow();
    }

    class ChangetQueryUrlValidator
    implements DocumentListener {
        ChangetQueryUrlValidator() {
        }

        protected String getCurrentFeedback() {
            String string = (String)UrlBasedQueryPanel.this.lblValid.getClientProperty("valid");
            return string == null ? "none" : string;
        }

        protected void feedbackValid() {
            if (this.getCurrentFeedback().equals("valid")) {
                return;
            }
            UrlBasedQueryPanel.this.lblValid.setIcon(ImageProvider.get("dialogs/changeset", "valid"));
            UrlBasedQueryPanel.this.lblValid.setToolTipText("");
            UrlBasedQueryPanel.this.lblValid.putClientProperty("valid", "valid");
        }

        protected void feedbackInvalid() {
            if (this.getCurrentFeedback().equals("invalid")) {
                return;
            }
            UrlBasedQueryPanel.this.lblValid.setIcon(ImageProvider.get("warning-small"));
            UrlBasedQueryPanel.this.lblValid.setToolTipText(I18n.tr("This changeset query URL is invalid"));
            UrlBasedQueryPanel.this.lblValid.putClientProperty("valid", "invalid");
        }

        protected void feedbackNone() {
            UrlBasedQueryPanel.this.lblValid.setIcon(null);
            UrlBasedQueryPanel.this.lblValid.putClientProperty("valid", "none");
        }

        protected void validate() {
            String string = UrlBasedQueryPanel.this.tfUrl.getText();
            if (string.trim().equals("")) {
                this.feedbackNone();
                return;
            }
            if (UrlBasedQueryPanel.this.isValidChangesetQueryUrl(string = string.trim())) {
                this.feedbackValid();
            } else {
                this.feedbackInvalid();
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.validate();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.validate();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.validate();
        }
    }
}

