/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.awt.Color;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPaintSettings;
import org.openstreetmap.josm.data.osm.visitor.paint.MapPainter;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.gui.mappaint.Cascade;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.Keyword;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.TextElement;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Utils;

public class AreaElemStyle
extends ElemStyle {
    public Color color;
    public BufferedImage fillImage;
    public float fillImageAlpha;
    public TextElement text;

    protected AreaElemStyle(Cascade cascade, Color color, BufferedImage bufferedImage, float f, TextElement textElement) {
        super(cascade, -1000.0f);
        CheckParameterUtil.ensureParameterNotNull(color);
        this.color = color;
        this.fillImage = bufferedImage;
        this.fillImageAlpha = f;
        this.text = textElement;
    }

    public static AreaElemStyle create(Cascade cascade) {
        Object object;
        BufferedImage bufferedImage = null;
        Color color = null;
        float f = 1.0f;
        MapPaintStyles.IconReference iconReference = cascade.get("fill-image", null, MapPaintStyles.IconReference.class);
        if (iconReference != null) {
            ImageIcon imageIcon = MapPaintStyles.getIcon(iconReference, false);
            if (imageIcon != null) {
                if (!(imageIcon.getImage() instanceof BufferedImage)) {
                    imageIcon = MapPaintStyles.getIcon(iconReference, true);
                }
                if (!(imageIcon.getImage() instanceof BufferedImage)) {
                    throw new RuntimeException();
                }
                bufferedImage = (BufferedImage)imageIcon.getImage();
                color = new Color(bufferedImage.getRGB(bufferedImage.getWidth() / 2, bufferedImage.getHeight() / 2));
                f = Utils.color_int2float(Math.min(255, Math.max(0, Main.pref.getInteger("mappaint.fill-image-alpha", 255)))).floatValue();
                object = cascade.get("fill-opacity", null, Float.class);
                if (object != null) {
                    if (((Float)object).floatValue() < 0.0f || ((Float)object).floatValue() > 1.0f) {
                        object = Float.valueOf(1.0f);
                    }
                    f = ((Float)object).floatValue();
                }
            }
        } else {
            color = cascade.get("fill-color", null, Color.class);
            if (color != null) {
                int n = Math.min(255, Math.max(0, Main.pref.getInteger("mappaint.fillalpha", 50)));
                object = Utils.color_float2int(cascade.get("fill-opacity", null, Float.TYPE));
                if (object != null) {
                    n = (Integer)object;
                }
                color = new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
            }
        }
        TextElement textElement = null;
        object = cascade.get("text-position", null, Keyword.class);
        if (object == null || Utils.equal(((Keyword)object).val, "center")) {
            textElement = TextElement.create(cascade, PaintColors.AREA_TEXT.get(), true);
        }
        if (color != null) {
            return new AreaElemStyle(cascade, color, bufferedImage, f, textElement);
        }
        return null;
    }

    public void paintPrimitive(OsmPrimitive osmPrimitive, MapPaintSettings mapPaintSettings, MapPainter mapPainter, boolean bl, boolean bl2) {
        if (osmPrimitive instanceof Way) {
            Color color = this.color;
            if (this.color != null && osmPrimitive.isSelected()) {
                color = mapPaintSettings.getSelectedColor(this.color.getAlpha());
            }
            mapPainter.drawArea((Way)osmPrimitive, color, this.fillImage, this.fillImageAlpha, this.text);
        } else if (osmPrimitive instanceof Relation) {
            Color color = this.color;
            if (this.color != null && bl) {
                color = mapPaintSettings.getRelationSelectedColor(this.color.getAlpha());
            }
            mapPainter.drawArea((Relation)osmPrimitive, color, this.fillImage, this.fillImageAlpha, this.text);
        }
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        AreaElemStyle areaElemStyle = (AreaElemStyle)object;
        if (this.fillImage != areaElemStyle.fillImage) {
            return false;
        }
        if (!Utils.equal(this.color, areaElemStyle.color)) {
            return false;
        }
        if (this.fillImageAlpha != areaElemStyle.fillImageAlpha) {
            return false;
        }
        return Utils.equal(this.text, areaElemStyle.text);
    }

    public int hashCode() {
        int n = 3;
        n = 61 * n + this.color.hashCode();
        n = 61 * n + (this.fillImage != null ? this.fillImage.hashCode() : 0);
        n = 61 * n + Float.floatToIntBits(this.fillImageAlpha);
        n = 61 * n + (this.text != null ? this.text.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "AreaElemStyle{" + super.toString() + "color=" + Utils.toString(this.color) + " fillImageAlpha=" + this.fillImageAlpha + " fillImage=[" + this.fillImage + "]}";
    }
}

