/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;

public class MirroredInputStream
extends InputStream {
    InputStream fs = null;
    File file = null;

    public MirroredInputStream(String string) throws IOException {
        this(string, null, -1L);
    }

    public MirroredInputStream(String string, long l) throws IOException {
        this(string, null, l);
    }

    public MirroredInputStream(String string, String string2) throws IOException {
        this(string, string2, -1L);
    }

    public MirroredInputStream(String string, String string2, long l) throws IOException {
        try {
            URL uRL = new URL(string);
            if (uRL.getProtocol().equals("file")) {
                this.file = new File(string.substring("file:/".length()));
                if (!this.file.exists()) {
                    this.file = new File(string.substring("file://".length()));
                }
            } else if (Main.applet) {
                URLConnection uRLConnection = uRL.openConnection();
                uRLConnection.setConnectTimeout(5000);
                uRLConnection.setReadTimeout(5000);
                this.fs = new BufferedInputStream(uRLConnection.getInputStream());
                this.file = new File(uRL.getFile());
            } else {
                this.file = this.checkLocal(uRL, string2, l);
            }
        }
        catch (MalformedURLException malformedURLException) {
            if (string.startsWith("resource://")) {
                this.fs = this.getClass().getResourceAsStream(string.substring("resource:/".length()));
                if (this.fs == null) {
                    throw new IOException(I18n.tr("Failed to open input stream for resource ''{0}''", string));
                }
                return;
            }
            this.file = new File(string);
        }
        if (this.file == null) {
            throw new IOException();
        }
        this.fs = new FileInputStream(this.file);
    }

    public InputStream getZipEntry(String string, String string2) {
        InputStream inputStream;
        block6: {
            if (this.file == null) {
                return null;
            }
            inputStream = null;
            try {
                ZipFile zipFile = new ZipFile(this.file);
                ZipEntry zipEntry = null;
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry2 = enumeration.nextElement();
                    if (!zipEntry2.getName().endsWith("." + string) || zipEntry != null && zipEntry2.getName().indexOf(string2) < 0) continue;
                    zipEntry = zipEntry2;
                }
                if (zipEntry != null) {
                    inputStream = zipFile.getInputStream(zipEntry);
                } else {
                    zipFile.close();
                }
            }
            catch (Exception exception) {
                if (!this.file.getName().endsWith(".zip")) break block6;
                System.err.println(I18n.tr("Warning: failed to open file with extension ''{2}'' and namepart ''{3}'' in zip file ''{0}''. Exception was: {1}", this.file.getName(), exception.toString(), string, string2));
            }
        }
        return inputStream;
    }

    public File getFile() {
        return this.file;
    }

    public static void cleanup(String string) {
        MirroredInputStream.cleanup(string, null);
    }

    public static void cleanup(String string, String string2) {
        try {
            URL uRL = new URL(string);
            if (!uRL.getProtocol().equals("file")) {
                String[] stringArray;
                File file;
                String string3 = MirroredInputStream.getPrefKey(uRL, string2);
                Collection<String> collection = Main.pref.getCollectionOld(string3, ";");
                if (collection.size() == 2 && (file = new File((stringArray = (String[])collection.toArray())[1])).exists()) {
                    file.delete();
                }
                Main.pref.put(string3, null);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private static String getPrefKey(URL uRL, String string) {
        StringBuilder stringBuilder = new StringBuilder("mirror.");
        if (string != null) {
            String string2 = Main.pref.getPreferencesDir();
            if (string.startsWith(string2)) {
                string = string.substring(string2.length());
            }
            stringBuilder.append(string);
            stringBuilder.append(".");
        }
        stringBuilder.append(uRL.toString());
        return stringBuilder.toString().replaceAll("=", "_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File checkLocal(URL uRL, String string, long l) throws IOException {
        Object object;
        String string2 = MirroredInputStream.getPrefKey(uRL, string);
        File file = null;
        Collection<String> collection = Main.pref.getCollectionOld(string2, ";");
        if (collection.size() == 2) {
            object = (String[])collection.toArray();
            file = new File((String)object[1]);
            if (!file.exists()) {
                file = null;
            } else {
                if (l <= 0L) {
                    l = Main.pref.getInteger("mirror.maxtime", 604800);
                }
                if (System.currentTimeMillis() - Long.parseLong((String)object[0]) < l * 1000L) {
                    return file;
                }
            }
        }
        if (string == null) {
            string = Main.pref.getPreferencesDir();
        }
        if (!((File)(object = new File(string))).exists()) {
            ((File)object).mkdirs();
        }
        String string3 = uRL.toString().replaceAll("[^A-Za-z0-9_.-]", "_");
        String string4 = "mirror_" + string3;
        object = new File(string, string4 + ".tmp");
        FilterOutputStream filterOutputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            int n;
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setConnectTimeout(5000);
            uRLConnection.setReadTimeout(5000);
            bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
            filterOutputStream = new BufferedOutputStream(new FileOutputStream((File)object));
            byte[] byArray = new byte[4096];
            while ((n = bufferedInputStream.read(byArray)) > -1) {
                ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
            }
            filterOutputStream.close();
            filterOutputStream = null;
            file = new File(string, string4);
            ((File)object).renameTo(file);
            Main.pref.putCollection(string2, Arrays.asList(Long.toString(System.currentTimeMillis()), file.toString()));
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return file;
    }

    public int available() throws IOException {
        return this.fs.available();
    }

    public void close() throws IOException {
        this.fs.close();
    }

    public int read() throws IOException {
        return this.fs.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.fs.read(byArray);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.fs.read(byArray, n, n2);
    }

    public long skip(long l) throws IOException {
        return this.fs.skip(l);
    }
}

