/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AbstractMergeAction;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class MergeLayerAction
extends AbstractMergeAction {
    public MergeLayerAction() {
        super(I18n.tr("Merge layer"), "dialogs/mergedown", I18n.tr("Merge the current layer into another layer"), Shortcut.registerShortcut("system:merge", I18n.tr("Edit: {0}", I18n.tr("Merge")), 77, 2), false);
        this.putValue("help", HelpUtil.ht("/Action/MergeLayer"));
        this.putValue("toolbar", "action/mergelayer");
        Main.toolbar.register(this);
    }

    public void merge(Layer layer) {
        if (layer == null) {
            return;
        }
        List<Layer> list = LayerListDialog.getInstance().getModel().getPossibleMergeTargets(layer);
        if (list.isEmpty()) {
            this.warnNoTargetLayersForSourceLayer(layer);
            return;
        }
        Layer layer2 = this.askTargetLayer(list);
        if (layer2 == null) {
            return;
        }
        layer2.mergeFrom(layer);
        Main.map.mapView.removeLayer(layer);
        Main.map.mapView.setActiveLayer(layer2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        OsmDataLayer osmDataLayer = Main.main.getEditLayer();
        if (osmDataLayer == null) {
            return;
        }
        this.merge(osmDataLayer);
    }

    protected void updateEnabledState() {
        if (MergeLayerAction.getEditLayer() == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(!LayerListDialog.getInstance().getModel().getPossibleMergeTargets(MergeLayerAction.getEditLayer()).isEmpty());
    }
}

