/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DatasetConsistencyTest;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class ShowStatusReportAction
extends JosmAction {
    public ShowStatusReportAction() {
        super(I18n.tr("Show Status Report"), "clock", I18n.tr("Show status report with useful information that can be attached to bugs"), Shortcut.registerShortcut("help:showstatusreport", I18n.tr("Help: {0}", I18n.tr("Show Status Report")), 82, 0), false);
        this.putValue("help", HelpUtil.ht("/Action/ShowStatusReport"));
        this.putValue("toolbar", "help/showstatusreport");
        Main.toolbar.register(this);
    }

    public static String getReportHeader() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Version.getInstance().getReleaseAttributes());
        stringBuilder.append("\n");
        stringBuilder.append("Identification: " + Version.getInstance().getAgentString());
        stringBuilder.append("\n");
        stringBuilder.append("Memory Usage: ");
        stringBuilder.append(Runtime.getRuntime().totalMemory() / 1024L / 1024L);
        stringBuilder.append(" MB / ");
        stringBuilder.append(Runtime.getRuntime().maxMemory() / 1024L / 1024L);
        stringBuilder.append(" MB (");
        stringBuilder.append(Runtime.getRuntime().freeMemory() / 1024L / 1024L);
        stringBuilder.append(" MB allocated, but free)");
        stringBuilder.append("\n");
        stringBuilder.append("Java version: " + System.getProperty("java.version") + ", " + System.getProperty("java.vendor") + ", " + System.getProperty("java.vm.name"));
        stringBuilder.append("\n");
        stringBuilder.append("Operating system: " + System.getProperty("os.name"));
        stringBuilder.append("\n");
        DataSet dataSet = Main.main.getCurrentDataSet();
        if (dataSet != null) {
            String string = DatasetConsistencyTest.runTests(dataSet);
            if (string.length() == 0) {
                stringBuilder.append("Dataset consistency test: No problems found\n");
            } else {
                stringBuilder.append("\nDataset consistency test:\n" + string + "\n");
            }
        }
        stringBuilder.append("\n");
        stringBuilder.append(PluginHandler.getBugReportText());
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Object object2;
        Object object3;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ShowStatusReportAction.getReportHeader());
        try {
            object3 = new BufferedReader(new FileReader(Main.pref.getPreferencesDirFile() + File.separator + "preferences"));
            try {
                object2 = null;
                while ((object2 = ((BufferedReader)object3).readLine()) != null) {
                    object = ((String)object2).trim().toLowerCase();
                    if (((String)object).startsWith("osm-server.username") || ((String)object).startsWith("osm-server.password") || ((String)object).startsWith("marker.show") || ((String)object).startsWith("oauth.access-token.key") || ((String)object).startsWith("oauth.access-token.secret")) continue;
                    stringBuilder.append((String)object2);
                    stringBuilder.append("\n");
                }
            }
            finally {
                ((BufferedReader)object3).close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object3 = new JTextArea(stringBuilder.toString());
        ((JTextArea)object3).setWrapStyleWord(true);
        ((JTextArea)object3).setLineWrap(true);
        ((JTextComponent)object3).setEditable(false);
        object2 = new JScrollPane((Component)object3);
        object = new ExtendedDialog(Main.parent, I18n.tr("Status Report"), new String[]{I18n.tr("Copy to clipboard and close"), I18n.tr("Close")});
        ((ExtendedDialog)object).setButtonIcons(new String[]{"copy.png", "cancel.png"});
        ((ExtendedDialog)object).setContent((Component)object2, false);
        ((Window)object).setMinimumSize(new Dimension(500, 0));
        ((ExtendedDialog)object).showDialog();
        if (((ExtendedDialog)object).getValue() != 1) {
            return;
        }
        try {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(stringBuilder.toString()), new ClipboardOwner(){

                public void lostOwnership(Clipboard clipboard, Transferable transferable) {
                }
            });
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

