/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.corrector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.corrector.RoleCorrection;
import org.openstreetmap.josm.corrector.TagCorrection;
import org.openstreetmap.josm.corrector.TagCorrector;
import org.openstreetmap.josm.corrector.UserCancelException;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReverseWayTagCorrector
extends TagCorrector<Way> {
    private static PrefixSuffixSwitcher[] prefixSuffixSwitchers = new PrefixSuffixSwitcher[]{new PrefixSuffixSwitcher("left", "right"), new PrefixSuffixSwitcher("forward", "backward"), new PrefixSuffixSwitcher("forwards", "backwards"), new PrefixSuffixSwitcher("up", "down"), new PrefixSuffixSwitcher("east", "west"), new PrefixSuffixSwitcher("north", "south")};
    private static ArrayList<String> reversibleTags = new ArrayList<String>(Arrays.asList("oneway", "incline", "direction"));

    public static boolean isReversible(Way way) {
        for (String string : way.keySet()) {
            if (reversibleTags.contains(string)) {
                return false;
            }
            for (PrefixSuffixSwitcher prefixSuffixSwitcher : prefixSuffixSwitchers) {
                if (string.equals(prefixSuffixSwitcher.apply(string))) continue;
                return false;
            }
        }
        return true;
    }

    public static List<Way> irreversibleWays(List<Way> list) {
        ArrayList<Way> arrayList = new ArrayList<Way>(list);
        for (Way way : list) {
            if (!ReverseWayTagCorrector.isReversible(way)) continue;
            arrayList.remove(way);
        }
        return arrayList;
    }

    public String invertNumber(String string) {
        Pattern pattern = Pattern.compile("^([+-]?)(\\d.*)$", 2);
        Matcher matcher = pattern.matcher(string);
        if (!matcher.matches()) {
            return string;
        }
        String string2 = matcher.group(1);
        String string3 = matcher.group(2);
        string2 = string2.equals("-") ? "" : "-";
        return string2 + string3;
    }

    @Override
    public Collection<Command> execute(Way way, Way way2) throws UserCancelException {
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        HashMap<OsmPrimitive, List<TagCorrection>> hashMap = new HashMap<OsmPrimitive, List<TagCorrection>>();
        ArrayList<TagCorrection> arrayList = new ArrayList<TagCorrection>();
        Object object5 = way2.keySet().iterator();
        while (object5.hasNext()) {
            boolean bl;
            block17: {
                block15: {
                    block16: {
                        object3 = object4 = object5.next();
                        object = object2 = way2.get((String)object4);
                        if (!((String)object4).equals("oneway")) break block15;
                        if (!OsmUtils.isReversed((String)object2)) break block16;
                        object = "yes";
                        break block17;
                    }
                    if (!OsmUtils.isTrue((String)object2)) break block17;
                    object = "-1";
                    break block17;
                }
                if (((String)object4).equals("incline") || ((String)object4).equals("direction")) {
                    PrefixSuffixSwitcher prefixSuffixSwitcher = new PrefixSuffixSwitcher("up", "down");
                    object = prefixSuffixSwitcher.apply((String)object2);
                    if (((String)object).equals(object2)) {
                        object = this.invertNumber((String)object2);
                    }
                } else if (!((String)object4).startsWith("name") && !((String)object4).endsWith("name")) {
                    PrefixSuffixSwitcher object6;
                    PrefixSuffixSwitcher[] prefixSuffixSwitcherArray = prefixSuffixSwitchers;
                    n = prefixSuffixSwitcherArray.length;
                    for (int i = 0; i < n && ((String)object4).equals(object3 = (object6 = prefixSuffixSwitcherArray[i]).apply((String)object4)) && ((String)object2).equals(object = object6.apply((String)object2)); ++i) {
                    }
                }
            }
            boolean bl2 = bl = !((String)object4).equals(object3);
            if (way2.get((String)object3) != null && way2.get((String)object3).equals(object)) {
                bl = false;
            }
            if (!((String)object2).equals(object)) {
                bl = true;
            }
            if (!bl) continue;
            arrayList.add(new TagCorrection((String)object4, (String)object2, (String)object3, (String)object));
        }
        if (!arrayList.isEmpty()) {
            hashMap.put(way2, arrayList);
        }
        object5 = new HashMap();
        object4 = new ArrayList();
        object3 = way.getReferrers();
        object2 = object3.iterator();
        while (object2.hasNext()) {
            object = (OsmPrimitive)object2.next();
            if (!(object instanceof Relation)) continue;
            Relation relation = (Relation)object;
            n = 0;
            for (RelationMember relationMember : relation.getMembers()) {
                if (!relationMember.getMember().hasEqualSemanticAttributes(way) || !relationMember.hasRole()) {
                    ++n;
                    continue;
                }
                boolean bl = false;
                String string = null;
                for (PrefixSuffixSwitcher prefixSuffixSwitcher : prefixSuffixSwitchers) {
                    string = prefixSuffixSwitcher.apply(relationMember.getRole());
                    if (string.equals(relationMember.getRole())) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    ((ArrayList)object4).add(new RoleCorrection(relation, n, relationMember, string));
                }
                ++n;
            }
        }
        if (!((ArrayList)object4).isEmpty()) {
            object5.put(way2, object4);
        }
        return this.applyCorrections(hashMap, (Map<OsmPrimitive, List<RoleCorrection>>)object5, I18n.tr("When reversing this way, the following changes to properties of the way and its nodes are suggested in order to maintain data consistency."));
    }

    private static class PrefixSuffixSwitcher {
        private static final String SEPARATOR = "[:_]?";
        private final String a;
        private final String b;
        private final Pattern startPattern;
        private final Pattern endPattern;

        public PrefixSuffixSwitcher(String string, String string2) {
            this.a = string;
            this.b = string2;
            this.startPattern = Pattern.compile("^(" + string + "|" + string2 + ")(" + SEPARATOR + "|$)", 2);
            this.endPattern = Pattern.compile("^.*[:_]?(" + string + "|" + string2 + ")$", 2);
        }

        public String apply(String string) {
            Matcher matcher = this.startPattern.matcher(string);
            if (!matcher.lookingAt()) {
                matcher = this.endPattern.matcher(string);
            }
            if (matcher.lookingAt()) {
                String string2 = matcher.group(1).toLowerCase();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string.substring(0, matcher.start(1)));
                stringBuilder.append(string2.equals(this.a) ? this.b : this.a);
                stringBuilder.append(string.substring(matcher.end(1)));
                return stringBuilder.toString();
            }
            return string;
        }
    }
}

