/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TMSTileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageryInfo
implements Comparable<ImageryInfo> {
    private String name;
    private String url = null;
    private String cookies = null;
    private String eulaAcceptanceRequired = null;
    private ImageryType imageryType = ImageryType.WMS;
    private double pixelPerDegree = 0.0;
    private int maxZoom = 0;
    private int defaultMaxZoom = 0;
    private int defaultMinZoom = 0;
    private Bounds bounds = null;
    private String attributionText;
    private String attributionImage;
    private String attributionLinkURL;
    private String termsOfUseURL;

    public ImageryInfo(String string) {
        this.name = string;
    }

    public ImageryInfo(String string, String string2) {
        this.name = string;
        this.setUrl(string2);
    }

    public ImageryInfo(String string, String string2, String string3) {
        this.name = string;
        this.setUrl(string2);
        this.eulaAcceptanceRequired = string3;
    }

    public ImageryInfo(String string, String string2, String string3, String string4) {
        this.name = string;
        this.setUrl(string2);
        this.cookies = string4;
        this.eulaAcceptanceRequired = string3;
    }

    public ImageryInfo(String string, String string2, String string3, double d) {
        this.name = string;
        this.setUrl(string2);
        this.cookies = string3;
        this.pixelPerDegree = d;
    }

    public ArrayList<String> getInfoArray() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.name);
        arrayList.add(this.url != null && !this.url.isEmpty() ? this.getFullUrl() : null);
        arrayList.add(this.cookies);
        if (this.imageryType == ImageryType.WMS || this.imageryType == ImageryType.HTML) {
            arrayList.add(this.pixelPerDegree != 0.0 ? String.valueOf(this.pixelPerDegree) : null);
        } else {
            arrayList.add(this.maxZoom != 0 ? String.valueOf(this.maxZoom) : null);
        }
        arrayList.add(this.bounds != null ? this.bounds.encodeAsString(",") : null);
        arrayList.add(this.attributionText);
        arrayList.add(this.attributionLinkURL);
        arrayList.add(this.attributionImage);
        arrayList.add(this.termsOfUseURL);
        return arrayList;
    }

    public ImageryInfo(Collection<String> collection) {
        ArrayList<String> arrayList = new ArrayList<String>(collection);
        this.name = arrayList.get(0);
        if (arrayList.size() >= 2 && !arrayList.get(1).isEmpty()) {
            this.setUrl(arrayList.get(1));
        }
        if (arrayList.size() >= 3 && !arrayList.get(2).isEmpty()) {
            this.cookies = arrayList.get(2);
        }
        if (arrayList.size() >= 4 && !arrayList.get(3).isEmpty()) {
            if (this.imageryType == ImageryType.WMS || this.imageryType == ImageryType.HTML) {
                this.pixelPerDegree = Double.valueOf(arrayList.get(3));
            } else {
                this.maxZoom = Integer.valueOf(arrayList.get(3));
            }
        }
        if (arrayList.size() >= 5 && !arrayList.get(4).isEmpty()) {
            try {
                this.bounds = new Bounds(arrayList.get(4), ",");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Main.warn(illegalArgumentException.toString());
            }
        }
        if (arrayList.size() >= 6 && !arrayList.get(5).isEmpty()) {
            this.setAttributionText(arrayList.get(5));
        }
        if (arrayList.size() >= 7 && !arrayList.get(6).isEmpty()) {
            this.setAttributionLinkURL(arrayList.get(6));
        }
        if (arrayList.size() >= 8 && !arrayList.get(7).isEmpty()) {
            this.setAttributionImage(arrayList.get(7));
        }
        if (arrayList.size() >= 9 && !arrayList.get(8).isEmpty()) {
            this.setTermsOfUseURL(arrayList.get(8));
        }
    }

    public ImageryInfo(ImageryInfo imageryInfo) {
        this.name = imageryInfo.name;
        this.url = imageryInfo.url;
        this.cookies = imageryInfo.cookies;
        this.imageryType = imageryInfo.imageryType;
        this.defaultMinZoom = imageryInfo.defaultMinZoom;
        this.maxZoom = imageryInfo.maxZoom;
        this.defaultMaxZoom = imageryInfo.defaultMaxZoom;
        this.pixelPerDegree = imageryInfo.pixelPerDegree;
        this.eulaAcceptanceRequired = null;
        this.bounds = imageryInfo.bounds;
        this.attributionImage = imageryInfo.attributionImage;
        this.attributionLinkURL = imageryInfo.attributionLinkURL;
        this.attributionText = imageryInfo.attributionText;
        this.termsOfUseURL = imageryInfo.termsOfUseURL;
    }

    @Override
    public int compareTo(ImageryInfo imageryInfo) {
        int n = this.name.compareTo(imageryInfo.name);
        if (n == 0) {
            n = this.url.compareTo(imageryInfo.url);
        }
        if (n == 0) {
            n = Double.compare(this.pixelPerDegree, imageryInfo.pixelPerDegree);
        }
        return n;
    }

    public boolean equalsBaseValues(ImageryInfo imageryInfo) {
        return this.url.equals(imageryInfo.url);
    }

    public void setPixelPerDegree(double d) {
        this.pixelPerDegree = d;
    }

    public void setMaxZoom(int n) {
        this.maxZoom = n;
    }

    public void setBounds(Bounds bounds) {
        this.bounds = bounds;
    }

    public Bounds getBounds() {
        return this.bounds;
    }

    public void setAttributionText(String string) {
        this.attributionText = string;
    }

    public void setAttributionImage(String string) {
        this.attributionImage = string;
    }

    public void setAttributionLinkURL(String string) {
        this.attributionLinkURL = string;
    }

    public void setTermsOfUseURL(String string) {
        this.termsOfUseURL = string;
    }

    public void setUrl(String string) {
        CheckParameterUtil.ensureParameterNotNull(string);
        this.defaultMaxZoom = 0;
        this.defaultMinZoom = 0;
        for (ImageryType imageryType : ImageryType.values()) {
            Matcher matcher = Pattern.compile(imageryType.getUrlString() + "(?:\\[(?:(\\d+),)?(\\d+)\\])?:(.*)").matcher(string);
            if (!matcher.matches()) continue;
            this.url = matcher.group(3);
            this.imageryType = imageryType;
            if (matcher.group(2) != null) {
                this.maxZoom = this.defaultMaxZoom = Integer.valueOf(matcher.group(2)).intValue();
            }
            if (matcher.group(1) != null) {
                this.defaultMinZoom = Integer.valueOf(matcher.group(1));
            }
            return;
        }
        this.url = string;
        this.imageryType = ImageryType.WMS;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getUrl() {
        return this.url;
    }

    public String getCookies() {
        return this.cookies;
    }

    public double getPixelPerDegree() {
        return this.pixelPerDegree;
    }

    public int getMaxZoom() {
        return this.maxZoom;
    }

    public int getMinZoom() {
        return this.defaultMinZoom;
    }

    public String getEulaAcceptanceRequired() {
        return this.eulaAcceptanceRequired;
    }

    public String getFullUrl() {
        return this.imageryType.getUrlString() + (this.defaultMaxZoom != 0 ? "[" + (this.defaultMinZoom != 0 ? this.defaultMinZoom + "," : "") + this.defaultMaxZoom + "]" : "") + ":" + this.url;
    }

    public String getToolbarName() {
        String string = this.name;
        if (this.pixelPerDegree != 0.0) {
            string = string + "#PPD=" + this.pixelPerDegree;
        }
        return string;
    }

    public String getMenuName() {
        String string = this.name;
        if (this.pixelPerDegree != 0.0) {
            string = string + " (" + this.pixelPerDegree + ")";
        } else if (this.maxZoom != 0 && this.maxZoom != this.defaultMaxZoom) {
            string = string + " (z" + this.maxZoom + ")";
        }
        return string;
    }

    public boolean hasAttribution() {
        return this.attributionText != null;
    }

    public void copyAttribution(ImageryInfo imageryInfo) {
        this.attributionImage = imageryInfo.attributionImage;
        this.attributionLinkURL = imageryInfo.attributionLinkURL;
        this.attributionText = imageryInfo.attributionText;
        this.termsOfUseURL = imageryInfo.termsOfUseURL;
    }

    public void setAttribution(TMSTileSource tMSTileSource) {
        ImageIcon imageIcon;
        if (this.attributionLinkURL != null) {
            if (this.attributionLinkURL.equals("osm")) {
                tMSTileSource.setAttributionLinkURL(new OsmTileSource.Mapnik().getAttributionLinkURL());
            } else {
                tMSTileSource.setAttributionLinkURL(this.attributionLinkURL);
            }
        }
        if (this.attributionText != null) {
            if (this.attributionText.equals("osm")) {
                tMSTileSource.setAttributionText(new OsmTileSource.Mapnik().getAttributionText(0, null, null));
            } else {
                tMSTileSource.setAttributionText(this.attributionText);
            }
        }
        if (this.attributionImage != null && (imageIcon = ImageProvider.getIfAvailable(null, this.attributionImage)) != null) {
            tMSTileSource.setAttributionImage(imageIcon.getImage());
        }
        if (this.termsOfUseURL != null) {
            if (this.termsOfUseURL.equals("osm")) {
                tMSTileSource.setTermsOfUseURL(new OsmTileSource.Mapnik().getTermsOfUseURL());
            } else {
                tMSTileSource.setTermsOfUseURL(this.termsOfUseURL);
            }
        }
    }

    public ImageryType getImageryType() {
        return this.imageryType;
    }

    public static boolean isUrlWithPatterns(String string) {
        return string != null && string.contains("{") && string.contains("}");
    }

    public boolean isBlacklisted() {
        return OsmApi.getOsmApi().getCapabilities().isOnImageryBlacklist(this.url);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImageryType {
        WMS("wms"),
        TMS("tms"),
        HTML("html"),
        BING("bing"),
        SCANEX("scanex");

        private String urlString;

        private ImageryType(String string2) {
            this.urlString = string2;
        }

        public String getUrlString() {
            return this.urlString;
        }
    }
}

