/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.history.HistoryNameFormatter;
import org.openstreetmap.josm.data.osm.history.HistoryNode;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.data.osm.history.HistoryRelation;
import org.openstreetmap.josm.data.osm.history.HistoryWay;
import org.openstreetmap.josm.gui.NameFormatterHook;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNameFormatter
implements NameFormatter,
HistoryNameFormatter {
    private static DefaultNameFormatter instance;
    private static final LinkedList<NameFormatterHook> formatHooks;
    public static final String[] DEFAULT_NAMING_TAGS_FOR_RELATIONS;
    private static List<String> namingTagsForRelations;
    private final Comparator<Node> nodeComparator = new Comparator<Node>(){

        @Override
        public int compare(Node node, Node node2) {
            return DefaultNameFormatter.this.format(node).compareTo(DefaultNameFormatter.this.format(node2));
        }
    };
    private final Comparator<Way> wayComparator = new Comparator<Way>(){

        @Override
        public int compare(Way way, Way way2) {
            return DefaultNameFormatter.this.format(way).compareTo(DefaultNameFormatter.this.format(way2));
        }
    };
    private final Comparator<Relation> relationComparator = new Comparator<Relation>(){

        @Override
        public int compare(Relation relation, Relation relation2) {
            String string;
            String string2 = DefaultNameFormatter.this.getRelationTypeName(relation);
            int n = string2.compareTo(string = DefaultNameFormatter.this.getRelationTypeName(relation2));
            if (n != 0) {
                return n;
            }
            String string3 = DefaultNameFormatter.this.getRelationName(relation);
            String string4 = DefaultNameFormatter.this.getRelationName(relation2);
            if (string3 == null && string4 == null) {
                return relation.getUniqueId() > relation2.getUniqueId() ? 1 : -1;
            }
            if (string3 == null) {
                return -1;
            }
            if (string4 == null) {
                return 1;
            }
            if (!string3.isEmpty() && !string4.isEmpty() && Character.isDigit(string3.charAt(0)) && Character.isDigit(string4.charAt(0))) {
                String string5 = DefaultNameFormatter.this.getLeadingNumber(string3);
                String string6 = DefaultNameFormatter.this.getLeadingNumber(string4);
                n = Long.valueOf(string5).compareTo(Long.valueOf(string6));
                if (n != 0) {
                    return n;
                }
                n = string5.compareTo(string6);
                if (n != 0) {
                    return n;
                }
                n = string3.substring(string5.length()).compareTo(string4.substring(string6.length()));
                if (n != 0) {
                    return n;
                }
            } else {
                n = string3.compareToIgnoreCase(string4);
                if (n != 0) {
                    return n;
                }
            }
            if (relation.getMembersCount() != relation2.getMembersCount()) {
                return relation.getMembersCount() > relation2.getMembersCount() ? 1 : -1;
            }
            n = Boolean.valueOf(DefaultNameFormatter.this.relationHasIncompleteMember(relation)).compareTo(DefaultNameFormatter.this.relationHasIncompleteMember(relation2));
            if (n != 0) {
                return n;
            }
            return relation.getUniqueId() > relation2.getUniqueId() ? 1 : -1;
        }
    };

    public static DefaultNameFormatter getInstance() {
        if (instance == null) {
            instance = new DefaultNameFormatter();
        }
        return instance;
    }

    public static void registerFormatHook(NameFormatterHook nameFormatterHook) {
        if (nameFormatterHook == null) {
            return;
        }
        if (!formatHooks.contains(nameFormatterHook)) {
            formatHooks.add(0, nameFormatterHook);
        }
    }

    public static void unregisterFormatHook(NameFormatterHook nameFormatterHook) {
        if (nameFormatterHook == null) {
            return;
        }
        if (formatHooks.contains(nameFormatterHook)) {
            formatHooks.remove(nameFormatterHook);
        }
    }

    public static List<String> getNamingtagsForRelations() {
        if (namingTagsForRelations == null) {
            namingTagsForRelations = new ArrayList<String>(Main.pref.getCollection("relation.nameOrder", Arrays.asList(DEFAULT_NAMING_TAGS_FOR_RELATIONS)));
        }
        return namingTagsForRelations;
    }

    protected String decorateNameWithId(String string, IPrimitive iPrimitive) {
        if (Main.pref.getBoolean("osm-primitives.showid")) {
            if (Main.pref.getBoolean("osm-primitives.showid.new-primitives")) {
                return string + I18n.tr(" [id: {0}]", iPrimitive.getUniqueId());
            }
            return string + I18n.tr(" [id: {0}]", iPrimitive.getId());
        }
        return string;
    }

    @Override
    public String format(INode iNode) {
        String string = "";
        if (iNode.isIncomplete()) {
            string = I18n.tr("incomplete");
        } else {
            string = Main.pref.getBoolean("osm-primitives.localize-name", true) ? iNode.getLocalName() : iNode.getName();
            if (string == null) {
                Object object = iNode.get("addr:housename");
                if (object != null) {
                    string = I18n.tr("House {0}", object);
                }
                if (string == null && (object = iNode.get("addr:housenumber")) != null) {
                    String object2 = iNode.get("addr:street");
                    string = object2 != null ? I18n.tr("House number {0} at {1}", object, object2) : I18n.tr("House number {0}", object);
                }
            }
            if (string == null) {
                string = iNode.isNew() ? I18n.tr("node") : "" + iNode.getId();
            }
            string = string + " (" + iNode.getCoor().latToString(CoordinateFormat.getDefaultFormat()) + ", " + iNode.getCoor().lonToString(CoordinateFormat.getDefaultFormat()) + ")";
        }
        string = this.decorateNameWithId(string, iNode);
        for (NameFormatterHook nameFormatterHook : formatHooks) {
            String string2 = nameFormatterHook.checkFormat(iNode, string);
            if (string2 == null) continue;
            return string2;
        }
        return string;
    }

    @Override
    public Comparator<Node> getNodeComparator() {
        return this.nodeComparator;
    }

    @Override
    public String format(IWay iWay) {
        String string = "";
        if (iWay.isIncomplete()) {
            string = I18n.tr("incomplete");
        } else {
            int n;
            string = Main.pref.getBoolean("osm-primitives.localize-name", true) ? iWay.getLocalName() : iWay.getName();
            if (string == null) {
                string = iWay.get("ref");
            }
            if (string == null) {
                String string2 = iWay.get("highway") != null ? I18n.tr("highway") : (iWay.get("railway") != null ? I18n.tr("railway") : (iWay.get("waterway") != null ? I18n.tr("waterway") : (string = iWay.get("landuse") != null ? I18n.tr("landuse") : null)));
            }
            if (string == null) {
                String string3 = iWay.get("addr:housename");
                if (string3 != null) {
                    string = I18n.tr("House {0}", string3);
                }
                if (string == null && (string3 = iWay.get("addr:housenumber")) != null) {
                    String object = iWay.get("addr:street");
                    string = object != null ? I18n.tr("House number {0} at {1}", string3, object) : I18n.tr("House number {0}", string3);
                }
            }
            if ((n = iWay.getNodesCount()) > 1 && iWay.isClosed()) {
                --n;
            }
            if (string == null || string.length() == 0) {
                string = String.valueOf(iWay.getId());
            }
            String string3 = I18n.trn("{0} node", "{0} nodes", n, n);
            string = string + (string.length() > 0 ? " (" + string3 + ")" : string3);
        }
        string = this.decorateNameWithId(string, iWay);
        for (NameFormatterHook nameFormatterHook : formatHooks) {
            String string4 = nameFormatterHook.checkFormat(iWay, string);
            if (string4 == null) continue;
            return string4;
        }
        return string;
    }

    @Override
    public Comparator<Way> getWayComparator() {
        return this.wayComparator;
    }

    @Override
    public String format(IRelation iRelation) {
        String string;
        if (iRelation.isIncomplete()) {
            string = I18n.tr("incomplete");
        } else {
            string = this.getRelationTypeName(iRelation);
            Object object = this.getRelationName(iRelation);
            object = object == null ? Long.toString(iRelation.getId()) : "\"" + (String)object + "\"";
            string = string + " (" + (String)object + ", ";
            int n = iRelation.getMembersCount();
            string = string + I18n.trn("{0} member", "{0} members", n, n);
            if (iRelation instanceof Relation && this.relationHasIncompleteMember((Relation)iRelation)) {
                string = string + ", " + I18n.tr("incomplete");
            }
            string = string + ")";
        }
        string = this.decorateNameWithId(string, iRelation);
        for (NameFormatterHook nameFormatterHook : formatHooks) {
            String string2 = nameFormatterHook.checkFormat(iRelation, string);
            if (string2 == null) continue;
            return string2;
        }
        return string;
    }

    @Override
    public Comparator<Relation> getRelationComparator() {
        return this.relationComparator;
    }

    private String getLeadingNumber(String string) {
        int n;
        for (n = 0; n < string.length() && Character.isDigit(string.charAt(n)); ++n) {
        }
        return string.substring(0, n);
    }

    private String getRelationTypeName(IRelation iRelation) {
        String string;
        String string2 = I18n.trc("Relation type", iRelation.get("type"));
        if (string2 == null) {
            String string3 = string2 = iRelation.get("public_transport") != null ? I18n.tr("public transport") : null;
        }
        if (string2 == null) {
            string = iRelation.get("building");
            if (OsmUtils.isTrue(string)) {
                string2 = I18n.tr("building");
            } else if (string != null) {
                string2 = I18n.tr(string);
            }
        }
        if (string2 == null) {
            string2 = I18n.trc("Place type", iRelation.get("place"));
        }
        if (string2 == null) {
            string2 = I18n.tr("relation");
        }
        if ((string = iRelation.get("admin_level")) != null) {
            string2 = string2 + "[" + string + "]";
        }
        for (NameFormatterHook nameFormatterHook : formatHooks) {
            String string4 = nameFormatterHook.checkRelationTypeName(iRelation, string2);
            if (string4 == null) continue;
            return string4;
        }
        return string2;
    }

    private String getNameTagValue(IRelation iRelation, String string) {
        if (string.equals("name")) {
            if (Main.pref.getBoolean("osm-primitives.localize-name", true)) {
                return iRelation.getLocalName();
            }
            return iRelation.getName();
        }
        if (string.equals(":LocationCode")) {
            for (String string2 : iRelation.keySet()) {
                if (!string2.endsWith(string)) continue;
                return iRelation.get(string2);
            }
            return null;
        }
        return I18n.trc_lazy(string, iRelation.get(string));
    }

    private String getRelationName(IRelation iRelation) {
        String string = null;
        for (String string2 : DefaultNameFormatter.getNamingtagsForRelations()) {
            string = this.getNameTagValue(iRelation, string2);
            if (string == null) continue;
            return string;
        }
        return null;
    }

    private boolean relationHasIncompleteMember(Relation relation) {
        for (RelationMember relationMember : relation.getMembers()) {
            if (!relationMember.getMember().isIncomplete()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String format(Changeset changeset) {
        return I18n.tr("Changeset {0}", changeset.getId());
    }

    public String buildDefaultToolTip(IPrimitive iPrimitive) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append("<strong>id</strong>=").append(iPrimitive.getId()).append("<br>");
        ArrayList<String> arrayList = new ArrayList<String>(iPrimitive.keySet());
        Collections.sort(arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i > 0) {
                stringBuilder.append("<br>");
            }
            String string = arrayList.get(i);
            stringBuilder.append("<strong>").append(string).append("</strong>").append("=");
            String string2 = iPrimitive.get(string);
            while (string2.length() != 0) {
                stringBuilder.append(string2.substring(0, Math.min(50, string2.length())));
                if (string2.length() > 50) {
                    stringBuilder.append("<br>");
                    string2 = string2.substring(50);
                    continue;
                }
                string2 = "";
            }
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    protected void decorateNameWithId(StringBuilder stringBuilder, HistoryOsmPrimitive historyOsmPrimitive) {
        if (Main.pref.getBoolean("osm-primitives.showid")) {
            stringBuilder.append(I18n.tr(" [id: {0}]", historyOsmPrimitive.getId()));
        }
    }

    @Override
    public String format(HistoryNode historyNode) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = Main.pref.getBoolean("osm-primitives.localize-name", true) ? historyNode.getLocalName() : historyNode.getName();
        if (string == null) {
            stringBuilder.append(historyNode.getId());
        } else {
            stringBuilder.append(string);
        }
        stringBuilder.append(" (").append(historyNode.getCoords().latToString(CoordinateFormat.getDefaultFormat())).append(", ").append(historyNode.getCoords().lonToString(CoordinateFormat.getDefaultFormat())).append(")");
        this.decorateNameWithId(stringBuilder, historyNode);
        return stringBuilder.toString();
    }

    @Override
    public String format(HistoryWay historyWay) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = Main.pref.getBoolean("osm-primitives.localize-name", true) ? historyWay.getLocalName() : historyWay.getName();
        if (string != null) {
            stringBuilder.append(string);
        }
        if (stringBuilder.length() == 0 && historyWay.get("ref") != null) {
            stringBuilder.append(historyWay.get("ref"));
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append(historyWay.get("highway") != null ? I18n.tr("highway") : (historyWay.get("railway") != null ? I18n.tr("railway") : (historyWay.get("waterway") != null ? I18n.tr("waterway") : (historyWay.get("landuse") != null ? I18n.tr("landuse") : ""))));
        }
        int n = historyWay.isClosed() ? historyWay.getNumNodes() - 1 : historyWay.getNumNodes();
        String string2 = I18n.trn("{0} node", "{0} nodes", n, n);
        if (stringBuilder.length() == 0) {
            stringBuilder.append(historyWay.getId());
        }
        stringBuilder.append(stringBuilder.length() > 0 ? " (" + string2 + ")" : string2);
        this.decorateNameWithId(stringBuilder, historyWay);
        return stringBuilder.toString();
    }

    @Override
    public String format(HistoryRelation historyRelation) {
        StringBuilder stringBuilder = new StringBuilder();
        if (historyRelation.get("type") != null) {
            stringBuilder.append(historyRelation.get("type"));
        } else {
            stringBuilder.append(I18n.tr("relation"));
        }
        stringBuilder.append(" (");
        String string = null;
        HashSet<String> hashSet = new HashSet<String>(DefaultNameFormatter.getNamingtagsForRelations());
        for (String string2 : historyRelation.getTags().keySet()) {
            if (hashSet.contains(string2.trim()) && (string = Main.pref.getBoolean("osm-primitives.localize-name", true) ? historyRelation.getLocalName() : historyRelation.getName()) == null) {
                string = historyRelation.get(string2);
            }
            if (string == null) continue;
            break;
        }
        if (string == null) {
            stringBuilder.append(Long.toString(historyRelation.getId())).append(", ");
        } else {
            stringBuilder.append("\"").append(string).append("\", ");
        }
        int n = historyRelation.getNumMembers();
        stringBuilder.append(I18n.trn("{0} member", "{0} members", n, n)).append(")");
        this.decorateNameWithId(stringBuilder, historyRelation);
        return stringBuilder.toString();
    }

    public String buildDefaultToolTip(HistoryOsmPrimitive historyOsmPrimitive) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append("<strong>id</strong>=").append(historyOsmPrimitive.getId()).append("<br>");
        ArrayList<String> arrayList = new ArrayList<String>(historyOsmPrimitive.getTags().keySet());
        Collections.sort(arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i > 0) {
                stringBuilder.append("<br>");
            }
            String string = arrayList.get(i);
            stringBuilder.append("<strong>").append(string).append("</strong>").append("=");
            String string2 = historyOsmPrimitive.get(string);
            while (string2.length() != 0) {
                stringBuilder.append(string2.substring(0, Math.min(50, string2.length())));
                if (string2.length() > 50) {
                    stringBuilder.append("<br>");
                    string2 = string2.substring(50);
                    continue;
                }
                string2 = "";
            }
        }
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    static {
        formatHooks = new LinkedList();
        DEFAULT_NAMING_TAGS_FOR_RELATIONS = new String[]{"name", "ref", "restriction", "landuse", "natural", "public_transport", ":LocationCode", "note"};
        namingTagsForRelations = null;
    }
}

