/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.bbox;

import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.MapMarkerDot;
import org.openstreetmap.gui.jmapviewer.MemoryTileCache;
import org.openstreetmap.gui.jmapviewer.OsmFileCacheTileLoader;
import org.openstreetmap.gui.jmapviewer.OsmMercator;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.MapMarker;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.ImageryLayerInfo;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.gui.bbox.BBoxChooser;
import org.openstreetmap.josm.gui.bbox.SizeButton;
import org.openstreetmap.josm.gui.bbox.SlippyMapControler;
import org.openstreetmap.josm.gui.bbox.SourceButton;
import org.openstreetmap.josm.gui.download.DownloadDialog;
import org.openstreetmap.josm.gui.layer.TMSLayer;

public class SlippyMapBBoxChooser
extends JMapViewer
implements BBoxChooser {
    private static CopyOnWriteArrayList<TileSourceProvider> providers = new CopyOnWriteArrayList();
    private static final StringProperty PROP_MAPSTYLE;
    private Dimension iDownloadDialogDimension;
    private TileLoader cachedLoader = null;
    private TileLoader uncachedLoader;
    private final SizeButton iSizeButton = new SizeButton();
    private final SourceButton iSourceButton;
    private Bounds bbox;
    Point iSelectionRectStart;
    Point iSelectionRectEnd;
    private DownloadDialog iGui;

    public static void addTileSourceProvider(TileSourceProvider tileSourceProvider) {
        providers.addIfAbsent(tileSourceProvider);
    }

    public SlippyMapBBoxChooser() {
        String string = TMSLayer.PROP_TILECACHE_DIR.get();
        if (string != null && !string.isEmpty()) {
            try {
                this.cachedLoader = new OsmFileCacheTileLoader(this, new File(string));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.uncachedLoader = new OsmTileLoader(this);
        this.setZoomContolsVisible(false);
        this.setMapMarkerVisible(false);
        this.setMinimumSize(new Dimension(350, 175));
        this.setBounds(new Rectangle(this.getMinimumSize()));
        if (this.cachedLoader == null) {
            this.setFileCacheEnabled(false);
        } else {
            this.setFileCacheEnabled(Main.pref.getBoolean("slippy_map_chooser.file_cache", true));
        }
        this.setMaxTilesInMemory(Main.pref.getInteger("slippy_map_chooser.max_tiles", 1000));
        ArrayList<TileSource> arrayList = new ArrayList<TileSource>();
        for (TileSourceProvider tileSourceProvider : providers) {
            arrayList.addAll(tileSourceProvider.getTileSources());
        }
        this.iSourceButton = new SourceButton(arrayList);
        String string2 = PROP_MAPSTYLE.get();
        boolean bl = false;
        for (TileSource tileSource : arrayList) {
            if (!tileSource.getName().equals(string2)) continue;
            this.setTileSource(tileSource);
            this.iSourceButton.setCurrentMap(tileSource);
            bl = true;
            break;
        }
        if (!bl) {
            this.setTileSource((TileSource)arrayList.get(0));
            this.iSourceButton.setCurrentMap((TileSource)arrayList.get(0));
        }
        new SlippyMapControler(this, this, this.iSizeButton, this.iSourceButton);
    }

    public boolean handleAttribution(Point point, boolean bl) {
        TileSource tileSource = this.tileController.getTileSource();
        if (!tileSource.requiresAttribution()) {
            return false;
        }
        try {
            if (this.attrImageBounds != null && this.attrImageBounds.contains(point) || this.attrTextBounds != null && this.attrTextBounds.contains(point)) {
                if (bl) {
                    Desktop.getDesktop().browse(new URI(tileSource.getAttributionLinkURL()));
                }
                return true;
            }
            if (this.attrToUBounds != null && this.attrToUBounds.contains(point)) {
                if (bl) {
                    Desktop.getDesktop().browse(new URI(tileSource.getTermsOfUseURL()));
                }
                return true;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        return false;
    }

    protected Point getTopLeftCoordinates() {
        return new Point(this.center.x - this.getWidth() / 2, this.center.y - this.getHeight() / 2);
    }

    public void paint(Graphics graphics) {
        try {
            super.paint(graphics);
            if (this.iSelectionRectStart != null && this.iSelectionRectEnd != null) {
                int n = 22 - this.zoom;
                Point point = this.getTopLeftCoordinates();
                int n2 = (this.iSelectionRectStart.x >> n) - point.x;
                int n3 = (this.iSelectionRectStart.y >> n) - point.y;
                int n4 = (this.iSelectionRectEnd.x >> n) - point.x;
                int n5 = (this.iSelectionRectEnd.y >> n) - point.y;
                int n6 = n4 - n2;
                int n7 = n5 - n3;
                graphics.setColor(new Color(0.9f, 0.7f, 0.7f, 0.6f));
                graphics.fillRect(n2, n3, n6, n7);
                graphics.setColor(Color.BLACK);
                graphics.drawRect(n2, n3, n6, n7);
            }
            this.iSizeButton.paint(graphics);
            this.iSourceButton.paint((Graphics2D)graphics);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setFileCacheEnabled(boolean bl) {
        if (bl) {
            this.setTileLoader(this.cachedLoader);
        } else {
            this.setTileLoader(this.uncachedLoader);
        }
    }

    public void setMaxTilesInMemory(int n) {
        ((MemoryTileCache)this.getTileCache()).setCacheSize(n);
    }

    public void setSelection(Point point, Point point2) {
        if (point == null || point2 == null || point.x == point2.x || point.y == point2.y) {
            return;
        }
        Point point3 = new Point(Math.max(point2.x, point.x), Math.max(point2.y, point.y));
        Point point4 = new Point(Math.min(point2.x, point.x), Math.min(point2.y, point.y));
        Point point5 = this.getTopLeftCoordinates();
        int n = 22 - this.zoom;
        Point point6 = new Point(point3.x + point5.x, point3.y + point5.y);
        Point point7 = new Point(point4.x + point5.x, point4.y + point5.y);
        point6.x <<= n;
        point6.y <<= n;
        point7.x <<= n;
        point7.y <<= n;
        this.iSelectionRectStart = point7;
        this.iSelectionRectEnd = point6;
        Coordinate coordinate = this.getPosition(point3);
        Coordinate coordinate2 = this.getPosition(point4);
        Bounds bounds = new Bounds(new LatLon(Math.min(coordinate2.getLat(), coordinate.getLat()), Math.min(coordinate.getLon(), coordinate2.getLon())), new LatLon(Math.max(coordinate2.getLat(), coordinate.getLat()), Math.max(coordinate.getLon(), coordinate2.getLon())));
        Bounds bounds2 = this.bbox;
        this.bbox = bounds;
        this.firePropertyChange(BBOX_PROP, bounds2, this.bbox);
        this.repaint();
    }

    public void setGui(DownloadDialog downloadDialog) {
        this.iGui = downloadDialog;
    }

    public void resizeSlippyMap() {
        int n;
        int n2;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (this.iDownloadDialogDimension == null) {
            n2 = dimension.width * 90 / 100;
            n = dimension.height * 90 / 100;
            this.iDownloadDialogDimension = this.iGui.getSize();
        } else {
            n2 = this.iDownloadDialogDimension.width;
            n = this.iDownloadDialogDimension.height;
            this.iDownloadDialogDimension = null;
        }
        this.iGui.setBounds((dimension.width - n2) / 2, (dimension.height - n) / 2, n2, n);
        this.repaint();
    }

    public void toggleMapSource(TileSource tileSource) {
        this.tileController.setTileCache(new MemoryTileCache());
        this.setTileSource(tileSource);
        PROP_MAPSTYLE.put(tileSource.getName());
    }

    public Bounds getBoundingBox() {
        return this.bbox;
    }

    public void setBoundingBox(Bounds bounds) {
        if (bounds == null) {
            this.bbox = null;
            return;
        }
        if (bounds.getMin().lat() == 0.0 && bounds.getMin().lon() == 0.0 && bounds.getMax().lat() == 0.0 && bounds.getMax().lon() == 0.0) {
            this.bbox = null;
        }
        int n = OsmMercator.LatToY(bounds.getMin().lat(), 22);
        int n2 = OsmMercator.LatToY(bounds.getMax().lat(), 22);
        int n3 = OsmMercator.LonToX(bounds.getMin().lon(), 22);
        int n4 = OsmMercator.LonToX(bounds.getMax().lon(), 22);
        this.iSelectionRectStart = new Point(Math.min(n3, n4), Math.min(n, n2));
        this.iSelectionRectEnd = new Point(Math.max(n3, n4), Math.max(n, n2));
        MapMarkerDot mapMarkerDot = new MapMarkerDot(bounds.getMin().lat(), bounds.getMin().lon());
        MapMarkerDot mapMarkerDot2 = new MapMarkerDot(bounds.getMax().lat(), bounds.getMax().lon());
        Vector<MapMarker> vector = new Vector<MapMarker>(2);
        vector.add(mapMarkerDot);
        vector.add(mapMarkerDot2);
        this.setMapMarkerList(vector);
        this.setDisplayToFitMapMarkers();
        this.zoomOut();
        this.bbox = bounds;
    }

    static {
        SlippyMapBBoxChooser.addTileSourceProvider(new TileSourceProvider(){

            @Override
            public List<TileSource> getTileSources() {
                return Arrays.asList(new RenamedSourceDecorator(new OsmTileSource.Mapnik(), "Mapnik"), new RenamedSourceDecorator(new OsmTileSource.TilesAtHome(), "Osmarender"), new RenamedSourceDecorator(new OsmTileSource.CycleMap(), "Cyclemap"));
            }
        });
        SlippyMapBBoxChooser.addTileSourceProvider(new TMSTileSourceProvider());
        PROP_MAPSTYLE = new StringProperty("slippy_map_chooser.mapstyle", "Mapnik");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TMSTileSourceProvider
    implements TileSourceProvider {
        static final HashSet<String> existingSlippyMapUrls = new HashSet();

        @Override
        public List<TileSource> getTileSources() {
            if (!TMSLayer.PROP_ADD_TO_SLIPPYMAP_CHOOSER.get()) {
                return Collections.emptyList();
            }
            ArrayList<TileSource> arrayList = new ArrayList<TileSource>();
            for (ImageryInfo imageryInfo : ImageryLayerInfo.instance.getLayers()) {
                TileSource tileSource;
                if (existingSlippyMapUrls.contains(imageryInfo.getUrl()) || (tileSource = TMSLayer.getTileSource(imageryInfo)) == null) continue;
                arrayList.add(tileSource);
            }
            return arrayList;
        }

        public static void addExistingSlippyMapUrl(String string) {
            existingSlippyMapUrls.add(string);
        }

        static {
            existingSlippyMapUrls.add("http://tile.openstreetmap.org/");
            existingSlippyMapUrls.add("http://tah.openstreetmap.org/Tiles/tile/");
            existingSlippyMapUrls.add("http://tile.opencyclemap.org/cycle/");
        }
    }

    public static class RenamedSourceDecorator
    implements TileSource {
        private final TileSource source;
        private final String name;

        public RenamedSourceDecorator(TileSource tileSource, String string) {
            this.source = tileSource;
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public int getMaxZoom() {
            return this.source.getMaxZoom();
        }

        public int getMinZoom() {
            return this.source.getMinZoom();
        }

        public int getTileSize() {
            return this.source.getTileSize();
        }

        public String getTileType() {
            return this.source.getTileType();
        }

        public TileSource.TileUpdate getTileUpdate() {
            return this.source.getTileUpdate();
        }

        public String getTileUrl(int n, int n2, int n3) throws IOException {
            return this.source.getTileUrl(n, n2, n3);
        }

        public Image getAttributionImage() {
            return this.source.getAttributionImage();
        }

        public String getAttributionText(int n, Coordinate coordinate, Coordinate coordinate2) {
            return this.source.getAttributionText(n, coordinate, coordinate2);
        }

        public boolean requiresAttribution() {
            return this.source.requiresAttribution();
        }

        public String getAttributionLinkURL() {
            return this.source.getAttributionLinkURL();
        }

        public String getTermsOfUseURL() {
            return this.source.getTermsOfUseURL();
        }

        public double latToTileY(double d, int n) {
            return this.source.latToTileY(d, n);
        }

        public double lonToTileX(double d, int n) {
            return this.source.lonToTileX(d, n);
        }

        public double tileYToLat(int n, int n2) {
            return this.tileYToLat(n, n2);
        }

        public double tileXToLon(int n, int n2) {
            return this.tileXToLon(n, n2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface TileSourceProvider {
        public List<TileSource> getTileSources();
    }
}

