/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Stack;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.search.SearchAction;
import org.openstreetmap.josm.data.osm.Filter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.DatasetEventManager;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.FilterTableModel;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterDialog
extends ToggleDialog
implements DataSetListener {
    private JTable userTable;
    private FilterTableModel filterModel = new FilterTableModel();
    private SideButton addButton;
    private SideButton editButton;
    private SideButton deleteButton;
    private SideButton upButton;
    private SideButton downButton;
    protected String[] columnToolTips = new String[]{I18n.tr("Enable filter"), I18n.tr("Hide elements"), null, I18n.tr("Inverse filter"), I18n.tr("Filter mode")};

    public FilterDialog() {
        super(I18n.tr("Filter"), "filter", I18n.tr("Filter objects and hide/disable them."), Shortcut.registerShortcut("subwindow:filter", I18n.tr("Toggle: {0}", I18n.tr("Filter")), 70, 4, 1), 162);
        this.build();
    }

    @Override
    public void showNotify() {
        DatasetEventManager.getInstance().addDatasetListener(this, DatasetEventManager.FireMode.IN_EDT_CONSOLIDATED);
        this.filterModel.executeFilters();
    }

    @Override
    public void hideNotify() {
        DatasetEventManager.getInstance().removeDatasetListener(this);
        this.filterModel.clearFilterFlags();
        Main.map.mapView.repaint();
    }

    protected JPanel buildButtonRow() {
        JPanel jPanel = this.getButtonPanel(5);
        this.addButton = new SideButton(I18n.marktr("Add"), "add", "SelectionList", I18n.tr("Add filter."), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Filter filter = (Filter)SearchAction.showSearchDialog(new Filter());
                if (filter != null) {
                    FilterDialog.this.filterModel.addFilter(filter);
                }
            }
        });
        jPanel.add(this.addButton);
        this.editButton = new SideButton(I18n.marktr("Edit"), "edit", "SelectionList", I18n.tr("Edit filter."), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = FilterDialog.this.userTable.getSelectionModel().getMinSelectionIndex();
                if (n < 0) {
                    return;
                }
                Filter filter = FilterDialog.this.filterModel.getFilter(n);
                Filter filter2 = (Filter)SearchAction.showSearchDialog(filter);
                if (filter2 != null) {
                    FilterDialog.this.filterModel.setFilter(n, filter2);
                }
            }
        });
        jPanel.add(this.editButton);
        this.deleteButton = new SideButton(I18n.marktr("Delete"), "delete", "SelectionList", I18n.tr("Delete filter."), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = FilterDialog.this.userTable.getSelectionModel().getMinSelectionIndex();
                if (n < 0) {
                    return;
                }
                FilterDialog.this.filterModel.removeFilter(n);
            }
        });
        jPanel.add(this.deleteButton);
        this.upButton = new SideButton(I18n.marktr("Up"), "up", "SelectionList", I18n.tr("Move filter up."), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = FilterDialog.this.userTable.getSelectionModel().getMinSelectionIndex();
                if (n < 0) {
                    return;
                }
                FilterDialog.this.filterModel.moveUpFilter(n);
                FilterDialog.this.userTable.getSelectionModel().setSelectionInterval(n - 1, n - 1);
            }
        });
        jPanel.add(this.upButton);
        this.downButton = new SideButton(I18n.marktr("Down"), "down", "SelectionList", I18n.tr("Move filter down."), new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = FilterDialog.this.userTable.getSelectionModel().getMinSelectionIndex();
                if (n < 0) {
                    return;
                }
                FilterDialog.this.filterModel.moveDownFilter(n);
                FilterDialog.this.userTable.getSelectionModel().setSelectionInterval(n + 1, n + 1);
            }
        });
        jPanel.add(this.downButton);
        return jPanel;
    }

    protected void build() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.userTable = new JTable(this.filterModel){

            protected JTableHeader createDefaultTableHeader() {
                return new JTableHeader(this.columnModel){

                    public String getToolTipText(MouseEvent mouseEvent) {
                        Point point = mouseEvent.getPoint();
                        int n = this.columnModel.getColumnIndexAtX(point.x);
                        int n2 = this.columnModel.getColumn(n).getModelIndex();
                        return FilterDialog.this.columnToolTips[n2];
                    }
                };
            }
        };
        this.userTable.setSelectionMode(0);
        this.userTable.getColumnModel().getColumn(0).setMaxWidth(1);
        this.userTable.getColumnModel().getColumn(1).setMaxWidth(1);
        this.userTable.getColumnModel().getColumn(3).setMaxWidth(1);
        this.userTable.getColumnModel().getColumn(4).setMaxWidth(1);
        this.userTable.getColumnModel().getColumn(0).setResizable(false);
        this.userTable.getColumnModel().getColumn(1).setResizable(false);
        this.userTable.getColumnModel().getColumn(3).setResizable(false);
        this.userTable.getColumnModel().getColumn(4).setResizable(false);
        this.userTable.setDefaultRenderer(Boolean.class, new BooleanRenderer());
        this.userTable.setDefaultRenderer(String.class, new StringRenderer());
        jPanel.add((Component)new JScrollPane(this.userTable), "Center");
        jPanel.add((Component)this.buildButtonRow(), "South");
        this.add((Component)jPanel, "Center");
    }

    public void updateDialogHeader() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FilterDialog.this.setTitle(I18n.tr("Filter Hidden:{0} Disabled:{1}", ((FilterDialog)FilterDialog.this).filterModel.disabledAndHiddenCount, ((FilterDialog)FilterDialog.this).filterModel.disabledCount));
            }
        });
    }

    public void drawOSDText(Graphics2D graphics2D) {
        this.filterModel.drawOSDText(graphics2D);
    }

    private Collection<OsmPrimitive> getAffectedPrimitives(Collection<? extends OsmPrimitive> collection) {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        Stack<? extends OsmPrimitive> stack = new Stack<OsmPrimitive>();
        stack.addAll(collection);
        while (!stack.isEmpty()) {
            OsmPrimitive osmPrimitive = (OsmPrimitive)stack.pop();
            if (hashSet.contains(osmPrimitive)) continue;
            hashSet.add(osmPrimitive);
            if (osmPrimitive instanceof Way) {
                for (Node node : ((Way)osmPrimitive).getNodes()) {
                    stack.push(node);
                }
            } else if (osmPrimitive instanceof Relation) {
                for (RelationMember relationMember : ((Relation)osmPrimitive).getMembers()) {
                    stack.push(relationMember.getMember());
                }
            }
            for (OsmPrimitive osmPrimitive2 : osmPrimitive.getReferrers()) {
                stack.push(osmPrimitive2);
            }
        }
        return hashSet;
    }

    @Override
    public void dataChanged(DataChangedEvent dataChangedEvent) {
        this.filterModel.executeFilters();
    }

    @Override
    public void nodeMoved(NodeMovedEvent nodeMovedEvent) {
    }

    @Override
    public void otherDatasetChange(AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
        this.filterModel.executeFilters();
    }

    @Override
    public void primitivesAdded(PrimitivesAddedEvent primitivesAddedEvent) {
        this.filterModel.executeFilters(primitivesAddedEvent.getPrimitives());
    }

    @Override
    public void primitivesRemoved(PrimitivesRemovedEvent primitivesRemovedEvent) {
        this.filterModel.executeFilters();
    }

    @Override
    public void relationMembersChanged(RelationMembersChangedEvent relationMembersChangedEvent) {
        this.filterModel.executeFilters(this.getAffectedPrimitives(relationMembersChangedEvent.getPrimitives()));
    }

    @Override
    public void tagsChanged(TagsChangedEvent tagsChangedEvent) {
        this.filterModel.executeFilters(this.getAffectedPrimitives(tagsChangedEvent.getPrimitives()));
    }

    @Override
    public void wayNodesChanged(WayNodesChangedEvent wayNodesChangedEvent) {
        this.filterModel.executeFilters(this.getAffectedPrimitives(wayNodesChangedEvent.getPrimitives()));
    }

    static class BooleanRenderer
    extends JCheckBox
    implements TableCellRenderer {
        BooleanRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            FilterTableModel filterTableModel = (FilterTableModel)jTable.getModel();
            this.setSelected(object != null && (Boolean)object != false);
            this.setEnabled(filterTableModel.isCellEnabled(n, n2));
            this.setHorizontalAlignment(0);
            return this;
        }
    }

    static class StringRenderer
    extends DefaultTableCellRenderer {
        StringRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            FilterTableModel filterTableModel = (FilterTableModel)jTable.getModel();
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            component.setEnabled(filterTableModel.isCellEnabled(n, n2));
            return component;
        }
    }
}

