/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io;

import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum UploadStrategy {
    INDIVIDUAL_OBJECTS_STRATEGY("individualobjects"),
    CHUNKED_DATASET_STRATEGY("chunked"),
    SINGLE_REQUEST_STRATEGY("singlerequest");

    private String preferenceValue;
    public static final UploadStrategy DEFAULT_UPLOAD_STRATEGY;

    private UploadStrategy(String string2) {
        this.preferenceValue = string2;
    }

    public static UploadStrategy fromPreference(String string) {
        if (string == null) {
            return null;
        }
        string = string.trim().toLowerCase();
        for (UploadStrategy uploadStrategy : UploadStrategy.values()) {
            if (!uploadStrategy.getPreferenceValue().equals(string)) continue;
            return uploadStrategy;
        }
        return null;
    }

    public String getPreferenceValue() {
        return this.preferenceValue;
    }

    public static UploadStrategy getFromPreferences() {
        String string = Main.pref.get("osm-server.upload-strategy", null);
        if (string == null) {
            string = Main.pref.get("osm-server.atomic-upload", null);
            if (string != null) {
                Main.pref.removeFromCollection("osm-server.atomic-upload", string);
            } else {
                string = "";
            }
            string = string.trim().toLowerCase();
            if (string.equals("true")) {
                return SINGLE_REQUEST_STRATEGY;
            }
            if (string.equals("false")) {
                return INDIVIDUAL_OBJECTS_STRATEGY;
            }
            return DEFAULT_UPLOAD_STRATEGY;
        }
        UploadStrategy uploadStrategy = UploadStrategy.fromPreference(string);
        if (uploadStrategy == null) {
            System.err.println(I18n.tr("Warning: unexpected value for key ''{0}'' in preferences, got ''{1}''", "osm-server.upload-strategy", string));
            return DEFAULT_UPLOAD_STRATEGY;
        }
        return uploadStrategy;
    }

    public static void saveToPreferences(UploadStrategy uploadStrategy) {
        Main.pref.put("osm-server.upload-strategy", uploadStrategy.getPreferenceValue());
    }

    static {
        DEFAULT_UPLOAD_STRATEGY = SINGLE_REQUEST_STRATEGY;
    }
}

