/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.server;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.oauth.OAuthParameters;
import org.openstreetmap.josm.data.oauth.OAuthToken;
import org.openstreetmap.josm.gui.JMultilineLabel;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.oauth.AdvancedOAuthPropertiesPanel;
import org.openstreetmap.josm.gui.oauth.OAuthAuthorizationWizard;
import org.openstreetmap.josm.gui.oauth.TestAccessTokenTask;
import org.openstreetmap.josm.gui.preferences.server.OAuthAccessTokenHolder;
import org.openstreetmap.josm.gui.preferences.server.OsmApiUrlInputPanel;
import org.openstreetmap.josm.io.auth.CredentialsManagerFactory;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class OAuthAuthenticationPreferencesPanel
extends JPanel
implements PropertyChangeListener {
    private JPanel pnlAuthorisationMessage;
    private NotYetAuthorisedPanel pnlNotYetAuthorised;
    private AlreadyAuthorisedPanel pnlAlreadyAuthorised;
    private AdvancedOAuthPropertiesPanel pnlAdvancedProperties;
    private String apiUrl;
    private JCheckBox cbShowAdvancedParameters;
    private JCheckBox cbSaveToPreferences;

    protected JPanel buildAdvancedPropertiesPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.cbShowAdvancedParameters = new JCheckBox();
        jPanel.add((Component)this.cbShowAdvancedParameters, gridBagConstraints);
        this.cbShowAdvancedParameters.setSelected(false);
        this.cbShowAdvancedParameters.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                OAuthAuthenticationPreferencesPanel.this.pnlAdvancedProperties.setVisible(itemEvent.getStateChange() == 1);
            }
        });
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        JMultilineLabel jMultilineLabel = new JMultilineLabel(I18n.tr("Display Advanced OAuth Parameters"));
        jMultilineLabel.setFont(jMultilineLabel.getFont().deriveFont(0));
        jPanel.add((Component)jMultilineLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.pnlAdvancedProperties = new AdvancedOAuthPropertiesPanel();
        jPanel.add((Component)this.pnlAdvancedProperties, gridBagConstraints);
        this.pnlAdvancedProperties.initFromPreferences(Main.pref);
        this.pnlAdvancedProperties.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.GRAY, 1), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        this.pnlAdvancedProperties.setVisible(false);
        return jPanel;
    }

    protected void build() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.pnlAuthorisationMessage = new JPanel();
        this.add((Component)this.pnlAuthorisationMessage, gridBagConstraints);
        this.pnlAuthorisationMessage.setLayout(new BorderLayout());
        this.pnlAlreadyAuthorised = new AlreadyAuthorisedPanel();
        this.pnlNotYetAuthorised = new NotYetAuthorisedPanel();
    }

    protected void refreshView() {
        this.pnlAuthorisationMessage.removeAll();
        if (OAuthAccessTokenHolder.getInstance().containsAccessToken()) {
            this.pnlAuthorisationMessage.add((Component)this.pnlAlreadyAuthorised, "Center");
            this.pnlAlreadyAuthorised.refreshView();
            this.pnlAlreadyAuthorised.revalidate();
        } else {
            this.pnlAuthorisationMessage.add((Component)this.pnlNotYetAuthorised, "Center");
            this.pnlNotYetAuthorised.revalidate();
        }
        this.repaint();
    }

    public OAuthAuthenticationPreferencesPanel() {
        this.build();
        this.refreshView();
    }

    public void setApiUrl(String string) {
        this.apiUrl = string;
    }

    public void initFromPreferences() {
        this.refreshView();
    }

    public void saveToPreferences() {
        OAuthAccessTokenHolder.getInstance().setSaveToPreferences(this.cbSaveToPreferences.isSelected());
        OAuthAccessTokenHolder.getInstance().save(Main.pref, CredentialsManagerFactory.getCredentialManager());
        this.pnlAdvancedProperties.getAdvancedParameters().saveToPreferences(Main.pref);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!propertyChangeEvent.getPropertyName().equals(OsmApiUrlInputPanel.API_URL_PROP)) {
            return;
        }
        this.apiUrl = (String)propertyChangeEvent.getNewValue();
    }

    private class TestAuthorisationAction
    extends AbstractAction {
        public TestAuthorisationAction() {
            this.putValue("Name", I18n.tr("Test Access Token"));
            this.putValue("ShortDescription", I18n.tr("Click test access to the OSM server with the current access token"));
            this.putValue("SmallIcon", ImageProvider.get("oauth", "oauth"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OAuthToken oAuthToken = OAuthAccessTokenHolder.getInstance().getAccessToken();
            OAuthParameters oAuthParameters = OAuthParameters.createFromPreferences(Main.pref);
            TestAccessTokenTask testAccessTokenTask = new TestAccessTokenTask(OAuthAuthenticationPreferencesPanel.this, OAuthAuthenticationPreferencesPanel.this.apiUrl, oAuthParameters, oAuthToken);
            Main.worker.submit(testAccessTokenTask);
        }
    }

    private class RenewAuthorisationAction
    extends AbstractAction {
        public RenewAuthorisationAction() {
            this.putValue("Name", I18n.tr("New Access Token"));
            this.putValue("ShortDescription", I18n.tr("Click to step through the OAuth authorization process and generate a new Access Token"));
            this.putValue("SmallIcon", ImageProvider.get("oauth", "oauth"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OAuthAuthorizationWizard oAuthAuthorizationWizard = new OAuthAuthorizationWizard(OAuthAuthenticationPreferencesPanel.this, OAuthAuthenticationPreferencesPanel.this.apiUrl);
            oAuthAuthorizationWizard.setVisible(true);
            if (oAuthAuthorizationWizard.isCanceled()) {
                return;
            }
            OAuthAccessTokenHolder oAuthAccessTokenHolder = OAuthAccessTokenHolder.getInstance();
            oAuthAccessTokenHolder.setAccessToken(oAuthAuthorizationWizard.getAccessToken());
            oAuthAccessTokenHolder.setSaveToPreferences(oAuthAuthorizationWizard.isSaveAccessTokenToPreferences());
            OAuthAuthenticationPreferencesPanel.this.pnlAdvancedProperties.setAdvancedParameters(oAuthAuthorizationWizard.getOAuthParameters());
            OAuthAuthenticationPreferencesPanel.this.refreshView();
        }
    }

    private class AuthoriseNowAction
    extends AbstractAction {
        public AuthoriseNowAction() {
            this.putValue("Name", I18n.tr("Authorize now"));
            this.putValue("ShortDescription", I18n.tr("Click to step through the OAuth authorization process"));
            this.putValue("SmallIcon", ImageProvider.get("oauth", "oauth"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            OAuthAuthorizationWizard oAuthAuthorizationWizard = new OAuthAuthorizationWizard(OAuthAuthenticationPreferencesPanel.this, OAuthAuthenticationPreferencesPanel.this.apiUrl);
            oAuthAuthorizationWizard.setVisible(true);
            if (oAuthAuthorizationWizard.isCanceled()) {
                return;
            }
            OAuthAccessTokenHolder oAuthAccessTokenHolder = OAuthAccessTokenHolder.getInstance();
            oAuthAccessTokenHolder.setAccessToken(oAuthAuthorizationWizard.getAccessToken());
            oAuthAccessTokenHolder.setSaveToPreferences(oAuthAuthorizationWizard.isSaveAccessTokenToPreferences());
            OAuthAuthenticationPreferencesPanel.this.pnlAdvancedProperties.setAdvancedParameters(oAuthAuthorizationWizard.getOAuthParameters());
            OAuthAuthenticationPreferencesPanel.this.refreshView();
        }
    }

    private class AlreadyAuthorisedPanel
    extends JPanel {
        private JTextField tfAccessTokenKey;
        private JTextField tfAccessTokenSecret;

        protected void build() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(0, 0, 3, 3);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 2;
            JMultilineLabel jMultilineLabel = new JMultilineLabel(I18n.tr("You already have an Access Token to access the OSM server using OAuth."));
            this.add((Component)jMultilineLabel, gridBagConstraints);
            jMultilineLabel.setFont(jMultilineLabel.getFont().deriveFont(0));
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            this.add((Component)new JLabel(I18n.tr("Access Token Key:")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            this.tfAccessTokenKey = new JTextField();
            this.add((Component)this.tfAccessTokenKey, gridBagConstraints);
            this.tfAccessTokenKey.setEditable(false);
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            this.add((Component)new JLabel(I18n.tr("Access Token Secret:")), gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            this.tfAccessTokenSecret = new JTextField();
            this.add((Component)this.tfAccessTokenSecret, gridBagConstraints);
            this.tfAccessTokenSecret.setEditable(false);
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)(OAuthAuthenticationPreferencesPanel.this.cbSaveToPreferences = new JCheckBox(I18n.tr("Save to preferences"))), gridBagConstraints);
            OAuthAuthenticationPreferencesPanel.this.cbSaveToPreferences.setSelected(OAuthAccessTokenHolder.getInstance().isSaveToPreferences());
            JPanel jPanel = new JPanel(new FlowLayout(0));
            jPanel.add(new SideButton(new RenewAuthorisationAction()));
            jPanel.add(new SideButton(new TestAuthorisationAction()));
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)jPanel, gridBagConstraints);
            gridBagConstraints.gridy = 5;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)OAuthAuthenticationPreferencesPanel.this.buildAdvancedPropertiesPanel(), gridBagConstraints);
            gridBagConstraints.gridy = 6;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)new JPanel(), gridBagConstraints);
        }

        public void refreshView() {
            String string = OAuthAccessTokenHolder.getInstance().getAccessTokenKey();
            this.tfAccessTokenKey.setText(string == null ? "" : string);
            string = OAuthAccessTokenHolder.getInstance().getAccessTokenSecret();
            this.tfAccessTokenSecret.setText(string == null ? "" : string);
            OAuthAuthenticationPreferencesPanel.this.cbSaveToPreferences.setSelected(OAuthAccessTokenHolder.getInstance().isSaveToPreferences());
        }

        public AlreadyAuthorisedPanel() {
            this.build();
            this.refreshView();
        }
    }

    private class NotYetAuthorisedPanel
    extends JPanel {
        protected void build() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(0, 0, 3, 0);
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            JMultilineLabel jMultilineLabel = new JMultilineLabel(I18n.tr("You do not have an Access Token yet to access the OSM server using OAuth. Please authorize first."));
            this.add((Component)jMultilineLabel, gridBagConstraints);
            jMultilineLabel.setFont(jMultilineLabel.getFont().deriveFont(0));
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            this.add((Component)new SideButton(new AuthoriseNowAction()), gridBagConstraints);
            gridBagConstraints.gridy = 2;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)new JPanel(), gridBagConstraints);
        }

        public NotYetAuthorisedPanel() {
            this.build();
        }
    }
}

