/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSetMerger;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmApi;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiFetchServerObjectReader
extends OsmServerReader {
    private static int MAX_IDS_PER_REQUEST = 200;
    private Set<Long> nodes = new LinkedHashSet<Long>();
    private Set<Long> ways = new LinkedHashSet<Long>();
    private Set<Long> relations = new LinkedHashSet<Long>();
    private Set<PrimitiveId> missingPrimitives;
    private DataSet outputDataSet = new DataSet();

    public MultiFetchServerObjectReader() {
        this.missingPrimitives = new LinkedHashSet<PrimitiveId>();
    }

    protected void remember(PrimitiveId primitiveId) {
        if (primitiveId.isNew()) {
            return;
        }
        switch (primitiveId.getType()) {
            case NODE: {
                this.nodes.add(primitiveId.getUniqueId());
                break;
            }
            case WAY: {
                this.ways.add(primitiveId.getUniqueId());
                break;
            }
            case RELATION: {
                this.relations.add(primitiveId.getUniqueId());
            }
        }
    }

    protected void remember(DataSet dataSet, long l, OsmPrimitiveType osmPrimitiveType) throws IllegalArgumentException, NoSuchElementException {
        CheckParameterUtil.ensureParameterNotNull(dataSet, "ds");
        if (l <= 0L) {
            return;
        }
        OsmPrimitive osmPrimitive = dataSet.getPrimitiveById(l, osmPrimitiveType);
        if (osmPrimitive == null) {
            throw new NoSuchElementException(I18n.tr("No primitive with id {0} in local dataset. Cannot infer primitive type.", l));
        }
        this.remember(osmPrimitive.getPrimitiveId());
    }

    public MultiFetchServerObjectReader append(DataSet dataSet, long l, OsmPrimitiveType osmPrimitiveType) {
        switch (osmPrimitiveType) {
            case NODE: {
                Node node = (Node)dataSet.getPrimitiveById(l, osmPrimitiveType);
                this.appendNode(node);
                break;
            }
            case WAY: {
                Way way = (Way)dataSet.getPrimitiveById(l, osmPrimitiveType);
                this.appendWay(way);
                break;
            }
            case RELATION: {
                Relation relation = (Relation)dataSet.getPrimitiveById(l, osmPrimitiveType);
                this.appendRelation(relation);
            }
        }
        return this;
    }

    public MultiFetchServerObjectReader appendNode(Node node) {
        if (node == null) {
            return this;
        }
        this.remember(node.getPrimitiveId());
        return this;
    }

    public MultiFetchServerObjectReader appendWay(Way way) {
        if (way == null) {
            return this;
        }
        if (way.isNew()) {
            return this;
        }
        for (Node node : way.getNodes()) {
            if (node.isNew()) continue;
            this.remember(node.getPrimitiveId());
        }
        this.remember(way.getPrimitiveId());
        return this;
    }

    protected MultiFetchServerObjectReader appendRelation(Relation relation) {
        if (relation == null) {
            return this;
        }
        if (relation.isNew()) {
            return this;
        }
        this.remember(relation.getPrimitiveId());
        for (RelationMember relationMember : relation.getMembers()) {
            if (OsmPrimitiveType.from(relationMember.getMember()).equals((Object)OsmPrimitiveType.RELATION) && this.relations.contains(relationMember.getMember().getId()) || relationMember.getMember().isIncomplete()) continue;
            this.append(relationMember.getMember());
        }
        return this;
    }

    public MultiFetchServerObjectReader append(OsmPrimitive osmPrimitive) {
        if (OsmPrimitiveType.from(osmPrimitive).equals((Object)OsmPrimitiveType.NODE)) {
            return this.appendNode((Node)osmPrimitive);
        }
        if (OsmPrimitiveType.from(osmPrimitive).equals((Object)OsmPrimitiveType.WAY)) {
            return this.appendWay((Way)osmPrimitive);
        }
        if (OsmPrimitiveType.from(osmPrimitive).equals((Object)OsmPrimitiveType.RELATION)) {
            return this.appendRelation((Relation)osmPrimitive);
        }
        return this;
    }

    public MultiFetchServerObjectReader append(Collection<? extends OsmPrimitive> collection) {
        if (collection == null) {
            return this;
        }
        for (OsmPrimitive osmPrimitive : collection) {
            this.append(osmPrimitive);
        }
        return this;
    }

    protected Set<Long> extractIdPackage(Set<Long> set) {
        HashSet<Long> hashSet = new HashSet<Long>();
        if (set.isEmpty()) {
            return hashSet;
        }
        if (set.size() > MAX_IDS_PER_REQUEST) {
            Iterator<Long> iterator = set.iterator();
            for (int i = 0; i < MAX_IDS_PER_REQUEST; ++i) {
                hashSet.add(iterator.next());
            }
            set.removeAll(hashSet);
        } else {
            hashSet.addAll(set);
            set.clear();
        }
        return hashSet;
    }

    protected String buildRequestString(OsmPrimitiveType osmPrimitiveType, Set<Long> set) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(osmPrimitiveType.getAPIName()).append("s?").append(osmPrimitiveType.getAPIName()).append("s=");
        Iterator<Long> iterator = set.iterator();
        for (int i = 0; i < set.size(); ++i) {
            stringBuilder.append(iterator.next());
            if (i >= set.size() - 1) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }

    protected String buildRequestString(OsmPrimitiveType osmPrimitiveType, long l) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(osmPrimitiveType.getAPIName()).append("s?").append(osmPrimitiveType.getAPIName()).append("s=").append(l);
        return stringBuilder.toString();
    }

    protected void multiGetIdPackage(OsmPrimitiveType osmPrimitiveType, Set<Long> set, ProgressMonitor progressMonitor) throws OsmTransferException {
        String string = this.buildRequestString(osmPrimitiveType, set);
        InputStream inputStream = this.getInputStream(string, NullProgressMonitor.INSTANCE);
        if (inputStream == null) {
            return;
        }
        progressMonitor.subTask(I18n.tr("Downloading OSM data..."));
        try {
            DataSet dataSet = OsmReader.parseDataSet(inputStream, progressMonitor.createSubTaskMonitor(set.size(), false));
            this.rememberNodesOfIncompleteWaysToLoad(dataSet);
            this.merge(dataSet);
        }
        catch (Exception exception) {
            throw new OsmTransferException(exception);
        }
    }

    protected void singleGetId(OsmPrimitiveType osmPrimitiveType, long l, ProgressMonitor progressMonitor) throws OsmTransferException {
        String string = this.buildRequestString(osmPrimitiveType, l);
        InputStream inputStream = this.getInputStream(string, NullProgressMonitor.INSTANCE);
        if (inputStream == null) {
            return;
        }
        progressMonitor.subTask(I18n.tr("Downloading OSM data..."));
        try {
            DataSet dataSet = OsmReader.parseDataSet(inputStream, progressMonitor.createSubTaskMonitor(1, false));
            this.rememberNodesOfIncompleteWaysToLoad(dataSet);
            this.merge(dataSet);
        }
        catch (Exception exception) {
            throw new OsmTransferException(exception);
        }
    }

    protected void singleGetIdPackage(OsmPrimitiveType osmPrimitiveType, Set<Long> set, ProgressMonitor progressMonitor) throws OsmTransferException {
        for (long l : set) {
            try {
                String string = "";
                switch (osmPrimitiveType) {
                    case NODE: {
                        string = I18n.tr("Fetching node with id {0} from ''{1}''", l, OsmApi.getOsmApi().getBaseUrl());
                        break;
                    }
                    case WAY: {
                        string = I18n.tr("Fetching way with id {0} from ''{1}''", l, OsmApi.getOsmApi().getBaseUrl());
                        break;
                    }
                    case RELATION: {
                        string = I18n.tr("Fetching relation with id {0} from ''{1}''", l, OsmApi.getOsmApi().getBaseUrl());
                    }
                }
                progressMonitor.setCustomText(string);
                this.singleGetId(osmPrimitiveType, l, progressMonitor);
            }
            catch (OsmApiException osmApiException) {
                if (osmApiException.getResponseCode() == 404) {
                    System.out.println(I18n.tr("Server replied with response code 404 for id {0}. Skipping.", Long.toString(l)));
                    this.missingPrimitives.add(new SimplePrimitiveId(l, osmPrimitiveType));
                    continue;
                }
                throw osmApiException;
            }
        }
    }

    protected void rememberNodesOfIncompleteWaysToLoad(DataSet dataSet) {
        for (Way way : dataSet.getWays()) {
            if (!way.hasIncompleteNodes()) continue;
            for (Node node : way.getNodes()) {
                if (!node.isIncomplete()) continue;
                this.nodes.add(node.getId());
            }
        }
    }

    protected void merge(DataSet dataSet) {
        DataSetMerger dataSetMerger = new DataSetMerger(this.outputDataSet, dataSet);
        dataSetMerger.merge();
    }

    protected void fetchPrimitives(Set<Long> set, OsmPrimitiveType osmPrimitiveType, ProgressMonitor progressMonitor) throws OsmTransferException {
        String string = "";
        switch (osmPrimitiveType) {
            case NODE: {
                string = I18n.tr("Fetching a package of nodes from ''{0}''", OsmApi.getOsmApi().getBaseUrl());
                break;
            }
            case WAY: {
                string = I18n.tr("Fetching a package of ways from ''{0}''", OsmApi.getOsmApi().getBaseUrl());
                break;
            }
            case RELATION: {
                string = I18n.tr("Fetching a package of relations from ''{0}''", OsmApi.getOsmApi().getBaseUrl());
            }
        }
        progressMonitor.setTicksCount(set.size());
        progressMonitor.setTicks(0);
        HashSet<Long> hashSet = new HashSet<Long>(set);
        while (!hashSet.isEmpty() && !this.isCanceled()) {
            Set<Long> set2 = this.extractIdPackage(hashSet);
            progressMonitor.subTask(string + "... " + progressMonitor.getTicks() + "/" + progressMonitor.getTicksCount());
            try {
                this.multiGetIdPackage(osmPrimitiveType, set2, progressMonitor);
            }
            catch (OsmApiException osmApiException) {
                if (osmApiException.getResponseCode() == 404) {
                    System.out.println(I18n.tr("Server replied with response code 404, retrying with an individual request for each object."));
                    this.singleGetIdPackage(osmPrimitiveType, set2, progressMonitor);
                    continue;
                }
                throw osmApiException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        int n = this.nodes.size() + this.ways.size() + this.relations.size();
        progressMonitor.beginTask(I18n.trn("Downloading {0} object from ''{1}''", "Downloading {0} objects from ''{1}''", n, n, OsmApi.getOsmApi().getBaseUrl()));
        try {
            this.missingPrimitives = new HashSet<PrimitiveId>();
            if (this.isCanceled()) {
                DataSet dataSet = null;
                return dataSet;
            }
            this.fetchPrimitives(this.ways, OsmPrimitiveType.WAY, progressMonitor);
            if (this.isCanceled()) {
                DataSet dataSet = null;
                return dataSet;
            }
            this.fetchPrimitives(this.nodes, OsmPrimitiveType.NODE, progressMonitor);
            if (this.isCanceled()) {
                DataSet dataSet = null;
                return dataSet;
            }
            this.fetchPrimitives(this.relations, OsmPrimitiveType.RELATION, progressMonitor);
            if (this.outputDataSet != null) {
                this.outputDataSet.deleteInvisible();
            }
            DataSet dataSet = this.outputDataSet;
            return dataSet;
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public Set<PrimitiveId> getMissingPrimitives() {
        return this.missingPrimitives;
    }
}

