/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.io.XmlWriter;
import org.openstreetmap.josm.tools.ColorHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.XmlObjectParser;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Preferences {
    private File preferencesDirFile = null;
    protected final SortedMap<String, String> properties = new TreeMap<String, String>();
    protected final SortedMap<String, String> defaults = new TreeMap<String, String>();
    protected final SortedMap<String, String> colornames = new TreeMap<String, String>();
    private final CopyOnWriteArrayList<PreferenceChangedListener> listeners = new CopyOnWriteArrayList();
    private static final String[] DEFAULT_PLUGIN_SITE = new String[]{"http://josm.openstreetmap.de/plugin%<?plugins=>"};

    public void addPreferenceChangeListener(PreferenceChangedListener preferenceChangedListener) {
        if (preferenceChangedListener != null) {
            this.listeners.addIfAbsent(preferenceChangedListener);
        }
    }

    public void removePreferenceChangeListener(PreferenceChangedListener preferenceChangedListener) {
        this.listeners.remove(preferenceChangedListener);
    }

    protected void firePreferenceChanged(String string, String string2, String string3) {
        DefaultPreferenceChangeEvent defaultPreferenceChangeEvent = new DefaultPreferenceChangeEvent(string, string2, string3);
        for (PreferenceChangedListener preferenceChangedListener : this.listeners) {
            preferenceChangedListener.preferenceChanged(defaultPreferenceChangeEvent);
        }
    }

    public String getPreferencesDir() {
        String string = this.getPreferencesDirFile().getPath();
        if (string.endsWith(File.separator)) {
            return string;
        }
        return string + File.separator;
    }

    public File getPreferencesDirFile() {
        if (this.preferencesDirFile != null) {
            return this.preferencesDirFile;
        }
        String string = System.getProperty("josm.home");
        this.preferencesDirFile = string != null ? new File(string) : ((string = System.getenv("APPDATA")) != null ? new File(string, "JOSM") : new File(System.getProperty("user.home"), ".josm"));
        return this.preferencesDirFile;
    }

    public File getPreferenceFile() {
        return new File(this.getPreferencesDirFile(), "preferences");
    }

    public File getPluginsDirectory() {
        return new File(this.getPreferencesDirFile(), "plugins");
    }

    public Collection<String> getAllPossiblePreferenceDirs() {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(Main.pref.getPreferencesDir());
        String string = System.getenv("JOSM_RESOURCES");
        if (string != null) {
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            linkedList.add(string);
        }
        if ((string = System.getProperty("josm.resources")) != null) {
            if (!string.endsWith(File.separator)) {
                string = string + File.separator;
            }
            linkedList.add(string);
        }
        String string2 = System.getenv("APPDATA");
        if (System.getenv("ALLUSERSPROFILE") != null && string2 != null && string2.lastIndexOf(File.separator) != -1) {
            string2 = string2.substring(string2.lastIndexOf(File.separator));
            linkedList.add(new File(new File(System.getenv("ALLUSERSPROFILE"), string2), "JOSM").getPath());
        }
        linkedList.add("/usr/local/share/josm/");
        linkedList.add("/usr/local/lib/josm/");
        linkedList.add("/usr/share/josm/");
        linkedList.add("/usr/lib/josm/");
        return linkedList;
    }

    public synchronized boolean hasKey(String string) {
        return this.properties.containsKey(string);
    }

    public synchronized String get(String string) {
        this.putDefault(string, null);
        if (!this.properties.containsKey(string)) {
            return "";
        }
        return (String)this.properties.get(string);
    }

    public synchronized String get(String string, String string2) {
        this.putDefault(string, string2);
        String string3 = (String)this.properties.get(string);
        if (string3 == null || string3.equals("")) {
            return string2;
        }
        return string3;
    }

    public synchronized Map<String, String> getAllPrefix(String string) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            if (!entry.getKey().startsWith(string)) continue;
            treeMap.put(entry.getKey(), entry.getValue());
        }
        return treeMap;
    }

    private synchronized Map<String, String> getAllPrefixDefault(String string) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (Map.Entry<String, String> entry : this.defaults.entrySet()) {
            if (!entry.getKey().startsWith(string)) continue;
            treeMap.put(entry.getKey(), entry.getValue());
        }
        return treeMap;
    }

    public synchronized TreeMap<String, String> getAllColors() {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (Map.Entry<String, String> entry : this.defaults.entrySet()) {
            if (!entry.getKey().startsWith("color.") || entry.getValue() == null) continue;
            treeMap.put(entry.getKey().substring(6), entry.getValue());
        }
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            if (!entry.getKey().startsWith("color.")) continue;
            treeMap.put(entry.getKey().substring(6), entry.getValue());
        }
        return treeMap;
    }

    public synchronized Map<String, String> getDefaults() {
        return this.defaults;
    }

    public synchronized void putDefault(String string, String string2) {
        if (!this.defaults.containsKey(string) || this.defaults.get(string) == null) {
            this.defaults.put(string, string2);
        } else if (string2 != null && !((String)this.defaults.get(string)).equals(string2)) {
            System.out.println("Defaults for " + string + " differ: " + string2 + " != " + (String)this.defaults.get(string));
        }
    }

    public synchronized boolean getBoolean(String string) {
        this.putDefault(string, null);
        return this.properties.containsKey(string) ? Boolean.parseBoolean((String)this.properties.get(string)) : false;
    }

    public synchronized boolean getBoolean(String string, boolean bl) {
        this.putDefault(string, Boolean.toString(bl));
        return this.properties.containsKey(string) ? Boolean.parseBoolean((String)this.properties.get(string)) : bl;
    }

    public synchronized boolean getBoolean(String string, String string2, boolean bl) {
        this.putDefault(string, Boolean.toString(bl));
        String string3 = string + "." + string2;
        if (this.properties.containsKey(string3)) {
            return Boolean.parseBoolean((String)this.properties.get(string3));
        }
        return this.properties.containsKey(string) ? Boolean.parseBoolean((String)this.properties.get(string)) : bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(String string, String string2) {
        boolean bl = false;
        String string3 = null;
        Preferences preferences = this;
        synchronized (preferences) {
            boolean bl2;
            string3 = (String)this.properties.get(string);
            if (string2 != null && string2.length() == 0) {
                string2 = null;
            }
            boolean bl3 = string3 != null && string3.equals(string2);
            boolean bl4 = bl2 = string3 == null && (string2 == null || string2.equals(this.defaults.get(string)));
            if (!bl3 && !bl2) {
                if (string2 == null) {
                    this.properties.remove(string);
                } else {
                    this.properties.put(string, string2);
                }
                try {
                    this.save();
                }
                catch (IOException iOException) {
                    System.out.println(I18n.tr("Warning: failed to persist preferences to ''{0}''", this.getPreferenceFile().getAbsoluteFile()));
                }
                bl = true;
            }
        }
        if (bl) {
            this.firePreferenceChanged(string, string3, string2);
        }
        return bl;
    }

    public boolean put(String string, boolean bl) {
        return this.put(string, Boolean.toString(bl));
    }

    public boolean putInteger(String string, Integer n) {
        return this.put(string, Integer.toString(n));
    }

    public boolean putDouble(String string, Double d) {
        return this.put(string, Double.toString(d));
    }

    public boolean putLong(String string, Long l) {
        return this.put(string, Long.toString(l));
    }

    public void save() throws IOException {
        this.putInteger("josm.version", Version.getInstance().getVersion());
        this.updateSystemProperties();
        if (Main.applet) {
            return;
        }
        File file = this.getPreferenceFile();
        File file2 = new File(file + "_backup");
        if (file.exists()) {
            Preferences.copyFile(file, file2);
        }
        PrintWriter printWriter = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(file + "_tmp"), "utf-8"), false);
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            String string = (String)this.defaults.get(entry.getKey());
            if (string != null && string.equals(entry.getValue())) continue;
            printWriter.println(entry.getKey() + "=" + entry.getValue());
        }
        printWriter.close();
        File file3 = new File(file + "_tmp");
        Preferences.copyFile(file3, file);
        file3.delete();
        this.setCorrectPermissions(file);
        this.setCorrectPermissions(file2);
    }

    private void setCorrectPermissions(File file) {
        file.setReadable(false, false);
        file.setWritable(false, false);
        file.setExecutable(false, false);
        file.setReadable(true, true);
        file.setWritable(true, true);
    }

    public static void copyFile(File file, File file2) throws IOException {
        FileChannel fileChannel = new FileInputStream(file).getChannel();
        FileChannel fileChannel2 = new FileOutputStream(file2).getChannel();
        try {
            fileChannel.transferTo(0L, fileChannel.size(), fileChannel2);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (fileChannel != null) {
                fileChannel.close();
            }
            if (fileChannel2 != null) {
                fileChannel2.close();
            }
        }
    }

    public void load() throws IOException {
        this.properties.clear();
        if (!Main.applet) {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.getPreferencesDir() + "preferences"), "utf-8"));
            int n = 0;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            String string = bufferedReader.readLine();
            while (string != null) {
                int n2 = string.indexOf(61);
                if (n2 == -1 || n2 == 0) {
                    arrayList.add(n);
                } else {
                    String string2 = string.substring(0, n2);
                    String string3 = string.substring(n2 + 1);
                    if (!string3.isEmpty()) {
                        this.properties.put(string2, string3);
                    }
                }
                string = bufferedReader.readLine();
                ++n;
            }
            if (!arrayList.isEmpty()) {
                throw new IOException(I18n.tr("Malformed config file at lines {0}", arrayList));
            }
        }
        this.updateSystemProperties();
    }

    public void init(boolean bl) {
        if (Main.applet) {
            return;
        }
        File file = this.getPreferencesDirFile();
        if (file.exists()) {
            if (!file.isDirectory()) {
                System.err.println(I18n.tr("Warning: Failed to initialize preferences. Preference directory ''{0}'' is not a directory.", file.getAbsoluteFile()));
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Failed to initialize preferences.<br>Preference directory ''{0}'' is not a directory.</html>", file.getAbsoluteFile()), I18n.tr("Error"), 0);
                return;
            }
        } else if (!file.mkdirs()) {
            System.err.println(I18n.tr("Warning: Failed to initialize preferences. Failed to create missing preference directory: {0}", file.getAbsoluteFile()));
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Failed to initialize preferences.<br>Failed to create missing preference directory: {0}</html>", file.getAbsoluteFile()), I18n.tr("Error"), 0);
            return;
        }
        File file2 = this.getPreferenceFile();
        try {
            if (!file2.exists()) {
                System.out.println(I18n.tr("Warning: Missing preference file ''{0}''. Creating a default preference file.", file2.getAbsoluteFile()));
                this.resetToDefault();
                this.save();
            } else if (bl) {
                System.out.println(I18n.tr("Warning: Replacing existing preference file ''{0}'' with default preference file.", file2.getAbsoluteFile()));
                this.resetToDefault();
                this.save();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Failed to initialize preferences.<br>Failed to reset preference file to default: {0}</html>", this.getPreferenceFile().getAbsoluteFile()), I18n.tr("Error"), 0);
            return;
        }
        try {
            this.load();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            File file3 = new File(file, "preferences.bak");
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("<html>Preferences file had errors.<br> Making backup of old one to <br>{0}<br> and creating a new default preference file.</html>", file3.getAbsoluteFile()), I18n.tr("Error"), 0);
            file2.renameTo(file3);
            try {
                this.resetToDefault();
                this.save();
            }
            catch (IOException iOException2) {
                iOException2.printStackTrace();
                System.err.println(I18n.tr("Warning: Failed to initialize preferences.Failed to reset preference file to default: {0}", this.getPreferenceFile()));
            }
        }
    }

    public final void resetToDefault() {
        this.properties.clear();
    }

    public synchronized Color getColor(String string, Color color) {
        return this.getColor(string, null, color);
    }

    public synchronized String getColorName(String string) {
        try {
            Matcher matcher = Pattern.compile("mappaint\\.(.+?)\\.(.+)").matcher(string);
            matcher.matches();
            return I18n.tr("Paint style {0}: {1}", I18n.tr(matcher.group(1)), I18n.tr(matcher.group(2)));
        }
        catch (Exception exception) {
            try {
                Matcher matcher = Pattern.compile("layer (.+)").matcher(string);
                matcher.matches();
                return I18n.tr("Layer: {0}", I18n.tr(matcher.group(1)));
            }
            catch (Exception exception2) {
                return I18n.tr(this.colornames.containsKey(string) ? (String)this.colornames.get(string) : string);
            }
        }
    }

    public Color getColor(ColorKey colorKey) {
        return this.getColor(colorKey.getColorName(), colorKey.getSpecialName(), colorKey.getDefault());
    }

    public synchronized Color getColor(String string, String string2, Color color) {
        String string3;
        String string4 = string.toLowerCase().replaceAll("[^a-z0-9]+", ".");
        if (!string4.equals(string)) {
            this.colornames.put(string4, string);
        }
        this.putDefault("color." + string4, ColorHelper.color2html(color));
        String string5 = string3 = string2 != null ? this.get("color." + string2) : "";
        if (string3.equals("")) {
            string3 = this.get("color." + string4);
        }
        return string3.equals("") ? color : ColorHelper.html2color(string3);
    }

    public synchronized Color getDefaultColor(String string) {
        String string2 = (String)this.defaults.get("color." + string);
        return string2 == null || "".equals(string2) ? null : ColorHelper.html2color(string2);
    }

    public synchronized boolean putColor(String string, Color color) {
        return this.put("color." + string, color != null ? ColorHelper.color2html(color) : null);
    }

    public synchronized int getInteger(String string, int n) {
        this.putDefault(string, Integer.toString(n));
        String string2 = this.get(string);
        if (string2.isEmpty()) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public synchronized int getInteger(String string, String string2, int n) {
        this.putDefault(string, Integer.toString(n));
        String string3 = this.get(string + "." + string2);
        if (string3.isEmpty()) {
            string3 = this.get(string);
        }
        if (string3.isEmpty()) {
            return n;
        }
        try {
            return Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public synchronized long getLong(String string, long l) {
        this.putDefault(string, Long.toString(l));
        String string2 = this.get(string);
        if (null == string2) {
            return l;
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return l;
        }
    }

    public synchronized double getDouble(String string, double d) {
        this.putDefault(string, Double.toString(d));
        String string2 = this.get(string);
        if (null == string2) {
            return d;
        }
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }

    public synchronized double getDouble(String string, String string2) {
        this.putDefault(string, string2);
        String string3 = this.get(string);
        if (string3 != null && string3.length() != 0) {
            try {
                return Double.parseDouble(string3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    public synchronized String getCollectionAsString(String string) {
        String string2 = this.get(string);
        if (string2 != null && string2.length() != 0) {
            string2 = string2.replaceAll("\u001e", ",");
        }
        return string2;
    }

    public boolean isCollection(String string, boolean bl) {
        String string2 = this.get(string);
        if (string2 != null && string2.length() != 0) {
            return string2.indexOf("\u001e") >= 0;
        }
        return bl;
    }

    public synchronized Collection<String> getCollection(String string, Collection<String> collection) {
        this.putCollectionDefault(string, collection);
        String string2 = this.get(string);
        if (string2 != null && string2.length() != 0) {
            return Arrays.asList(string2.split("\u001e", -1));
        }
        return collection;
    }

    public synchronized Collection<String> getCollection(String string) {
        this.putCollectionDefault(string, null);
        String string2 = this.get(string);
        if (string2 != null && string2.length() != 0) {
            return Arrays.asList(string2.split("\u001e", -1));
        }
        return Collections.emptyList();
    }

    @Deprecated
    public synchronized Collection<String> getCollectionOld(String string, String string2) {
        this.putCollectionDefault(string, null);
        String string3 = this.get(string);
        if (string3 != null && string3.length() != 0) {
            if (!string3.contains("\u001e") && string3.contains(string2)) {
                string3 = string3.replace(string2, "\u001e");
                this.put(string, string3);
            }
            return Arrays.asList(string3.split("\u001e", -1));
        }
        return Collections.emptyList();
    }

    public synchronized void removeFromCollection(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>(this.getCollection(string, Collections.<String>emptyList()));
        arrayList.remove(string2);
        this.putCollection(string, arrayList);
    }

    public synchronized boolean putCollection(String string, Collection<String> collection) {
        return this.put(string, Utils.join("\u001e", collection));
    }

    private synchronized void putCollectionDefault(String string, Collection<String> collection) {
        this.putDefault(string, Utils.join("\u001e", collection));
    }

    public synchronized Collection<Collection<String>> getArray(String string, Collection<Collection<String>> collection) {
        if (collection != null) {
            this.putArrayDefault(string, collection);
        }
        string = string + ".";
        int n = 0;
        LinkedList<Collection<String>> linkedList = new LinkedList<Collection<String>>();
        while (this.properties.containsKey(string + n)) {
            linkedList.add(this.getCollection(string + n++, null));
        }
        return n == 0 ? collection : linkedList;
    }

    public synchronized boolean putArray(String string, Collection<Collection<String>> collection) {
        int n;
        boolean bl = false;
        string = string + ".";
        Set<String> set = this.getAllPrefix(string).keySet();
        if (collection != null) {
            n = 0;
            for (Collection<String> object : collection) {
                set.remove(string + n);
                bl |= this.putCollection(string + n++, object);
            }
        }
        n = string.length();
        for (String string2 : set) {
            try {
                Integer.valueOf(string2.substring(n));
                bl |= this.put(string2, null);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return bl;
    }

    private synchronized void putArrayDefault(String string, Collection<Collection<String>> collection) {
        string = string + ".";
        Set<String> set = this.getAllPrefixDefault(string).keySet();
        int n = 0;
        for (Collection<String> object : collection) {
            set.remove(string + n);
            this.putCollectionDefault(string + n++, object);
        }
        int n2 = string.length();
        for (String string2 : set) {
            try {
                Integer.valueOf(string2.substring(n2));
                this.defaults.remove(string2);
            }
            catch (Exception exception) {}
        }
    }

    public <T> List<T> getListOfStructs(String string, Class<T> clazz) {
        List<T> list = this.getListOfStructs(string, null, clazz);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public <T> List<T> getListOfStructs(String string, Collection<T> collection, Class<T> clazz) {
        Collection<Collection<String>> collection2 = this.getArray(string, collection == null ? null : this.serializeListOfStructs(collection, clazz));
        if (collection2 == null) {
            return collection == null ? null : new ArrayList<T>(collection);
        }
        ArrayList<T> arrayList = new ArrayList<T>();
        for (Collection<String> collection3 : collection2) {
            T t = this.deserializeStruct(collection3, clazz);
            arrayList.add(t);
        }
        return arrayList;
    }

    public <T> boolean putListOfStructs(String string, Collection<T> collection, Class<T> clazz) {
        return this.putArray(string, this.serializeListOfStructs(collection, clazz));
    }

    private <T> Collection<Collection<String>> serializeListOfStructs(Collection<T> collection, Class<T> clazz) {
        if (collection == null) {
            return null;
        }
        ArrayList<Collection<String>> arrayList = new ArrayList<Collection<String>>();
        for (T t : collection) {
            if (t == null) continue;
            arrayList.add(this.serializeStruct(t, clazz));
        }
        return arrayList;
    }

    private <T> Collection<String> serializeStruct(T t, Class<T> clazz) {
        T t2;
        try {
            t2 = clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Field field : clazz.getDeclaredFields()) {
            if (field.getAnnotation(pref.class) == null) continue;
            field.setAccessible(true);
            try {
                Object object = field.get(t);
                Object object2 = field.get(t2);
                if (object == null || field.getAnnotation(writeExplicitly.class) == null && Utils.equal(object, object2)) continue;
                arrayList.add(String.format("%s:%s", field.getName().replace("_", "-"), object.toString()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException();
            }
        }
        return arrayList;
    }

    private <T> T deserializeStruct(Collection<String> collection, Class<T> clazz) {
        T t = null;
        try {
            t = clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException();
        }
        for (String string : collection) {
            Field field;
            Object object;
            block17: {
                int n = string.indexOf(58);
                if (n == -1 || n == 0) continue;
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                object = null;
                try {
                    field = clazz.getDeclaredField(string2.replace("-", "_"));
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    continue;
                }
                catch (SecurityException securityException) {
                    throw new RuntimeException();
                }
                if (field.getAnnotation(pref.class) == null) continue;
                field.setAccessible(true);
                if (field.getType() == Boolean.class || field.getType() == Boolean.TYPE) {
                    object = Boolean.parseBoolean(string3);
                } else {
                    if (field.getType() == Integer.class || field.getType() == Integer.TYPE) {
                        try {
                            object = Integer.parseInt(string3);
                            break block17;
                        }
                        catch (NumberFormatException numberFormatException) {
                            continue;
                        }
                    }
                    if (field.getType() == String.class) {
                        object = string3;
                    } else {
                        throw new RuntimeException("unsupported preference primitive type");
                    }
                }
            }
            try {
                field.set(t, object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new AssertionError();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException();
            }
        }
        return t;
    }

    public void updateSystemProperties() {
        Properties properties = System.getProperties();
        properties.put("http.agent", Version.getInstance().getAgentString());
        System.setProperties(properties);
    }

    public Collection<String> getPluginSites() {
        return this.getCollection("pluginmanager.sites", Arrays.asList(DEFAULT_PLUGIN_SITE));
    }

    public void setPluginSites(Collection<String> collection) {
        this.putCollection("pluginmanager.sites", collection);
    }

    public void fromXML(Reader reader) throws SAXException {
        XmlObjectParser xmlObjectParser = new XmlObjectParser();
        xmlObjectParser.map("tag", XMLTag.class);
        xmlObjectParser.map("entry", XMLEntry.class);
        xmlObjectParser.map("collection", XMLCollection.class);
        xmlObjectParser.startWithValidation(reader, "http://josm.openstreetmap.de/preferences-1.0", "resource://data/preferences.xsd");
        LinkedList<String> linkedList = new LinkedList<String>();
        while (xmlObjectParser.hasNext()) {
            Object object = xmlObjectParser.next();
            if (object instanceof XMLTag) {
                this.properties.put(((XMLTag)object).key, ((XMLTag)object).value);
                continue;
            }
            if (object instanceof XMLEntry) {
                linkedList.add(((XMLEntry)object).value);
                continue;
            }
            if (!(object instanceof XMLCollection)) continue;
            this.properties.put(((XMLCollection)object).key, Utils.join("\u001e", linkedList));
            linkedList = new LinkedList();
        }
    }

    public String toXML(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<preferences xmlns=\"http://josm.openstreetmap.de/preferences-1.0\">\n");
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            if (bl && entry.getKey().equals("osm-server.password")) continue;
            String string = entry.getValue();
            if (string.contains("\u001e")) {
                stringBuilder.append(" <collection key='");
                stringBuilder.append(XmlWriter.encode(entry.getKey()));
                stringBuilder.append("'>\n");
                for (String string2 : string.split("\u001e", -1)) {
                    stringBuilder.append("  <entry value='");
                    stringBuilder.append(XmlWriter.encode(string2));
                    stringBuilder.append("' />\n");
                }
                stringBuilder.append(" </collection>\n");
                continue;
            }
            stringBuilder.append(" <tag key='");
            stringBuilder.append(XmlWriter.encode(entry.getKey()));
            stringBuilder.append("' value='");
            stringBuilder.append(XmlWriter.encode(entry.getValue()));
            stringBuilder.append("' />\n");
        }
        stringBuilder.append("</preferences>");
        return stringBuilder.toString();
    }

    public static class XMLEntry {
        public String value;
    }

    public static class XMLCollection {
        public String key;
    }

    public static class XMLTag {
        public String key;
        public String value;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface writeExplicitly {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface pref {
    }

    public static interface ColorKey {
        public String getColorName();

        public String getSpecialName();

        public Color getDefault();
    }

    private static class DefaultPreferenceChangeEvent
    implements PreferenceChangeEvent {
        private final String key;
        private final String oldValue;
        private final String newValue;

        public DefaultPreferenceChangeEvent(String string, String string2, String string3) {
            this.key = string;
            this.oldValue = string2;
            this.newValue = string3;
        }

        public String getKey() {
            return this.key;
        }

        public String getOldValue() {
            return this.oldValue;
        }

        public String getNewValue() {
            return this.newValue;
        }
    }

    public static interface PreferenceChangedListener {
        public void preferenceChanged(PreferenceChangeEvent var1);
    }

    public static interface PreferenceChangeEvent {
        public String getKey();

        public String getOldValue();

        public String getNewValue();
    }
}

