/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataIntegrityProblemException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.data.osm.visitor.PrimitiveVisitor;
import org.openstreetmap.josm.data.osm.visitor.Visitor;
import org.openstreetmap.josm.tools.CopyList;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Way
extends OsmPrimitive
implements IWay {
    private Node[] nodes = new Node[0];
    private BBox bbox;

    public List<Node> getNodes() {
        return new CopyList<Node>(this.nodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodes(List<Node> list) {
        boolean bl = this.writeLock();
        try {
            for (Node node : this.nodes) {
                node.removeReferrer(this);
            }
            this.nodes = list == null ? new Node[0] : list.toArray(new Node[list.size()]);
            for (Node node : this.nodes) {
                node.addReferrer(this);
            }
            this.clearCachedStyle();
            this.fireNodesChanged();
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    private List<Node> removeDouble(List<Node> list) {
        Node node = null;
        int n = list.size();
        int n2 = 0;
        while (n2 < n && n > 2) {
            Node node2 = list.get(n2);
            if (node == node2) {
                list.remove(n2);
                --n;
                continue;
            }
            node = node2;
            ++n2;
        }
        return list;
    }

    @Override
    public int getNodesCount() {
        return this.nodes.length;
    }

    public Node getNode(int n) {
        return this.nodes[n];
    }

    @Override
    public long getNodeId(int n) {
        return this.nodes[n].getUniqueId();
    }

    public boolean containsNode(Node node) {
        if (node == null) {
            return false;
        }
        Node[] nodeArray = this.nodes;
        for (int i = 0; i < nodeArray.length; ++i) {
            if (!nodeArray[i].equals(node)) continue;
            return true;
        }
        return false;
    }

    public List<Pair<Node, Node>> getNodePairs(boolean bl) {
        Node[] nodeArray;
        ArrayList<Pair<Node, Node>> arrayList = new ArrayList<Pair<Node, Node>>();
        if (this.isIncomplete()) {
            return arrayList;
        }
        Node node = null;
        for (Node node2 : nodeArray = this.nodes) {
            if (node == null) {
                node = node2;
                continue;
            }
            Pair<Node, Node> pair = new Pair<Node, Node>(node, node2);
            if (bl) {
                Pair.sort(pair);
            }
            arrayList.add(pair);
            node = node2;
        }
        return arrayList;
    }

    @Override
    public void visit(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void visit(PrimitiveVisitor primitiveVisitor) {
        primitiveVisitor.visit(this);
    }

    protected Way(long l, boolean bl) {
        super(l, bl);
    }

    public Way() {
        super(0L, false);
    }

    public Way(Way way, boolean bl) {
        super(way.getUniqueId(), true);
        this.cloneFrom(way);
        if (bl) {
            this.clearOsmId();
        }
    }

    public Way(Way way) {
        this(way, false);
    }

    public Way(long l) throws IllegalArgumentException {
        super(l, false);
    }

    public Way(long l, int n) {
        super(l, n, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(PrimitiveData primitiveData) {
        boolean bl = this.writeLock();
        try {
            super.load(primitiveData);
            WayData wayData = (WayData)primitiveData;
            ArrayList<Node> arrayList = new ArrayList<Node>(wayData.getNodes().size());
            for (Long l : wayData.getNodes()) {
                Node node = (Node)this.getDataSet().getPrimitiveById(l, OsmPrimitiveType.NODE);
                if (node != null) {
                    arrayList.add(node);
                    continue;
                }
                throw new AssertionError((Object)"Data consistency problem - way with missing node detected");
            }
            this.setNodes(arrayList);
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    @Override
    public WayData save() {
        WayData wayData = new WayData();
        this.saveCommonAttributes(wayData);
        for (Node node : this.nodes) {
            wayData.getNodes().add(node.getUniqueId());
        }
        return wayData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cloneFrom(OsmPrimitive osmPrimitive) {
        boolean bl = this.writeLock();
        try {
            super.cloneFrom(osmPrimitive);
            Way way = (Way)osmPrimitive;
            this.setNodes(way.getNodes());
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    public String toString() {
        String string = this.isIncomplete() ? "(incomplete)" : "nodes=" + Arrays.toString(this.nodes);
        return "{Way id=" + this.getUniqueId() + " version=" + this.getVersion() + " " + this.getFlagsAsString() + " " + string + "}";
    }

    @Override
    public boolean hasEqualSemanticAttributes(OsmPrimitive osmPrimitive) {
        if (osmPrimitive == null || !(osmPrimitive instanceof Way)) {
            return false;
        }
        if (!super.hasEqualSemanticAttributes(osmPrimitive)) {
            return false;
        }
        Way way = (Way)osmPrimitive;
        if (this.getNodesCount() != way.getNodesCount()) {
            return false;
        }
        for (int i = 0; i < this.getNodesCount(); ++i) {
            if (this.getNode(i).hasEqualSemanticAttributes(way.getNode(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(OsmPrimitive osmPrimitive) {
        if (osmPrimitive instanceof Relation) {
            return 1;
        }
        return osmPrimitive instanceof Way ? Long.valueOf(this.getUniqueId()).compareTo(osmPrimitive.getUniqueId()) : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode(Node node) {
        if (this.isIncomplete()) {
            return;
        }
        boolean bl = this.writeLock();
        try {
            int n;
            boolean bl2 = this.lastNode() == node && this.firstNode() == node;
            List<Node> list = this.getNodes();
            while ((n = list.indexOf(node)) >= 0) {
                list.remove(n);
            }
            n = list.size();
            if (bl2 && n > 2) {
                list.add(list.get(0));
            } else if (n >= 2 && n <= 3 && list.get(0) == list.get(n - 1)) {
                list.remove(n - 1);
            }
            this.setNodes(this.removeDouble(list));
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNodes(Set<? extends OsmPrimitive> set) {
        if (this.isIncomplete()) {
            return;
        }
        boolean bl = this.writeLock();
        try {
            boolean bl2 = this.lastNode() == this.firstNode() && set.contains(this.lastNode());
            ArrayList<Node> arrayList = new ArrayList<Node>();
            for (Node node : this.nodes) {
                if (set.contains(node)) continue;
                arrayList.add(node);
            }
            int n = arrayList.size();
            if (bl2 && n > 2) {
                arrayList.add((Node)arrayList.get(0));
            } else if (n >= 2 && n <= 3 && arrayList.get(0) == arrayList.get(n - 1)) {
                arrayList.remove(n - 1);
            }
            this.setNodes(this.removeDouble(arrayList));
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode(Node node) throws IllegalStateException {
        if (node == null) {
            return;
        }
        boolean bl = this.writeLock();
        try {
            if (this.isIncomplete()) {
                throw new IllegalStateException(I18n.tr("Cannot add node {0} to incomplete way {1}.", node.getId(), this.getId()));
            }
            this.clearCachedStyle();
            node.addReferrer(this);
            Node[] nodeArray = new Node[this.nodes.length + 1];
            System.arraycopy(this.nodes, 0, nodeArray, 0, this.nodes.length);
            nodeArray[this.nodes.length] = node;
            this.nodes = nodeArray;
            this.fireNodesChanged();
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNode(int n, Node node) throws IllegalStateException, IndexOutOfBoundsException {
        if (node == null) {
            return;
        }
        boolean bl = this.writeLock();
        try {
            if (this.isIncomplete()) {
                throw new IllegalStateException(I18n.tr("Cannot add node {0} to incomplete way {1}.", node.getId(), this.getId()));
            }
            this.clearCachedStyle();
            node.addReferrer(this);
            Node[] nodeArray = new Node[this.nodes.length + 1];
            System.arraycopy(this.nodes, 0, nodeArray, 0, n);
            System.arraycopy(this.nodes, n, nodeArray, n + 1, this.nodes.length - n);
            nodeArray[n] = node;
            this.nodes = nodeArray;
            this.fireNodesChanged();
        }
        finally {
            this.writeUnlock(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDeleted(boolean bl) {
        boolean bl2 = this.writeLock();
        try {
            for (Node node : this.nodes) {
                if (bl) {
                    node.removeReferrer(this);
                    continue;
                }
                node.addReferrer(this);
            }
            this.fireNodesChanged();
            super.setDeleted(bl);
        }
        finally {
            this.writeUnlock(bl2);
        }
    }

    @Override
    public boolean isClosed() {
        if (this.isIncomplete()) {
            return false;
        }
        Node[] nodeArray = this.nodes;
        return nodeArray.length >= 3 && nodeArray[nodeArray.length - 1] == nodeArray[0];
    }

    public Node lastNode() {
        Node[] nodeArray = this.nodes;
        if (this.isIncomplete() || nodeArray.length == 0) {
            return null;
        }
        return nodeArray[nodeArray.length - 1];
    }

    public Node firstNode() {
        Node[] nodeArray = this.nodes;
        if (this.isIncomplete() || nodeArray.length == 0) {
            return null;
        }
        return nodeArray[0];
    }

    public boolean isFirstLastNode(Node node) {
        Node[] nodeArray = this.nodes;
        if (this.isIncomplete() || nodeArray.length == 0) {
            return false;
        }
        return node == nodeArray[0] || node == nodeArray[nodeArray.length - 1];
    }

    public boolean isInnerNode(Node node) {
        Node[] nodeArray = this.nodes;
        if (this.isIncomplete() || nodeArray.length <= 2) {
            return false;
        }
        if (node == nodeArray[0] && node == nodeArray[nodeArray.length - 1]) {
            return true;
        }
        for (int i = 1; i < nodeArray.length - 1; ++i) {
            if (nodeArray[i] != node) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDisplayName(NameFormatter nameFormatter) {
        return nameFormatter.format(this);
    }

    @Override
    public OsmPrimitiveType getType() {
        return OsmPrimitiveType.WAY;
    }

    @Override
    public OsmPrimitiveType getDisplayType() {
        return this.isClosed() ? OsmPrimitiveType.CLOSEDWAY : OsmPrimitiveType.WAY;
    }

    private void checkNodes() {
        DataSet dataSet = this.getDataSet();
        if (dataSet != null) {
            Node[] nodeArray;
            for (Node node : nodeArray = this.nodes) {
                if (node.getDataSet() != dataSet) {
                    throw new DataIntegrityProblemException("Nodes in way must be in the same dataset");
                }
                if (!node.isDeleted()) continue;
                throw new DataIntegrityProblemException("Deleted node referenced: " + this.toString());
            }
            if (Main.pref.getBoolean("debug.checkNullCoor", true)) {
                for (Node node : nodeArray) {
                    if (node.isIncomplete() || node.getCoor() != null && node.getEastNorth() != null) continue;
                    throw new DataIntegrityProblemException("Complete node with null coordinates: " + this.toString() + node.get3892DebugInfo());
                }
            }
        }
    }

    private void fireNodesChanged() {
        this.checkNodes();
        if (this.getDataSet() != null) {
            this.getDataSet().fireWayNodesChanged(this);
        }
    }

    @Override
    public void setDataset(DataSet dataSet) {
        super.setDataset(dataSet);
        this.checkNodes();
    }

    @Override
    public BBox getBBox() {
        if (this.getDataSet() == null) {
            return new BBox(this);
        }
        if (this.bbox == null) {
            this.bbox = new BBox(this);
        }
        return new BBox(this.bbox);
    }

    @Override
    public void updatePosition() {
        this.bbox = new BBox(this);
    }

    public boolean hasIncompleteNodes() {
        Node[] nodeArray;
        for (Node node : nodeArray = this.nodes) {
            if (!node.isIncomplete()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isUsable() {
        return super.isUsable() && !this.hasIncompleteNodes();
    }

    @Override
    public boolean isDrawable() {
        return super.isDrawable() && !this.hasIncompleteNodes();
    }

    public double getLength() {
        double d = 0.0;
        Node node = null;
        for (Node node2 : this.nodes) {
            if (node != null) {
                d += node2.getCoor().greatCircleDistance(node.getCoor());
            }
            node = node2;
        }
        return d;
    }
}

