/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair.tags;

import org.openstreetmap.josm.gui.conflict.ConflictColors;
import org.openstreetmap.josm.gui.conflict.pair.MergeDecisionType;
import org.openstreetmap.josm.gui.conflict.pair.tags.TagMergeItem;
import org.openstreetmap.josm.gui.conflict.pair.tags.TagMergeTableCellRenderer;
import org.openstreetmap.josm.tools.I18n;

public class MergedTableCellRenderer
extends TagMergeTableCellRenderer {
    protected void setBackgroundColor(TagMergeItem tagMergeItem, boolean bl) {
        if (bl) {
            this.setBackground(ConflictColors.BGCOLOR_SELECTED.get());
            return;
        }
        if (MergeDecisionType.KEEP_MINE.equals((Object)tagMergeItem.getMergeDecision())) {
            this.setBackground(ConflictColors.BGCOLOR_COMBINED.get());
        } else if (MergeDecisionType.KEEP_THEIR.equals((Object)tagMergeItem.getMergeDecision())) {
            this.setBackground(ConflictColors.BGCOLOR_COMBINED.get());
        } else if (MergeDecisionType.UNDECIDED.equals((Object)tagMergeItem.getMergeDecision())) {
            this.setBackground(ConflictColors.BGCOLOR_UNDECIDED.get());
        }
    }

    protected void renderKey(TagMergeItem tagMergeItem, boolean bl) {
        this.setBackgroundColor(tagMergeItem, bl);
        if (MergeDecisionType.KEEP_MINE.equals((Object)tagMergeItem.getMergeDecision()) && tagMergeItem.getMyTagValue() == null) {
            this.setText(I18n.tr("<undefined>"));
            this.setToolTipText(I18n.tr("The merged dataset will not include a tag with key {0}", tagMergeItem.getKey()));
        } else if (MergeDecisionType.KEEP_THEIR.equals((Object)tagMergeItem.getMergeDecision()) && tagMergeItem.getTheirTagValue() == null) {
            this.setText(I18n.tr("<undefined>"));
            this.setToolTipText(I18n.tr("The merged dataset will not include a tag with key {0}", tagMergeItem.getKey()));
        } else if (MergeDecisionType.UNDECIDED.equals((Object)tagMergeItem.getMergeDecision())) {
            this.setText("");
        } else {
            this.setText(tagMergeItem.getKey());
            this.setToolTipText(tagMergeItem.getKey());
        }
    }

    protected void renderValue(TagMergeItem tagMergeItem, boolean bl) {
        this.setBackgroundColor(tagMergeItem, bl);
        if (MergeDecisionType.KEEP_MINE.equals((Object)tagMergeItem.getMergeDecision()) && tagMergeItem.getMyTagValue() == null) {
            this.setText(I18n.tr("<undefined>"));
            this.setToolTipText(I18n.tr("The merged dataset will not include a tag with key {0}", tagMergeItem.getKey()));
        } else if (MergeDecisionType.KEEP_THEIR.equals((Object)tagMergeItem.getMergeDecision()) && tagMergeItem.getTheirTagValue() == null) {
            this.setText(I18n.tr("<undefined>"));
            this.setToolTipText(I18n.tr("The merged dataset will not include a tag with key {0}", tagMergeItem.getKey()));
        } else if (MergeDecisionType.UNDECIDED.equals((Object)tagMergeItem.getMergeDecision())) {
            this.setText("");
        } else if (MergeDecisionType.KEEP_MINE.equals((Object)tagMergeItem.getMergeDecision())) {
            this.setText(tagMergeItem.getMyTagValue());
            this.setToolTipText(tagMergeItem.getMyTagValue());
        } else if (MergeDecisionType.KEEP_THEIR.equals((Object)tagMergeItem.getMergeDecision())) {
            this.setText(tagMergeItem.getTheirTagValue());
            this.setToolTipText(tagMergeItem.getTheirTagValue());
        }
    }
}

