/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

public class LatLonDialog
extends JDialog {
    private static final Color BG_COLOR_ERROR = new Color(255, 224, 224);
    private JTextField tfLatLon;
    private String help;
    private boolean canceled = false;
    private LatLon coordinates;
    private OKAction actOK;
    private CancelAction actCancel;
    private static final double ZERO = 0.0;
    private static final String DEG = "\u00b0";
    private static final String MIN = "\u2032";
    private static final String SEC = "\u2033";
    private static final char N_TR = LatLon.NORTH.charAt(0);
    private static final char S_TR = LatLon.SOUTH.charAt(0);
    private static final char E_TR = LatLon.EAST.charAt(0);
    private static final char W_TR = LatLon.WEST.charAt(0);
    private static final Pattern p = Pattern.compile("([+|-]?\\d+[.,]\\d+)|([+|-]?\\d+)|(\u00b0|o|deg)|('|\u2032|min)|(\"|\u2033|sec)|(,|;)|([NSEW" + N_TR + S_TR + E_TR + W_TR + "])|" + "\\s+|" + "(.+)");

    protected JPanel buildInputForm() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)new JLabel(I18n.tr("Coordinates:")), GBC.std().insets(0, 10, 5, 0));
        this.tfLatLon = new JTextField(24);
        jPanel.add((Component)this.tfLatLon, GBC.eol().insets(0, 10, 0, 0).fill(2).weight(1.0, 0.0));
        jPanel.add((Component)new JSeparator(), GBC.eol().fill(2).insets(0, 5, 0, 5));
        jPanel.add((Component)new HtmlPanel(I18n.tr("Enter the coordinates for the new node.<br/>You can separate longitude and latitude with space, comma or semicolon.<br/>Use positive numbers or N, E characters to indicate North or East cardinal direction.<br/>For South and West cardinal directions you can use either negative numbers or S, W characters.<br/>Coordinate value can be in one of three formats:<ul><li><i>degrees</i><tt>&deg;</tt></li><li><i>degrees</i><tt>&deg;</tt> <i>minutes</i><tt>&#39;</tt></li><li><i>degrees</i><tt>&deg;</tt> <i>minutes</i><tt>&#39;</tt> <i>seconds</i><tt>&quot</tt></li></ul>Symbols <tt>&deg;</tt>, <tt>&#39;</tt>, <tt>&prime;</tt>, <tt>&quot;</tt>, <tt>&Prime;</tt> are optional.<br/><br/>Some examples:<ul><li>49.29918&deg; 19.24788&deg;</li><li>N 49.29918 E 19.24788</li><li>W 49&deg;29.918&#39; S 19&deg;24.788&#39;</li><li>N 49&deg;29&#39;04&quot; E 19&deg;24&#39;43&quot;</li><li>49.29918 N, 19.24788 E</li><li>49&deg;29&#39;21&quot; N 19&deg;24&#39;38&quot; E</li><li>49 29 51, 19 24 18</li><li>49 29, 19 24</li><li>E 49 29, N 19 24</li><li>49&deg; 29; 19&deg; 24</li><li>N 49&deg; 29, W 19&deg; 24</li><li>49&deg; 29.5 S, 19&deg; 24.6 E</li><li>N 49 29.918 E 19 15.88</li><li>49 29.4 19 24.5</li><li>-49 29.4 N -19 24.5 W</li></ul><li>48 deg 42&#39; 52.13\" N, 21 deg 11&#39; 47.60\" E</li></ul>")), GBC.eol().fill().weight(1.0, 1.0));
        LatLonInputVerifier latLonInputVerifier = new LatLonInputVerifier();
        this.tfLatLon.getDocument().addDocumentListener(latLonInputVerifier);
        TextFieldFocusHandler textFieldFocusHandler = new TextFieldFocusHandler();
        this.tfLatLon.addFocusListener(textFieldFocusHandler);
        return jPanel;
    }

    protected JPanel buildButtonRow() {
        JPanel jPanel = new JPanel(new FlowLayout());
        this.actOK = new OKAction();
        SideButton sideButton = new SideButton(this.actOK);
        jPanel.add(sideButton);
        this.makeButtonRespondToEnter(sideButton);
        this.actCancel = new CancelAction();
        sideButton = new SideButton(this.actCancel);
        jPanel.add(sideButton);
        this.makeButtonRespondToEnter(sideButton);
        jPanel.add(new SideButton(new ContextSensitiveHelpAction(this.help)));
        return jPanel;
    }

    protected void makeButtonRespondToEnter(SideButton sideButton) {
        sideButton.setFocusable(true);
        sideButton.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "enter");
        sideButton.getActionMap().put("enter", sideButton.getAction());
    }

    protected void build() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.buildInputForm(), "Center");
        this.getContentPane().add((Component)this.buildButtonRow(), "South");
        this.pack();
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "escape");
        this.getRootPane().getActionMap().put("escape", this.actCancel);
        HelpUtil.setHelpContext(this.getRootPane(), this.help);
    }

    public LatLonDialog(Component component, String string, String string2) {
        super((Window)JOptionPane.getFrameForComponent(component), Dialog.ModalityType.DOCUMENT_MODAL);
        this.help = string2;
        this.setTitle(string);
        this.build();
        this.addWindowListener(new WindowEventHandler());
        this.setCoordinates(null);
    }

    public void setCoordinates(LatLon latLon) {
        if (latLon == null) {
            latLon = new LatLon(0.0, 0.0);
        }
        this.coordinates = latLon;
        this.tfLatLon.setText(latLon.latToString(CoordinateFormat.getDefaultFormat()) + " " + latLon.lonToString(CoordinateFormat.getDefaultFormat()));
        this.actOK.setEnabled(true);
    }

    public LatLon getCoordinates() {
        return this.coordinates;
    }

    protected void setErrorFeedback(JTextField jTextField, String string) {
        jTextField.setBorder(BorderFactory.createLineBorder(Color.RED, 1));
        jTextField.setToolTipText(string);
        jTextField.setBackground(BG_COLOR_ERROR);
    }

    protected void clearErrorFeedback(JTextField jTextField, String string) {
        jTextField.setBorder(UIManager.getBorder("TextField.border"));
        jTextField.setToolTipText(string);
        jTextField.setBackground(UIManager.getColor("TextField.background"));
    }

    protected Double parseDoubleFromUserInput(String string) {
        if (string == null) {
            return null;
        }
        string = string.trim();
        string = string.replaceAll(DEG, "");
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        Number number = null;
        ParsePosition parsePosition = new ParsePosition(0);
        number = numberFormat.parse(string, parsePosition);
        if (parsePosition.getErrorIndex() >= 0 || parsePosition.getIndex() < string.length()) {
            parsePosition = new ParsePosition(0);
            numberFormat = NumberFormat.getNumberInstance(Locale.ENGLISH);
            number = numberFormat.parse(string, parsePosition);
            if (parsePosition.getErrorIndex() >= 0 || parsePosition.getIndex() < string.length()) {
                return null;
            }
        }
        return number == null ? null : Double.valueOf(number.doubleValue());
    }

    protected void parseUserInput() {
        LatLon latLon;
        try {
            latLon = LatLonDialog.parse(this.tfLatLon.getText());
            if (!LatLon.isValidLat(latLon.lat()) || !LatLon.isValidLon(latLon.lon())) {
                latLon = null;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            latLon = null;
        }
        if (latLon == null) {
            this.setErrorFeedback(this.tfLatLon, I18n.tr("Please enter a GPS coordinates"));
            this.coordinates = null;
            this.actOK.setEnabled(false);
        } else {
            this.clearErrorFeedback(this.tfLatLon, I18n.tr("Please enter a GPS coordinates"));
            this.coordinates = latLon;
            this.actOK.setEnabled(true);
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    protected void setCanceled(boolean bl) {
        this.canceled = bl;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.setCanceled(false);
            WindowGeometry.centerInWindow(Main.parent, this.getSize()).applySafe(this);
        }
        super.setVisible(bl);
    }

    private static LatLon parse(String string) {
        String string2;
        Matcher matcher = p.matcher(string);
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (matcher.find()) {
            if (matcher.group(1) != null) {
                stringBuilder.append('R');
                arrayList.add(Double.parseDouble(matcher.group(1).replace(',', '.')));
                continue;
            }
            if (matcher.group(2) != null) {
                stringBuilder.append('Z');
                arrayList.add(Double.parseDouble(matcher.group(2)));
                continue;
            }
            if (matcher.group(3) != null) {
                stringBuilder.append('o');
                continue;
            }
            if (matcher.group(4) != null) {
                stringBuilder.append('\'');
                continue;
            }
            if (matcher.group(5) != null) {
                stringBuilder.append('\"');
                continue;
            }
            if (matcher.group(6) != null) {
                stringBuilder.append(',');
                continue;
            }
            if (matcher.group(7) != null) {
                stringBuilder.append("x");
                string2 = matcher.group(7).toUpperCase();
                if (string2.equals("N") || string2.equals("S") || string2.equals("E") || string2.equals("W")) {
                    arrayList.add(string2);
                    continue;
                }
                arrayList.add(string2.replace(N_TR, 'N').replace(S_TR, 'S').replace(E_TR, 'E').replace(W_TR, 'W'));
                continue;
            }
            if (matcher.group(8) == null) continue;
            throw new IllegalArgumentException("invalid token: " + matcher.group(8));
        }
        string2 = stringBuilder.toString();
        Object[] objectArray = arrayList.toArray();
        LatLonHolder latLonHolder = new LatLonHolder();
        if (string2.matches("Ro?,?Ro?")) {
            LatLonDialog.setLatLonObj(latLonHolder, objectArray[0], 0.0, 0.0, "N", objectArray[1], 0.0, 0.0, "E");
        } else if (string2.matches("xRo?,?xRo?")) {
            LatLonDialog.setLatLonObj(latLonHolder, objectArray[1], 0.0, 0.0, objectArray[0], objectArray[3], 0.0, 0.0, objectArray[2]);
        } else if (string2.matches("Ro?x,?Ro?x")) {
            LatLonDialog.setLatLonObj(latLonHolder, objectArray[0], 0.0, 0.0, objectArray[1], objectArray[2], 0.0, 0.0, objectArray[3]);
        } else if (string2.matches("Zo[RZ]'?,?Zo[RZ]'?|Z[RZ],?Z[RZ]")) {
            LatLonDialog.setLatLonObj(latLonHolder, objectArray[0], objectArray[1], 0.0, "N", objectArray[2], objectArray[3], 0.0, "E");
        } else if (string2.matches("xZo[RZ]'?,?xZo[RZ]'?|xZo?[RZ],?xZo?[RZ]")) {
            LatLonDialog.setLatLonObj(latLonHolder, objectArray[1], objectArray[2], 0.0, objectArray[0], objectArray[4], objectArray[5], 0.0, objectArray[3]);
        } else if (string2.matches("Zo[RZ]'?x,?Zo[RZ]'?x|Zo?[RZ]x,?Zo?[RZ]x")) {
            LatLonDialog.setLatLonObj(latLonHolder, objectArray[0], objectArray[1], 0.0, objectArray[2], objectArray[3], objectArray[4], 0.0, objectArray[5]);
        } else if (string2.matches("ZoZ'[RZ]\"?x,?ZoZ'[RZ]\"?x|ZZ[RZ]x,?ZZ[RZ]x")) {
            LatLonDialog.setLatLonObj(latLonHolder, objectArray[0], objectArray[1], objectArray[2], objectArray[3], objectArray[4], objectArray[5], objectArray[6], objectArray[7]);
        } else if (string2.matches("xZoZ'[RZ]\"?,?xZoZ'[RZ]\"?|xZZ[RZ],?xZZ[RZ]")) {
            LatLonDialog.setLatLonObj(latLonHolder, objectArray[1], objectArray[2], objectArray[3], objectArray[0], objectArray[5], objectArray[6], objectArray[7], objectArray[4]);
        } else if (string2.matches("ZZ[RZ],?ZZ[RZ]")) {
            LatLonDialog.setLatLonObj(latLonHolder, objectArray[0], objectArray[1], objectArray[2], "N", objectArray[3], objectArray[4], objectArray[5], "E");
        } else {
            throw new IllegalArgumentException("invalid format: " + string2);
        }
        return new LatLon(latLonHolder.lat, latLonHolder.lon);
    }

    private static void setLatLonObj(LatLonHolder latLonHolder, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        LatLonDialog.setLatLon(latLonHolder, (Double)object, (Double)object2, (Double)object3, (String)object4, (Double)object5, (Double)object6, (Double)object7, (String)object8);
    }

    private static void setLatLon(LatLonHolder latLonHolder, double d, double d2, double d3, String string, double d4, double d5, double d6, String string2) {
        LatLonDialog.setLatLon(latLonHolder, d, d2, d3, string);
        LatLonDialog.setLatLon(latLonHolder, d4, d5, d6, string2);
    }

    private static void setLatLon(LatLonHolder latLonHolder, double d, double d2, double d3, String string) {
        if (d < -180.0 || d > 180.0 || d2 < 0.0 || d2 >= 60.0 || d3 < 0.0 || d3 > 60.0) {
            throw new IllegalArgumentException("out of range");
        }
        double d4 = (double)(d < 0.0 ? -1 : 1) * (Math.abs(d) + d2 / 60.0 + d3 / 3600.0);
        double d5 = d4 = string.equals("N") || string.equals("E") ? d4 : -d4;
        if (string.equals("N") || string.equals("S")) {
            latLonHolder.lat = d4;
        } else {
            latLonHolder.lon = d4;
        }
    }

    public String getText() {
        return this.tfLatLon.getText();
    }

    public void setText(String string) {
        this.tfLatLon.setText(string);
    }

    private static class LatLonHolder {
        double lat;
        double lon;

        private LatLonHolder() {
        }
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            LatLonDialog.this.setCanceled(true);
            LatLonDialog.this.setVisible(false);
        }

        public void windowOpened(WindowEvent windowEvent) {
            LatLonDialog.this.tfLatLon.requestFocusInWindow();
        }
    }

    static class TextFieldFocusHandler
    implements FocusListener {
        TextFieldFocusHandler() {
        }

        public void focusGained(FocusEvent focusEvent) {
            Component component = focusEvent.getComponent();
            if (component instanceof JTextField) {
                JTextField jTextField = (JTextField)component;
                jTextField.selectAll();
            }
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }

    class LatLonInputVerifier
    implements DocumentListener {
        LatLonInputVerifier() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            LatLonDialog.this.parseUserInput();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            LatLonDialog.this.parseUserInput();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            LatLonDialog.this.parseUserInput();
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", I18n.tr("Cancel"));
            this.putValue("ShortDescription", I18n.tr("Close the dialog, do not create a new node"));
            this.putValue("SmallIcon", ImageProvider.get("cancel"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LatLonDialog.this.setCanceled(true);
            LatLonDialog.this.setVisible(false);
        }
    }

    class OKAction
    extends AbstractAction {
        public OKAction() {
            this.putValue("Name", I18n.tr("OK"));
            this.putValue("ShortDescription", I18n.tr("Close the dialog and create a new node"));
            this.putValue("SmallIcon", ImageProvider.get("ok"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LatLonDialog.this.setCanceled(false);
            LatLonDialog.this.setVisible(false);
        }
    }
}

