/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class GPXSettingsPanel
extends JPanel {
    private JRadioButton drawRawGpsLinesGlobal = new JRadioButton(I18n.tr("Use global settings."));
    private JRadioButton drawRawGpsLinesAll = new JRadioButton(I18n.tr("All"));
    private JRadioButton drawRawGpsLinesLocal = new JRadioButton(I18n.tr("Local files"));
    private JRadioButton drawRawGpsLinesNone = new JRadioButton(I18n.tr("None"));
    private ActionListener drawRawGpsLinesActionListener;
    private JTextField drawRawGpsMaxLineLength = new JTextField(8);
    private JTextField drawRawGpsMaxLineLengthLocal = new JTextField(8);
    private JCheckBox forceRawGpsLines = new JCheckBox(I18n.tr("Force lines if no segments imported."));
    private JCheckBox largeGpsPoints = new JCheckBox(I18n.tr("Draw large GPS points."));
    private JCheckBox hdopCircleGpsPoints = new JCheckBox(I18n.tr("Draw a circle form HDOP value."));
    private ButtonGroup colorGroup;
    private JRadioButton colorTypeVelocity = new JRadioButton(I18n.tr("Velocity (red = slow, green = fast)"));
    private JRadioButton colorTypeDirection = new JRadioButton(I18n.tr("Direction (red = west, yellow = north, green = east, blue = south)"));
    private JRadioButton colorTypeDilution = new JRadioButton(I18n.tr("Dilution of Position (red = high, green = low, if available)"));
    private JRadioButton colorTypeTime = new JRadioButton(I18n.tr("Track date"));
    private JRadioButton colorTypeNone = new JRadioButton(I18n.tr("Single Color (can be customized for named layers)"));
    private JRadioButton colorTypeGlobal = new JRadioButton(I18n.tr("Use global settings."));
    private JComboBox colorTypeVelocityTune = new JComboBox<String>(new String[]{I18n.tr("Car"), I18n.tr("Bicycle"), I18n.tr("Foot")});
    private JCheckBox makeAutoMarkers = new JCheckBox(I18n.tr("Create markers when reading GPX."));
    private JCheckBox drawGpsArrows = new JCheckBox(I18n.tr("Draw Direction Arrows"));
    private JCheckBox drawGpsArrowsFast = new JCheckBox(I18n.tr("Fast drawing (looks uglier)"));
    private JTextField drawGpsArrowsMinDist = new JTextField(8);
    private JCheckBox colorDynamic = new JCheckBox(I18n.tr("Dynamic color range based on data limits"));
    private JComboBox waypointLabel = new JComboBox<String>(new String[]{I18n.tr("Auto"), I18n.trc("gpx_field", "Name"), I18n.trc("gpx_field", "Desc(ription)"), I18n.tr("Both"), I18n.tr("None")});
    private String layerName;
    private boolean local;
    private boolean nonlocal;

    public GPXSettingsPanel(String string, boolean bl, boolean bl2) {
        super(new GridBagLayout());
        this.local = bl;
        this.nonlocal = bl2;
        this.layerName = "layer " + string;
        this.initComponents();
        this.loadPreferences();
    }

    public GPXSettingsPanel() {
        super(new GridBagLayout());
        this.initComponents();
        this.local = false;
        this.nonlocal = false;
        this.loadPreferences();
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.makeAutoMarkers.setToolTipText(I18n.tr("Automatically make a marker layer from any waypoints when opening a GPX layer."));
        this.add((Component)this.makeAutoMarkers, GBC.eol().insets(20, 0, 0, 5));
        ButtonGroup buttonGroup = new ButtonGroup();
        if (this.layerName != null) {
            buttonGroup.add(this.drawRawGpsLinesGlobal);
        }
        buttonGroup.add(this.drawRawGpsLinesNone);
        buttonGroup.add(this.drawRawGpsLinesLocal);
        buttonGroup.add(this.drawRawGpsLinesAll);
        this.add((Component)new JLabel(I18n.tr("Draw lines between raw GPS points")), GBC.eol().insets(20, 0, 0, 0));
        if (this.layerName != null) {
            this.add((Component)this.drawRawGpsLinesGlobal, GBC.eol().insets(40, 0, 0, 0));
        }
        this.add((Component)this.drawRawGpsLinesNone, GBC.eol().insets(40, 0, 0, 0));
        if (this.layerName == null || this.local) {
            this.add((Component)this.drawRawGpsLinesLocal, GBC.eol().insets(40, 0, 0, 0));
        }
        if (this.layerName == null || this.nonlocal) {
            this.add((Component)this.drawRawGpsLinesAll, GBC.eol().insets(40, 0, 0, 0));
        }
        this.drawRawGpsLinesActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = GPXSettingsPanel.this.drawRawGpsLinesNone.isSelected() || GPXSettingsPanel.this.drawRawGpsLinesGlobal.isSelected();
                GPXSettingsPanel.this.forceRawGpsLines.setEnabled(!bl);
                GPXSettingsPanel.this.drawRawGpsMaxLineLength.setEnabled(!bl && !GPXSettingsPanel.this.drawRawGpsLinesLocal.isSelected());
                GPXSettingsPanel.this.drawRawGpsMaxLineLengthLocal.setEnabled(!bl);
                GPXSettingsPanel.this.drawGpsArrows.setEnabled(!bl);
                GPXSettingsPanel.this.drawGpsArrowsFast.setEnabled(GPXSettingsPanel.this.drawGpsArrows.isSelected() && GPXSettingsPanel.this.drawGpsArrows.isEnabled());
                GPXSettingsPanel.this.drawGpsArrowsMinDist.setEnabled(GPXSettingsPanel.this.drawGpsArrows.isSelected() && GPXSettingsPanel.this.drawGpsArrows.isEnabled());
            }
        };
        this.drawRawGpsLinesGlobal.addActionListener(this.drawRawGpsLinesActionListener);
        this.drawRawGpsLinesNone.addActionListener(this.drawRawGpsLinesActionListener);
        this.drawRawGpsLinesLocal.addActionListener(this.drawRawGpsLinesActionListener);
        this.drawRawGpsLinesAll.addActionListener(this.drawRawGpsLinesActionListener);
        this.drawRawGpsMaxLineLengthLocal.setToolTipText(I18n.tr("Maximum length (in meters) to draw lines for local files. Set to ''-1'' to draw all lines."));
        this.add((Component)new JLabel(I18n.tr("Maximum length for local files (meters)")), GBC.std().insets(40, 0, 0, 0));
        this.add((Component)this.drawRawGpsMaxLineLengthLocal, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.drawRawGpsMaxLineLength.setToolTipText(I18n.tr("Maximum length (in meters) to draw lines. Set to ''-1'' to draw all lines."));
        this.add((Component)new JLabel(I18n.tr("Maximum length (meters)")), GBC.std().insets(40, 0, 0, 0));
        this.add((Component)this.drawRawGpsMaxLineLength, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.forceRawGpsLines.setToolTipText(I18n.tr("Force drawing of lines if the imported data contain no line information."));
        this.add((Component)this.forceRawGpsLines, GBC.eop().insets(40, 0, 0, 0));
        this.drawGpsArrows.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GPXSettingsPanel.this.drawGpsArrowsFast.setEnabled(GPXSettingsPanel.this.drawGpsArrows.isSelected() && GPXSettingsPanel.this.drawGpsArrows.isEnabled());
                GPXSettingsPanel.this.drawGpsArrowsMinDist.setEnabled(GPXSettingsPanel.this.drawGpsArrows.isSelected() && GPXSettingsPanel.this.drawGpsArrows.isEnabled());
            }
        });
        this.drawGpsArrows.setToolTipText(I18n.tr("Draw direction arrows for lines, connecting GPS points."));
        this.add((Component)this.drawGpsArrows, GBC.eop().insets(40, 0, 0, 0));
        this.drawGpsArrowsFast.setToolTipText(I18n.tr("Draw the direction arrows using table lookups instead of complex math."));
        this.add((Component)this.drawGpsArrowsFast, GBC.eop().insets(60, 0, 0, 0));
        this.drawGpsArrowsMinDist.setToolTipText(I18n.tr("Do not draw arrows if they are not at least this distance away from the last one."));
        this.add((Component)new JLabel(I18n.tr("Minimum distance (pixels)")), GBC.std().insets(60, 0, 0, 0));
        this.add((Component)this.drawGpsArrowsMinDist, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.hdopCircleGpsPoints.setToolTipText(I18n.tr("Draw a circle form HDOP value."));
        this.add((Component)this.hdopCircleGpsPoints, GBC.eop().insets(20, 0, 0, 0));
        this.largeGpsPoints.setToolTipText(I18n.tr("Draw larger dots for the GPS points."));
        this.add((Component)this.largeGpsPoints, GBC.eop().insets(20, 0, 0, 0));
        this.colorGroup = new ButtonGroup();
        if (this.layerName != null) {
            this.colorGroup.add(this.colorTypeGlobal);
        }
        this.colorGroup.add(this.colorTypeNone);
        this.colorGroup.add(this.colorTypeVelocity);
        this.colorGroup.add(this.colorTypeDirection);
        this.colorGroup.add(this.colorTypeDilution);
        this.colorGroup.add(this.colorTypeTime);
        this.colorTypeVelocity.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                GPXSettingsPanel.this.colorTypeVelocityTune.setEnabled(GPXSettingsPanel.this.colorTypeVelocity.isSelected());
                GPXSettingsPanel.this.colorDynamic.setEnabled(GPXSettingsPanel.this.colorTypeVelocity.isSelected() || GPXSettingsPanel.this.colorTypeDilution.isSelected());
            }
        });
        this.colorTypeDilution.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                GPXSettingsPanel.this.colorDynamic.setEnabled(GPXSettingsPanel.this.colorTypeVelocity.isSelected() || GPXSettingsPanel.this.colorTypeDilution.isSelected());
            }
        });
        this.colorTypeNone.setToolTipText(I18n.tr("All points and track segments will have the same color. Can be customized in Layer Manager."));
        this.colorTypeVelocity.setToolTipText(I18n.tr("Colors points and track segments by velocity."));
        this.colorTypeDirection.setToolTipText(I18n.tr("Colors points and track segments by direction."));
        this.colorTypeDilution.setToolTipText(I18n.tr("Colors points and track segments by dilution of position (HDOP). Your capture device needs to log that information."));
        this.colorTypeTime.setToolTipText(I18n.tr("Colors points and track segments by its timestamp."));
        this.colorTypeVelocityTune.setToolTipText(I18n.tr("Allows to tune the track coloring for different average speeds."));
        this.add(Box.createVerticalGlue(), GBC.eol().insets(0, 20, 0, 0));
        this.add((Component)new JLabel(I18n.tr("Track and Point Coloring")), GBC.eol().insets(20, 0, 0, 0));
        if (this.layerName != null) {
            this.add((Component)this.colorTypeGlobal, GBC.eol().insets(40, 0, 0, 0));
        }
        this.add((Component)this.colorTypeNone, GBC.eol().insets(40, 0, 0, 0));
        this.add((Component)this.colorTypeVelocity, GBC.std().insets(40, 0, 0, 0));
        this.add((Component)this.colorTypeVelocityTune, GBC.eop().insets(5, 0, 0, 5));
        this.add((Component)this.colorTypeDirection, GBC.eol().insets(40, 0, 0, 0));
        this.add((Component)this.colorTypeDilution, GBC.eol().insets(40, 0, 0, 0));
        this.add((Component)this.colorTypeTime, GBC.eol().insets(40, 0, 0, 0));
        this.colorDynamic.setToolTipText(I18n.tr("Colors points and track segments by data limits."));
        this.add((Component)this.colorDynamic, GBC.eop().insets(40, 0, 0, 0));
        this.add(Box.createVerticalGlue(), GBC.eol().insets(0, 20, 0, 0));
        this.add((Component)new JLabel(I18n.tr("Waypoint labelling")), GBC.std().insets(20, 0, 0, 0));
        if (this.layerName != null) {
            this.waypointLabel.addItem(I18n.tr("Global settings"));
        }
        this.add((Component)this.waypointLabel, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.add(Box.createVerticalGlue(), GBC.eol().fill(1));
    }

    public void loadPreferences() {
        this.makeAutoMarkers.setSelected(Main.pref.getBoolean("marker.makeautomarkers", true));
        if (this.layerName != null && !Main.pref.hasKey("draw.rawgps.lines." + this.layerName) && !Main.pref.hasKey("draw.rawgps.lines.local." + this.layerName)) {
            this.drawRawGpsLinesGlobal.setSelected(true);
        } else {
            Boolean bl = Main.pref.getBoolean("draw.rawgps.lines.local", this.layerName, true);
            if (Main.pref.getBoolean("draw.rawgps.lines", this.layerName, true)) {
                this.drawRawGpsLinesAll.setSelected(true);
            } else if (bl.booleanValue()) {
                this.drawRawGpsLinesLocal.setSelected(true);
            } else {
                this.drawRawGpsLinesNone.setSelected(true);
            }
        }
        this.drawRawGpsMaxLineLengthLocal.setText(Integer.toString(Main.pref.getInteger("draw.rawgps.max-line-length.local", this.layerName, -1)));
        this.drawRawGpsMaxLineLength.setText(Integer.toString(Main.pref.getInteger("draw.rawgps.max-line-length", this.layerName, 200)));
        this.forceRawGpsLines.setSelected(Main.pref.getBoolean("draw.rawgps.lines.force", this.layerName, false));
        this.drawGpsArrows.setSelected(Main.pref.getBoolean("draw.rawgps.direction", this.layerName, false));
        this.drawGpsArrowsFast.setSelected(Main.pref.getBoolean("draw.rawgps.alternatedirection", this.layerName, false));
        this.drawGpsArrowsMinDist.setText(Integer.toString(Main.pref.getInteger("draw.rawgps.min-arrow-distance", this.layerName, 40)));
        this.hdopCircleGpsPoints.setSelected(Main.pref.getBoolean("draw.rawgps.hdopcircle", this.layerName, false));
        this.largeGpsPoints.setSelected(Main.pref.getBoolean("draw.rawgps.large", this.layerName, false));
        this.drawRawGpsLinesActionListener.actionPerformed(null);
        if (this.layerName != null && !Main.pref.hasKey("draw.rawgps.colors." + this.layerName)) {
            this.colorTypeGlobal.setSelected(true);
            this.colorDynamic.setSelected(false);
            this.colorDynamic.setEnabled(false);
        } else {
            switch (Main.pref.getInteger("draw.rawgps.colors", this.layerName, 0)) {
                case 0: {
                    this.colorTypeNone.setSelected(true);
                    break;
                }
                case 1: {
                    this.colorTypeVelocity.setSelected(true);
                    break;
                }
                case 2: {
                    this.colorTypeDilution.setSelected(true);
                    break;
                }
                case 3: {
                    this.colorTypeDirection.setSelected(true);
                    break;
                }
                case 4: {
                    this.colorTypeTime.setSelected(true);
                }
            }
            int n = Main.pref.getInteger("draw.rawgps.colorTracksTune", this.layerName, 45);
            this.colorTypeVelocityTune.setSelectedIndex(n == 10 ? 2 : (n == 20 ? 1 : 0));
            this.colorTypeVelocityTune.setEnabled(this.colorTypeVelocity.isSelected() && this.colorTypeVelocity.isEnabled());
            this.colorDynamic.setSelected(Main.pref.getBoolean("draw.rawgps.colors.dynamic", this.layerName, false));
            this.colorDynamic.setEnabled(this.colorTypeVelocity.isSelected() || this.colorTypeDilution.isSelected());
        }
        if (this.layerName != null) {
            this.waypointLabel.setSelectedIndex(Main.pref.getInteger("draw.rawgps.layer.wpt." + this.layerName, 5));
        } else {
            this.waypointLabel.setSelectedIndex(Main.pref.getInteger("draw.rawgps.layer.wpt", 0));
        }
    }

    public boolean savePreferences(String string, boolean bl) {
        String string2 = ".layer " + string;
        if (string == null) {
            string2 = "";
        }
        Main.pref.put("marker.makeautomarkers" + string2, this.makeAutoMarkers.isSelected());
        if (this.drawRawGpsLinesGlobal.isSelected()) {
            Main.pref.put("draw.rawgps.lines" + string2, null);
            Main.pref.put("draw.rawgps.max-line-length" + string2, null);
            Main.pref.put("draw.rawgps.lines.local" + string2, null);
            Main.pref.put("draw.rawgps.max-line-length.local" + string2, null);
            Main.pref.put("draw.rawgps.lines.force" + string2, null);
            Main.pref.put("draw.rawgps.direction" + string2, null);
            Main.pref.put("draw.rawgps.alternatedirection" + string2, null);
            Main.pref.put("draw.rawgps.min-arrow-distance" + string2, null);
        } else {
            if (string == null || !bl) {
                Main.pref.put("draw.rawgps.lines" + string2, this.drawRawGpsLinesAll.isSelected());
                Main.pref.put("draw.rawgps.max-line-length" + string2, this.drawRawGpsMaxLineLength.getText());
            }
            if (string == null || bl) {
                Main.pref.put("draw.rawgps.lines.local" + string2, this.drawRawGpsLinesAll.isSelected() || this.drawRawGpsLinesLocal.isSelected());
                Main.pref.put("draw.rawgps.max-line-length.local" + string2, this.drawRawGpsMaxLineLengthLocal.getText());
            }
            Main.pref.put("draw.rawgps.lines.force" + string2, this.forceRawGpsLines.isSelected());
            Main.pref.put("draw.rawgps.direction" + string2, this.drawGpsArrows.isSelected());
            Main.pref.put("draw.rawgps.alternatedirection" + string2, this.drawGpsArrowsFast.isSelected());
            Main.pref.put("draw.rawgps.min-arrow-distance" + string2, this.drawGpsArrowsMinDist.getText());
        }
        Main.pref.put("draw.rawgps.hdopcircle" + string2, this.hdopCircleGpsPoints.isSelected());
        Main.pref.put("draw.rawgps.large" + string2, this.largeGpsPoints.isSelected());
        if (this.waypointLabel.getSelectedIndex() == 5) {
            Main.pref.put("draw.rawgps.layer.wpt" + string2, null);
        } else {
            Main.pref.putInteger("draw.rawgps.layer.wpt" + string2, this.waypointLabel.getSelectedIndex());
        }
        if (this.colorTypeGlobal.isSelected()) {
            Main.pref.put("draw.rawgps.colors" + string2, null);
            Main.pref.put("draw.rawgps.colors.dynamic" + string2, null);
            Main.pref.put("draw.rawgps.colorTracksTunec" + string2, null);
            return false;
        }
        if (this.colorTypeVelocity.isSelected()) {
            Main.pref.putInteger("draw.rawgps.colors" + string2, 1);
        } else if (this.colorTypeDilution.isSelected()) {
            Main.pref.putInteger("draw.rawgps.colors" + string2, 2);
        } else if (this.colorTypeDirection.isSelected()) {
            Main.pref.putInteger("draw.rawgps.colors" + string2, 3);
        } else if (this.colorTypeTime.isSelected()) {
            Main.pref.putInteger("draw.rawgps.colors" + string2, 4);
        } else {
            Main.pref.putInteger("draw.rawgps.colors" + string2, 0);
        }
        Main.pref.put("draw.rawgps.colors.dynamic" + string2, this.colorDynamic.isSelected());
        int n = this.colorTypeVelocityTune.getSelectedIndex();
        Main.pref.putInteger("draw.rawgps.colorTracksTune" + string2, n == 2 ? 10 : (n == 1 ? 20 : 45));
        return false;
    }

    public void savePreferences() {
        this.savePreferences(null, false);
    }
}

