/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.plugin;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openstreetmap.josm.gui.preferences.plugin.PluginPreferencesModel;
import org.openstreetmap.josm.gui.widgets.HtmlPanel;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.OpenBrowser;

public class PluginListPanel
extends VerticallyScrollablePanel {
    private PluginPreferencesModel model;

    public PluginListPanel() {
        this.model = new PluginPreferencesModel();
        this.setLayout(new GridBagLayout());
    }

    public PluginListPanel(PluginPreferencesModel pluginPreferencesModel) {
        this.model = pluginPreferencesModel;
        this.setLayout(new GridBagLayout());
    }

    protected String formatPluginRemoteVersion(PluginInformation pluginInformation) {
        StringBuilder stringBuilder = new StringBuilder();
        if (pluginInformation.version == null || pluginInformation.version.trim().equals("")) {
            stringBuilder.append(I18n.tr("unknown"));
        } else {
            stringBuilder.append(pluginInformation.version);
            if (pluginInformation.oldmode) {
                stringBuilder.append("*");
            }
        }
        return stringBuilder.toString();
    }

    protected String formatPluginLocalVersion(PluginInformation pluginInformation) {
        if (pluginInformation == null) {
            return I18n.tr("unknown");
        }
        if (pluginInformation.localversion == null || pluginInformation.localversion.trim().equals("")) {
            return I18n.tr("unknown");
        }
        return pluginInformation.localversion;
    }

    protected String formatCheckboxTooltipText(PluginInformation pluginInformation) {
        if (pluginInformation == null) {
            return "";
        }
        if (pluginInformation.downloadlink == null) {
            return I18n.tr("Plugin bundled with JOSM");
        }
        return pluginInformation.downloadlink;
    }

    public void displayEmptyPluginListInformation() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(40, 0, 40, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        HtmlPanel htmlPanel = new HtmlPanel();
        htmlPanel.setText("<html>" + I18n.tr("Please click on <strong>Download list</strong> to download and display a list of available plugins.") + "</html>");
        this.add((Component)htmlPanel, gridBagConstraints);
    }

    public void refreshView() {
        List<PluginInformation> list = this.model.getDisplayedPlugins();
        this.removeAll();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        if (list.isEmpty()) {
            this.displayEmptyPluginListInformation();
            return;
        }
        int n = -1;
        for (final PluginInformation pluginInformation : list) {
            boolean bl = this.model.isSelectedPlugin(pluginInformation.getName());
            String string = this.formatPluginRemoteVersion(pluginInformation);
            String string2 = this.formatPluginLocalVersion(this.model.getPluginInformation(pluginInformation.getName()));
            final JCheckBox jCheckBox = new JCheckBox();
            jCheckBox.setSelected(bl);
            jCheckBox.setToolTipText(this.formatCheckboxTooltipText(pluginInformation));
            jCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PluginListPanel.this.model.setPluginSelected(pluginInformation.getName(), jCheckBox.isSelected());
                }
            });
            JLabel jLabel = new JLabel(I18n.tr("{0}: Version {1} (local: {2})", pluginInformation.getName(), string, string2), pluginInformation.getScaledIcon(), 2);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = ++n;
            gridBagConstraints.insets = new Insets(5, 5, 0, 5);
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            this.add((Component)jCheckBox, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)jLabel, gridBagConstraints);
            HtmlPanel htmlPanel = new HtmlPanel();
            htmlPanel.setText(pluginInformation.getDescriptionAsHtml());
            htmlPanel.getEditorPane().addHyperlinkListener(new HyperlinkListener(){

                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        OpenBrowser.displayUrl(hyperlinkEvent.getURL().toString());
                    }
                }
            });
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = ++n;
            gridBagConstraints.insets = new Insets(3, 25, 5, 5);
            gridBagConstraints.weighty = 1.0;
            this.add((Component)htmlPanel, gridBagConstraints);
        }
        this.revalidate();
        this.repaint();
    }
}

