/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.Capabilities;
import org.openstreetmap.josm.io.ChangesetClosedException;
import org.openstreetmap.josm.io.DiffResultProcessor;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmApiInitializationException;
import org.openstreetmap.josm.io.OsmApiPrimitiveGoneException;
import org.openstreetmap.josm.io.OsmChangeBuilder;
import org.openstreetmap.josm.io.OsmConnection;
import org.openstreetmap.josm.io.OsmDataParsingException;
import org.openstreetmap.josm.io.OsmTransferCancelledException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.OsmWriter;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmApi
extends OsmConnection {
    public static final int DEFAULT_MAX_NUM_RETRIES = 5;
    private static HashMap<String, OsmApi> instances = new HashMap();
    private String serverUrl;
    private Changeset changeset;
    private String version = null;
    private Capabilities capabilities = new Capabilities();
    private boolean initialized = false;
    private StringWriter swriter = new StringWriter();
    private OsmWriter osmWriter = new OsmWriter(new PrintWriter(this.swriter), true, null);

    public static OsmApi getOsmApi(String string) {
        OsmApi osmApi = instances.get(string);
        if (osmApi == null) {
            osmApi = new OsmApi(string);
            instances.put(string, osmApi);
        }
        return osmApi;
    }

    public static OsmApi getOsmApi() {
        String string = Main.pref.get("osm-server.url", "http://api.openstreetmap.org/api");
        if (string == null) {
            throw new IllegalStateException(I18n.tr("Preference ''{0}'' missing. Cannot initialize OsmApi.", "osm-server.url"));
        }
        return OsmApi.getOsmApi(string);
    }

    protected OsmApi(String string) {
        CheckParameterUtil.ensureParameterNotNull(string, "serverUrl");
        this.serverUrl = string;
    }

    public String getVersion() {
        return this.version;
    }

    public void initialize(ProgressMonitor progressMonitor) throws OsmApiInitializationException, OsmTransferCancelledException {
        this.initialize(progressMonitor, false);
    }

    public void initialize(ProgressMonitor progressMonitor, boolean bl) throws OsmApiInitializationException, OsmTransferCancelledException {
        if (this.initialized) {
            return;
        }
        this.cancel = false;
        try {
            String string = this.sendRequest("GET", "capabilities", null, progressMonitor, false, bl);
            InputSource inputSource = new InputSource(new StringReader(string));
            SAXParserFactory.newInstance().newSAXParser().parse(inputSource, (DefaultHandler)new CapabilitiesParser());
            if (this.capabilities.supportsVersion("0.6")) {
                this.version = "0.6";
            } else {
                System.err.println(I18n.tr("This version of JOSM is incompatible with the configured server."));
                System.err.println(I18n.tr("It supports protocol version 0.6, while the server says it supports {0} to {1}.", this.capabilities.get("version", "minimum"), this.capabilities.get("version", "maximum")));
                this.initialized = false;
            }
            System.out.println(I18n.tr("Communications with {0} established using protocol version {1}.", this.serverUrl, this.version));
            this.osmWriter.setVersion(this.version);
            this.initialized = true;
            if (this.serverUrl.matches(".*openstreetmap.org/api.*") && this.capabilities.getImageryBlacklist().isEmpty()) {
                this.capabilities.put("blacklist", "regex", ".*\\.google\\.com/.*");
                this.capabilities.put("blacklist", "regex", ".*209\\.85\\.2\\d\\d.*");
                this.capabilities.put("blacklist", "regex", ".*209\\.85\\.1[3-9]\\d.*");
                this.capabilities.put("blacklist", "regex", ".*209\\.85\\.12[89].*");
            }
            if (Main.main.isDisplayingMapView()) {
                for (ImageryLayer imageryLayer : Main.map.mapView.getLayersOfType(ImageryLayer.class)) {
                    if (!imageryLayer.getInfo().isBlacklisted()) continue;
                    System.out.println(I18n.tr("Removed layer {0} because it is not allowed by the configured API.", imageryLayer.getName()));
                    Main.main.removeLayer(imageryLayer);
                }
            }
        }
        catch (IOException iOException) {
            this.initialized = false;
            throw new OsmApiInitializationException(iOException);
        }
        catch (SAXException sAXException) {
            this.initialized = false;
            throw new OsmApiInitializationException(sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.initialized = false;
            throw new OsmApiInitializationException(parserConfigurationException);
        }
        catch (OsmTransferCancelledException osmTransferCancelledException) {
            throw osmTransferCancelledException;
        }
        catch (OsmTransferException osmTransferException) {
            this.initialized = false;
            throw new OsmApiInitializationException(osmTransferException);
        }
    }

    private String toXml(IPrimitive iPrimitive, boolean bl) {
        this.swriter.getBuffer().setLength(0);
        this.osmWriter.setWithBody(bl);
        this.osmWriter.setChangeset(this.changeset);
        this.osmWriter.header();
        iPrimitive.visit(this.osmWriter);
        this.osmWriter.footer();
        this.osmWriter.out.flush();
        return this.swriter.toString();
    }

    private String toXml(Changeset changeset) {
        this.swriter.getBuffer().setLength(0);
        this.osmWriter.header();
        this.osmWriter.visit(changeset);
        this.osmWriter.footer();
        this.osmWriter.out.flush();
        return this.swriter.toString();
    }

    public String getBaseUrl() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(this.serverUrl);
        if (this.version != null) {
            stringBuffer.append("/");
            stringBuffer.append(this.version);
        }
        stringBuffer.append("/");
        while ((n = stringBuffer.indexOf("//", 6)) > -1) {
            stringBuffer.delete(n, n + 1);
        }
        return stringBuffer.toString();
    }

    public void createPrimitive(IPrimitive iPrimitive, ProgressMonitor progressMonitor) throws OsmTransferException {
        String string = "";
        try {
            this.ensureValidChangeset();
            this.initialize(progressMonitor);
            string = this.sendRequest("PUT", OsmPrimitiveType.from(iPrimitive).getAPIName() + "/create", this.toXml(iPrimitive, true), progressMonitor);
            iPrimitive.setOsmId(Long.parseLong(string.trim()), 1);
            iPrimitive.setChangesetId(this.getChangeset().getId());
        }
        catch (NumberFormatException numberFormatException) {
            throw new OsmTransferException(I18n.tr("Unexpected format of ID replied by the server. Got ''{0}''.", string));
        }
    }

    public void modifyPrimitive(IPrimitive iPrimitive, ProgressMonitor progressMonitor) throws OsmTransferException {
        String string = null;
        try {
            this.ensureValidChangeset();
            this.initialize(progressMonitor);
            string = this.sendRequest("PUT", OsmPrimitiveType.from(iPrimitive).getAPIName() + "/" + iPrimitive.getId(), this.toXml(iPrimitive, true), progressMonitor);
            iPrimitive.setOsmId(iPrimitive.getId(), Integer.parseInt(string.trim()));
            iPrimitive.setChangesetId(this.getChangeset().getId());
            iPrimitive.setVisible(true);
        }
        catch (NumberFormatException numberFormatException) {
            throw new OsmTransferException(I18n.tr("Unexpected format of new version of modified primitive ''{0}''. Got ''{1}''.", iPrimitive.getId(), string));
        }
    }

    public void deletePrimitive(IPrimitive iPrimitive, ProgressMonitor progressMonitor) throws OsmTransferException {
        this.ensureValidChangeset();
        this.initialize(progressMonitor);
        this.uploadDiff(Collections.singleton(iPrimitive), progressMonitor.createSubTaskMonitor(-1, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openChangeset(Changeset changeset, ProgressMonitor progressMonitor) throws OsmTransferException {
        CheckParameterUtil.ensureParameterNotNull(changeset, "changeset");
        try {
            progressMonitor.beginTask(I18n.tr("Creating changeset..."));
            this.initialize(progressMonitor);
            String string = "";
            try {
                string = this.sendRequest("PUT", "changeset/create", this.toXml(changeset), progressMonitor);
                changeset.setId(Integer.parseInt(string.trim()));
                changeset.setOpen(true);
            }
            catch (NumberFormatException numberFormatException) {
                throw new OsmTransferException(I18n.tr("Unexpected format of ID replied by the server. Got ''{0}''.", string));
            }
            progressMonitor.setCustomText(I18n.tr("Successfully opened changeset {0}", changeset.getId()));
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public void updateChangeset(Changeset changeset, ProgressMonitor progressMonitor) throws OsmTransferException {
        CheckParameterUtil.ensureParameterNotNull(changeset, "changeset");
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        if (changeset.getId() <= 0) {
            throw new IllegalArgumentException(I18n.tr("Changeset ID > 0 expected. Got {0}.", changeset.getId()));
        }
        try {
            progressMonitor.beginTask(I18n.tr("Updating changeset..."));
            this.initialize(progressMonitor);
            progressMonitor.setCustomText(I18n.tr("Updating changeset {0}...", changeset.getId()));
            this.sendRequest("PUT", "changeset/" + changeset.getId(), this.toXml(changeset), progressMonitor);
        }
        catch (ChangesetClosedException changesetClosedException) {
            changesetClosedException.setSource(ChangesetClosedException.Source.UPDATE_CHANGESET);
            throw changesetClosedException;
        }
        catch (OsmApiException osmApiException) {
            if (osmApiException.getResponseCode() == 409 && ChangesetClosedException.errorHeaderMatchesPattern(osmApiException.getErrorHeader())) {
                throw new ChangesetClosedException(osmApiException.getErrorHeader(), ChangesetClosedException.Source.UPDATE_CHANGESET);
            }
            throw osmApiException;
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeChangeset(Changeset changeset, ProgressMonitor progressMonitor) throws OsmTransferException {
        CheckParameterUtil.ensureParameterNotNull(changeset, "changeset");
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        if (changeset.getId() <= 0) {
            throw new IllegalArgumentException(I18n.tr("Changeset ID > 0 expected. Got {0}.", changeset.getId()));
        }
        try {
            progressMonitor.beginTask(I18n.tr("Closing changeset..."));
            this.initialize(progressMonitor);
            this.sendRequest("PUT", "changeset/" + changeset.getId() + "/close", "\r\n", progressMonitor);
            changeset.setOpen(false);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public Collection<IPrimitive> uploadDiff(Collection<? extends IPrimitive> collection, ProgressMonitor progressMonitor) throws OsmTransferException {
        try {
            progressMonitor.beginTask("", collection.size() * 2);
            if (this.changeset == null) {
                throw new OsmTransferException(I18n.tr("No changeset present for diff upload."));
            }
            this.initialize(progressMonitor);
            OsmChangeBuilder osmChangeBuilder = new OsmChangeBuilder(this.changeset);
            progressMonitor.subTask(I18n.tr("Preparing upload request..."));
            osmChangeBuilder.start();
            osmChangeBuilder.append(collection);
            osmChangeBuilder.finish();
            String string = osmChangeBuilder.getDocument();
            progressMonitor.indeterminateSubTask(I18n.trn("Uploading {0} object...", "Uploading {0} objects...", collection.size(), collection.size()));
            String string2 = this.sendRequest("POST", "changeset/" + this.changeset.getId() + "/upload", string, progressMonitor);
            DiffResultProcessor diffResultProcessor = new DiffResultProcessor(collection);
            diffResultProcessor.parse(string2, progressMonitor.createSubTaskMonitor(-1, false));
            Set<IPrimitive> set = diffResultProcessor.postProcess(this.getChangeset(), progressMonitor.createSubTaskMonitor(-1, false));
            return set;
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
        catch (OsmDataParsingException osmDataParsingException) {
            throw new OsmTransferException(osmDataParsingException);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    private void sleepAndListen(int n, ProgressMonitor progressMonitor) throws OsmTransferCancelledException {
        System.out.print(I18n.tr("Waiting 10 seconds ... "));
        for (int i = 0; i < 10; ++i) {
            if (progressMonitor != null) {
                progressMonitor.setCustomText(I18n.tr("Starting retry {0} of {1} in {2} seconds ...", this.getMaxRetries() - n, this.getMaxRetries(), 10 - i));
            }
            if (this.cancel) {
                throw new OsmTransferCancelledException();
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        System.out.println(I18n.tr("OK - trying again."));
    }

    protected int getMaxRetries() {
        int n = Main.pref.getInteger("osm-server.max-num-retries", 5);
        return Math.max(n, 0);
    }

    protected boolean isUsingOAuth() {
        String string = Main.pref.get("osm-server.auth-method", "basic");
        return string.equals("oauth");
    }

    private String sendRequest(String string, String string2, String string3, ProgressMonitor progressMonitor) throws OsmTransferException {
        return this.sendRequest(string, string2, string3, progressMonitor, true, false);
    }

    private String sendRequest(String string, String string2, String string3, ProgressMonitor progressMonitor, boolean bl) throws OsmTransferException {
        return this.sendRequest(string, string2, string3, progressMonitor, bl, false);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private String sendRequest(String string, String string2, String string3, ProgressMonitor progressMonitor, boolean bl, boolean bl2) throws OsmTransferException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getMaxRetries();
        while (true) {
            try {
                String string4;
                Object object;
                void var11_22;
                int n2;
                while (true) {
                    URL uRL = new URL(new URL(this.getBaseUrl()), string2);
                    System.out.print(string + " " + uRL + "... ");
                    this.activeConnection = (HttpURLConnection)uRL.openConnection();
                    this.activeConnection.setConnectTimeout(bl2 ? 1000 : Main.pref.getInteger("socket.timeout.connect", 15) * 1000);
                    this.activeConnection.setRequestMethod(string);
                    if (bl) {
                        this.addAuth(this.activeConnection);
                    }
                    if (string.equals("PUT") || string.equals("POST") || string.equals("DELETE")) {
                        this.activeConnection.setDoOutput(true);
                        this.activeConnection.setRequestProperty("Content-type", "text/xml");
                        OutputStream outputStream = this.activeConnection.getOutputStream();
                        if (string3 != null) {
                            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
                            bufferedWriter.write(string3);
                            bufferedWriter.flush();
                        }
                        outputStream.close();
                    }
                    this.activeConnection.connect();
                    System.out.println(this.activeConnection.getResponseMessage());
                    n2 = this.activeConnection.getResponseCode();
                    if (n2 < 500 || n-- <= 0) break;
                    this.sleepAndListen(n, progressMonitor);
                    System.out.println(I18n.tr("Starting retry {0} of {1}.", this.getMaxRetries() - n, this.getMaxRetries()));
                }
                stringBuffer.setLength(0);
                Object var11_19 = null;
                try {
                    InputStream inputStream = this.activeConnection.getInputStream();
                }
                catch (IOException iOException) {
                    InputStream inputStream = this.activeConnection.getErrorStream();
                }
                if (var11_22 != null) {
                    object = new BufferedReader(new InputStreamReader((InputStream)var11_22));
                    while ((string4 = ((BufferedReader)object).readLine()) != null) {
                        stringBuffer.append(string4);
                        stringBuffer.append("\n");
                    }
                }
                object = null;
                if (this.activeConnection.getHeaderField("Error") != null) {
                    object = this.activeConnection.getHeaderField("Error");
                    System.err.println("Error header: " + (String)object);
                } else if (n2 != 200 && stringBuffer.length() > 0) {
                    System.err.println("Error body: " + stringBuffer);
                }
                this.activeConnection.disconnect();
                object = object == null ? null : ((String)object).trim();
                string4 = stringBuffer.length() == 0 ? null : stringBuffer.toString().trim();
                switch (n2) {
                    case 200: {
                        return stringBuffer.toString();
                    }
                    case 410: {
                        throw new OsmApiPrimitiveGoneException((String)object, string4);
                    }
                    case 409: {
                        if (!ChangesetClosedException.errorHeaderMatchesPattern((String)object)) throw new OsmApiException(n2, (String)object, string4);
                        throw new ChangesetClosedException(string4, ChangesetClosedException.Source.UPLOAD_DATA);
                    }
                    case 403: {
                        OsmApiException osmApiException = new OsmApiException(n2, (String)object, string4);
                        osmApiException.setAccessedUrl(this.activeConnection.getURL().toString());
                        throw osmApiException;
                    }
                }
                throw new OsmApiException(n2, (String)object, string4);
            }
            catch (UnknownHostException unknownHostException) {
                throw new OsmTransferException(unknownHostException);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                if (n-- <= 0) throw new OsmTransferException(socketTimeoutException);
                continue;
            }
            catch (ConnectException connectException) {
                if (n-- <= 0) throw new OsmTransferException(connectException);
                continue;
            }
            catch (IOException iOException) {
                throw new OsmTransferException(iOException);
            }
            catch (OsmTransferCancelledException osmTransferCancelledException) {
                throw osmTransferCancelledException;
            }
            break;
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
    }

    public Capabilities getCapabilities() {
        return this.capabilities;
    }

    protected void ensureValidChangeset() throws OsmTransferException {
        if (this.changeset == null) {
            throw new OsmTransferException(I18n.tr("Current changeset is null. Cannot upload data."));
        }
        if (this.changeset.getId() <= 0) {
            throw new OsmTransferException(I18n.tr("ID of current changeset > 0 required. Current ID is {0}.", this.changeset.getId()));
        }
    }

    public Changeset getChangeset() {
        return this.changeset;
    }

    public void setChangeset(Changeset changeset) {
        if (changeset == null) {
            this.changeset = null;
            return;
        }
        if (changeset.getId() <= 0) {
            throw new IllegalArgumentException(I18n.tr("Changeset ID > 0 expected. Got {0}.", changeset.getId()));
        }
        if (!changeset.isOpen()) {
            throw new IllegalArgumentException(I18n.tr("Open changeset expected. Got closed changeset with id {0}.", changeset.getId()));
        }
        this.changeset = changeset;
    }

    private class CapabilitiesParser
    extends DefaultHandler {
        private CapabilitiesParser() {
        }

        public void startDocument() throws SAXException {
            OsmApi.this.capabilities.clear();
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            for (int i = 0; i < attributes.getLength(); ++i) {
                OsmApi.this.capabilities.put(string3, attributes.getQName(i), attributes.getValue(i));
            }
        }
    }
}

