/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.Font;
import com.kitfox.svg.FontFace;
import com.kitfox.svg.MissingGlyph;
import com.kitfox.svg.SVGElement;
import com.kitfox.svg.SVGElementException;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGLoaderHelper;
import com.kitfox.svg.ShapeElement;
import com.kitfox.svg.Tspan;
import com.kitfox.svg.xml.StyleAttribute;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Text
extends ShapeElement {
    float x = 0.0f;
    float y = 0.0f;
    AffineTransform transform = null;
    String fontFamily;
    float fontSize;
    LinkedList content = new LinkedList();
    Shape textShape;
    public static final int TXAN_START = 0;
    public static final int TXAN_MIDDLE = 1;
    public static final int TXAN_END = 2;
    int textAnchor = 0;
    public static final int TXST_NORMAL = 0;
    public static final int TXST_ITALIC = 1;
    public static final int TXST_OBLIQUE = 2;
    int fontStyle;
    public static final int TXWE_NORMAL = 0;
    public static final int TXWE_BOLD = 1;
    public static final int TXWE_BOLDER = 2;
    public static final int TXWE_LIGHTER = 3;
    public static final int TXWE_100 = 4;
    public static final int TXWE_200 = 5;
    public static final int TXWE_300 = 6;
    public static final int TXWE_400 = 7;
    public static final int TXWE_500 = 8;
    public static final int TXWE_600 = 9;
    public static final int TXWE_700 = 10;
    public static final int TXWE_800 = 11;
    public static final int TXWE_900 = 12;
    int fontWeight;

    public void appendText(String string) {
        this.content.addLast(string);
    }

    public void appendTspan(Tspan tspan) throws SVGElementException {
        super.loaderAddChild(null, tspan);
        this.content.addLast(tspan);
    }

    public void rebuild() throws SVGException {
        this.build();
    }

    public List getContent() {
        return this.content;
    }

    public void loaderAddChild(SVGLoaderHelper sVGLoaderHelper, SVGElement sVGElement) throws SVGElementException {
        super.loaderAddChild(sVGLoaderHelper, sVGElement);
        this.content.addLast(sVGElement);
    }

    public void loaderAddText(SVGLoaderHelper sVGLoaderHelper, String string) {
        Matcher matcher = Pattern.compile("\\s*").matcher(string);
        if (!matcher.matches()) {
            this.content.addLast(string);
        }
    }

    public void build() throws SVGException {
        String string;
        super.build();
        StyleAttribute styleAttribute = new StyleAttribute();
        if (this.getPres(styleAttribute.setName("x"))) {
            this.x = styleAttribute.getFloatValueWithUnits();
        }
        if (this.getPres(styleAttribute.setName("y"))) {
            this.y = styleAttribute.getFloatValueWithUnits();
        }
        this.fontFamily = this.getStyle(styleAttribute.setName("font-family")) ? styleAttribute.getStringValue() : "Sans Serif";
        this.fontSize = this.getStyle(styleAttribute.setName("font-size")) ? styleAttribute.getFloatValueWithUnits() : 12.0f;
        if (this.getStyle(styleAttribute.setName("font-style"))) {
            string = styleAttribute.getStringValue();
            if ("normal".equals(string)) {
                this.fontStyle = 0;
            } else if ("italic".equals(string)) {
                this.fontStyle = 1;
            } else if ("oblique".equals(string)) {
                this.fontStyle = 2;
            }
        } else {
            this.fontStyle = 0;
        }
        if (this.getStyle(styleAttribute.setName("font-weight"))) {
            string = styleAttribute.getStringValue();
            if ("normal".equals(string)) {
                this.fontWeight = 0;
            } else if ("bold".equals(string)) {
                this.fontWeight = 1;
            }
        } else {
            this.fontWeight = 1;
        }
        this.textAnchor = this.getStyle(styleAttribute.setName("text-anchor")) ? ((string = styleAttribute.getStringValue()).equals("middle") ? 1 : (string.equals("end") ? 2 : 0)) : 0;
        this.buildFont();
    }

    protected void buildFont() throws SVGException {
        int n;
        int n2;
        switch (this.fontStyle) {
            case 1: {
                n2 = 2;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        switch (this.fontWeight) {
            case 1: 
            case 2: {
                n = 1;
                break;
            }
            default: {
                n = 0;
            }
        }
        Font font = this.diagram.getUniverse().getFont(this.fontFamily);
        if (font == null) {
            java.awt.Font font2 = new java.awt.Font(this.fontFamily, n2 | n, (int)this.fontSize);
            this.buildSysFont(font2);
            return;
        }
        GeneralPath generalPath = new GeneralPath();
        this.textShape = generalPath;
        float f = this.x;
        float f2 = this.y;
        FontFace fontFace = font.getFontFace();
        int n3 = fontFace.getAscent();
        float f3 = this.fontSize / (float)n3;
        AffineTransform affineTransform = new AffineTransform();
        for (Object e : this.content) {
            Object object;
            if (e instanceof String) {
                object = (String)e;
                this.strokeWidthScalar = 1.0f / f3;
                for (int i = 0; i < ((String)object).length(); ++i) {
                    affineTransform.setToIdentity();
                    affineTransform.setToTranslation(f, f2);
                    affineTransform.scale(f3, f3);
                    String string = ((String)object).substring(i, i + 1);
                    MissingGlyph missingGlyph = font.getGlyph(string);
                    Shape shape = missingGlyph.getPath();
                    if (shape != null) {
                        shape = affineTransform.createTransformedShape(shape);
                        generalPath.append(shape, false);
                    }
                    f += f3 * (float)missingGlyph.getHorizAdvX();
                }
                this.strokeWidthScalar = 1.0f;
                continue;
            }
            if (!(e instanceof Tspan)) continue;
            object = (Tspan)e;
            affineTransform.setToIdentity();
            affineTransform.setToTranslation(f, f2);
            affineTransform.scale(f3, f3);
            Shape shape = ((Tspan)object).getShape();
            shape = affineTransform.createTransformedShape(shape);
            generalPath.append(shape, false);
        }
        switch (this.textAnchor) {
            case 1: {
                Object object = new AffineTransform();
                ((AffineTransform)object).translate(-generalPath.getBounds2D().getWidth() / 2.0, 0.0);
                generalPath.transform((AffineTransform)object);
                break;
            }
            case 2: {
                Object object = new AffineTransform();
                ((AffineTransform)object).translate(-generalPath.getBounds2D().getWidth(), 0.0);
                generalPath.transform((AffineTransform)object);
                break;
            }
        }
    }

    private void buildSysFont(java.awt.Font font) throws SVGException {
        GeneralPath generalPath = new GeneralPath();
        this.textShape = generalPath;
        float f = this.x;
        float f2 = this.y;
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
        AffineTransform affineTransform = new AffineTransform();
        for (Object e : this.content) {
            Object object;
            if (e instanceof String) {
                object = (String)e;
                Shape shape = font.createGlyphVector(fontRenderContext, (String)object).getOutline(f, f2);
                generalPath.append(shape, false);
                Rectangle2D rectangle2D = font.getStringBounds((String)object, fontRenderContext);
                f += (float)rectangle2D.getWidth();
                continue;
            }
            if (!(e instanceof Tspan)) continue;
            object = (Tspan)e;
            ((Tspan)object).setCursorX(f);
            ((Tspan)object).setCursorY(f2);
            ((Tspan)object).addShape(generalPath);
            f = ((Tspan)object).getCursorX();
            f2 = ((Tspan)object).getCursorY();
        }
        switch (this.textAnchor) {
            case 1: {
                Object object = new AffineTransform();
                ((AffineTransform)object).translate(-generalPath.getBounds2D().getWidth() / 2.0, 0.0);
                generalPath.transform((AffineTransform)object);
                break;
            }
            case 2: {
                Object object = new AffineTransform();
                ((AffineTransform)object).translate(-generalPath.getBounds2D().getWidth(), 0.0);
                generalPath.transform((AffineTransform)object);
                break;
            }
        }
    }

    public void render(Graphics2D graphics2D) throws SVGException {
        this.beginLayer(graphics2D);
        this.renderShape(graphics2D, this.textShape);
        this.finishLayer(graphics2D);
    }

    public Shape getShape() {
        return this.shapeToParent(this.textShape);
    }

    public Rectangle2D getBoundingBox() throws SVGException {
        return this.boundsToParent(this.includeStrokeInBounds(this.textShape.getBounds2D()));
    }

    public boolean updateTime(double d) throws SVGException {
        int n;
        float f;
        String string;
        float f2;
        boolean bl = super.updateTime(d);
        StyleAttribute styleAttribute = new StyleAttribute();
        boolean bl2 = false;
        if (this.getPres(styleAttribute.setName("x")) && (f2 = styleAttribute.getFloatValueWithUnits()) != this.x) {
            this.x = f2;
            bl2 = true;
        }
        if (this.getPres(styleAttribute.setName("y")) && (f2 = styleAttribute.getFloatValueWithUnits()) != this.y) {
            this.y = f2;
            bl2 = true;
        }
        if (this.getPres(styleAttribute.setName("font-family")) && !(string = styleAttribute.getStringValue()).equals(this.fontFamily)) {
            this.fontFamily = string;
            bl2 = true;
        }
        if (this.getPres(styleAttribute.setName("font-size")) && (f = styleAttribute.getFloatValueWithUnits()) != this.fontSize) {
            this.fontSize = f;
            bl2 = true;
        }
        if (this.getStyle(styleAttribute.setName("font-style"))) {
            String string2 = styleAttribute.getStringValue();
            n = this.fontStyle;
            if ("normal".equals(string2)) {
                n = 0;
            } else if ("italic".equals(string2)) {
                n = 1;
            } else if ("oblique".equals(string2)) {
                n = 2;
            }
            if (n != this.fontStyle) {
                this.fontStyle = n;
                bl2 = true;
            }
        }
        if (this.getStyle(styleAttribute.setName("font-weight"))) {
            String string3 = styleAttribute.getStringValue();
            n = this.fontWeight;
            if ("normal".equals(string3)) {
                n = 0;
            } else if ("bold".equals(string3)) {
                n = 1;
            }
            if (n != this.fontWeight) {
                this.fontWeight = n;
                bl2 = true;
            }
        }
        if (bl2) {
            this.build();
        }
        return bl || bl2;
    }
}

