/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.dialogs.relation.RelationDialogManager;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class DeleteAction
extends MapMode
implements AWTEventListener {
    private MouseEvent oldEvent = null;
    private Set<OsmPrimitive> oldHighlights = new HashSet<OsmPrimitive>();
    private boolean drawTargetHighlight;

    public DeleteAction(MapFrame mapFrame) {
        super(I18n.tr("Delete Mode", new Object[0]), "delete", I18n.tr("Delete nodes or ways.", new Object[0]), Shortcut.registerShortcut("mapmode:delete", I18n.tr("Mode: {0}", I18n.tr("Delete", new Object[0])), 68, 3), mapFrame, ImageProvider.getCursor("normal", "delete"));
    }

    public void enterMode() {
        super.enterMode();
        if (!this.isEnabled()) {
            return;
        }
        this.drawTargetHighlight = Main.pref.getBoolean("draw.target-highlight", true);
        Main.map.mapView.addMouseListener(this);
        Main.map.mapView.addMouseMotionListener(this);
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
        catch (SecurityException securityException) {
            System.out.println(securityException);
        }
    }

    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener(this);
        Main.map.mapView.removeMouseMotionListener(this);
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        catch (SecurityException securityException) {
            System.out.println(securityException);
        }
        this.removeHighlighting();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        DeleteAction.doActionPerformed(actionEvent);
    }

    public static void doActionPerformed(ActionEvent actionEvent) {
        boolean bl;
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        boolean bl2 = (actionEvent.getModifiers() & 2) != 0;
        boolean bl3 = bl = (actionEvent.getModifiers() & 0x28) != 0;
        Command command = bl2 ? DeleteCommand.deleteWithReferences(DeleteAction.getEditLayer(), DeleteAction.getCurrentDataSet().getSelected()) : DeleteCommand.delete(DeleteAction.getEditLayer(), DeleteAction.getCurrentDataSet().getSelected(), !bl);
        if (command != null) {
            Main.main.undoRedo.add(command);
        }
        DeleteAction.getCurrentDataSet().setSelected(new PrimitiveId[0]);
        Main.map.repaint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.oldEvent = mouseEvent;
        this.giveUserFeedback(mouseEvent);
    }

    private void removeHighlighting() {
        for (OsmPrimitive osmPrimitive : this.oldHighlights) {
            osmPrimitive.setHighlighted(false);
        }
        this.oldHighlights = new HashSet<OsmPrimitive>();
        DataSet dataSet = DeleteAction.getCurrentDataSet();
        if (dataSet != null) {
            dataSet.clearHighlightedWaySegments();
        }
    }

    private void addHighlighting(MouseEvent mouseEvent, int n) {
        if (!this.drawTargetHighlight) {
            return;
        }
        this.removeHighlighting();
        DeleteParameters deleteParameters = this.getDeleteParameters(mouseEvent, n);
        if (deleteParameters.mode == DeleteMode.segment) {
            DataSet dataSet = DeleteAction.getCurrentDataSet();
            if (dataSet != null) {
                dataSet.setHighlightedWaySegments(Collections.singleton(deleteParameters.nearestSegment));
            }
        } else {
            Command command = this.buildDeleteCommands(mouseEvent, n, true);
            if (command == null) {
                Main.map.mapView.repaint();
                return;
            }
            for (OsmPrimitive osmPrimitive : command.getParticipatingPrimitives()) {
                osmPrimitive.setHighlighted(true);
                this.oldHighlights.add(osmPrimitive);
            }
        }
        Main.map.mapView.repaint();
    }

    private void updateCursor(MouseEvent mouseEvent, int n) {
        if (!Main.isDisplayingMapView()) {
            return;
        }
        if (!Main.map.mapView.isActiveLayerVisible() || mouseEvent == null) {
            return;
        }
        DeleteParameters deleteParameters = this.getDeleteParameters(mouseEvent, n);
        Main.map.mapView.setNewCursor(deleteParameters.mode.cursor(), (Object)this);
    }

    private void giveUserFeedback(MouseEvent mouseEvent, int n) {
        this.updateCursor(mouseEvent, n);
        this.addHighlighting(mouseEvent, n);
    }

    private void giveUserFeedback(MouseEvent mouseEvent) {
        this.giveUserFeedback(mouseEvent, mouseEvent.getModifiers());
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() != 1) {
            return;
        }
        if (!Main.map.mapView.isActiveLayerVisible()) {
            return;
        }
        Main.map.mapView.requestFocus();
        Command command = this.buildDeleteCommands(mouseEvent, mouseEvent.getModifiers(), false);
        if (command != null) {
            Main.main.undoRedo.add(command);
        }
        DeleteAction.getCurrentDataSet().setSelected(new PrimitiveId[0]);
        this.giveUserFeedback(mouseEvent);
        Main.map.mapView.repaint();
    }

    public String getModeHelpText() {
        return I18n.tr("Click to delete. Shift: delete way segment. Alt: do not delete unused nodes when deleting a way. Ctrl: delete referring objects.", new Object[0]);
    }

    public boolean layerIsSupported(Layer layer) {
        return layer instanceof OsmDataLayer;
    }

    protected void updateEnabledState() {
        this.setEnabled(Main.map != null && Main.map.mapView != null && Main.map.mapView.isActiveLayerDrawable());
    }

    public static void deleteRelation(OsmDataLayer osmDataLayer, Relation relation) {
        CheckParameterUtil.ensureParameterNotNull(osmDataLayer, "layer");
        CheckParameterUtil.ensureParameterNotNull(relation, "toDelete");
        Command command = DeleteCommand.delete(osmDataLayer, Collections.singleton(relation));
        if (command != null) {
            Main.main.undoRedo.add(command);
            RelationDialogManager.getRelationDialogManager().close(osmDataLayer, relation);
        }
    }

    private DeleteParameters getDeleteParameters(MouseEvent mouseEvent, int n) {
        this.updateKeyModifiers(n);
        DeleteParameters deleteParameters = new DeleteParameters();
        deleteParameters.nearestNode = Main.map.mapView.getNearestNode(mouseEvent.getPoint(), OsmPrimitive.isSelectablePredicate);
        if (deleteParameters.nearestNode == null) {
            deleteParameters.nearestSegment = Main.map.mapView.getNearestWaySegment(mouseEvent.getPoint(), OsmPrimitive.isSelectablePredicate);
            deleteParameters.mode = deleteParameters.nearestSegment != null ? (this.shift ? DeleteMode.segment : (this.ctrl ? DeleteMode.way_with_references : (this.alt ? DeleteMode.way : DeleteMode.way_with_nodes))) : DeleteMode.none;
        } else {
            deleteParameters.mode = this.ctrl ? DeleteMode.node_with_references : DeleteMode.node;
        }
        return deleteParameters;
    }

    private Command buildDeleteCommands(MouseEvent mouseEvent, int n, boolean bl) {
        DeleteParameters deleteParameters = this.getDeleteParameters(mouseEvent, n);
        switch (deleteParameters.mode) {
            case node: {
                return DeleteCommand.delete(DeleteAction.getEditLayer(), Collections.singleton(deleteParameters.nearestNode), false, bl);
            }
            case node_with_references: {
                return DeleteCommand.deleteWithReferences(DeleteAction.getEditLayer(), Collections.singleton(deleteParameters.nearestNode), bl);
            }
            case segment: {
                return DeleteCommand.deleteWaySegment(DeleteAction.getEditLayer(), deleteParameters.nearestSegment);
            }
            case way: {
                return DeleteCommand.delete(DeleteAction.getEditLayer(), Collections.singleton(deleteParameters.nearestSegment.way), false, bl);
            }
            case way_with_nodes: {
                return DeleteCommand.delete(DeleteAction.getEditLayer(), Collections.singleton(deleteParameters.nearestSegment.way), true, bl);
            }
            case way_with_references: {
                return DeleteCommand.deleteWithReferences(DeleteAction.getEditLayer(), Collections.singleton(deleteParameters.nearestSegment.way), true);
            }
        }
        return null;
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        if (this.oldEvent == null) {
            return;
        }
        this.giveUserFeedback(this.oldEvent, ((InputEvent)aWTEvent).getModifiers());
    }

    private static class DeleteParameters {
        DeleteMode mode;
        Node nearestNode;
        WaySegment nearestSegment;

        private DeleteParameters() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DeleteMode {
        none("delete"),
        segment("delete_segment"),
        node("delete_node"),
        node_with_references("delete_node"),
        way("delete_way_only"),
        way_with_references("delete_way_normal"),
        way_with_nodes("delete_way_node_only");

        private final Cursor c;

        private DeleteMode(String string2) {
            this.c = ImageProvider.getCursor("normal", string2);
        }

        public Cursor cursor() {
            return this.c;
        }
    }
}

