/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.upload;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.upload.CyclicUploadDependencyException;
import org.openstreetmap.josm.actions.upload.UploadHook;
import org.openstreetmap.josm.data.APIDataSet;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.WindowGeometry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationUploadOrderHook
implements UploadHook {
    private APIDataSet data;

    protected JPanel buildWarningPanel(List<Relation> list) {
        Object object;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        String string = I18n.tr("<html>{0} relations build a cycle because they refer to each other.<br>JOSM cannot upload them. Please edit the relations and remove the cyclic dependency.</html>", list.size() - 1);
        jPanel.add((Component)new JLabel(string), "North");
        DefaultTableModel defaultTableModel = new DefaultTableModel();
        defaultTableModel.addColumn(I18n.tr("Relation ...", new Object[0]));
        defaultTableModel.addColumn(I18n.tr("... refers to relation", new Object[0]));
        for (int i = 0; i < list.size() - 1; ++i) {
            object = list.get(i);
            Relation relation = list.get(i + 1);
            defaultTableModel.addRow(new Relation[]{object, relation});
        }
        JTable jTable = new JTable(defaultTableModel);
        object = new OsmPrimitivRenderer();
        jTable.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)object);
        jTable.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)object);
        jPanel.add((Component)new JScrollPane(jTable), "Center");
        return jPanel;
    }

    protected void warnCyclicUploadDependency(CyclicUploadDependencyException cyclicUploadDependencyException) {
        List<Relation> list = cyclicUploadDependencyException.getCyclicUploadDependency();
        Relation relation = list.get(list.size() - 1);
        Iterator<Relation> iterator = list.iterator();
        while (iterator.hasNext() && iterator.next() != relation) {
            iterator.remove();
        }
        JPanel jPanel = this.buildWarningPanel(list);
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Cycling dependencies", new Object[0]), new String[]{I18n.tr("OK", new Object[0])});
        extendedDialog.setContent(jPanel, false);
        extendedDialog.setButtonIcons(new String[]{"ok"});
        extendedDialog.setRememberWindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(Main.parent, new Dimension(300, 300)));
        extendedDialog.showDialog();
    }

    @Override
    public boolean checkUpload(APIDataSet aPIDataSet) {
        this.data = aPIDataSet;
        try {
            this.data.adjustRelationUploadOrder();
            return true;
        }
        catch (CyclicUploadDependencyException cyclicUploadDependencyException) {
            this.warnCyclicUploadDependency(cyclicUploadDependencyException);
            return false;
        }
    }
}

