/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.io.OsmConnection;
import org.openstreetmap.josm.tools.Base64;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class ServerSidePreferences
extends Preferences {
    private final Connection connection;

    public ServerSidePreferences(URL uRL) {
        Connection connection = null;
        try {
            connection = new Connection(new URL(uRL + "user/preferences"));
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not load preferences from server.", new Object[0]), I18n.tr("Error", new Object[0]), 0);
        }
        this.connection = connection;
    }

    public String getPreferencesDir() {
        return this.connection.serverUrl.toString();
    }

    public void load() {
    }

    public void save() {
    }

    public void download(String string, String string2) {
        if (!this.properties.containsKey("applet.username") && string != null) {
            this.properties.put("applet.username", string);
        }
        if (!this.properties.containsKey("applet.password") && string2 != null) {
            this.properties.put("applet.password", string2);
        }
        try {
            this.download();
        }
        catch (MissingPassword missingPassword) {
            // empty catch block
        }
    }

    public boolean download() throws MissingPassword {
        this.resetToDefault();
        String string = this.connection.download();
        if (string == null) {
            return false;
        }
        StringReader stringReader = new StringReader(string);
        boolean bl = false;
        try {
            this.fromXML(stringReader);
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        return bl;
    }

    public void upload() {
        this.connection.upload(this.toXML(true));
    }

    private class Connection
    extends OsmConnection {
        URL serverUrl;

        public Connection(URL uRL) {
            this.serverUrl = uRL;
        }

        public String download() throws MissingPassword {
            try {
                System.out.println("reading preferences from " + this.serverUrl);
                URLConnection uRLConnection = this.serverUrl.openConnection();
                String string = ServerSidePreferences.this.get("applet.username");
                String string2 = ServerSidePreferences.this.get("applet.password");
                if (string2.isEmpty() && string.isEmpty()) {
                    uRLConnection.addRequestProperty("Authorization", "Basic " + Base64.encode(string + ":" + string2));
                }
                uRLConnection.connect();
                if (string.isEmpty() && uRLConnection instanceof HttpURLConnection && ((HttpURLConnection)uRLConnection).getResponseCode() == 401) {
                    String string3 = ((HttpURLConnection)uRLConnection).getHeaderField("WWW-Authenticate");
                    string3 = string3.replace("Basic realm=\"", "").replace("\"", "");
                    throw new MissingPassword(string3);
                }
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
                StringBuilder stringBuilder = new StringBuilder();
                String string4 = bufferedReader.readLine();
                while (string4 != null) {
                    stringBuilder.append(string4);
                    stringBuilder.append("\n");
                    string4 = bufferedReader.readLine();
                }
                if (uRLConnection instanceof HttpURLConnection) {
                    ((HttpURLConnection)uRLConnection).disconnect();
                }
                return stringBuilder.toString();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
        }

        public void upload(String string) {
            try {
                URL uRL = new URL(ServerSidePreferences.this.getPreferencesDir());
                System.out.println("uploading preferences to " + uRL);
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                String string2 = ServerSidePreferences.this.get("applet.username");
                String string3 = ServerSidePreferences.this.get("applet.password");
                if (string3.isEmpty() && string2.isEmpty()) {
                    httpURLConnection.addRequestProperty("Authorization", "Basic " + Base64.encode(string2 + ":" + string3));
                }
                httpURLConnection.setRequestMethod("POST");
                httpURLConnection.setDoOutput(true);
                httpURLConnection.connect();
                PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(httpURLConnection.getOutputStream()));
                printWriter.println(string);
                printWriter.close();
                httpURLConnection.getInputStream().close();
                httpURLConnection.disconnect();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Preferences stored on {0}", uRL.getHost()), I18n.tr("Information", new Object[0]), 1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not upload preferences. Reason: {0}", exception.getMessage()), I18n.tr("Error", new Object[0]), 0);
            }
        }
    }

    public class MissingPassword
    extends Exception {
        public String realm;

        public MissingPassword(String string) {
            this.realm = string;
        }
    }
}

