/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.AbstractProjection;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.NTV2GridShiftFile;
import org.openstreetmap.josm.data.projection.ProjectionSubPrefs;
import org.openstreetmap.josm.data.projection.proj.LambertConformalConic;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lambert
extends AbstractProjection
implements ProjectionSubPrefs {
    private static final double[] n = new double[]{0.7604059656, 0.7289686274, 0.6959127966, 0.6712679322};
    private static final double[] c = new double[]{1.160379698E7, 1.174579339E7, 1.194799252E7, 1.213628199E7};
    private static final double[] x_0s = new double[]{600000.0, 600000.0, 600000.0, 234.358};
    private static final double[] y_fs = new double[]{5657616.674, 6199695.768, 6791905.085, 7239161.542};
    public static final double cMaxLatZone1Radian = Math.toRadians(51.300000000000004);
    public static final double cMinLatZone1Radian = Math.toRadians(41.49);
    public static final double[][] zoneLimitsDegree = new double[][]{{Math.toDegrees(cMaxLatZone1Radian), 48.15}, {48.15, 45.45}, {45.45, 42.300000000000004}, {42.767667, Math.toDegrees(cMinLatZone1Radian)}};
    public static final double cMinLonZonesRadian = Math.toRadians(-4.416666666666665);
    public static final double cMaxLonZonesRadian = Math.toRadians(9.18);
    public static final double cMaxOverlappingZonesDegree = 1.5;
    public static final int DEFAULT_ZONE = 0;
    private int layoutZone;
    private static NTV2GridShiftFile ntf_rgf93Grid = null;
    public static String[] lambert4zones = new String[]{I18n.tr("{0} ({1} to {2} degrees)", 1, "51.30", "48.15"), I18n.tr("{0} ({1} to {2} degrees)", 2, "48.15", "45.45"), I18n.tr("{0} ({1} to {2} degrees)", 3, "45.45", "42.76"), I18n.tr("{0} (Corsica)", 4)};

    public static NTV2GridShiftFile getNtf_rgf93Grid() {
        return ntf_rgf93Grid;
    }

    public Lambert() {
        if (ntf_rgf93Grid == null) {
            try {
                String string = "ntf_r93_b.gsb";
                InputStream inputStream = Main.class.getResourceAsStream("/data/" + string);
                if (inputStream == null) {
                    throw new RuntimeException(I18n.tr("Error: failed to open input stream for resource ''/data/{0}''. Cannot load NTF<->RGF93 grid", string));
                }
                ntf_rgf93Grid = new NTV2GridShiftFile();
                ntf_rgf93Grid.loadGridShiftFile(inputStream, false);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        this.updateParameters(0);
    }

    private void updateParameters(int n) {
        this.layoutZone = n;
        this.ellps = Ellipsoid.clarke;
        this.datum = null;
        this.nadgrids = ntf_rgf93Grid;
        this.x_0 = x_0s[n];
        this.lon_0 = 2.337229166666667;
        if (this.proj == null) {
            this.proj = new LambertConformalConic();
        }
        ((LambertConformalConic)this.proj).updateParametersDirect(Ellipsoid.clarke, Lambert.n[n], c[n] / this.ellps.a, y_fs[n] / this.ellps.a);
    }

    @Override
    public String toString() {
        return I18n.tr("Lambert 4 Zones (France)", new Object[0]);
    }

    @Override
    public Integer getEpsgCode() {
        return 27561 + this.layoutZone;
    }

    public int hashCode() {
        return this.getClass().getName().hashCode() + this.layoutZone;
    }

    @Override
    public String getCacheDirectoryName() {
        return "lambert";
    }

    @Override
    public Bounds getWorldBoundsLatLon() {
        Bounds bounds = new Bounds(new LatLon(Math.max(zoneLimitsDegree[this.layoutZone][1] - 1.5, Math.toDegrees(cMinLatZone1Radian)), Math.toDegrees(cMinLonZonesRadian)), new LatLon(Math.min(zoneLimitsDegree[this.layoutZone][0] + 1.5, Math.toDegrees(cMaxLatZone1Radian)), Math.toDegrees(cMaxLonZonesRadian)));
        return bounds;
    }

    public int getLayoutZone() {
        return this.layoutZone;
    }

    @Override
    public void setupPreferencePanel(JPanel jPanel, ActionListener actionListener) {
        JComboBox<String> jComboBox = new JComboBox<String>(lambert4zones);
        jComboBox.setSelectedIndex(this.layoutZone);
        jPanel.setLayout(new GridBagLayout());
        jPanel.add((Component)new JLabel(I18n.tr("Lambert CC Zone", new Object[0])), GBC.std().insets(5, 5, 0, 5));
        jPanel.add(GBC.glue(1, 0), GBC.std().fill(2));
        jPanel.add(jComboBox, GBC.eop().fill(2));
        jPanel.add((Component)new JLabel(ImageProvider.get("data/projection", "Departements_Lambert4Zones.png")), GBC.eol().fill(2));
        jPanel.add(GBC.glue(1, 1), GBC.eol().fill(1));
        if (actionListener != null) {
            jComboBox.addActionListener(actionListener);
        }
    }

    @Override
    public Collection<String> getPreferences(JPanel jPanel) {
        Component component = jPanel.getComponent(2);
        if (!(component instanceof JComboBox)) {
            return null;
        }
        this.layoutZone = ((JComboBox)component).getSelectedIndex();
        return Collections.singleton(Integer.toString(this.layoutZone + 1));
    }

    @Override
    public void setPreferences(Collection<String> collection) {
        int n = 0;
        if (collection != null) {
            try {
                String string;
                Iterator<String> iterator = collection.iterator();
                if (iterator.hasNext() && ((n = Integer.parseInt(string = iterator.next()) - 1) < 0 || n > 3)) {
                    n = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.updateParameters(n);
    }

    @Override
    public String[] allCodes() {
        String[] stringArray = new String[4];
        for (int i = 0; i < 4; ++i) {
            stringArray[i] = "EPSG:" + (27561 + i);
        }
        return stringArray;
    }

    @Override
    public Collection<String> getPreferencesFromCode(String string) {
        if (string.startsWith("EPSG:2756") && string.length() == 10) {
            try {
                String string2 = string.substring(9);
                int n = Integer.parseInt(string2);
                if (n >= 1 && n <= 4) {
                    return Collections.singleton(string2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }
}

