/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.Multipolygon;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.mappaint.AreaElemStyle;
import org.openstreetmap.josm.gui.mappaint.ElemStyle;
import org.openstreetmap.josm.gui.mappaint.ElemStyles;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.StyleCache;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipolygonTest
extends Test {
    protected static final int WRONG_MEMBER_TYPE = 1601;
    protected static final int WRONG_MEMBER_ROLE = 1602;
    protected static final int NON_CLOSED_WAY = 1603;
    protected static final int MISSING_OUTER_WAY = 1604;
    protected static final int INNER_WAY_OUTSIDE = 1605;
    protected static final int CROSSING_WAYS = 1606;
    protected static final int OUTER_STYLE_MISMATCH = 1607;
    protected static final int INNER_STYLE_MISMATCH = 1608;
    protected static final int NOT_CLOSED = 1609;
    protected static final int NO_STYLE = 1610;
    protected static final int NO_STYLE_POLYGON = 1611;
    private static ElemStyles styles;
    private final List<List<Node>> nonClosedWays = new ArrayList<List<Node>>();
    private final double SCALE = 1.0;

    public MultipolygonTest() {
        super(I18n.tr("Multipolygon", new Object[0]), I18n.tr("This test checks if multipolygons are valid", new Object[0]));
    }

    @Override
    public void initialize() throws Exception {
        styles = MapPaintStyles.getStyles();
    }

    private List<List<Node>> joinWays(Collection<Way> collection) {
        ArrayList<List<Node>> arrayList = new ArrayList<List<Node>>();
        ArrayList<Way> arrayList2 = new ArrayList<Way>();
        for (Way object : collection) {
            if (object.isClosed()) {
                arrayList.add(object.getNodes());
                continue;
            }
            arrayList2.add(object);
        }
        for (Multipolygon.JoinedWay joinedWay : Multipolygon.joinWays(arrayList2)) {
            if (!joinedWay.isClosed()) {
                this.nonClosedWays.add(joinedWay.getNodes());
                continue;
            }
            arrayList.add(joinedWay.getNodes());
        }
        return arrayList;
    }

    private GeneralPath createPath(List<Node> list) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)list.get(0).getCoor().lat(), (float)list.get(0).getCoor().lon());
        for (int i = 1; i < list.size(); ++i) {
            Node node = list.get(i);
            generalPath.lineTo((float)node.getCoor().lat(), (float)node.getCoor().lon());
        }
        return generalPath;
    }

    private List<GeneralPath> createPolygons(List<List<Node>> list) {
        ArrayList<GeneralPath> arrayList = new ArrayList<GeneralPath>();
        for (List<Node> list2 : list) {
            arrayList.add(this.createPath(list2));
        }
        return arrayList;
    }

    private Multipolygon.PolyData.Intersection getPolygonIntersection(GeneralPath generalPath, List<Node> list) {
        boolean bl = false;
        boolean bl2 = false;
        for (Node node : list) {
            boolean bl3 = generalPath.contains(node.getCoor().lat(), node.getCoor().lon());
            if (!((bl |= bl3) & (bl2 |= !bl3))) continue;
            return Multipolygon.PolyData.Intersection.CROSSING;
        }
        return bl ? Multipolygon.PolyData.Intersection.INSIDE : Multipolygon.PolyData.Intersection.OUTSIDE;
    }

    @Override
    public void visit(Way way) {
        if (styles != null && !way.isClosed()) {
            for (ElemStyle elemStyle : (StyleCache.StyleList)MultipolygonTest.styles.generateStyles((OsmPrimitive)way, (double)1.0, null, (boolean)false).a) {
                if (!(elemStyle instanceof AreaElemStyle)) continue;
                List<Node> list = way.getNodes();
                this.errors.add(new TestError(this, Severity.WARNING, I18n.tr("Area style way is not closed", new Object[0]), 1609, Collections.singletonList(way), Arrays.asList(list.get(0), list.get(list.size() - 1))));
                break;
            }
        }
    }

    @Override
    public void visit(Relation relation) {
        this.nonClosedWays.clear();
        if (relation.isMultipolygon()) {
            Object object3;
            Object object2;
            this.checkMembersAndRoles(relation);
            Multipolygon multipolygon = new Multipolygon(Main.map.mapView);
            multipolygon.load(relation);
            boolean bl = false;
            for (RelationMember object32 : relation.getMembers()) {
                if (!"outer".equals(object32.getRole())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("No outer way for multipolygon", new Object[0]), 1604, relation));
            }
            for (RelationMember relationMember : relation.getMembers()) {
                if (relationMember.getMember().isUsable()) continue;
                return;
            }
            List<List<Node>> list = this.joinWays(multipolygon.getInnerWays());
            List<List<Node>> list2 = this.joinWays(multipolygon.getOuterWays());
            if (styles != null) {
                object2 = null;
                boolean bl2 = false;
                for (ElemStyle elemStyle : (StyleCache.StyleList)MultipolygonTest.styles.generateStyles((OsmPrimitive)relation, (double)1.0, null, (boolean)false).a) {
                    if (!(elemStyle instanceof AreaElemStyle)) continue;
                    object2 = (AreaElemStyle)elemStyle;
                    bl2 = true;
                    break;
                }
                if (object2 == null) {
                    for (Way way : multipolygon.getOuterWays()) {
                        for (Object object3 : (StyleCache.StyleList)MultipolygonTest.styles.generateStyles((OsmPrimitive)way, (double)1.0, null, (boolean)true).a) {
                            if (!(object3 instanceof AreaElemStyle)) continue;
                            object2 = (AreaElemStyle)object3;
                            break;
                        }
                        if (object2 == null) continue;
                        break;
                    }
                    if (object2 == null) {
                        this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr("No style for multipolygon", new Object[0]), 1610, relation));
                    } else {
                        this.errors.add(new TestError((Test)this, Severity.OTHER, I18n.tr("No style in multipolygon relation", new Object[0]), 1611, relation));
                    }
                }
                if (object2 != null) {
                    Object object4;
                    for (Way way : multipolygon.getInnerWays()) {
                        object4 = null;
                        for (ElemStyle elemStyle : (StyleCache.StyleList)MultipolygonTest.styles.generateStyles((OsmPrimitive)way, (double)1.0, null, (boolean)false).a) {
                            if (!(elemStyle instanceof AreaElemStyle)) continue;
                            object4 = (AreaElemStyle)elemStyle;
                            break;
                        }
                        if (object4 == null || !((AreaElemStyle)object2).equals(object4)) continue;
                        object3 = new ArrayList();
                        object3.add(relation);
                        object3.add((Node)((Object)way));
                        this.errors.add(new TestError(this, Severity.WARNING, I18n.tr("Style for inner way equals multipolygon", new Object[0]), 1608, (Collection<? extends OsmPrimitive>)object3, (Collection<?>)Collections.singletonList(way)));
                    }
                    if (!bl2) {
                        for (Way way : multipolygon.getOuterWays()) {
                            object4 = null;
                            for (ElemStyle elemStyle : (StyleCache.StyleList)MultipolygonTest.styles.generateStyles((OsmPrimitive)way, (double)1.0, null, (boolean)false).a) {
                                if (!(elemStyle instanceof AreaElemStyle)) continue;
                                object4 = (AreaElemStyle)elemStyle;
                                break;
                            }
                            if (object4 == null || ((AreaElemStyle)object2).equals(object4)) continue;
                            object3 = new ArrayList<Node>();
                            object3.add((Node)((Object)relation));
                            object3.add((Node)((Object)way));
                            this.errors.add(new TestError(this, Severity.WARNING, I18n.tr("Style for outer way mismatches", new Object[0]), 1607, (Collection<? extends OsmPrimitive>)object3, (Collection<?>)Collections.singletonList(way)));
                        }
                    }
                }
            }
            for (List<Node> list3 : this.nonClosedWays) {
                this.errors.add(new TestError(this, Severity.WARNING, I18n.tr("Multipolygon is not closed", new Object[0]), 1603, list3, Arrays.asList(list3.get(0), list3.get(list3.size() - 1))));
            }
            object2 = this.createPolygons(list2);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                int n;
                Iterator<Way> iterator2 = (List)iterator.next();
                boolean bl3 = true;
                boolean bl4 = false;
                object3 = null;
                for (int i = 0; i < list2.size(); ++i) {
                    GeneralPath generalPath = (GeneralPath)object2.get(i);
                    Multipolygon.PolyData.Intersection intersection = this.getPolygonIntersection(generalPath, (List<Node>)((Object)iterator2));
                    n &= intersection == Multipolygon.PolyData.Intersection.OUTSIDE ? 1 : 0;
                    if (intersection != Multipolygon.PolyData.Intersection.CROSSING) continue;
                    bl4 = true;
                    object3 = list2.get(i);
                }
                if (n == 0 && !bl4) continue;
                ArrayList<Iterator<Object>> arrayList = new ArrayList<Iterator<Object>>();
                arrayList.add(iterator2);
                if (n != 0) {
                    this.errors.add(new TestError(this, Severity.WARNING, I18n.tr("Multipolygon inner way is outside", new Object[0]), 1605, Collections.singletonList(relation), arrayList));
                    continue;
                }
                if (!bl4) continue;
                arrayList.add((Iterator<Object>)object3);
                this.errors.add(new TestError(this, Severity.WARNING, I18n.tr("Intersection between multipolygon ways", new Object[0]), 1606, Collections.singletonList(relation), arrayList));
            }
        }
    }

    private void checkMembersAndRoles(Relation relation) {
        for (RelationMember relationMember : relation.getMembers()) {
            if (relationMember.isWay()) {
                if ("inner".equals(relationMember.getRole()) || "outer".equals(relationMember.getRole()) || !relationMember.hasRole()) continue;
                this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("No useful role for multipolygon member", new Object[0]), 1602, relationMember.getMember()));
                continue;
            }
            if ("admin_centre".equals(relationMember.getRole())) continue;
            this.errors.add(new TestError((Test)this, Severity.WARNING, I18n.tr("Non-Way in multipolygon", new Object[0]), 1601, relationMember.getMember()));
        }
    }
}

