/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.data.osm.history.HistoryDataSetListener;
import org.openstreetmap.josm.gui.OsmPrimitivRenderer;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.history.HistoryBrowserDialogManager;
import org.openstreetmap.josm.gui.history.HistoryLoadTask;
import org.openstreetmap.josm.tools.BugReportExceptionHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class HistoryDialog
extends ToggleDialog
implements HistoryDataSetListener {
    protected HistoryItemTableModel model;
    protected JTable historyTable;
    protected ShowHistoryAction showHistoryAction;
    protected ReloadAction reloadAction;

    public HistoryDialog() {
        super(I18n.tr("History", new Object[0]), "history", I18n.tr("Display the history of all selected items.", new Object[0]), Shortcut.registerShortcut("subwindow:history", I18n.tr("Toggle: {0}", I18n.tr("History", new Object[0])), 72, 4, 1), 150);
        this.build();
        HelpUtil.setHelpContext(this, HelpUtil.ht("/Dialog/History"));
    }

    protected void build() {
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        this.model = new HistoryItemTableModel(defaultListSelectionModel);
        this.historyTable = new JTable(this.model, new HistoryTableColumnModel(), defaultListSelectionModel);
        this.historyTable.setSelectionMode(2);
        final TableCellRenderer tableCellRenderer = this.historyTable.getTableHeader().getDefaultRenderer();
        this.historyTable.getTableHeader().setDefaultRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                JComponent jComponent = (JComponent)tableCellRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (!"".equals(object)) {
                    return jComponent;
                }
                JLabel jLabel = new JLabel(ImageProvider.get("misc", "showhide"));
                jLabel.setForeground(jComponent.getForeground());
                jLabel.setBackground(jComponent.getBackground());
                jLabel.setFont(jComponent.getFont());
                jLabel.setBorder(jComponent.getBorder());
                jLabel.setOpaque(true);
                return jLabel;
            }
        });
        this.historyTable.addMouseListener(new ShowHistoryMouseAdapter());
        this.historyTable.setTableHeader(null);
        SideButton[] sideButtonArray = new SideButton[2];
        this.reloadAction = new ReloadAction();
        sideButtonArray[0] = new SideButton(this.reloadAction);
        this.showHistoryAction = new ShowHistoryAction();
        sideButtonArray[1] = new SideButton(this.showHistoryAction);
        this.createLayout(this.historyTable, true, Arrays.asList(sideButtonArray));
        this.historyTable.getSelectionModel().addListSelectionListener(this.showHistoryAction);
        this.historyTable.getSelectionModel().addListSelectionListener(this.reloadAction);
    }

    public void showNotify() {
        HistoryDataSet.getInstance().addHistoryDataSetListener(this);
        DataSet.addSelectionListener(this.model);
        if (Main.main.getCurrentDataSet() == null) {
            this.model.selectionChanged(null);
        } else {
            this.model.selectionChanged(Main.main.getCurrentDataSet().getSelected());
        }
    }

    public void hideNotify() {
        HistoryDataSet.getInstance().removeHistoryDataSetListener(this);
        DataSet.removeSelectionListener(this.model);
    }

    public void historyUpdated(HistoryDataSet historyDataSet, PrimitiveId primitiveId) {
        this.model.refresh();
    }

    public void historyDataSetCleared(HistoryDataSet historyDataSet) {
        this.model.refresh();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ShowHistoryAction
    extends AbstractAction
    implements ListSelectionListener {
        public ShowHistoryAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "history"));
            this.putValue("Name", I18n.tr("Show", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Display the history of the selected objects.", new Object[0]));
            this.updateEnabledState();
        }

        protected List<OsmPrimitive> filterPrimitivesWithUnloadedHistory(Collection<OsmPrimitive> collection) {
            ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>(collection.size());
            HistoryDataSet historyDataSet = HistoryDataSet.getInstance();
            for (OsmPrimitive osmPrimitive : collection) {
                if (historyDataSet.getHistory(osmPrimitive.getPrimitiveId()) == null) {
                    arrayList.add(osmPrimitive);
                    continue;
                }
                if (osmPrimitive.isNew() || historyDataSet.getHistory(osmPrimitive.getPrimitiveId()).getByVersion(osmPrimitive.getUniqueId()) != null) continue;
                arrayList.add(osmPrimitive);
            }
            return arrayList;
        }

        public void showHistory(final List<OsmPrimitive> list) {
            Runnable runnable;
            List<OsmPrimitive> list2 = this.filterPrimitivesWithUnloadedHistory(list);
            if (!list2.isEmpty()) {
                runnable = new HistoryLoadTask();
                runnable.add(list);
                Main.worker.submit(runnable);
            }
            runnable = new Runnable(){

                public void run() {
                    try {
                        for (OsmPrimitive osmPrimitive : list) {
                            History history = HistoryDataSet.getInstance().getHistory(osmPrimitive.getPrimitiveId());
                            if (history == null) continue;
                            HistoryBrowserDialogManager.getInstance().show(history);
                        }
                    }
                    catch (Exception exception) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                BugReportExceptionHandler.handleException(exception);
                            }
                        });
                    }
                }
            };
            Main.worker.submit(runnable);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = HistoryDialog.this.historyTable.getSelectedRows();
            if (nArray == null || nArray.length == 0) {
                return;
            }
            this.showHistory(HistoryDialog.this.model.getPrimitives(nArray));
        }

        protected void updateEnabledState() {
            this.setEnabled(HistoryDialog.this.historyTable.getSelectedRowCount() > 0);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    class ShowHistoryMouseAdapter
    extends MouseAdapter {
        ShowHistoryMouseAdapter() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
                int n = HistoryDialog.this.historyTable.rowAtPoint(mouseEvent.getPoint());
                new ShowHistoryAction().showHistory(Collections.singletonList(HistoryDialog.this.model.getPrimitive(n)));
            }
        }
    }

    class ReloadAction
    extends AbstractAction
    implements ListSelectionListener {
        public ReloadAction() {
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "refresh"));
            this.putValue("Name", I18n.tr("Reload", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Reload all currently selected objects and refresh the list.", new Object[0]));
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = HistoryDialog.this.historyTable.getSelectedRows();
            if (nArray == null || nArray.length == 0) {
                return;
            }
            List<OsmPrimitive> list = HistoryDialog.this.model.getPrimitives(nArray);
            HistoryLoadTask historyLoadTask = new HistoryLoadTask();
            historyLoadTask.add(list);
            Main.worker.execute(historyLoadTask);
        }

        protected void updateEnabledState() {
            this.setEnabled(HistoryDialog.this.historyTable.getSelectedRowCount() > 0);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    static class HistoryTableColumnModel
    extends DefaultTableColumnModel {
        protected void createColumns() {
            TableColumn tableColumn = null;
            OsmPrimitivRenderer osmPrimitivRenderer = new OsmPrimitivRenderer();
            tableColumn = new TableColumn(0);
            tableColumn.setHeaderValue(I18n.tr("Object with history", new Object[0]));
            tableColumn.setCellRenderer(osmPrimitivRenderer);
            this.addColumn(tableColumn);
        }

        public HistoryTableColumnModel() {
            this.createColumns();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class HistoryItemTableModel
    extends DefaultTableModel
    implements SelectionChangedListener {
        private ArrayList<OsmPrimitive> data = new ArrayList();
        private DefaultListSelectionModel selectionModel;

        public HistoryItemTableModel(DefaultListSelectionModel defaultListSelectionModel) {
            this.selectionModel = defaultListSelectionModel;
        }

        @Override
        public int getRowCount() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.data.get(n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        protected List<OsmPrimitive> getSelectedPrimitives() {
            ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>();
            for (int i = 0; i < this.data.size(); ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                arrayList.add(this.data.get(i));
            }
            return arrayList;
        }

        protected void selectPrimitives(Collection<OsmPrimitive> collection) {
            for (OsmPrimitive osmPrimitive : collection) {
                int n = this.data.indexOf(osmPrimitive);
                if (n < 0) continue;
                this.selectionModel.addSelectionInterval(n, n);
            }
        }

        public void refresh() {
            List<OsmPrimitive> list = this.getSelectedPrimitives();
            this.data.clear();
            if (Main.main.getCurrentDataSet() == null) {
                return;
            }
            for (OsmPrimitive osmPrimitive : Main.main.getCurrentDataSet().getSelected()) {
                if (osmPrimitive.isNew()) continue;
                this.data.add(osmPrimitive);
            }
            this.fireTableDataChanged();
            this.selectPrimitives(list);
        }

        @Override
        public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
            this.data.clear();
            this.selectionModel.clearSelection();
            if (collection != null && !collection.isEmpty()) {
                for (OsmPrimitive osmPrimitive : collection) {
                    if (osmPrimitive.isNew()) continue;
                    this.data.add(osmPrimitive);
                }
            }
            this.fireTableDataChanged();
            this.selectionModel.addSelectionInterval(0, this.data.size() - 1);
        }

        public List<OsmPrimitive> getPrimitives(int[] nArray) {
            if (nArray == null || nArray.length == 0) {
                return Collections.emptyList();
            }
            ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>(nArray.length);
            for (int n : nArray) {
                arrayList.add(this.data.get(n));
            }
            return arrayList;
        }

        public OsmPrimitive getPrimitive(int n) {
            return this.data.get(n);
        }
    }
}

