/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import javax.swing.DefaultListSelectionModel;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.event.AbstractDatasetChangedEvent;
import org.openstreetmap.josm.data.osm.event.ChangesetIdChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataChangedEvent;
import org.openstreetmap.josm.data.osm.event.DataSetListener;
import org.openstreetmap.josm.data.osm.event.NodeMovedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesAddedEvent;
import org.openstreetmap.josm.data.osm.event.PrimitivesRemovedEvent;
import org.openstreetmap.josm.data.osm.event.RelationMembersChangedEvent;
import org.openstreetmap.josm.data.osm.event.TagsChangedEvent;
import org.openstreetmap.josm.data.osm.event.WayNodesChangedEvent;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetListModel;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

public class ChangesetsInActiveDataLayerListModel
extends ChangesetListModel
implements DataSetListener,
MapView.EditLayerChangeListener {
    public ChangesetsInActiveDataLayerListModel(DefaultListSelectionModel defaultListSelectionModel) {
        super(defaultListSelectionModel);
    }

    public void dataChanged(DataChangedEvent dataChangedEvent) {
        this.initFromDataSet(dataChangedEvent.getDataset());
    }

    public void primitivesAdded(PrimitivesAddedEvent primitivesAddedEvent) {
        for (OsmPrimitive osmPrimitive : primitivesAddedEvent.getPrimitives()) {
            this.addChangeset(new Changeset(osmPrimitive.getChangesetId()));
        }
    }

    public void primitivesRemoved(PrimitivesRemovedEvent primitivesRemovedEvent) {
        for (OsmPrimitive osmPrimitive : primitivesRemovedEvent.getPrimitives()) {
            this.removeChangeset(new Changeset(osmPrimitive.getChangesetId()));
        }
    }

    public void otherDatasetChange(AbstractDatasetChangedEvent abstractDatasetChangedEvent) {
        if (abstractDatasetChangedEvent instanceof ChangesetIdChangedEvent) {
            ChangesetIdChangedEvent changesetIdChangedEvent = (ChangesetIdChangedEvent)abstractDatasetChangedEvent;
            this.removeChangeset(new Changeset(changesetIdChangedEvent.getOldChangesetId()));
            this.addChangeset(new Changeset(changesetIdChangedEvent.getNewChangesetId()));
        }
    }

    public void nodeMoved(NodeMovedEvent nodeMovedEvent) {
    }

    public void relationMembersChanged(RelationMembersChangedEvent relationMembersChangedEvent) {
    }

    public void tagsChanged(TagsChangedEvent tagsChangedEvent) {
    }

    public void wayNodesChanged(WayNodesChangedEvent wayNodesChangedEvent) {
    }

    public void editLayerChanged(OsmDataLayer osmDataLayer, OsmDataLayer osmDataLayer2) {
        if (osmDataLayer2 != null) {
            this.initFromDataSet(osmDataLayer2.data);
        } else {
            this.initFromDataSet(null);
        }
    }
}

