/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Color;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class VersionTableCellRenderer
extends JLabel
implements TableCellRenderer {
    public static final Color BGCOLOR_SELECTED = new Color(143, 170, 255);
    public static final Color BGCOLOR_IS_REFERENCE_POINT = new Color(255, 197, 197);
    protected HashMap<OsmPrimitiveType, ImageIcon> icons = null;

    public VersionTableCellRenderer() {
        this.loadIcons();
        this.setOpaque(true);
    }

    protected void loadIcons() {
        this.icons = new HashMap();
        this.icons.put(OsmPrimitiveType.NODE, ImageProvider.get("data", "node"));
        this.icons.put(OsmPrimitiveType.WAY, ImageProvider.get("data", "way"));
        this.icons.put(OsmPrimitiveType.RELATION, ImageProvider.get("data", "relation"));
    }

    protected void renderIcon(OsmPrimitiveType osmPrimitiveType) {
        ImageIcon imageIcon = osmPrimitiveType == null ? null : this.icons.get((Object)osmPrimitiveType);
        this.setIcon(imageIcon);
    }

    protected void renderText(HistoryOsmPrimitive historyOsmPrimitive) {
        StringBuilder stringBuilder = new StringBuilder();
        if (historyOsmPrimitive == null) {
            stringBuilder.append("");
        } else {
            String string = I18n.tr("Version {0}, {1} (by {2})", Long.toString(historyOsmPrimitive.getVersion()), new SimpleDateFormat().format(historyOsmPrimitive.getTimestamp()), historyOsmPrimitive.getUser());
            stringBuilder.append(string);
        }
        this.setText(stringBuilder.toString());
        stringBuilder = new StringBuilder();
        if (historyOsmPrimitive == null) {
            stringBuilder.append("");
        } else {
            stringBuilder.append(I18n.tr("Version {0} created on {1} by {2}", Long.toString(historyOsmPrimitive.getVersion()), new SimpleDateFormat().format(historyOsmPrimitive.getTimestamp()), historyOsmPrimitive.getUser()));
        }
        this.setToolTipText(stringBuilder.toString());
    }

    protected OsmDataLayer getEditLayer() {
        try {
            return Main.map.mapView.getEditLayer();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    protected void renderLatestText(OsmPrimitive osmPrimitive) {
        StringBuffer stringBuffer = new StringBuffer();
        if (osmPrimitive == null) {
            this.setText("");
            return;
        }
        if (osmPrimitive.isModified()) {
            stringBuffer.append("*");
        }
        stringBuffer.append(I18n.tr("Version {0} in editor", osmPrimitive.getVersion()));
        if (osmPrimitive.isDeleted()) {
            stringBuffer.append(I18n.tr("[deleted]", new Object[0]));
        }
        this.setText(stringBuffer.toString());
        stringBuffer = new StringBuffer();
        OsmDataLayer osmDataLayer = this.getEditLayer();
        stringBuffer.append(I18n.tr("Version {0} currently edited in data layer ''{1}''", osmPrimitive.getId(), osmDataLayer == null ? I18n.tr("unknown", new Object[0]) : osmDataLayer.getName()));
        this.setToolTipText(stringBuffer.toString());
    }

    protected void renderBackground(JTable jTable, int n, boolean bl) {
        Color color = Color.WHITE;
        if (bl) {
            color = BGCOLOR_SELECTED;
        } else if (this.getModel(jTable).isReferencePointInTime(n)) {
            color = BGCOLOR_IS_REFERENCE_POINT;
        }
        this.setBackground(color);
    }

    public void renderVersionFromHistory(HistoryOsmPrimitive historyOsmPrimitive, JTable jTable, int n, boolean bl) {
        this.renderIcon(historyOsmPrimitive == null ? null : historyOsmPrimitive.getType());
        this.renderText(historyOsmPrimitive);
        this.renderBackground(jTable, n, bl);
    }

    public void renderLatest(OsmPrimitive osmPrimitive, JTable jTable, int n, boolean bl) {
        this.renderIcon(osmPrimitive.getType());
        this.renderLatestText(this.getModel(jTable).getLatest());
        this.renderBackground(jTable, n, bl);
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (object == null) {
            return this;
        }
        if (this.getModel(jTable).isLatest(n)) {
            this.renderLatest(this.getModel(jTable).getLatest(), jTable, n, bl);
        } else {
            this.renderVersionFromHistory((HistoryOsmPrimitive)object, jTable, n, bl);
        }
        return this;
    }

    protected HistoryBrowserModel.VersionTableModel getModel(JTable jTable) {
        return (HistoryBrowserModel.VersionTableModel)jTable.getModel();
    }
}

