/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.imagery;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageryReader {
    private String source;

    public ImageryReader(String string) throws IOException {
        this.source = string;
    }

    public List<ImageryInfo> parse() throws SAXException, IOException {
        if (this.isXml(this.source)) {
            Parser parser = new Parser();
            try {
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                sAXParserFactory.setNamespaceAware(true);
                MirroredInputStream mirroredInputStream = new MirroredInputStream(this.source);
                InputSource inputSource = new InputSource(UTFInputStreamReader.create(mirroredInputStream, "UTF-8"));
                sAXParserFactory.newSAXParser().parse(inputSource, (DefaultHandler)parser);
                return parser.entries;
            }
            catch (SAXException sAXException) {
                throw sAXException;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                parserConfigurationException.printStackTrace();
                throw new SAXException(parserConfigurationException);
            }
        }
        return this.readCSV(this.source);
    }

    /*
     * Exception decompiling
     */
    private boolean isXml(String var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<ImageryInfo> readCSV(String string) {
        Object object;
        ArrayList<ImageryInfo> arrayList = new ArrayList<ImageryInfo>();
        MirroredInputStream mirroredInputStream = null;
        try {
            mirroredInputStream = new MirroredInputStream(string);
            try {
                String string2;
                try {
                    object = new InputStreamReader((InputStream)mirroredInputStream, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    object = new InputStreamReader(mirroredInputStream);
                }
                BufferedReader bufferedReader = new BufferedReader((Reader)object);
                while ((string2 = bufferedReader.readLine()) != null) {
                    String[] stringArray = string2.split(";");
                    if (string2.startsWith("#") || stringArray.length < 3) continue;
                    boolean bl = "true".equals(stringArray[0]);
                    String string3 = I18n.tr(stringArray[1], new Object[0]);
                    String string4 = stringArray[2];
                    String string5 = null;
                    if (stringArray.length >= 4 && !stringArray[3].isEmpty()) {
                        string5 = stringArray[3];
                    }
                    ImageryInfo imageryInfo = new ImageryInfo(string3, string4, string5);
                    imageryInfo.setDefaultEntry(bl);
                    if (stringArray.length >= 5 && !stringArray[4].isEmpty()) {
                        try {
                            imageryInfo.setBounds(new Bounds(stringArray[4], ","));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            Main.warn(illegalArgumentException.toString());
                        }
                    }
                    if (stringArray.length >= 6 && !stringArray[5].isEmpty()) {
                        imageryInfo.setAttributionText(stringArray[5]);
                    }
                    if (stringArray.length >= 7 && !stringArray[6].isEmpty()) {
                        imageryInfo.setAttributionLinkURL(stringArray[6]);
                    }
                    if (stringArray.length >= 8 && !stringArray[7].isEmpty()) {
                        imageryInfo.setTermsOfUseURL(stringArray[7]);
                    }
                    if (stringArray.length >= 9 && !stringArray[8].isEmpty()) {
                        imageryInfo.setAttributionImage(stringArray[8]);
                    }
                    arrayList.add(imageryInfo);
                }
            }
            finally {
                Utils.close(mirroredInputStream);
            }
            object = arrayList;
        }
        catch (IOException iOException) {
            try {
                iOException.printStackTrace();
            }
            catch (Throwable throwable) {
                Utils.close(mirroredInputStream);
                throw throwable;
            }
            Utils.close(mirroredInputStream);
            return arrayList;
        }
        Utils.close(mirroredInputStream);
        return object;
    }

    private class Parser
    extends DefaultHandler {
        private StringBuffer accumulator = new StringBuffer();
        private Stack<State> states;
        List<ImageryInfo> entries;
        boolean skipEntry;
        ImageryInfo entry;
        Bounds bounds;
        List<String> supported_srs;

        private Parser() {
        }

        public void startDocument() {
            this.accumulator = new StringBuffer();
            this.skipEntry = false;
            this.states = new Stack();
            this.states.push(State.INIT);
            this.entries = new ArrayList<ImageryInfo>();
            this.entry = null;
            this.bounds = null;
            this.supported_srs = null;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.accumulator.setLength(0);
            State state = null;
            switch (this.states.peek()) {
                case INIT: {
                    if (!string3.equals("imagery")) break;
                    state = State.IMAGERY;
                    break;
                }
                case IMAGERY: {
                    if (!string3.equals("entry")) break;
                    this.entry = new ImageryInfo();
                    this.skipEntry = false;
                    state = State.ENTRY;
                    break;
                }
                case ENTRY: {
                    if (Arrays.asList("name", "type", "default", "url", "eula", "min-zoom", "max-zoom", "attribution-text", "attribution-url", "logo-image", "logo-url", "terms-of-use-text", "terms-of-use-url").contains(string3)) {
                        state = State.ENTRY_ATTRIBUTE;
                        break;
                    }
                    if (string3.equals("bounds")) {
                        try {
                            this.bounds = new Bounds(attributes.getValue("min-lat") + "," + attributes.getValue("min-lon") + "," + attributes.getValue("max-lat") + "," + attributes.getValue("max-lon"), ",");
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            break;
                        }
                        state = State.ENTRY_ATTRIBUTE;
                        break;
                    }
                    if (!string3.equals("supported-projections")) break;
                    this.supported_srs = new ArrayList<String>();
                    state = State.SUPPORTED_PROJECTIONS;
                    break;
                }
                case SUPPORTED_PROJECTIONS: {
                    if (!string3.equals("pr")) break;
                    state = State.PR;
                }
            }
            if (state == null) {
                state = State.UNKNOWN;
            }
            this.states.push(state);
            if (state == State.UNKNOWN && Utils.equal(attributes.getValue("mandatory"), "true")) {
                this.skipEntry = true;
            }
        }

        public void characters(char[] cArray, int n, int n2) {
            this.accumulator.append(cArray, n, n2);
        }

        public void endElement(String string, String string2, String string3) {
            switch (this.states.pop()) {
                case INIT: {
                    throw new RuntimeException("parsing error: more closing than opening elements");
                }
                case ENTRY: {
                    if (!string2.equals("entry")) break;
                    if (!this.skipEntry) {
                        this.entries.add(this.entry);
                    }
                    this.entry = null;
                    break;
                }
                case ENTRY_ATTRIBUTE: {
                    if (string2.equals("name")) {
                        this.entry.setName(this.accumulator.toString());
                        break;
                    }
                    if (string2.equals("type")) {
                        boolean bl = false;
                        for (ImageryInfo.ImageryType imageryType : ImageryInfo.ImageryType.values()) {
                            if (!Utils.equal(this.accumulator.toString(), imageryType.getUrlString())) continue;
                            this.entry.setImageryType(imageryType);
                            bl = true;
                            break;
                        }
                        if (bl) break;
                        this.skipEntry = true;
                        break;
                    }
                    if (string2.equals("default")) {
                        if (this.accumulator.toString().equals("true")) {
                            this.entry.setDefaultEntry(true);
                            break;
                        }
                        if (this.accumulator.toString().equals("false")) {
                            this.entry.setDefaultEntry(false);
                            break;
                        }
                        this.skipEntry = true;
                        break;
                    }
                    if (string2.equals("url")) {
                        this.entry.setUrl(this.accumulator.toString());
                        break;
                    }
                    if (string2.equals("eula")) {
                        this.entry.setEulaAcceptanceRequired(this.accumulator.toString());
                        break;
                    }
                    if (string2.equals("min-zoom") || string2.equals("max-zoom")) {
                        Integer n = null;
                        try {
                            n = Integer.parseInt(this.accumulator.toString());
                        }
                        catch (NumberFormatException numberFormatException) {
                            n = null;
                        }
                        if (n == null) {
                            this.skipEntry = true;
                            break;
                        }
                        if (string2.equals("min-zoom")) {
                            this.entry.setDefaultMinZoom(n);
                            break;
                        }
                        this.entry.setDefaultMaxZoom(n);
                        this.entry.setMaxZoom(n);
                        break;
                    }
                    if (string2.equals("bounds")) {
                        this.entry.setBounds(this.bounds);
                        this.bounds = null;
                        break;
                    }
                    if (string2.equals("attribution-text")) {
                        this.entry.setAttributionText(this.accumulator.toString());
                        break;
                    }
                    if (string2.equals("attribution-url")) {
                        this.entry.setAttributionLinkURL(this.accumulator.toString());
                        break;
                    }
                    if (string2.equals("logo-image")) {
                        this.entry.setAttributionImage(this.accumulator.toString());
                        break;
                    }
                    if (string2.equals("logo-url") || string2.equals("terms-of-use-text") || !string2.equals("terms-of-use-url")) break;
                    this.entry.setTermsOfUseURL(this.accumulator.toString());
                    break;
                }
                case PR: {
                    this.supported_srs.add(this.accumulator.toString());
                    break;
                }
                case SUPPORTED_PROJECTIONS: {
                    this.entry.setServerProjections(this.supported_srs);
                    this.supported_srs = null;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        INIT,
        IMAGERY,
        ENTRY,
        ENTRY_ATTRIBUTE,
        SUPPORTED_PROJECTIONS,
        PR,
        UNKNOWN;

    }
}

