/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.imaging.jpeg.JpegProcessingException;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifDirectory;
import java.io.File;
import java.text.ParseException;
import java.util.Date;
import java.util.Iterator;
import org.openstreetmap.josm.tools.DateParser;

public class ExifReader {
    public static Date readTime(File file) throws ParseException {
        Date date = null;
        try {
            Metadata metadata = JpegMetadataReader.readMetadata(file);
            Iterator iterator = metadata.getDirectoryIterator();
            while (iterator.hasNext()) {
                Iterator iterator2 = ((Directory)iterator.next()).getTagIterator();
                while (iterator2.hasNext()) {
                    Tag tag = (Tag)iterator2.next();
                    if (tag.getTagType() == 36867) {
                        return DateParser.parse(tag.getDescription());
                    }
                    if (tag.getTagType() != 306 && tag.getTagType() != 36868) continue;
                    date = DateParser.parse(tag.getDescription());
                }
            }
        }
        catch (ParseException parseException) {
            throw parseException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return date;
    }

    public static Integer readOrientation(File file) throws ParseException {
        Integer n = null;
        try {
            Metadata metadata = JpegMetadataReader.readMetadata(file);
            Directory directory = metadata.getDirectory(ExifDirectory.class);
            n = directory.getInt(274);
        }
        catch (JpegProcessingException jpegProcessingException) {
            jpegProcessingException.printStackTrace();
        }
        catch (MetadataException metadataException) {
            metadataException.printStackTrace();
        }
        return n;
    }
}

