/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.LinkedList;
import java.util.concurrent.Future;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.widgets.HistoryComboBox;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class OpenLocationAction
extends JosmAction {
    public OpenLocationAction() {
        super(I18n.tr("Open Location...", new Object[0]), "openlocation", I18n.tr("Open an URL.", new Object[0]), Shortcut.registerShortcut("system:open_location", I18n.tr("File: {0}", I18n.tr("Open Location...", new Object[0])), 76, 2), true);
        this.putValue("help", HelpUtil.ht("/Action/OpenLocation"));
    }

    protected void restoreUploadAddressHistory(HistoryComboBox historyComboBox) {
        LinkedList<String> linkedList = new LinkedList<String>(Main.pref.getCollection(this.getClass().getName() + ".uploadAddressHistory", new LinkedList<String>()));
        Collections.reverse(linkedList);
        historyComboBox.setPossibleItems(linkedList);
    }

    protected void remindUploadAddressHistory(HistoryComboBox historyComboBox) {
        historyComboBox.addCurrentItemToHistory();
        Main.pref.putCollection(this.getClass().getName() + ".uploadAddressHistory", historyComboBox.getHistory());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JCheckBox jCheckBox = new JCheckBox(I18n.tr("Separate Layer", new Object[0]));
        jCheckBox.setToolTipText(I18n.tr("Select if the data should be downloaded into a new layer", new Object[0]));
        jCheckBox.setSelected(Main.pref.getBoolean("download.newlayer"));
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 23;
        jPanel.add((Component)new JLabel(I18n.tr("Enter URL to download:", new Object[0])), gridBagConstraints);
        HistoryComboBox historyComboBox = new HistoryComboBox();
        historyComboBox.setToolTipText(I18n.tr("Enter an URL from where data should be downloaded", new Object[0]));
        this.restoreUploadAddressHistory(historyComboBox);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)historyComboBox, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jCheckBox, gridBagConstraints);
        ExtendedDialog extendedDialog = new ExtendedDialog(Main.parent, I18n.tr("Download Location", new Object[0]), new String[]{I18n.tr("Download URL", new Object[0]), I18n.tr("Cancel", new Object[0])});
        extendedDialog.setContent(jPanel, false);
        extendedDialog.setButtonIcons(new String[]{"download.png", "cancel.png"});
        extendedDialog.setToolTipTexts(new String[]{I18n.tr("Start downloading data", new Object[0]), I18n.tr("Close dialog and cancel downloading", new Object[0])});
        extendedDialog.configureContextsensitiveHelp("/Action/OpenLocation", true);
        extendedDialog.showDialog();
        if (extendedDialog.getValue() != 1) {
            return;
        }
        this.remindUploadAddressHistory(historyComboBox);
        this.openUrl(jCheckBox.isSelected(), historyComboBox.getText());
    }

    public void openUrl(boolean bl, String string) {
        DownloadOsmTask downloadOsmTask = new DownloadOsmTask();
        PleaseWaitProgressMonitor pleaseWaitProgressMonitor = new PleaseWaitProgressMonitor(I18n.tr("Download Data", new Object[0]));
        Future<?> future = downloadOsmTask.loadUrl(bl, string, pleaseWaitProgressMonitor);
        Main.worker.submit(new PostDownloadHandler((DownloadTask)downloadOsmTask, future));
    }
}

