/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.io.IOException;
import java.util.concurrent.Future;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.AbstractDownloadTask;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.BoundingBoxDownloader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadGpsTask
extends AbstractDownloadTask {
    private DownloadTask downloadTask;

    @Override
    public Future<?> download(boolean bl, Bounds bounds, ProgressMonitor progressMonitor) {
        this.downloadTask = new DownloadTask(bl, new BoundingBoxDownloader(bounds), progressMonitor);
        return Main.worker.submit(this.downloadTask);
    }

    @Override
    public Future<?> loadUrl(boolean bl, String string, ProgressMonitor progressMonitor) {
        return null;
    }

    @Override
    public void cancel() {
        if (this.downloadTask != null) {
            this.downloadTask.cancel();
        }
    }

    class DownloadTask
    extends PleaseWaitRunnable {
        private BoundingBoxDownloader reader;
        private GpxData rawData;
        private final boolean newLayer;

        public DownloadTask(boolean bl, BoundingBoxDownloader boundingBoxDownloader, ProgressMonitor progressMonitor) {
            super(I18n.tr("Downloading GPS data", new Object[0]));
            this.reader = boundingBoxDownloader;
            this.newLayer = bl;
        }

        public void realRun() throws IOException, SAXException, OsmTransferException {
            try {
                if (DownloadGpsTask.this.isCanceled()) {
                    return;
                }
                this.rawData = this.reader.parseRawGps(this.progressMonitor.createSubTaskMonitor(-1, false));
            }
            catch (Exception exception) {
                if (DownloadGpsTask.this.isCanceled()) {
                    return;
                }
                if (exception instanceof OsmTransferException) {
                    DownloadGpsTask.this.rememberException(exception);
                }
                DownloadGpsTask.this.rememberException(new OsmTransferException(exception));
            }
        }

        protected void finish() {
            if (DownloadGpsTask.this.isCanceled() || DownloadGpsTask.this.isFailed()) {
                return;
            }
            if (this.rawData == null) {
                return;
            }
            this.rawData.recalculateBounds();
            String string = I18n.tr("Downloaded GPX Data", new Object[0]);
            GpxLayer gpxLayer = new GpxLayer(this.rawData, string);
            Layer layer = this.findMergeLayer();
            if (this.newLayer || layer == null) {
                Main.main.addLayer(gpxLayer);
            } else {
                layer.mergeFrom(gpxLayer);
                Main.map.repaint();
            }
        }

        private Layer findMergeLayer() {
            boolean bl = Main.pref.getBoolean("download.gps.mergeWithLocal", false);
            if (!Main.isDisplayingMapView()) {
                return null;
            }
            Layer layer = Main.map.mapView.getActiveLayer();
            if (layer != null && layer instanceof GpxLayer && (bl || ((GpxLayer)layer).data.fromServer)) {
                return layer;
            }
            for (Layer layer2 : Main.map.mapView.getAllLayers()) {
                if (!(layer2 instanceof GpxLayer) || !bl && !((GpxLayer)layer2).data.fromServer) continue;
                return layer2;
            }
            return null;
        }

        protected void cancel() {
            DownloadGpsTask.this.setCanceled(true);
            if (this.reader != null) {
                this.reader.cancel();
            }
        }
    }
}

