/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.AbstractDownloadTask;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSource;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.BoundingBoxDownloader;
import org.openstreetmap.josm.io.OsmServerLocationReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferCanceledException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadOsmTask
extends AbstractDownloadTask {
    private Bounds currentBounds;
    private DataSet downloadedData;
    private DownloadTask downloadTask;

    private void rememberDownloadedData(DataSet dataSet) {
        this.downloadedData = dataSet;
    }

    public DataSet getDownloadedData() {
        return this.downloadedData;
    }

    @Override
    public Future<?> download(boolean bl, Bounds bounds, ProgressMonitor progressMonitor) {
        this.downloadTask = new DownloadTask(bl, new BoundingBoxDownloader(bounds), progressMonitor);
        this.currentBounds = new Bounds(bounds);
        return Main.worker.submit(this.downloadTask);
    }

    @Override
    public Future<?> loadUrl(boolean bl, String string, ProgressMonitor progressMonitor) {
        this.downloadTask = new DownloadTask(bl, new OsmServerLocationReader(string), progressMonitor);
        this.currentBounds = null;
        return Main.worker.submit(this.downloadTask);
    }

    @Override
    public void cancel() {
        if (this.downloadTask != null) {
            this.downloadTask.cancel();
        }
    }

    private class DownloadTask
    extends PleaseWaitRunnable {
        private OsmServerReader reader;
        private DataSet dataSet;
        private boolean newLayer;

        public DownloadTask(boolean bl, OsmServerReader osmServerReader, ProgressMonitor progressMonitor) {
            super(I18n.tr("Downloading data", new Object[0]), progressMonitor, false);
            this.reader = osmServerReader;
            this.newLayer = bl;
        }

        public void realRun() throws IOException, SAXException, OsmTransferException {
            try {
                if (DownloadOsmTask.this.isCanceled()) {
                    return;
                }
                this.dataSet = this.reader.parseOsm(this.progressMonitor.createSubTaskMonitor(-1, false));
            }
            catch (Exception exception) {
                if (DownloadOsmTask.this.isCanceled()) {
                    System.out.println(I18n.tr("Ignoring exception because download has been canceled. Exception was: {0}", exception.toString()));
                    return;
                }
                if (exception instanceof OsmTransferCanceledException) {
                    DownloadOsmTask.this.setCanceled(true);
                    return;
                }
                if (exception instanceof OsmTransferException) {
                    DownloadOsmTask.this.rememberException(exception);
                } else {
                    DownloadOsmTask.this.rememberException(new OsmTransferException(exception));
                }
                DownloadOsmTask.this.setFailed(true);
            }
        }

        protected OsmDataLayer getEditLayer() {
            if (!Main.isDisplayingMapView()) {
                return null;
            }
            return Main.map.mapView.getEditLayer();
        }

        protected int getNumDataLayers() {
            int n = 0;
            if (!Main.isDisplayingMapView()) {
                return 0;
            }
            Collection<Layer> collection = Main.map.mapView.getAllLayers();
            for (Layer layer : collection) {
                if (!(layer instanceof OsmDataLayer)) continue;
                ++n;
            }
            return n;
        }

        protected OsmDataLayer getFirstDataLayer() {
            if (!Main.isDisplayingMapView()) {
                return null;
            }
            List<Layer> list = Main.map.mapView.getAllLayersAsList();
            for (Layer layer : list) {
                if (!(layer instanceof OsmDataLayer)) continue;
                return (OsmDataLayer)layer;
            }
            return null;
        }

        protected void finish() {
            if (DownloadOsmTask.this.isFailed() || DownloadOsmTask.this.isCanceled()) {
                return;
            }
            if (this.dataSet == null) {
                return;
            }
            if (this.dataSet.allPrimitives().isEmpty()) {
                DownloadOsmTask.this.rememberErrorMessage(I18n.tr("No data found in this area.", new Object[0]));
                this.dataSet.dataSources.add(new DataSource(DownloadOsmTask.this.currentBounds != null ? DownloadOsmTask.this.currentBounds : new Bounds(new LatLon(0.0, 0.0)), "OpenStreetMap server"));
            }
            DownloadOsmTask.this.rememberDownloadedData(this.dataSet);
            int n = this.getNumDataLayers();
            if (this.newLayer || n == 0 || n > 1 && this.getEditLayer() == null) {
                OsmDataLayer osmDataLayer = new OsmDataLayer(this.dataSet, OsmDataLayer.createNewName(), null);
                boolean bl = Main.isDisplayingMapView();
                Main.main.addLayer(osmDataLayer);
                if (bl) {
                    BoundingXYVisitor boundingXYVisitor = new BoundingXYVisitor();
                    if (DownloadOsmTask.this.currentBounds != null) {
                        boundingXYVisitor.visit(DownloadOsmTask.this.currentBounds);
                    } else {
                        boundingXYVisitor.computeBoundingBox(this.dataSet.getNodes());
                    }
                    Main.map.mapView.recalculateCenterScale(boundingXYVisitor);
                }
            } else {
                OsmDataLayer osmDataLayer = this.getEditLayer();
                if (osmDataLayer == null) {
                    osmDataLayer = this.getFirstDataLayer();
                }
                osmDataLayer.mergeFrom(this.dataSet);
                BoundingXYVisitor boundingXYVisitor = new BoundingXYVisitor();
                if (DownloadOsmTask.this.currentBounds != null) {
                    boundingXYVisitor.visit(DownloadOsmTask.this.currentBounds);
                } else {
                    boundingXYVisitor.computeBoundingBox(this.dataSet.getNodes());
                }
                Main.map.mapView.recalculateCenterScale(boundingXYVisitor);
                osmDataLayer.onPostDownloadFromServer();
            }
        }

        protected void cancel() {
            DownloadOsmTask.this.setCanceled(true);
            if (this.reader != null) {
                this.reader.cancel();
            }
        }
    }
}

