/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm.history;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.history.HistoryNameFormatter;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryWay
extends HistoryOsmPrimitive {
    private ArrayList<Long> nodeIds = new ArrayList();

    public HistoryWay(long l, long l2, boolean bl, String string, long l3, long l4, Date date) {
        super(l, l2, bl, string, l3, l4, date);
    }

    public HistoryWay(long l, long l2, boolean bl, String string, long l3, long l4, Date date, ArrayList<Long> arrayList) {
        this(l, l2, bl, string, l3, l4, date);
        this.nodeIds.addAll(arrayList);
    }

    public HistoryWay(Way way) {
        super(way);
    }

    public int getNumNodes() {
        return this.nodeIds.size();
    }

    public long getNodeId(int n) throws IndexOutOfBoundsException {
        if (n < 0 || n >= this.nodeIds.size()) {
            throw new IndexOutOfBoundsException(I18n.tr("Parameter {0} not in range 0..{1}. Got ''{2}''.", "idx", this.nodeIds.size(), n));
        }
        return this.nodeIds.get(n);
    }

    public List<Long> getNodes() {
        return Collections.unmodifiableList(this.nodeIds);
    }

    @Override
    public OsmPrimitiveType getType() {
        return OsmPrimitiveType.WAY;
    }

    public void addNode(long l) {
        this.nodeIds.add(l);
    }

    public boolean isClosed() {
        return this.getNumNodes() >= 3 && this.nodeIds.get(0) == this.nodeIds.get(this.nodeIds.size() - 1);
    }

    @Override
    public String getDisplayName(HistoryNameFormatter historyNameFormatter) {
        return historyNameFormatter.format(this);
    }
}

