/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.NTV2GridShift;
import org.openstreetmap.josm.data.projection.NTV2GridShiftFile;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.datum.Datum;
import org.openstreetmap.josm.data.projection.proj.Proj;

public abstract class AbstractProjection
implements Projection {
    protected Ellipsoid ellps;
    protected Datum datum;
    protected Proj proj;
    protected double x_0 = 0.0;
    protected double y_0 = 0.0;
    protected double lon_0 = 0.0;
    protected double k_0 = 1.0;
    protected NTV2GridShiftFile nadgrids = null;

    public EastNorth latlon2eastNorth(LatLon latLon) {
        Object object;
        if (this.nadgrids != null) {
            object = new NTV2GridShift(latLon);
            this.nadgrids.gridShiftReverse((NTV2GridShift)object);
            latLon = new LatLon(latLon.lat() + ((NTV2GridShift)object).getLatShiftDegrees(), latLon.lon() + ((NTV2GridShift)object).getLonShiftPositiveEastDegrees());
        } else {
            latLon = this.datum.fromWGS84(latLon);
        }
        object = this.proj.project(Math.toRadians(latLon.lat()), Math.toRadians(latLon.lon() - this.lon_0));
        return new EastNorth(this.ellps.a * this.k_0 * object[0] + this.x_0, this.ellps.a * this.k_0 * object[1] + this.y_0);
    }

    public LatLon eastNorth2latlon(EastNorth eastNorth) {
        double[] dArray = this.proj.invproject((eastNorth.east() - this.x_0) / this.ellps.a / this.k_0, (eastNorth.north() - this.y_0) / this.ellps.a / this.k_0);
        LatLon latLon = new LatLon(Math.toDegrees(dArray[0]), Math.toDegrees(dArray[1]) + this.lon_0);
        if (this.nadgrids != null) {
            NTV2GridShift nTV2GridShift = new NTV2GridShift(latLon);
            this.nadgrids.gridShiftForward(nTV2GridShift);
            latLon = new LatLon(latLon.lat() + nTV2GridShift.getLatShiftDegrees(), latLon.lon() + nTV2GridShift.getLonShiftPositiveEastDegrees());
        } else {
            latLon = this.datum.toWGS84(latLon);
        }
        return latLon;
    }

    public double getDefaultZoomInPPD() {
        return 10.0;
    }

    public abstract Integer getEpsgCode();

    public String toCode() {
        return "EPSG:" + this.getEpsgCode();
    }
}

