/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.imagery.GeorefImage;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.ImageryLayerInfo;
import org.openstreetmap.josm.data.imagery.WmsCache;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.data.projection.Mercator;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.io.imagery.Grabber;
import org.openstreetmap.josm.io.imagery.HTMLGrabber;
import org.openstreetmap.josm.io.imagery.WMSGrabber;
import org.openstreetmap.josm.io.imagery.WMSRequest;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class WMSLayer
extends ImageryLayer
implements Preferences.PreferenceChangedListener {
    public static final BooleanProperty PROP_ALPHA_CHANNEL = new BooleanProperty("imagery.wms.alpha_channel", true);
    public static final IntegerProperty PROP_SIMULTANEOUS_CONNECTIONS = new IntegerProperty("imagery.wms.simultaneousConnections", 3);
    public static final BooleanProperty PROP_OVERLAP = new BooleanProperty("imagery.wms.overlap", false);
    public static final IntegerProperty PROP_OVERLAP_EAST = new IntegerProperty("imagery.wms.overlapEast", 14);
    public static final IntegerProperty PROP_OVERLAP_NORTH = new IntegerProperty("imagery.wms.overlapNorth", 4);
    public int messageNum = 5;
    protected String resolution;
    protected int imageSize = 500;
    protected int dax = 10;
    protected int day = 10;
    protected int daStep = 5;
    protected int minZoom = 3;
    protected GeorefImage[][] images;
    protected final int serializeFormatVersion = 5;
    protected boolean autoDownloadEnabled = true;
    protected boolean settingsChanged;
    protected ImageryInfo info;
    protected final MapView mv;
    public WmsCache cache;
    private volatile int bminx;
    private volatile int bminy;
    private volatile int bmaxx;
    private volatile int bmaxy;
    private volatile int leftEdge;
    private volatile int bottomEdge;
    private final List<WMSRequest> requestQueue = new ArrayList<WMSRequest>();
    private final List<WMSRequest> finishedRequests = new ArrayList<WMSRequest>();
    private final List<WMSRequest> processingRequests = new ArrayList<WMSRequest>();
    private final Lock requestQueueLock = new ReentrantLock();
    private final Condition queueEmpty = this.requestQueueLock.newCondition();
    private final List<Grabber> grabbers = new ArrayList<Grabber>();
    private final List<Thread> grabberThreads = new ArrayList<Thread>();
    private int threadCount;
    private int workingThreadCount;
    private boolean canceled;
    private boolean usesInvalidUrl = false;
    private boolean isInvalidUrlConfirmed = false;

    public WMSLayer() {
        this(new ImageryInfo(I18n.tr("Blank Layer", new Object[0])));
    }

    public WMSLayer(ImageryInfo imageryInfo) {
        super(imageryInfo);
        this.mv = Main.map.mapView;
        this.setBackgroundLayer(true);
        this.initializeImages();
        if (imageryInfo.getUrl() != null) {
            for (WMSLayer wMSLayer : Main.map.mapView.getLayersOfType(WMSLayer.class)) {
                if (!wMSLayer.getInfo().getUrl().equals(imageryInfo.getUrl())) continue;
                this.cache = wMSLayer.cache;
                break;
            }
            if (this.cache == null) {
                this.cache = new WmsCache(imageryInfo.getUrl(), this.imageSize);
                this.cache.loadIndex();
            }
        }
        this.info = new ImageryInfo(imageryInfo);
        if (this.info.getPixelPerDegree() == 0.0) {
            this.info.setPixelPerDegree(this.getPPD());
        }
        this.resolution = this.mv.getDist100PixelText();
        if (imageryInfo.getUrl() != null) {
            this.startGrabberThreads();
        }
        Main.pref.addPreferenceChangeListener(this);
    }

    public void doSetName(String string) {
        this.setName(string);
        this.info.setName(string);
    }

    public boolean hasAutoDownload() {
        return this.autoDownloadEnabled;
    }

    public void destroy() {
        this.cancelGrabberThreads(false);
        Main.pref.removePreferenceChangeListener(this);
        if (this.cache != null) {
            this.cache.saveIndex();
        }
    }

    public void initializeImages() {
        int n;
        int n2;
        GeorefImage[][] georefImageArray = this.images;
        this.images = new GeorefImage[this.dax][this.day];
        if (georefImageArray != null) {
            for (n2 = 0; n2 < georefImageArray.length; ++n2) {
                for (n = 0; n < georefImageArray[n2].length; ++n) {
                    GeorefImage georefImage = georefImageArray[n2][n];
                    this.images[this.modulo((int)georefImage.getXIndex(), (int)this.dax)][this.modulo((int)georefImage.getYIndex(), (int)this.day)] = georefImageArray[n2][n];
                }
            }
        }
        for (n2 = 0; n2 < this.dax; ++n2) {
            for (n = 0; n < this.day; ++n) {
                if (this.images[n2][n] != null) continue;
                this.images[n2][n] = new GeorefImage(this);
            }
        }
    }

    public ImageryInfo getInfo() {
        return this.info;
    }

    public String getToolTipText() {
        if (this.autoDownloadEnabled) {
            return I18n.tr("WMS layer ({0}), automatically downloading in zoom {1}", this.getName(), this.resolution);
        }
        return I18n.tr("WMS layer ({0}), downloading in zoom {1}", this.getName(), this.resolution);
    }

    private int modulo(int n, int n2) {
        return n % n2 >= 0 ? n % n2 : n % n2 + n2;
    }

    private boolean zoomIsTooBig() {
        return this.info.getPixelPerDegree() / this.getPPD() > (double)this.minZoom;
    }

    public void paint(Graphics2D graphics2D, MapView mapView, Bounds bounds) {
        if (this.info.getUrl() == null || this.usesInvalidUrl && !this.isInvalidUrlConfirmed) {
            return;
        }
        this.settingsChanged = false;
        ProjectionBounds projectionBounds = mapView.getProjectionBounds();
        this.bminx = this.getImageXIndex(projectionBounds.minEast);
        this.bminy = this.getImageYIndex(projectionBounds.minNorth);
        this.bmaxx = this.getImageXIndex(projectionBounds.maxEast);
        this.bmaxy = this.getImageYIndex(projectionBounds.maxNorth);
        this.leftEdge = (int)(projectionBounds.minEast * this.getPPD());
        this.bottomEdge = (int)(projectionBounds.minNorth * this.getPPD());
        if (this.zoomIsTooBig()) {
            for (int i = 0; i < this.images.length; ++i) {
                for (int j = 0; j < this.images[0].length; ++j) {
                    GeorefImage georefImage = this.images[i][j];
                    georefImage.paint(graphics2D, mapView, georefImage.getXIndex(), georefImage.getYIndex(), this.leftEdge, this.bottomEdge);
                }
            }
        } else {
            this.downloadAndPaintVisible(graphics2D, mapView, false);
        }
    }

    public void setOffset(double d, double d2) {
        super.setOffset(d, d2);
        this.settingsChanged = true;
    }

    public int getImageXIndex(double d) {
        return (int)Math.floor((d - this.dx) * this.info.getPixelPerDegree() / (double)this.imageSize);
    }

    public int getImageYIndex(double d) {
        return (int)Math.floor((d - this.dy) * this.info.getPixelPerDegree() / (double)this.imageSize);
    }

    public int getImageX(int n) {
        return (int)((double)(n * this.imageSize) * (this.getPPD() / this.info.getPixelPerDegree()) + this.dx * this.getPPD());
    }

    public int getImageY(int n) {
        return (int)((double)(n * this.imageSize) * (this.getPPD() / this.info.getPixelPerDegree()) + this.dy * this.getPPD());
    }

    public int getImageWidth(int n) {
        return this.getImageX(n + 1) - this.getImageX(n);
    }

    public int getImageHeight(int n) {
        return this.getImageY(n + 1) - this.getImageY(n);
    }

    public int getBaseImageWidth() {
        int n = PROP_OVERLAP.get() ? PROP_OVERLAP_EAST.get() * this.imageSize / 100 : 0;
        return this.imageSize + n;
    }

    public int getBaseImageHeight() {
        int n = PROP_OVERLAP.get() ? PROP_OVERLAP_NORTH.get() * this.imageSize / 100 : 0;
        return this.imageSize + n;
    }

    public int getImageSize() {
        return this.imageSize;
    }

    public boolean isOverlapEnabled() {
        return PROP_OVERLAP.get() && (PROP_OVERLAP_EAST.get() > 0 || PROP_OVERLAP_NORTH.get() > 0);
    }

    public BufferedImage normalizeImage(BufferedImage bufferedImage) {
        if (this.isOverlapEnabled()) {
            BufferedImage bufferedImage2 = bufferedImage;
            bufferedImage = new BufferedImage(this.imageSize, this.imageSize, bufferedImage2.getType());
            bufferedImage.createGraphics().drawImage(bufferedImage2, 0, 0, this.imageSize, this.imageSize, 0, bufferedImage2.getHeight() - this.imageSize, this.imageSize, bufferedImage2.getHeight(), null);
        }
        return bufferedImage;
    }

    public EastNorth getEastNorth(int n, int n2) {
        return new EastNorth((double)(n * this.imageSize) / this.info.getPixelPerDegree(), (double)(n2 * this.imageSize) / this.info.getPixelPerDegree());
    }

    protected void downloadAndPaintVisible(Graphics graphics, MapView mapView, boolean bl) {
        int n;
        int n2 = this.dax;
        int n3 = this.day;
        if (this.bmaxx - this.bminx >= this.dax || this.bmaxx - this.bminx < this.dax - 2 * this.daStep) {
            n2 = ((this.bmaxx - this.bminx) / this.daStep + 1) * this.daStep;
        }
        if (this.bmaxy - this.bminy >= this.day || this.bmaxy - this.bminx < this.day - 2 * this.daStep) {
            n3 = ((this.bmaxy - this.bminy) / this.daStep + 1) * this.daStep;
        }
        if (n2 != this.dax || n3 != this.day) {
            this.dax = n2;
            this.day = n3;
            this.initializeImages();
        }
        for (int i = this.bminx; i <= this.bmaxx; ++i) {
            for (n = this.bminy; n <= this.bmaxy; ++n) {
                this.images[this.modulo(i, this.dax)][this.modulo(n, this.day)].changePosition(i, n);
            }
        }
        this.gatherFinishedRequests();
        HashSet<ProjectionBounds> hashSet = new HashSet<ProjectionBounds>();
        for (n = this.bminx; n <= this.bmaxx; ++n) {
            for (int i = this.bminy; i <= this.bmaxy; ++i) {
                WMSRequest wMSRequest;
                GeorefImage georefImage = this.images[this.modulo(n, this.dax)][this.modulo(i, this.day)];
                if (!georefImage.paint(graphics, mapView, n, i, this.leftEdge, this.bottomEdge)) {
                    wMSRequest = new WMSRequest(n, i, this.info.getPixelPerDegree(), bl, true);
                    this.addRequest(wMSRequest);
                    hashSet.add(new ProjectionBounds(this.getEastNorth(n, i), this.getEastNorth(n + 1, i + 1)));
                    continue;
                }
                if (georefImage.getState() != GeorefImage.State.PARTLY_IN_CACHE || !this.autoDownloadEnabled) continue;
                wMSRequest = new WMSRequest(n, i, this.info.getPixelPerDegree(), bl, false);
                this.addRequest(wMSRequest);
                hashSet.add(new ProjectionBounds(this.getEastNorth(n, i), this.getEastNorth(n + 1, i + 1)));
            }
        }
        this.cache.setAreaToCache(hashSet);
    }

    public void visitBoundingBox(BoundingXYVisitor boundingXYVisitor) {
        for (int i = 0; i < this.dax; ++i) {
            for (int j = 0; j < this.day; ++j) {
                if (this.images[i][j].getImage() == null) continue;
                boundingXYVisitor.visit(this.images[i][j].getMin());
                boundingXYVisitor.visit(this.images[i][j].getMax());
            }
        }
    }

    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createActivateLayerAction(this), LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), Layer.SeparatorLayerAction.INSTANCE, new ImageryLayer.OffsetAction(), new LoadWmsAction(), new SaveWmsAction(), new BookmarkWmsAction(), Layer.SeparatorLayerAction.INSTANCE, new ZoomToNativeResolution(), new StartStopAction(), new ToggleAlphaAction(), new ChangeResolutionAction(), new ReloadErrorTilesAction(), new DownloadAction(), Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction(this)};
    }

    public GeorefImage findImage(EastNorth eastNorth) {
        int n = this.getImageXIndex(eastNorth.east());
        int n2 = this.getImageYIndex(eastNorth.north());
        GeorefImage georefImage = this.images[this.modulo(n, this.dax)][this.modulo(n2, this.day)];
        if (georefImage.getXIndex() == n && georefImage.getYIndex() == n2) {
            return georefImage;
        }
        return null;
    }

    private int getRequestPriority(WMSRequest wMSRequest) {
        if (wMSRequest.getPixelPerDegree() != this.info.getPixelPerDegree()) {
            return -1;
        }
        if (this.bminx > wMSRequest.getXIndex() || this.bmaxx < wMSRequest.getXIndex() || this.bminy > wMSRequest.getYIndex() || this.bmaxy < wMSRequest.getYIndex()) {
            return -1;
        }
        EastNorth eastNorth = this.mv.getEastNorth(this.mv.lastMEvent.getX(), this.mv.lastMEvent.getY());
        int n = this.getImageXIndex(eastNorth.east());
        int n2 = this.getImageYIndex(eastNorth.north());
        int n3 = wMSRequest.getXIndex() - n;
        int n4 = wMSRequest.getYIndex() - n2;
        return n3 * n3 + n4 * n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WMSRequest getRequest() {
        this.requestQueueLock.lock();
        try {
            boolean bl;
            int n;
            Object object;
            --this.workingThreadCount;
            Iterator<WMSRequest> iterator = this.requestQueue.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                n = this.getRequestPriority((WMSRequest)object);
                if (n == -1 || this.finishedRequests.contains(object) || this.processingRequests.contains(object)) {
                    iterator.remove();
                    continue;
                }
                ((WMSRequest)object).setPriority(n);
            }
            Collections.sort(this.requestQueue);
            object = this.mv.getEastNorth(this.mv.lastMEvent.getX(), this.mv.lastMEvent.getY());
            n = this.getImageXIndex(((EastNorth)object).east());
            int n2 = this.getImageYIndex(((EastNorth)object).north());
            boolean bl2 = bl = this.requestQueue.size() > 0 && this.requestQueue.get(0).getXIndex() == n && this.requestQueue.get(0).getYIndex() == n2;
            while (!this.canceled && (this.requestQueue.isEmpty() || !bl && this.threadCount - this.workingThreadCount == 0 && this.threadCount > 1)) {
                try {
                    this.queueEmpty.await();
                }
                catch (InterruptedException interruptedException) {}
            }
            ++this.workingThreadCount;
            if (this.canceled) {
                WMSRequest wMSRequest = null;
                return wMSRequest;
            }
            WMSRequest wMSRequest = this.requestQueue.remove(0);
            this.processingRequests.add(wMSRequest);
            WMSRequest wMSRequest2 = wMSRequest;
            return wMSRequest2;
        }
        finally {
            this.requestQueueLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishRequest(WMSRequest wMSRequest) {
        this.requestQueueLock.lock();
        try {
            this.processingRequests.remove(wMSRequest);
            if (wMSRequest.getState() != null) {
                this.finishedRequests.add(wMSRequest);
                this.mv.repaint();
            }
        }
        finally {
            this.requestQueueLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequest(WMSRequest wMSRequest) {
        this.requestQueueLock.lock();
        try {
            if (!(this.requestQueue.contains(wMSRequest) || this.finishedRequests.contains(wMSRequest) || this.processingRequests.contains(wMSRequest))) {
                this.requestQueue.add(wMSRequest);
                this.queueEmpty.signalAll();
            }
        }
        finally {
            this.requestQueueLock.unlock();
        }
    }

    public boolean requestIsValid(WMSRequest wMSRequest) {
        return this.bminx <= wMSRequest.getXIndex() && this.bmaxx >= wMSRequest.getXIndex() && this.bminy <= wMSRequest.getYIndex() && this.bmaxy >= wMSRequest.getYIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gatherFinishedRequests() {
        this.requestQueueLock.lock();
        try {
            for (WMSRequest wMSRequest : this.finishedRequests) {
                GeorefImage georefImage = this.images[this.modulo(wMSRequest.getXIndex(), this.dax)][this.modulo(wMSRequest.getYIndex(), this.day)];
                if (!georefImage.equalPosition(wMSRequest.getXIndex(), wMSRequest.getYIndex())) continue;
                georefImage.changeImage(wMSRequest.getState(), wMSRequest.getImage());
            }
        }
        finally {
            this.requestQueueLock.unlock();
            this.finishedRequests.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelGrabberThreads(boolean bl) {
        this.requestQueueLock.lock();
        try {
            this.canceled = true;
            for (Grabber runnable : this.grabbers) {
                runnable.cancel();
            }
            this.queueEmpty.signalAll();
        }
        finally {
            this.requestQueueLock.unlock();
        }
        if (bl) {
            for (Thread thread : this.grabberThreads) {
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startGrabberThreads() {
        int n = PROP_SIMULTANEOUS_CONNECTIONS.get();
        this.requestQueueLock.lock();
        try {
            this.canceled = false;
            this.grabbers.clear();
            this.grabberThreads.clear();
            for (int i = 0; i < n; ++i) {
                Grabber grabber = this.getGrabber();
                this.grabbers.add(grabber);
                Thread thread = new Thread((Runnable)grabber, "WMS " + this.getName() + " " + i);
                thread.setDaemon(true);
                thread.start();
                this.grabberThreads.add(thread);
            }
            this.workingThreadCount = this.grabbers.size();
            this.threadCount = this.grabbers.size();
        }
        finally {
            this.requestQueueLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isChanged() {
        this.requestQueueLock.lock();
        try {
            boolean bl = !this.finishedRequests.isEmpty() || this.settingsChanged;
            return bl;
        }
        finally {
            this.requestQueueLock.unlock();
        }
    }

    public void preferenceChanged(Preferences.PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getKey().equals(PROP_SIMULTANEOUS_CONNECTIONS.getKey())) {
            this.cancelGrabberThreads(true);
            this.startGrabberThreads();
        } else if (preferenceChangeEvent.getKey().equals(PROP_OVERLAP.getKey()) || preferenceChangeEvent.getKey().equals(PROP_OVERLAP_EAST.getKey()) || preferenceChangeEvent.getKey().equals(PROP_OVERLAP_NORTH.getKey())) {
            for (int i = 0; i < this.images.length; ++i) {
                for (int j = 0; j < this.images[i].length; ++j) {
                    this.images[i][j] = new GeorefImage(this);
                }
            }
            this.settingsChanged = true;
        }
    }

    protected Grabber getGrabber() {
        if (this.getInfo().getImageryType() == ImageryInfo.ImageryType.HTML) {
            return new HTMLGrabber(this.mv, this);
        }
        if (this.getInfo().getImageryType() == ImageryInfo.ImageryType.WMS) {
            return new WMSGrabber(this.mv, this);
        }
        throw new IllegalStateException("getGrabber() called for non-WMS layer type");
    }

    public boolean isProjectionSupported(Projection projection) {
        List<String> list = this.info.getServerProjections();
        return list.contains(projection.toCode().toUpperCase()) || projection instanceof Mercator && list.contains("EPSG:4326");
    }

    public String nameSupportedProjections() {
        String string = "";
        for (String string2 : this.info.getServerProjections()) {
            if (!string.isEmpty()) {
                string = string + ", ";
            }
            string = string + string2;
        }
        return I18n.tr("Supported projections are: {0}", string);
    }

    private class ZoomToNativeResolution
    extends AbstractAction {
        public ZoomToNativeResolution() {
            super(I18n.tr("Zoom to native resolution", new Object[0]));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Main.map.mapView.zoomTo(Main.map.mapView.getCenter(), 1.0 / WMSLayer.this.info.getPixelPerDegree());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StartStopAction
    extends AbstractAction
    implements Layer.LayerAction {
        public StartStopAction() {
            super(I18n.tr("Automatic downloading", new Object[0]));
        }

        @Override
        public Component createMenuComponent() {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this);
            jCheckBoxMenuItem.setSelected(WMSLayer.this.autoDownloadEnabled);
            return jCheckBoxMenuItem;
        }

        @Override
        public boolean supportLayers(List<Layer> list) {
            return list.size() == 1 && list.get(0) instanceof WMSLayer;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = WMSLayer.this.autoDownloadEnabled = !WMSLayer.this.autoDownloadEnabled;
            if (WMSLayer.this.autoDownloadEnabled) {
                for (int i = 0; i < WMSLayer.this.dax; ++i) {
                    for (int j = 0; j < WMSLayer.this.day; ++j) {
                        GeorefImage georefImage = WMSLayer.this.images[WMSLayer.this.modulo(i, WMSLayer.this.dax)][WMSLayer.this.modulo(j, WMSLayer.this.day)];
                        if (georefImage.getState() != GeorefImage.State.NOT_IN_CACHE) continue;
                        WMSLayer.this.addRequest(new WMSRequest(georefImage.getXIndex(), georefImage.getYIndex(), WMSLayer.this.info.getPixelPerDegree(), false, true));
                    }
                }
                WMSLayer.this.mv.repaint();
            }
        }
    }

    public class BookmarkWmsAction
    extends AbstractAction {
        public BookmarkWmsAction() {
            super(I18n.tr("Set WMS Bookmark", new Object[0]));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImageryLayerInfo.addLayer(new ImageryInfo(WMSLayer.this.info));
        }
    }

    public class LoadWmsAction
    extends AbstractAction {
        public LoadWmsAction() {
            super(I18n.tr("Load WMS layer from file", new Object[0]), ImageProvider.get("open"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = DiskAccessAction.createAndOpenFileChooser(true, false, I18n.tr("Load WMS layer", new Object[0]), "wms");
            if (jFileChooser == null) {
                return;
            }
            File file = jFileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                int n = objectInputStream.readInt();
                if (n != 5) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Unsupported WMS file version; found {0}, expected {1}", n, 5), I18n.tr("File Format Error", new Object[0]), 0);
                    return;
                }
                WMSLayer.this.autoDownloadEnabled = false;
                WMSLayer.this.dax = objectInputStream.readInt();
                WMSLayer.this.day = objectInputStream.readInt();
                WMSLayer.this.imageSize = objectInputStream.readInt();
                WMSLayer.this.info.setPixelPerDegree(objectInputStream.readDouble());
                WMSLayer.this.doSetName((String)objectInputStream.readObject());
                WMSLayer.this.info.setExtendedUrl((String)objectInputStream.readObject());
                WMSLayer.this.images = (GeorefImage[][])objectInputStream.readObject();
                objectInputStream.close();
                fileInputStream.close();
                GeorefImage[][] georefImageArray = WMSLayer.this.images;
                int n2 = georefImageArray.length;
                for (int i = 0; i < n2; ++i) {
                    GeorefImage[] georefImageArray2;
                    for (GeorefImage georefImage : georefImageArray2 = georefImageArray[i]) {
                        if (georefImage == null) continue;
                        georefImage.setLayer(WMSLayer.this);
                    }
                }
                WMSLayer.this.settingsChanged = true;
                WMSLayer.this.mv.repaint();
                if (WMSLayer.this.cache != null) {
                    WMSLayer.this.cache.saveIndex();
                    WMSLayer.this.cache = null;
                }
                if (WMSLayer.this.info.getUrl() != null) {
                    WMSLayer.this.cache = new WmsCache(WMSLayer.this.info.getUrl(), WMSLayer.this.imageSize);
                    WMSLayer.this.startGrabberThreads();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Error loading file", new Object[0]), I18n.tr("Error", new Object[0]), 0);
                return;
            }
        }
    }

    public class SaveWmsAction
    extends AbstractAction {
        public SaveWmsAction() {
            super(I18n.tr("Save WMS layer to file", new Object[0]), ImageProvider.get("save"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file = SaveActionBase.createAndOpenSaveFileChooser(I18n.tr("Save WMS layer", new Object[0]), ".wms");
            try {
                if (file != null) {
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
                    objectOutputStream.writeInt(5);
                    objectOutputStream.writeInt(WMSLayer.this.dax);
                    objectOutputStream.writeInt(WMSLayer.this.day);
                    objectOutputStream.writeInt(WMSLayer.this.imageSize);
                    objectOutputStream.writeDouble(WMSLayer.this.info.getPixelPerDegree());
                    objectOutputStream.writeObject(WMSLayer.this.info.getName());
                    objectOutputStream.writeObject(WMSLayer.this.info.getExtendedUrl());
                    objectOutputStream.writeObject(WMSLayer.this.images);
                    objectOutputStream.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ToggleAlphaAction
    extends AbstractAction
    implements Layer.LayerAction {
        public ToggleAlphaAction() {
            super(I18n.tr("Alpha channel", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
            boolean bl = jCheckBoxMenuItem.isSelected();
            PROP_ALPHA_CHANNEL.put(bl);
            for (int i = 0; i < WMSLayer.this.dax; ++i) {
                for (int j = 0; j < WMSLayer.this.day; ++j) {
                    GeorefImage georefImage = WMSLayer.this.images[WMSLayer.this.modulo(i, WMSLayer.this.dax)][WMSLayer.this.modulo(j, WMSLayer.this.day)];
                    georefImage.flushedResizedCachedInstance();
                }
            }
            WMSLayer.this.mv.repaint();
        }

        @Override
        public Component createMenuComponent() {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this);
            jCheckBoxMenuItem.setSelected(PROP_ALPHA_CHANNEL.get());
            return jCheckBoxMenuItem;
        }

        @Override
        public boolean supportLayers(List<Layer> list) {
            return list.size() == 1 && list.get(0) instanceof WMSLayer;
        }
    }

    public class ReloadErrorTilesAction
    extends AbstractAction {
        public ReloadErrorTilesAction() {
            super(I18n.tr("Reload erroneous tiles", new Object[0]));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WMSLayer.this.cache.cleanSmallFiles(4096);
            for (int i = 0; i < WMSLayer.this.dax; ++i) {
                for (int j = 0; j < WMSLayer.this.day; ++j) {
                    GeorefImage georefImage = WMSLayer.this.images[WMSLayer.this.modulo(i, WMSLayer.this.dax)][WMSLayer.this.modulo(j, WMSLayer.this.day)];
                    if (georefImage.getState() != GeorefImage.State.FAILED) continue;
                    WMSLayer.this.addRequest(new WMSRequest(georefImage.getXIndex(), georefImage.getYIndex(), WMSLayer.this.info.getPixelPerDegree(), true, false));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeResolutionAction
    extends AbstractAction
    implements Layer.LayerAction {
        public ChangeResolutionAction() {
            super(I18n.tr("Change resolution", new Object[0]));
        }

        private void changeResolution(WMSLayer wMSLayer) {
            wMSLayer.resolution = wMSLayer.mv.getDist100PixelText();
            wMSLayer.info.setPixelPerDegree(wMSLayer.getPPD());
            wMSLayer.settingsChanged = true;
            for (int i = 0; i < wMSLayer.dax; ++i) {
                for (int j = 0; j < wMSLayer.day; ++j) {
                    wMSLayer.images[i][j].changePosition(-1, -1);
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (LayerListDialog.getInstance() == null) {
                return;
            }
            List<Layer> list = LayerListDialog.getInstance().getModel().getSelectedLayers();
            for (Layer layer : list) {
                this.changeResolution((WMSLayer)layer);
            }
            Main.map.mapView.repaint();
        }

        @Override
        public boolean supportLayers(List<Layer> list) {
            for (Layer layer : list) {
                if (layer instanceof WMSLayer) continue;
                return false;
            }
            return true;
        }

        @Override
        public Component createMenuComponent() {
            return new JMenuItem(this);
        }

        public boolean equals(Object object) {
            return object instanceof ChangeResolutionAction;
        }
    }

    public class DownloadAction
    extends AbstractAction {
        private static final long serialVersionUID = -7183852461015284020L;

        public DownloadAction() {
            super(I18n.tr("Download visible tiles", new Object[0]));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (WMSLayer.this.zoomIsTooBig()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("The requested area is too big. Please zoom in a little, or change resolution", new Object[0]), I18n.tr("Error", new Object[0]), 0);
            } else {
                WMSLayer.this.downloadAndPaintVisible(WMSLayer.this.mv.getGraphics(), WMSLayer.this.mv, true);
            }
        }
    }
}

