/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.dialogs.DialogsPanel;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.ImageDisplay;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;

public class ImageViewerDialog
extends ToggleDialog {
    private static final String COMMAND_ZOOM = "zoom";
    private static final String COMMAND_CENTERVIEW = "centre";
    private static final String COMMAND_NEXT = "next";
    private static final String COMMAND_REMOVE = "remove";
    private static final String COMMAND_REMOVE_FROM_DISK = "removefromdisk";
    private static final String COMMAND_PREVIOUS = "previous";
    private static final String COMMAND_COLLAPSE = "collapse";
    private ImageDisplay imgDisplay = new ImageDisplay();
    private boolean centerView = false;
    private static ImageViewerDialog dialog;
    private boolean collapseButtonClicked = false;
    private JButton btnNext;
    private JButton btnPrevious;
    private JButton btnCollapse;
    private GeoImageLayer currentLayer = null;
    private ImageEntry currentEntry = null;

    static void newInstance() {
        dialog = new ImageViewerDialog();
    }

    public static ImageViewerDialog getInstance() {
        if (dialog == null) {
            throw new AssertionError();
        }
        return dialog;
    }

    private ImageViewerDialog() {
        super(I18n.tr("Geotagged Images", new Object[0]), "geoimage", I18n.tr("Display geotagged images", new Object[0]), Shortcut.registerShortcut("tools:geotagged", I18n.tr("Tool: {0}", I18n.tr("Display geotagged images", new Object[0])), 89, 3), 200);
        if (this.isShowing && !this.isDocked) {
            this.setIsShowing(false);
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.imgDisplay, "Center");
        Dimension dimension = new Dimension(26, 26);
        ImageAction imageAction = new ImageAction(COMMAND_PREVIOUS, ImageProvider.get("dialogs", COMMAND_PREVIOUS), I18n.tr("Previous", new Object[0]));
        this.btnPrevious = new JButton(imageAction);
        this.btnPrevious.setPreferredSize(dimension);
        Shortcut shortcut = Shortcut.registerShortcut("geoimage:previous", I18n.tr("Geoimage: {0}", I18n.tr("Show previous Image", new Object[0])), 33, 5);
        Main.registerActionShortcut((Action)imageAction, shortcut);
        this.btnPrevious.getInputMap(2).put(shortcut.getKeyStroke(), "Previous Image");
        this.btnPrevious.getActionMap().put("Previous Image", imageAction);
        String string = I18n.tr("Remove photo from layer", new Object[0]);
        ImageAction imageAction2 = new ImageAction(COMMAND_REMOVE, ImageProvider.get("dialogs", "delete"), string);
        JButton jButton = new JButton(imageAction2);
        jButton.setPreferredSize(dimension);
        Shortcut shortcut2 = Shortcut.registerShortcut("geoimage:deleteimagefromlayer", I18n.tr("Geoimage: {0}", string), 127, 5, 1);
        Main.registerActionShortcut((Action)imageAction2, shortcut2);
        jButton.getInputMap(2).put(shortcut2.getKeyStroke(), string);
        jButton.getActionMap().put(string, imageAction2);
        ImageAction imageAction3 = new ImageAction(COMMAND_REMOVE_FROM_DISK, ImageProvider.get("dialogs", "geoimage/deletefromdisk"), I18n.tr("Delete image file from disk", new Object[0]));
        JButton jButton2 = new JButton(imageAction3);
        jButton2.setPreferredSize(dimension);
        Shortcut shortcut3 = Shortcut.registerShortcut("geoimage:deletefilefromdisk", I18n.tr("Geoimage: {0}", I18n.tr("Delete File from disk", new Object[0])), 127, 5, 3);
        Main.registerActionShortcut((Action)imageAction3, shortcut3);
        jButton2.getInputMap(2).put(shortcut3.getKeyStroke(), "Delete image file from disk");
        jButton2.getActionMap().put("Delete image file from disk", imageAction3);
        ImageAction imageAction4 = new ImageAction(COMMAND_NEXT, ImageProvider.get("dialogs", COMMAND_NEXT), I18n.tr("Next", new Object[0]));
        this.btnNext = new JButton(imageAction4);
        this.btnNext.setPreferredSize(dimension);
        Shortcut shortcut4 = Shortcut.registerShortcut("geoimage:next", I18n.tr("Geoimage: {0}", I18n.tr("Show next Image", new Object[0])), 34, 5);
        Main.registerActionShortcut((Action)imageAction4, shortcut4);
        this.btnNext.getInputMap(2).put(shortcut4.getKeyStroke(), "Next Image");
        this.btnNext.getActionMap().put("Next Image", imageAction4);
        JToggleButton jToggleButton = new JToggleButton(new ImageAction(COMMAND_CENTERVIEW, ImageProvider.get("dialogs", "centreview"), I18n.tr("Center view", new Object[0])));
        jToggleButton.setPreferredSize(dimension);
        JButton jButton3 = new JButton(new ImageAction(COMMAND_ZOOM, ImageProvider.get("dialogs", "zoom-best-fit"), I18n.tr("Zoom best fit and 1:1", new Object[0])));
        jButton3.setPreferredSize(dimension);
        this.btnCollapse = new JButton(new ImageAction(COMMAND_COLLAPSE, ImageProvider.get("dialogs", COMMAND_COLLAPSE), I18n.tr("Move dialog to the side pane", new Object[0])));
        this.btnCollapse.setPreferredSize(new Dimension(20, 20));
        this.btnCollapse.setAlignmentY(0.0f);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.btnPrevious);
        jPanel2.add(this.btnNext);
        jPanel2.add(Box.createRigidArea(new Dimension(14, 0)));
        jPanel2.add(jToggleButton);
        jPanel2.add(jButton3);
        jPanel2.add(Box.createRigidArea(new Dimension(14, 0)));
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        jPanel3.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 20;
        gridBagConstraints.weightx = 0.0;
        jPanel3.add((Component)this.btnCollapse, gridBagConstraints);
        jPanel.add((Component)jPanel3, "South");
        this.add((Component)jPanel, "Center");
    }

    public static void showImage(GeoImageLayer geoImageLayer, ImageEntry imageEntry) {
        ImageViewerDialog.getInstance().displayImage(geoImageLayer, imageEntry);
        geoImageLayer.checkPreviousNextButtons();
    }

    public static void setPreviousEnabled(Boolean bl) {
        ImageViewerDialog.getInstance().btnPrevious.setEnabled(bl);
    }

    public static void setNextEnabled(Boolean bl) {
        ImageViewerDialog.getInstance().btnNext.setEnabled(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void displayImage(GeoImageLayer geoImageLayer, ImageEntry imageEntry) {
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.centerView && Main.map != null && imageEntry != null && imageEntry.getPos() != null) {
                Main.map.mapView.zoomTo(imageEntry.getPos());
            }
            this.currentLayer = geoImageLayer;
            this.currentEntry = imageEntry;
        }
        if (imageEntry != null) {
            this.imgDisplay.setImage(imageEntry.getFile(), imageEntry.getExifOrientation());
            this.setTitle("Geotagged Images" + (imageEntry.getFile() != null ? " - " + imageEntry.getFile().getName() : ""));
            serializable = new StringBuffer(imageEntry.getFile() != null ? imageEntry.getFile().getName() : "");
            if (imageEntry.getElevation() != null) {
                ((StringBuffer)serializable).append(I18n.tr("\nAltitude: {0} m", imageEntry.getElevation().longValue()));
            }
            if (imageEntry.getSpeed() != null) {
                ((StringBuffer)serializable).append(I18n.tr("\n{0} km/h", Math.round(imageEntry.getSpeed())));
            }
            if (imageEntry.getExifImgDir() != null) {
                ((StringBuffer)serializable).append(I18n.tr("\nDirection {0}\u00b0", Math.round(imageEntry.getExifImgDir())));
            }
            this.imgDisplay.setOsdText(((StringBuffer)serializable).toString());
        } else {
            this.imgDisplay.setImage(null, null);
            this.imgDisplay.setOsdText("");
        }
        if (!this.isDialogShowing()) {
            this.setIsDocked(false);
            this.showDialog();
        } else if (this.isDocked && this.isCollapsed) {
            this.expand();
            this.dialogsPanel.reconstruct(DialogsPanel.Action.COLLAPSED_TO_DEFAULT, this);
        }
    }

    protected void toggleButtonHook() {
        if (!this.isShowing) {
            this.setIsDocked(true);
            this.setIsCollapsed(false);
        }
    }

    protected boolean dockWhenClosingDetachedDlg() {
        if (this.collapseButtonClicked) {
            this.collapseButtonClicked = false;
            return true;
        }
        return false;
    }

    protected void stateChanged() {
        super.stateChanged();
        if (this.btnCollapse != null) {
            this.btnCollapse.setVisible(!this.isDocked);
        }
    }

    public boolean hasImage() {
        return this.currentEntry != null;
    }

    class ImageAction
    extends AbstractAction {
        private final String action;

        public ImageAction(String string, ImageIcon imageIcon, String string2) {
            this.action = string;
            this.putValue("ShortDescription", string2);
            this.putValue("SmallIcon", imageIcon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ImageViewerDialog.COMMAND_NEXT.equals(this.action)) {
                if (ImageViewerDialog.this.currentLayer != null) {
                    ImageViewerDialog.this.currentLayer.showNextPhoto();
                }
            } else if (ImageViewerDialog.COMMAND_PREVIOUS.equals(this.action)) {
                if (ImageViewerDialog.this.currentLayer != null) {
                    ImageViewerDialog.this.currentLayer.showPreviousPhoto();
                }
            } else if (ImageViewerDialog.COMMAND_CENTERVIEW.equals(this.action)) {
                ImageViewerDialog.this.centerView = ((JToggleButton)actionEvent.getSource()).isSelected();
                if (ImageViewerDialog.this.centerView && ImageViewerDialog.this.currentEntry != null && ImageViewerDialog.this.currentEntry.getPos() != null) {
                    Main.map.mapView.zoomTo(ImageViewerDialog.this.currentEntry.getPos());
                }
            } else if (ImageViewerDialog.COMMAND_ZOOM.equals(this.action)) {
                ImageViewerDialog.this.imgDisplay.zoomBestFitOrOne();
            } else if (ImageViewerDialog.COMMAND_REMOVE.equals(this.action)) {
                if (ImageViewerDialog.this.currentLayer != null) {
                    ImageViewerDialog.this.currentLayer.removeCurrentPhoto();
                }
            } else if (ImageViewerDialog.COMMAND_REMOVE_FROM_DISK.equals(this.action)) {
                if (ImageViewerDialog.this.currentLayer != null) {
                    ImageViewerDialog.this.currentLayer.removeCurrentPhotoFromDisk();
                }
            } else if (ImageViewerDialog.COMMAND_COLLAPSE.equals(this.action)) {
                ImageViewerDialog.this.collapseButtonClicked = true;
                ImageViewerDialog.this.detachedDialog.getToolkit().getSystemEventQueue().postEvent(new WindowEvent(ImageViewerDialog.this.detachedDialog, 201));
            }
        }
    }
}

