/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.GpxReader;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class BoundingBoxDownloader
extends OsmServerReader {
    private final double lat1;
    private final double lon1;
    private final double lat2;
    private final double lon2;

    public BoundingBoxDownloader(Bounds bounds) {
        this.lat1 = bounds.getMin().lat();
        this.lon1 = bounds.getMin().lon();
        this.lat2 = bounds.getMax().lat();
        this.lon2 = bounds.getMax().lon();
    }

    public GpxData parseRawGps(ProgressMonitor progressMonitor) throws IOException, SAXException, OsmTransferException {
        progressMonitor.beginTask("", 1);
        try {
            progressMonitor.indeterminateSubTask(I18n.tr("Contacting OSM Server...", new Object[0]));
            String string = "trackpoints?bbox=" + this.lon1 + "," + this.lat1 + "," + this.lon2 + "," + this.lat2 + "&page=";
            boolean bl = false;
            GpxData gpxData = null;
            int n = 0;
            while (!bl) {
                progressMonitor.subTask(I18n.tr("Downloading points {0} to {1}...", n * 5000, (n + 1) * 5000));
                InputStream inputStream = this.getInputStream(string + n, progressMonitor.createSubTaskMonitor(1, true));
                if (inputStream == null) break;
                progressMonitor.setTicks(0);
                GpxReader gpxReader = new GpxReader(inputStream);
                gpxReader.parse(false);
                GpxData gpxData2 = gpxReader.data;
                if (gpxData == null) {
                    gpxData = gpxData2;
                } else if (gpxData2.hasTrackPoints()) {
                    gpxData.mergeFrom(gpxData2);
                } else {
                    bl = true;
                }
                inputStream.close();
                this.activeConnection = null;
                ++n;
            }
            gpxData.fromServer = true;
            GpxData gpxData3 = gpxData;
            return gpxData3;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (this.cancel) {
                GpxData gpxData = null;
                return gpxData;
            }
            throw new SAXException("Illegal characters within the HTTP-header response.", illegalArgumentException);
        }
        catch (IOException iOException) {
            if (this.cancel) {
                GpxData gpxData = null;
                return gpxData;
            }
            throw iOException;
        }
        catch (SAXException sAXException) {
            throw sAXException;
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
        catch (RuntimeException runtimeException) {
            if (this.cancel) {
                GpxData gpxData = null;
                return gpxData;
            }
            throw runtimeException;
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        progressMonitor.beginTask(I18n.tr("Contacting OSM Server...", new Object[0]), 10);
        InputStream inputStream = null;
        try {
            progressMonitor.indeterminateSubTask(null);
            inputStream = this.getInputStream("map?bbox=" + this.lon1 + "," + this.lat1 + "," + this.lon2 + "," + this.lat2, progressMonitor.createSubTaskMonitor(9, false));
            if (inputStream == null) {
                DataSet dataSet = null;
                return dataSet;
            }
            DataSet dataSet = OsmReader.parseDataSet(inputStream, progressMonitor.createSubTaskMonitor(1, false));
            return dataSet;
        }
        catch (OsmTransferException osmTransferException) {
            throw osmTransferException;
        }
        catch (Exception exception) {
            throw new OsmTransferException(exception);
        }
        finally {
            progressMonitor.finishTask();
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            this.activeConnection = null;
        }
    }
}

