/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGUniverse;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.plugins.PluginHandler;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageResource;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageProvider {
    private static SVGUniverse svgUniverse;
    private static Map<String, ImageResource> cache;
    static final double DEGREE_90 = 1.5707963267948966;

    public static ImageIcon get(String string, String string2) {
        ImageIcon imageIcon = ImageProvider.getIfAvailable(string, string2);
        if (imageIcon == null) {
            String string3 = string2.indexOf(46) != -1 ? "" : ".???";
            throw new NullPointerException(I18n.tr("Fatal: failed to locate image ''{0}''. This is a serious configuration problem. JOSM will stop working.", string2 + string3));
        }
        return imageIcon;
    }

    public static ImageIcon get(String string) {
        return ImageProvider.get("", string);
    }

    public static ImageIcon getIfAvailable(String string, String string2) {
        return ImageProvider.getIfAvailable((Collection<String>)null, null, string, string2);
    }

    public static ImageIcon getIfAvailable(String[] stringArray, String string, String string2, String string3) {
        return ImageProvider.getIfAvailable(Arrays.asList(stringArray), string, string2, string3);
    }

    public static ImageIcon getIfAvailable(Collection<String> collection, String string, String string2, String string3) {
        return ImageProvider.getIfAvailable(collection, string, string2, string3, null);
    }

    public static ImageIcon getIfAvailable(Collection<String> collection, String string, String string2, String string3, File file) {
        return ImageProvider.getIfAvailable(collection, string, string2, string3, file, false);
    }

    public static ImageIcon getIfAvailable(Collection<String> collection, String string, String string2, String string3, File file, boolean bl) {
        return ImageProvider.getIfAvailable(collection, string, string2, string3, file, null, bl);
    }

    public static ImageIcon getIfAvailable(Collection<String> collection, String string, String string2, String string3, File file, Dimension dimension, boolean bl) {
        ImageResource imageResource = ImageProvider.getIfAvailableImpl(collection, string, string2, string3, file);
        if (imageResource == null) {
            return null;
        }
        return imageResource.getImageIcon(dimension == null ? ImageResource.DEFAULT_DIMENSION : dimension, bl);
    }

    private static ImageResource getIfAvailableImpl(Collection<String> collection, String string, String string2, String string3, File file) {
        ImageType imageType;
        if (string3 == null) {
            return null;
        }
        ImageType imageType2 = imageType = string3.toLowerCase().endsWith(".svg") ? ImageType.SVG : ImageType.OTHER;
        if (string3.startsWith("http://")) {
            String string4 = string3;
            ImageResource imageResource = cache.get(string4);
            if (imageResource != null) {
                return imageResource;
            }
            imageResource = ImageProvider.getIfAvailableHttp(string4, imageType);
            if (imageResource != null) {
                cache.put(string4, imageResource);
            }
            return imageResource;
        }
        if (string3.startsWith("wiki://")) {
            ImageResource imageResource = cache.get(string3);
            if (imageResource != null) {
                return imageResource;
            }
            imageResource = ImageProvider.getIfAvailableWiki(string3, imageType);
            if (imageResource != null) {
                cache.put(string3, imageResource);
            }
            return imageResource;
        }
        if (string2 == null) {
            string2 = "";
        } else if (!string2.equals("")) {
            string2 = string2 + "/";
        }
        String[] stringArray = string3.indexOf(46) != -1 ? new String[]{""} : new String[]{".png", ".svg"};
        Integer[] integerArray = new Integer[]{0, 1};
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = integerArray[i];
            block5: for (String string5 : stringArray) {
                ImageResource imageResource;
                String string6;
                if (".svg".equals(string5)) {
                    imageType = ImageType.SVG;
                } else if (".png".equals(string5)) {
                    imageType = ImageType.OTHER;
                }
                String string7 = string6 = string2 + string3 + string5;
                if (collection != null && collection.size() > 0) {
                    string7 = "id:" + string + ":" + string6;
                    if (file != null) {
                        string7 = string7 + ":" + file.getName();
                    }
                }
                if ((imageResource = cache.get(string7)) != null) {
                    return imageResource;
                }
                switch (n2) {
                    case 0: {
                        if (file == null || (imageResource = ImageProvider.getIfAvailableZip(string6, file, imageType)) == null) continue block5;
                        cache.put(string7, imageResource);
                        return imageResource;
                    }
                    case 1: {
                        URL uRL = ImageProvider.getImageUrl(string6, collection);
                        if (uRL == null || (imageResource = ImageProvider.getIfAvailableLocalURL(uRL, imageType)) == null) continue block5;
                        cache.put(string7, imageResource);
                        return imageResource;
                    }
                }
            }
        }
        return null;
    }

    private static ImageResource getIfAvailableHttp(String string, ImageType imageType) {
        try {
            MirroredInputStream mirroredInputStream = new MirroredInputStream(string, new File(Main.pref.getPreferencesDir(), "images").toString());
            switch (imageType) {
                case SVG: {
                    URI uRI = ImageProvider.getSvgUniverse().loadSVG(mirroredInputStream, mirroredInputStream.getFile().toURI().toURL().toString());
                    SVGDiagram sVGDiagram = ImageProvider.getSvgUniverse().getDiagram(uRI);
                    return sVGDiagram == null ? null : new ImageResource(sVGDiagram);
                }
                case OTHER: {
                    Image image = Toolkit.getDefaultToolkit().createImage(mirroredInputStream.getFile().toURI().toURL());
                    return image == null ? null : new ImageResource(image, false);
                }
            }
            throw new AssertionError();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static ImageResource getIfAvailableWiki(String string, ImageType imageType) {
        List<String> list = Arrays.asList("http://wiki.openstreetmap.org/w/images/", "http://upload.wikimedia.org/wikipedia/commons/", "http://wiki.openstreetmap.org/wiki/File:");
        Collection<String> collection = Main.pref.getCollection("image-provider.wiki.urls", list);
        String string2 = string.substring(string.lastIndexOf(47) + 1);
        ImageResource imageResource = null;
        for (String string3 : collection) {
            String string4;
            if (string3.endsWith(":")) {
                string4 = ImageProvider.getImgUrlFromWikiInfoPage(string3, string2);
                if (string4 == null) {
                    continue;
                }
            } else {
                String string5 = Utils.md5Hex(string2);
                string4 = string3 + string5.substring(0, 1) + "/" + string5.substring(0, 2) + "/" + string2;
            }
            if ((imageResource = ImageProvider.getIfAvailableHttp(string4, imageType)) == null) continue;
            break;
        }
        return imageResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ImageResource getIfAvailableZip(String string, File file, ImageType imageType) {
        ZipFile zipFile = null;
        try {
            int n;
            zipFile = new ZipFile(file);
            ZipEntry zipEntry = zipFile.getEntry(string);
            if (zipEntry == null) return null;
            int n2 = 0;
            byte[] byArray = new byte[n];
            InputStream inputStream = null;
            try {
                inputStream = zipFile.getInputStream(zipEntry);
                switch (imageType) {
                    case SVG: {
                        URI uRI = ImageProvider.getSvgUniverse().loadSVG(inputStream, string);
                        SVGDiagram sVGDiagram = ImageProvider.getSvgUniverse().getDiagram(uRI);
                        ImageResource imageResource = sVGDiagram == null ? null : new ImageResource(sVGDiagram);
                        return imageResource;
                    }
                    case OTHER: {
                        int n3;
                        for (n = (int)zipEntry.getSize(); n > 0; n2 += n3, n -= n3) {
                            n3 = inputStream.read(byArray, n2, n);
                        }
                        Image image = Toolkit.getDefaultToolkit().createImage(byArray);
                        ImageResource imageResource = image == null ? null : new ImageResource(image, false);
                        return imageResource;
                    }
                }
                throw new AssertionError();
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        catch (Exception exception) {
            System.err.println(I18n.tr("Warning: failed to handle zip file ''{0}''. Exception was: {1}", file.getName(), exception.toString()));
            return null;
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static ImageResource getIfAvailableLocalURL(URL uRL, ImageType imageType) {
        switch (imageType) {
            case SVG: {
                URI uRI = ImageProvider.getSvgUniverse().loadSVG(uRL);
                SVGDiagram sVGDiagram = ImageProvider.getSvgUniverse().getDiagram(uRI);
                return sVGDiagram == null ? null : new ImageResource(sVGDiagram);
            }
            case OTHER: {
                Image image = Toolkit.getDefaultToolkit().createImage(uRL);
                return image == null ? null : new ImageResource(image, false);
            }
        }
        throw new AssertionError();
    }

    private static URL getImageUrl(String string, String string2) {
        if (string != null && string.startsWith("resource://")) {
            String string3 = string.substring("resource://".length());
            for (ClassLoader classLoader : PluginHandler.getResourceClassLoaders()) {
                URL uRL = classLoader.getResource(string3 + string2);
                if (uRL == null) continue;
                return uRL;
            }
        } else {
            try {
                File file = new File(string, string2);
                if (file.exists()) {
                    return file.toURI().toURL();
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    private static URL getImageUrl(String string, Collection<String> collection) {
        URL uRL = null;
        if (collection != null) {
            for (String object : collection) {
                try {
                    uRL = ImageProvider.getImageUrl(object, string);
                    if (uRL == null) continue;
                    return uRL;
                }
                catch (SecurityException securityException) {
                    System.out.println(I18n.tr("Warning: failed to access directory ''{0}'' for security reasons. Exception was: {1}", object, securityException.toString()));
                }
            }
        }
        String string2 = Main.pref.getPreferencesDir() + "images";
        try {
            uRL = ImageProvider.getImageUrl(string2, string);
            if (uRL != null) {
                return uRL;
            }
        }
        catch (SecurityException securityException) {
            System.out.println(I18n.tr("Warning: failed to access directory ''{0}'' for security reasons. Exception was: {1}", string2, securityException.toString()));
        }
        uRL = ImageProvider.getImageUrl(null, string);
        if (uRL != null) {
            return uRL;
        }
        uRL = ImageProvider.getImageUrl("resource://images/", string);
        if (uRL != null) {
            return uRL;
        }
        for (String string3 : Main.pref.getAllPossiblePreferenceDirs()) {
            uRL = ImageProvider.getImageUrl(string3 + "images", string);
            if (uRL != null) {
                return uRL;
            }
            uRL = ImageProvider.getImageUrl(string3, string);
            if (uRL == null) continue;
            return uRL;
        }
        return null;
    }

    private static String getImgUrlFromWikiInfoPage(String string, final String string2) {
        class SAXReturnException
        extends SAXException {
            private String result;

            public SAXReturnException(String string) {
                this.result = string;
            }

            public String getResult() {
                return this.result;
            }
        }
        try {
            XMLReader xMLReader = XMLReaderFactory.createXMLReader();
            xMLReader.setContentHandler(new DefaultHandler(){

                public void startElement(String string, String string22, String string3, Attributes attributes) throws SAXException {
                    String string4;
                    System.out.println();
                    if (string22.equalsIgnoreCase("img") && (string4 = attributes.getValue("src")).endsWith(string2)) {
                        throw new SAXReturnException(string4);
                    }
                }
            });
            xMLReader.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String string, String string2) {
                    return new InputSource(new ByteArrayInputStream(new byte[0]));
                }
            });
            xMLReader.parse(new InputSource(new MirroredInputStream(string + string2, new File(Main.pref.getPreferencesDir(), "images").toString())));
        }
        catch (SAXReturnException sAXReturnException) {
            return sAXReturnException.getResult();
        }
        catch (Exception exception) {
            System.out.println("INFO: parsing " + string + string2 + " failed:\n" + exception);
            return null;
        }
        System.out.println("INFO: parsing " + string + string2 + " failed: Unexpected content.");
        return null;
    }

    public static Cursor getCursor(String string, String string2) {
        ImageIcon imageIcon = ImageProvider.get("cursor", string);
        if (string2 != null) {
            imageIcon = ImageProvider.overlay((Icon)imageIcon, "cursor/modifier/" + string2, OverlayPosition.SOUTHEAST);
        }
        Cursor cursor = Toolkit.getDefaultToolkit().createCustomCursor(imageIcon.getImage(), string.equals("crosshair") ? new Point(10, 10) : new Point(3, 2), "Cursor");
        return cursor;
    }

    public static ImageIcon overlay(Icon icon, String string, OverlayPosition overlayPosition) {
        return ImageProvider.overlay(icon, ImageProvider.get(string), overlayPosition);
    }

    public static ImageIcon overlay(Icon icon, Icon icon2, OverlayPosition overlayPosition) {
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        int n = icon.getIconWidth();
        int n2 = icon.getIconHeight();
        int n3 = icon2.getIconWidth();
        int n4 = icon2.getIconHeight();
        BufferedImage bufferedImage = graphicsConfiguration.createCompatibleImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        icon.paintIcon(null, graphics2D, 0, 0);
        int n5 = 0;
        int n6 = 0;
        switch (overlayPosition) {
            case NORTHWEST: {
                n5 = 0;
                n6 = 0;
                break;
            }
            case NORTHEAST: {
                n5 = n - n3;
                n6 = 0;
                break;
            }
            case SOUTHWEST: {
                n5 = 0;
                n6 = n2 - n4;
                break;
            }
            case SOUTHEAST: {
                n5 = n - n3;
                n6 = n2 - n4;
            }
        }
        icon2.paintIcon(null, graphics2D, n5, n6);
        return new ImageIcon(bufferedImage);
    }

    public static ImageIcon createRotatedImage(Component component, Icon icon, double d) {
        int n;
        int n2;
        double d2 = d % 360.0;
        if (d != 0.0 && d2 == 0.0) {
            d2 = 360.0;
        }
        double d3 = d2 % 90.0;
        if (d2 != 0.0 && d3 == 0.0) {
            d3 = 90.0;
        }
        double d4 = Math.toRadians(d3);
        int n3 = icon.getIconWidth();
        int n4 = icon.getIconHeight();
        if (d2 >= 0.0 && d2 <= 90.0 || d2 > 180.0 && d2 <= 270.0) {
            n2 = (int)((double)n3 * Math.sin(1.5707963267948966 - d4) + (double)n4 * Math.sin(d4));
            n = (int)((double)n3 * Math.sin(d4) + (double)n4 * Math.sin(1.5707963267948966 - d4));
        } else {
            n2 = (int)((double)n4 * Math.sin(1.5707963267948966 - d4) + (double)n3 * Math.sin(d4));
            n = (int)((double)n4 * Math.sin(d4) + (double)n3 * Math.sin(1.5707963267948966 - d4));
        }
        BufferedImage bufferedImage = new BufferedImage(n2, n, 2);
        Graphics graphics = bufferedImage.getGraphics();
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        int n5 = n3 / 2;
        int n6 = n4 / 2;
        graphics2D.translate(n2 / 2, n / 2);
        graphics2D.rotate(Math.toRadians(d2));
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        icon.paintIcon(component, graphics2D, -n5, -n6);
        graphics2D.dispose();
        return new ImageIcon(bufferedImage);
    }

    public static ImageIcon get(OsmPrimitiveType osmPrimitiveType) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull((Object)osmPrimitiveType, "type");
        return ImageProvider.get("data", osmPrimitiveType.getAPIName());
    }

    public static BufferedImage sanitize(Image image) {
        new ImageIcon(image).getImage();
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        bufferedImage.getGraphics().drawImage(image, 0, 0, null);
        return bufferedImage;
    }

    public static Image createImageFromSvg(SVGDiagram sVGDiagram, Dimension dimension) {
        float f = sVGDiagram.getWidth();
        float f2 = sVGDiagram.getHeight();
        int n = Math.round(f);
        int n2 = Math.round(f2);
        Double d = null;
        Double d2 = null;
        if (dimension.width != -1) {
            n = dimension.width;
            d = (double)n / (double)f;
            if (dimension.height == -1) {
                d2 = d;
                n2 = (int)Math.round((double)f2 * d2);
            } else {
                n2 = dimension.height;
                d2 = (double)n2 / (double)f2;
            }
        } else if (dimension.height != -1) {
            n2 = dimension.height;
            d = d2 = Double.valueOf((double)n2 / (double)f2);
            n = (int)Math.round((double)f * d);
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setClip(0, 0, n, n2);
        if (d != null) {
            graphics2D.scale(d, d2);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        try {
            sVGDiagram.render(graphics2D);
        }
        catch (SVGException sVGException) {
            return null;
        }
        return bufferedImage;
    }

    private static SVGUniverse getSvgUniverse() {
        if (svgUniverse == null) {
            svgUniverse = new SVGUniverse();
        }
        return svgUniverse;
    }

    static {
        cache = new HashMap<String, ImageResource>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImageType {
        SVG,
        OTHER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OverlayPosition {
        NORTHWEST,
        NORTHEAST,
        SOUTHWEST,
        SOUTHEAST;

    }
}

