/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.AdaptableAction;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.tools.I18n;

public class AddImageryLayerAction
extends JosmAction
implements AdaptableAction {
    private final ImageryInfo info;

    public AddImageryLayerAction(ImageryInfo imageryInfo) {
        super(imageryInfo.getMenuName(), "imagery_menu", I18n.tr("Add imagery layer {0}", imageryInfo.getName()), null, false, false);
        this.putValue("toolbar", "imagery_" + imageryInfo.getToolbarName());
        this.info = imageryInfo;
        this.installAdapters();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isEnabled()) {
            return;
        }
        try {
            Main.main.addLayer(ImageryLayer.create(this.info));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (illegalArgumentException.getMessage() == null || illegalArgumentException.getMessage().isEmpty()) {
                throw illegalArgumentException;
            }
            JOptionPane.showMessageDialog(Main.parent, illegalArgumentException.getMessage(), I18n.tr("Error", new Object[0]), 0);
        }
    }

    protected void updateEnabledState() {
        if (this.info.isBlacklisted()) {
            this.setEnabled(false);
        } else if (this.info.getImageryType() == ImageryInfo.ImageryType.TMS || this.info.getImageryType() == ImageryInfo.ImageryType.BING || this.info.getImageryType() == ImageryInfo.ImageryType.SCANEX) {
            this.setEnabled(true);
        } else if (Main.map != null && Main.map.mapView != null && !Main.map.mapView.getAllLayers().isEmpty()) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }
}

