/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.SelectionChangedListener;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.paint.PaintColors;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.MapViewPaintable;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawAction
extends MapMode
implements MapViewPaintable,
SelectionChangedListener,
AWTEventListener {
    private final Cursor cursorJoinNode;
    private final Cursor cursorJoinWay;
    private Node lastUsedNode = null;
    private double PHI = Math.toRadians(90.0);
    private Node mouseOnExistingNode;
    private Set<Way> mouseOnExistingWays = new HashSet<Way>();
    private Set<OsmPrimitive> oldHighlights = new HashSet<OsmPrimitive>();
    private boolean drawHelperLine;
    private boolean wayIsFinished = false;
    private boolean drawTargetHighlight;
    private Point mousePos;
    private Point oldMousePos;
    private Color selectedColor;
    private Node currentBaseNode;
    private EastNorth currentMouseEastNorth;
    private Shortcut extraShortcut = Shortcut.registerShortcut("mapmode:drawfocus", I18n.tr("Mode: Draw Focus", new Object[0]), 78, 3);

    public DrawAction(MapFrame mapFrame) {
        super(I18n.tr("Draw", new Object[0]), "node/autonode", I18n.tr("Draw nodes", new Object[0]), Shortcut.registerShortcut("mapmode:draw", I18n.tr("Mode: {0}", I18n.tr("Draw", new Object[0])), 65, 3), mapFrame, ImageProvider.getCursor("crosshair", null));
        Main.registerActionShortcut((Action)this, this.extraShortcut);
        this.cursorJoinNode = ImageProvider.getCursor("crosshair", "joinnode");
        this.cursorJoinWay = ImageProvider.getCursor("crosshair", "joinway");
    }

    private void redrawIfRequired() {
        this.updateStatusLine();
        if (!(this.drawHelperLine && !this.wayIsFinished || this.drawTargetHighlight)) {
            return;
        }
        if (this.currentBaseNode != null && !DrawAction.getCurrentDataSet().getSelected().isEmpty()) {
            Way way = this.getWayForNode(this.currentBaseNode);
            if (this.alt && way != null) {
                DrawAction.getCurrentDataSet().beginUpdate();
                DrawAction.getCurrentDataSet().addSelected(this.currentBaseNode);
                DrawAction.getCurrentDataSet().clearSelection(way);
                DrawAction.getCurrentDataSet().endUpdate();
            } else if (!this.alt && way != null) {
                DrawAction.getCurrentDataSet().addSelected(way);
            }
        }
        Main.map.mapView.repaint();
    }

    private void addHighlighting() {
        this.removeHighlighting();
        if (this.ctrl) {
            Main.map.mapView.setNewCursor(this.cursor, (Object)this);
            return;
        }
        if (this.mouseOnExistingNode == null && DrawAction.getCurrentDataSet().getSelected().size() == 0 && this.mousePos != null) {
            this.mouseOnExistingNode = Main.map.mapView.getNearestNode(this.mousePos, OsmPrimitive.isSelectablePredicate);
        }
        if (this.mouseOnExistingNode != null) {
            Main.map.mapView.setNewCursor(this.cursorJoinNode, (Object)this);
            this.oldHighlights.add(this.mouseOnExistingNode);
            if (this.drawTargetHighlight) {
                this.mouseOnExistingNode.setHighlighted(true);
            }
            return;
        }
        if (this.mouseOnExistingWays.size() == 0) {
            Main.map.mapView.setNewCursor(this.cursor, (Object)this);
            return;
        }
        Main.map.mapView.setNewCursor(this.cursorJoinWay, (Object)this);
        this.oldHighlights.addAll(this.mouseOnExistingWays);
        if (!this.drawTargetHighlight) {
            return;
        }
        for (Way way : this.mouseOnExistingWays) {
            way.setHighlighted(true);
        }
    }

    private void removeHighlighting() {
        for (OsmPrimitive osmPrimitive : this.oldHighlights) {
            osmPrimitive.setHighlighted(false);
        }
        this.oldHighlights = new HashSet<OsmPrimitive>();
    }

    @Override
    public void enterMode() {
        if (!this.isEnabled()) {
            return;
        }
        super.enterMode();
        this.selectedColor = PaintColors.SELECTED.get();
        this.drawHelperLine = Main.pref.getBoolean("draw.helper-line", true);
        this.drawTargetHighlight = Main.pref.getBoolean("draw.target-highlight", true);
        this.wayIsFinished = false;
        Main.map.mapView.addMouseListener(this);
        Main.map.mapView.addMouseMotionListener(this);
        Main.map.mapView.addTemporaryLayer(this);
        DataSet.addSelectionListener(this);
        try {
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 8L);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Override
    public void exitMode() {
        super.exitMode();
        Main.map.mapView.removeMouseListener(this);
        Main.map.mapView.removeMouseMotionListener(this);
        Main.map.mapView.removeTemporaryLayer(this);
        DataSet.removeSelectionListener(this);
        this.removeHighlighting();
        try {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        DataSet dataSet = DrawAction.getCurrentDataSet();
        if (dataSet != null) {
            dataSet.fireSelectionChanged();
        }
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        if (Main.map == null || Main.map.mapView == null || !Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        this.updateKeyModifiers((InputEvent)aWTEvent);
        this.computeHelperLine();
        this.addHighlighting();
        this.redrawIfRequired();
    }

    @Override
    public void selectionChanged(Collection<? extends OsmPrimitive> collection) {
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        this.computeHelperLine();
        this.addHighlighting();
        this.redrawIfRequired();
    }

    private void tryAgain(MouseEvent mouseEvent) {
        DrawAction.getCurrentDataSet().setSelected(new PrimitiveId[0]);
        this.mouseReleased(mouseEvent);
    }

    private void finishDrawing() {
        Main.main.getCurrentDataSet().fireSelectionChanged();
        this.lastUsedNode = null;
        this.wayIsFinished = true;
        Main.map.selectSelectTool(true);
        this.computeHelperLine();
        this.removeHighlighting();
        this.redrawIfRequired();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Iterator iterator;
        Object object;
        Object object3;
        if (mouseEvent.getButton() != 1) {
            return;
        }
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        Main.map.mapView.requestFocus();
        if (mouseEvent.getClickCount() > 1 && this.mousePos != null && this.mousePos.equals(this.oldMousePos)) {
            this.finishDrawing();
            return;
        }
        this.oldMousePos = this.mousePos;
        this.updateKeyModifiers(mouseEvent);
        this.mousePos = mouseEvent.getPoint();
        DataSet dataSet = DrawAction.getCurrentDataSet();
        ArrayList<OsmPrimitive> arrayList = new ArrayList<OsmPrimitive>(dataSet.getSelected());
        LinkedList<Command> linkedList = new LinkedList<Command>();
        LinkedList<OsmPrimitive> linkedList2 = new LinkedList<OsmPrimitive>(dataSet.getSelected());
        ArrayList<Way> arrayList2 = new ArrayList<Way>();
        ArrayList arrayList3 = new ArrayList();
        boolean bl = false;
        Node node = null;
        if (!this.ctrl) {
            node = Main.map.mapView.getNearestNode(this.mousePos, OsmPrimitive.isSelectablePredicate);
        }
        if (node != null) {
            if (arrayList.isEmpty() || this.wayIsFinished) {
                DrawAction.getCurrentDataSet().setSelected(node);
                Way way = this.getWayForNode(node);
                if (way != null) {
                    DrawAction.getCurrentDataSet().addSelected(way);
                }
                this.wayIsFinished = false;
                return;
            }
        } else {
            node = new Node(Main.map.mapView.getLatLon(mouseEvent.getX(), mouseEvent.getY()));
            if (node.getCoor().isOutSideWorld()) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Cannot add a node outside of the world.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
                return;
            }
            bl = true;
            linkedList.add(new AddCommand(node));
            if (!this.ctrl) {
                List<WaySegment> list = Main.map.mapView.getNearestWaySegments(mouseEvent.getPoint(), OsmPrimitive.isSelectablePredicate);
                HashMap hashMap = new HashMap();
                for (WaySegment iterator22 : list) {
                    void var14_25;
                    if (hashMap.containsKey(iterator22.way)) {
                        List list2 = (List)hashMap.get(iterator22.way);
                    } else {
                        ArrayList arrayList4 = new ArrayList();
                        hashMap.put(iterator22.way, arrayList4);
                    }
                    var14_25.add(iterator22.lowerIndex);
                }
                object3 = new HashSet<Pair<Node, Node>>();
                for (Map.Entry entry : hashMap.entrySet()) {
                    int n;
                    Way way = (Way)entry.getKey();
                    object = (List)entry.getValue();
                    Way way2 = new Way(way);
                    DrawAction.pruneSuccsAndReverse((List<Integer>)object);
                    iterator = object.iterator();
                    while (iterator.hasNext()) {
                        n = (Integer)iterator.next();
                        object3.add(Pair.sort(new Pair<Node, Node>(way.getNode(n), way.getNode(n + 1))));
                    }
                    iterator = object.iterator();
                    while (iterator.hasNext()) {
                        n = (Integer)iterator.next();
                        way2.addNode(n + 1, node);
                    }
                    if (this.alt) {
                        linkedList2.add((OsmPrimitive)entry.getKey());
                    }
                    linkedList.add(new ChangeCommand((OsmPrimitive)entry.getKey(), way2));
                    arrayList3.add(entry.getKey());
                    arrayList2.add(way2);
                }
                DrawAction.adjustNode(object3, node);
            }
        }
        boolean bl2 = false;
        boolean bl3 = this.wayIsFinished;
        this.wayIsFinished = false;
        if (arrayList.size() > 0 && !this.shift) {
            void var13_19;
            object3 = null;
            Object var13_18 = null;
            for (OsmPrimitive osmPrimitive : arrayList) {
                if (osmPrimitive instanceof Node) {
                    if (object3 != null) {
                        this.tryAgain(mouseEvent);
                        return;
                    }
                    object3 = (Node)osmPrimitive;
                    continue;
                }
                if (!(osmPrimitive instanceof Way)) continue;
                if (var13_19 != null) {
                    this.tryAgain(mouseEvent);
                    return;
                }
                Way way = (Way)osmPrimitive;
            }
            Node node2 = this.findNodeToContinueFrom((Node)object3, (Way)var13_19);
            if (node2 == null) {
                this.tryAgain(mouseEvent);
                return;
            }
            if (!bl3) {
                void var15_44;
                void var15_40;
                Way way;
                if (this.isSelfContainedWay((Way)var13_19, node2, node)) {
                    return;
                }
                if (node2 == node) {
                    this.finishDrawing();
                    return;
                }
                Object object2 = this.alt ? null : (way = var13_19 != null ? var13_19 : this.getWayForNode(node2));
                if (way != null) {
                    int n = 0;
                    for (Node node3 : way.getNodes()) {
                        if (!node3.equals(node2)) continue;
                        ++n;
                    }
                    if (n > 1) {
                        Object var15_39 = null;
                    }
                }
                if (var15_40 == null) {
                    Way way3 = new Way();
                    way3.addNode(node2);
                    linkedList.add(new AddCommand(way3));
                    object = way3;
                } else {
                    int n = arrayList3.indexOf(var15_40);
                    if (n != -1) {
                        Way way4 = (Way)arrayList2.get(n);
                        object = way4;
                    } else {
                        object = var15_40;
                        iterator = new Way((Way)var15_40);
                        linkedList.add(new ChangeCommand((OsmPrimitive)var15_40, (OsmPrimitive)((Object)iterator)));
                        Iterator iterator2 = iterator;
                    }
                }
                if (var15_44.containsNode(node)) {
                    this.wayIsFinished = true;
                    arrayList.clear();
                }
                if (var15_44.getNode(var15_44.getNodesCount() - 1) == node2) {
                    var15_44.addNode(node);
                } else {
                    var15_44.addNode(0, node);
                }
                bl2 = true;
                linkedList2.clear();
                linkedList2.add((OsmPrimitive)object);
            }
        }
        if (!bl2) {
            if (!bl) {
                return;
            }
            if (arrayList2.isEmpty()) {
                object3 = I18n.tr("Add node", new Object[0]);
            } else {
                object3 = I18n.tr("Add node into way", new Object[0]);
                for (Way way : arrayList2) {
                    linkedList2.remove(way);
                }
            }
            linkedList2.clear();
            linkedList2.add(node);
        } else {
            object3 = !bl ? I18n.tr("Connect existing way to node", new Object[0]) : (arrayList2.isEmpty() ? I18n.tr("Add a new node to an existing way", new Object[0]) : I18n.tr("Add node into way and connect", new Object[0]));
        }
        SequenceCommand sequenceCommand = new SequenceCommand((String)object3, linkedList);
        Main.main.undoRedo.add(sequenceCommand);
        if (!this.wayIsFinished) {
            this.lastUsedNode = node;
        }
        DrawAction.getCurrentDataSet().setSelected(linkedList2);
        if (node != null && Main.map.mapView.viewportFollowing) {
            Main.map.mapView.smoothScrollTo(node.getEastNorth());
        }
        this.computeHelperLine();
        this.removeHighlighting();
        this.redrawIfRequired();
    }

    private boolean isSelfContainedWay(Way way, Node node, Node node2) {
        int n;
        if (way != null && ((n = way.getNodes().indexOf(node)) != -1 && n >= 1 && node2.equals(way.getNode(n - 1)) || n < way.getNodesCount() - 1 && node2.equals(way.getNode(n + 1)))) {
            DrawAction.getCurrentDataSet().setSelected(node2);
            this.lastUsedNode = node2;
            return true;
        }
        return false;
    }

    private Node findNodeToContinueFrom(Node node, Way way) {
        if (node == null && way == null) {
            return null;
        }
        if (node == null) {
            if (way.isFirstLastNode(this.lastUsedNode)) {
                return this.lastUsedNode;
            }
            return null;
        }
        if (way == null) {
            return node;
        }
        if (way.isFirstLastNode(node)) {
            return node;
        }
        return null;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        this.updateKeyModifiers(mouseEvent);
        this.mousePos = mouseEvent.getPoint();
        this.computeHelperLine();
        this.addHighlighting();
        this.redrawIfRequired();
    }

    private void computeHelperLine() {
        Object object2;
        MapView mapView = Main.map.mapView;
        if (this.mousePos == null) {
            this.currentMouseEastNorth = null;
            this.currentBaseNode = null;
            return;
        }
        double d = -1.0;
        double d2 = -1.0;
        Collection<OsmPrimitive> collection = DrawAction.getCurrentDataSet().getSelected();
        Node node = null;
        Way way = null;
        Node node2 = null;
        this.mouseOnExistingNode = null;
        this.mouseOnExistingWays = new HashSet<Way>();
        Main.map.statusLine.setAngle(-1.0);
        Main.map.statusLine.setHeading(-1.0);
        Main.map.statusLine.setDist(-1.0);
        if (!this.ctrl && this.mousePos != null) {
            node2 = mapView.getNearestNode(this.mousePos, OsmPrimitive.isSelectablePredicate);
        }
        if (!this.ctrl && node2 == null) {
            object2 = mapView.getNearestWaySegments(this.mousePos, OsmPrimitive.isSelectablePredicate);
            Iterator<WaySegment> object3 = object2.iterator();
            while (object3.hasNext()) {
                WaySegment waySegment = object3.next();
                this.mouseOnExistingWays.add(waySegment.way);
            }
        }
        if (node2 != null) {
            if (collection.isEmpty()) {
                return;
            }
            this.currentMouseEastNorth = node2.getEastNorth();
            this.mouseOnExistingNode = node2;
        } else {
            this.currentMouseEastNorth = mapView.getEastNorth(this.mousePos.x, this.mousePos.y);
        }
        for (OsmPrimitive osmPrimitive : collection) {
            if (osmPrimitive instanceof Node) {
                if (node != null) {
                    return;
                }
                node = (Node)osmPrimitive;
                continue;
            }
            if (!(osmPrimitive instanceof Way)) continue;
            if (way != null) {
                return;
            }
            way = (Way)osmPrimitive;
        }
        this.currentBaseNode = null;
        object2 = null;
        if (node == null) {
            if (way == null) {
                return;
            }
            if (way.isFirstLastNode(this.lastUsedNode)) {
                this.currentBaseNode = this.lastUsedNode;
                if (this.lastUsedNode == way.getNode(way.getNodesCount() - 1) && way.getNodesCount() > 1) {
                    object2 = way.getNode(way.getNodesCount() - 2);
                }
            }
        } else if (way == null) {
            this.currentBaseNode = node;
        } else if (node == way.getNode(0) || node == way.getNode(way.getNodesCount() - 1)) {
            this.currentBaseNode = node;
        }
        if (this.currentBaseNode == null || this.currentBaseNode == node2) {
            return;
        }
        LatLon latLon = mapView.getProjection().eastNorth2latlon(this.currentMouseEastNorth);
        d = this.currentBaseNode.getCoor().greatCircleDistance(latLon);
        double d3 = Math.toDegrees(this.currentBaseNode.getEastNorth().heading(this.currentMouseEastNorth));
        if (object2 != null) {
            d2 += (d2 = d3 - Math.toDegrees(((Node)object2).getEastNorth().heading(this.currentBaseNode.getEastNorth()))) < 0.0 ? 360.0 : 0.0;
        }
        Main.map.statusLine.setAngle(d2);
        Main.map.statusLine.setHeading(d3);
        Main.map.statusLine.setDist(d);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (!Main.map.mapView.isActiveLayerDrawable()) {
            return;
        }
        this.mousePos = mouseEvent.getPoint();
        Main.map.mapView.repaint();
    }

    public Way getWayForNode(Node node) {
        Way way = null;
        for (Way way2 : Utils.filteredCollection(node.getReferrers(), Way.class)) {
            if (!way2.isUsable() || way2.getNodesCount() < 1) continue;
            Node node2 = way2.getNode(0);
            Node node3 = way2.getNode(way2.getNodesCount() - 1);
            if (node2 != node && node3 != node || node2 == node3) continue;
            if (way != null) {
                return null;
            }
            way = way2;
        }
        return way;
    }

    public Node getCurrentBaseNode() {
        return this.currentBaseNode;
    }

    private static void pruneSuccsAndReverse(List<Integer> list) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int n : list) {
            if (hashSet.contains(n - 1) || hashSet.contains(n + 1)) continue;
            hashSet.add(n);
        }
        list.clear();
        list.addAll(hashSet);
        Collections.sort(list);
        Collections.reverse(list);
    }

    private static void adjustNode(Collection<Pair<Node, Node>> collection, Node node) {
        double d;
        EastNorth eastNorth;
        EastNorth eastNorth2;
        Pair<Node, Node> pair;
        switch (collection.size()) {
            case 0: {
                return;
            }
            case 2: {
                Iterator<Pair<Node, Node>> iterator = collection.iterator();
                pair = iterator.next();
                eastNorth2 = ((Node)pair.a).getEastNorth();
                eastNorth = ((Node)pair.b).getEastNorth();
                pair = iterator.next();
                EastNorth eastNorth3 = ((Node)pair.a).getEastNorth();
                EastNorth eastNorth4 = ((Node)pair.b).getEastNorth();
                double d2 = DrawAction.det(eastNorth.east() - eastNorth2.east(), eastNorth.north() - eastNorth2.north(), eastNorth3.east() - eastNorth4.east(), eastNorth3.north() - eastNorth4.north());
                if (d2 == 0.0) {
                    return;
                }
                d = DrawAction.det(eastNorth.north() - eastNorth3.north(), eastNorth.east() - eastNorth3.east(), eastNorth4.north() - eastNorth3.north(), eastNorth4.east() - eastNorth3.east()) / d2;
                EastNorth eastNorth5 = new EastNorth(eastNorth.east() + d * (eastNorth2.east() - eastNorth.east()), eastNorth.north() + d * (eastNorth2.north() - eastNorth.north()));
                int n = Main.pref.getInteger("edit.snap-intersection-threshold", 10);
                if (!(Main.map.mapView.getPoint(node).distance(Main.map.mapView.getPoint(eastNorth5)) < (double)n)) break;
                node.setEastNorth(eastNorth5);
                return;
            }
        }
        EastNorth eastNorth6 = node.getEastNorth();
        pair = collection.iterator().next();
        eastNorth2 = ((Node)pair.a).getEastNorth();
        eastNorth = ((Node)pair.b).getEastNorth();
        double d3 = eastNorth6.distanceSq(eastNorth);
        double d4 = eastNorth6.distanceSq(eastNorth2);
        double d5 = eastNorth2.distanceSq(eastNorth);
        d = (d3 - d4 + d5) / (2.0 * d5);
        node.setEastNorth(new EastNorth(eastNorth.east() + d * (eastNorth2.east() - eastNorth.east()), eastNorth.north() + d * (eastNorth2.north() - eastNorth.north())));
    }

    static double det(double d, double d2, double d3, double d4) {
        return d * d4 - d2 * d3;
    }

    @Override
    public void paint(Graphics2D graphics2D, MapView mapView, Bounds bounds) {
        if (!this.drawHelperLine || this.wayIsFinished || this.shift) {
            return;
        }
        if (Main.map.mapView == null) {
            return;
        }
        if (this.mousePos == null) {
            return;
        }
        if (this.currentBaseNode == null || this.currentMouseEastNorth == null) {
            return;
        }
        if (!Main.map.mapView.getBounds().contains(this.mousePos)) {
            return;
        }
        Graphics2D graphics2D2 = graphics2D;
        graphics2D2.setColor(this.selectedColor);
        graphics2D2.setStroke(new BasicStroke(3.0f, 1, 1));
        GeneralPath generalPath = new GeneralPath();
        Point point = mapView.getPoint(this.currentBaseNode);
        Point point2 = mapView.getPoint(this.currentMouseEastNorth);
        double d = Math.atan2(point2.y - point.y, point2.x - point.x) + Math.PI;
        generalPath.moveTo(point.x, point.y);
        generalPath.lineTo(point2.x, point2.y);
        if (this.alt) {
            generalPath.moveTo((int)((double)point.x + 8.0 * Math.cos(d + this.PHI)), (int)((double)point.y + 8.0 * Math.sin(d + this.PHI)));
            generalPath.lineTo((int)((double)point.x + 8.0 * Math.cos(d - this.PHI)), (int)((double)point.y + 8.0 * Math.sin(d - this.PHI)));
        }
        graphics2D2.draw(generalPath);
        graphics2D2.setStroke(new BasicStroke(1.0f));
    }

    @Override
    public String getModeHelpText() {
        OsmPrimitive osmPrimitive;
        String string = "";
        string = this.ctrl || this.oldHighlights.isEmpty() ? I18n.tr("Create new node.", new Object[0]) : ((osmPrimitive = this.oldHighlights.iterator().next()) instanceof Node ? I18n.tr("Select node under cursor.", new Object[0]) : I18n.trn("Insert new node into way.", "Insert new node into {0} ways.", this.oldHighlights.size(), this.oldHighlights.size()));
        if (this.currentBaseNode != null && !this.wayIsFinished) {
            string = this.alt ? string + " " + I18n.tr("Start new way from last node.", new Object[0]) : string + " " + I18n.tr("Continue way from last node.", new Object[0]);
        }
        if ((osmPrimitive = this.mouseOnExistingNode) != null && DrawAction.getCurrentDataSet() != null && DrawAction.getCurrentDataSet().getSelectedNodes().contains(osmPrimitive)) {
            string = this.wayIsFinished ? I18n.tr("Select node under cursor.", new Object[0]) : I18n.tr("Finish drawing.", new Object[0]);
        }
        if (DrawAction.getCurrentDataSet() != null && DrawAction.getCurrentDataSet().getSelectedWays().size() > 0 && !this.wayIsFinished && !this.alt) {
            Way way = DrawAction.getCurrentDataSet().getSelectedWays().iterator().next();
            for (Node node : way.getNodes()) {
                if (!node.equals(this.mouseOnExistingNode) && !this.mouseOnExistingWays.contains(way)) continue;
                string = string + " " + I18n.tr("Finish drawing.", new Object[0]);
                break;
            }
        }
        return string;
    }

    @Override
    public boolean layerIsSupported(Layer layer) {
        return layer instanceof OsmDataLayer;
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(DrawAction.getEditLayer() != null);
    }

    @Override
    public void destroy() {
        super.destroy();
        Main.unregisterActionShortcut(this.extraShortcut);
    }
}

